<?php

namespace App\Controllers\Implementation_compliance;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\ImplementationComplianceModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;
use CodeIgniter\Exceptions\PageNotFoundException; 
class Implementation_compliance extends BaseController
{




     public function deleteSubClause($recordId, $subIndex)
    {
        $model = new ImplementationComplianceModel();
        $record = $model->find($recordId);

        if (!$record) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Record not found.");
        }

        // Decode the stored section_data
        $payload = json_decode($record['section_data'], true) ?: [];
        $subs = $payload['subclauses'] ?? [];

        if (!isset($subs[$subIndex])) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Sub-clause not found.");
        }

        // ✅ Remove file if exists
        $sub = $subs[$subIndex];
        if (($sub['input_type'] ?? '') === 'file' && !empty($sub['file_path'])) {
            $filePath = FCPATH . $sub['file_path'];
            if (is_file($filePath)) {
                @unlink($filePath);
            }
        }

        // ✅ Remove this sub-clause
        unset($subs[$subIndex]);
        $payload['subclauses'] = array_values($subs); // reindex

        // ✅ Save back to DB
        $model->update($recordId, [
            'section_data' => json_encode($payload),
            'updated_by'   => session()->get('logined_user_id'),
            'updated_at'   => date('Y-m-d H:i:s')
        ]);

        return redirect()->back()->with('success', 'Sub-clause deleted successfully.');
    }


    public function editSubClause($id, $index)
    {

     


       $model = new ImplementationComplianceModel();
        $row = $model->find($id);
        if (!$row) {
            throw PageNotFoundException::forPageNotFound('Record not found.');
        }

        $payload = json_decode($row['section_data'] ?? '[]', true) ?: [];
        $subs    = $payload['subclauses'] ?? [];

        if (!isset($subs[$index])) {
            throw PageNotFoundException::forPageNotFound('Sub-clause not found.');
        }

    $session = session();
        $id_2 = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id_2);

        return view('' . $session->get('acessing_folder') . '/Implementation_compliance/edit_subclause', [
            'record'   => $row,
            'ImplementationCompliance'=> $row,        // ✅ add this
            'sub'      => $subs[$index],
            'subIndex' => (int) $index,
            'organization' => $organization
        ]);
    }

    public function updateSubClause($id, $index)
    {
        $session = session();
        $model   = new ImplementationComplianceModel();

        $row = $model->find($id);
        if (!$row) {
            return redirect()->back()->with('error', 'Record not found.');
        }

        $payload = json_decode($row['section_data'] ?? '[]', true) ?: [];
        $subs    = $payload['subclauses'] ?? [];

        if (!isset($subs[$index])) {
            return redirect()->back()->with('error', 'Sub-clause not found.');
        }

        // incoming fields
        $clauseNo     = trim($this->request->getPost('clause_no') ?? '');
        $requirement  = trim($this->request->getPost('requirement') ?? '');
        $implementation = trim($this->request->getPost('implementation') ?? '');
        $remark       = trim($this->request->getPost('remark') ?? '');
        $inputType    = $this->request->getPost('input_type') ?? '';
        $link         = trim($this->request->getPost('link') ?? '');
        $isHeading    = (bool)$this->request->getPost('is_heading'); // optional flag
        $existingFile = $this->request->getPost('existing_file') ?? '';
        $file         = $this->request->getFile('file'); // <input name="file">

        // validate
        $errors = [];
        if ($clauseNo === '') {
            $errors[] = 'Clause No. is required.';
        }

        // If flagged as "heading", we ignore impl/link/file/remark validations
        if (!$isHeading) {
            if ($inputType === 'link') {
                if ($link !== '' && !filter_var($link, FILTER_VALIDATE_URL)) {
                    $errors[] = 'Link must be a valid URL.';
                }
            } elseif ($inputType === 'file') {
                // New file optional; if none and no existing_file, it's an error
                if ($file && $file->isValid()) {
                    if ($file->getSize() > 2 * 1024 * 1024) {
                        $errors[] = 'File must be less than 2MB.';
                    }
                    $ext = strtolower($file->getExtension());
                    if (!in_array($ext, ['jpg','jpeg','png','pdf','doc','docx','xls','xlsx'])) {
                        $errors[] = 'Invalid file type.';
                    }
                } else {
                    if (empty($existingFile)) {
                        $errors[] = 'File is required (upload new or keep existing).';
                    }
                }
            }
        }

        if (!empty($errors)) {
            $session->setFlashdata('validation_errors', $errors);
            return redirect()->back()->withInput();
        }

        // build updated sub-clause
        $updated = [
            'clause_no'      => $clauseNo,
            'requirement'    => $requirement,
            'implementation' => $implementation,
            'remark'         => $remark,
            'input_type'     => $isHeading ? '' : $inputType,
            'link'           => null,
            'file_path'      => $existingFile,
            'is_heading'     => $isHeading ? true : false,
        ];

        $entityId = $session->get('entity_id');

        if ($isHeading) {
            // headings have no impl/link/file/remark constraints; clear attachment
            $updated['link']      = null;
            $updated['file_path'] = null;

            // If you want to delete any existing file when marking as heading:
            if (!empty($existingFile) && file_exists(FCPATH . $existingFile)) {
                unlink(FCPATH . $existingFile);
            }
        } else {
            if ($inputType === 'link') {
                // switching to link -> remove existing file if any
                if (!empty($existingFile) && file_exists(FCPATH . $existingFile)) {
                    unlink(FCPATH . $existingFile);
                }
                $updated['link']      = $link ?: null;
                $updated['file_path'] = null;
            } elseif ($inputType === 'file') {
                $updated['link'] = null;

                if ($file && $file->isValid()) {
                    // delete old file if exists
                    if (!empty($existingFile) && file_exists(FCPATH . $existingFile)) {
                        unlink(FCPATH . $existingFile);
                    }

                    // store new file
                    $random = $file->getRandomName();
                    $folder = "uploads/entity_profile/{$entityId}/Implementation_compliance/{$id}/sub/{$index}";
                    $dest   = FCPATH . $folder;
                    if (!is_dir($dest)) {
                        mkdir($dest, 0777, true);
                    }
                    $file->move($dest, $random);
                    $updated['file_path'] = $folder . '/' . $random;
                }
            } else {
                // no attachment selected -> keep existing (or null if none)
                $updated['link'] = null;
            }
        }

        // replace only this sub-clause
        $subs[$index] = $updated;
        $payload['subclauses'] = array_values($subs); // normalize indices

        // save
        $model->update($id, [
            'section_data' => json_encode($payload),
            'updated_by'   => $session->get('logined_user_id'),
            'updated_at'   => date('Y-m-d H:i:s'),
        ]);

        $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('organization/view_Implementation_Compliance/' . $id);
        return redirect()->to($redirectUrl)->with('success', 'Sub-clause updated successfully.');
    }



    public function delete_ImplementationCompliance($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $ImplementationComplianc = new ImplementationComplianceModel();

        // Check if record exists
        $existing = $ImplementationComplianc->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $ImplementationComplianc->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'data deleted successfully.');
    }


    public function viewSubClause($id, $index)
{
            $session = session();
    $model = new \App\Models\ImplementationComplianceModel();
    $row = $model->find($id);
    if (!$row) {
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound('Record not found.');
    }

    $payload = json_decode($row['section_data'] ?? '[]', true) ?: [];
    $subs    = $payload['subclauses'] ?? [];

    if (!isset($subs[$index])) {
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound('Sub-clause not found.');
    }

       $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

    return view('' . $session->get('acessing_folder') . '/Implementation_compliance/view_subclass', [
        'record'          => $row,
        'sub'             => $subs[$index],
        'subIndex'        => (int) $index,
         'organization' => $organization
        
    ]);
}



    public function update_Implementation_compliance() 
    {

     $session = session();
        $model   = new ImplementationComplianceModel();

        $id  = $this->request->getPost('updating_id');
        $row = $model->find($id);
        if (!$row) {
            return redirect()->back()->with('error','Record not found.');
        }

        $payload = json_decode($row['section_data'] ?? '[]', true) ?: [];
        $main    = $payload['main_clause'] ?? [];
        $subs    = $payload['subclauses'] ?? [];

        $errors = [];

        // -------- Main Clause --------
        $mc         = $this->request->getPost('main_clause') ?? [];
        $clauseNo   = trim($mc['clause_no'] ?? '');
        $req        = trim($mc['requirement'] ?? '');
        $impl       = trim($mc['implementation'] ?? '');
        $remark     = trim($mc['remark'] ?? '');
        $inputType  = $mc['input_type'] ?? '';
        $link       = trim($mc['link'] ?? '');
        $existing   = $mc['existing_file'] ?? '';
        $fileMain   = $this->request->getFile('main_clause.file'); // name="main_clause[file]"

        if ($clauseNo === '') $errors[] = 'Main Clause: Clause No is required.';

        if ($inputType === 'link' && $link !== '' && !filter_var($link, FILTER_VALIDATE_URL)) {
            $errors[] = 'Main Clause: Link must be a valid URL.';
        }
        if ($inputType === 'file' && $fileMain && $fileMain->isValid()) {
            if ($fileMain->getSize() > 2*1024*1024) $errors[] = 'Main Clause: File must be < 2MB.';
            $ext = strtolower($fileMain->getExtension());
            if (!in_array($ext, ['jpg','jpeg','png','pdf','doc','docx','xls','xlsx'])) {
                $errors[] = 'Main Clause: Invalid file type.';
            }
        }

        // -------- New Sub-Clauses (append only) --------
        $newSubsPost = $this->request->getPost('new_subclauses') ?? [];
        $entityId = $session->get('entity_id');

        foreach ($newSubsPost as $i => $ns) {
            $nClause = trim($ns['clause_no'] ?? '');
            $nType   = $ns['input_type'] ?? '';
            $nLink   = trim($ns['link'] ?? '');
            $nFile   = $this->request->getFile("new_subclauses.$i.file");

            if ($nClause === '') $errors[] = "New Sub-Clause #".($i+1).": Clause No is required.";

            if ($nType === 'link' && $nLink !== '' && !filter_var($nLink, FILTER_VALIDATE_URL)) {
                $errors[] = "New Sub-Clause #".($i+1).": Link must be a valid URL.";
            }
            if ($nType === 'file' && $nFile && $nFile->getName() !== '') {
                if (!$nFile->isValid()) {
                    $errors[] = "New Sub-Clause #".($i+1).": Uploaded file is invalid.";
                } else {
                    if ($nFile->getSize() > 2*1024*1024) $errors[] = "New Sub-Clause #".($i+1).": File must be < 2MB.";
                    $ext = strtolower($nFile->getExtension());
                    if (!in_array($ext, ['jpg','jpeg','png','pdf','doc','docx','xls','xlsx'])) {
                        $errors[] = "New Sub-Clause #".($i+1).": Invalid file type.";
                    }
                }
            }
        }

        if (!empty($errors)) {
            $session->setFlashdata('validation_errors', $errors);
            return redirect()->back()->withInput();
        }

        // --- Save/replace main file if given
        $newMain = [
            'clause_no'      => $clauseNo,
            'requirement'    => $req,
            'implementation' => $impl,
            'remark'         => $remark,
            'input_type'     => $inputType,
            'link'           => null,
            'file_path'      => $existing ?: null,
        ];

        if ($inputType === 'link') {
            // optional: delete old file if switching to link
            // if (!empty($existing) && file_exists(FCPATH.$existing)) { @unlink(FCPATH.$existing); }
            $newMain['link'] = $link ?: null;
            $newMain['file_path'] = null;
        } elseif ($inputType === 'file') {
            $newMain['link'] = null;

            if ($fileMain && $fileMain->isValid()) {
                // delete old file if exists
                if (!empty($existing) && file_exists(FCPATH.$existing)) { @unlink(FCPATH.$existing); }

                $random = $fileMain->getRandomName();
                $folder = "uploads/entity_profile/{$entityId}/Implementation_compliance/{$id}/main";
                $dest   = FCPATH.$folder;
                if (!is_dir($dest)) mkdir($dest, 0777, true);
                $fileMain->move($dest, $random);
                $newMain['file_path'] = $folder.'/'.$random;
            }
        }

        // --- Build appended sub-clauses
        foreach ($newSubsPost as $i => $ns) {
            $nClause = trim($ns['clause_no'] ?? '');
            $nReq    = trim($ns['requirement'] ?? '');
            $nImpl   = trim($ns['implementation'] ?? '');
            $nRem    = trim($ns['remark'] ?? '');
            $nType   = $ns['input_type'] ?? '';
            $nLink   = trim($ns['link'] ?? '');
            $nFile   = $this->request->getFile("new_subclauses.$i.file");

            $sub = [
                'clause_no'      => $nClause,
                'requirement'    => $nReq,
                'implementation' => $nImpl,
                'remark'         => $nRem,
                'input_type'     => $nType,
                'link'           => null,
                'file_path'      => null,
            ];

            if ($nType === 'link') {
                $sub['link'] = $nLink ?: null;
            } elseif ($nType === 'file' && $nFile && $nFile->isValid()) {
                $random = $nFile->getRandomName();
                $nextIndex = count($subs); // zero-based
                $folder = "uploads/entity_profile/{$entityId}/Implementation_compliance/{$id}/sub/{$nextIndex}";
                $dest   = FCPATH.$folder;
                if (!is_dir($dest)) mkdir($dest, 0777, true);
                $nFile->move($dest, $random);
                $sub['file_path'] = $folder.'/'.$random;
            }

            $subs[] = $sub;
        }

        // --- Save back
        $payload['main_clause'] = $newMain;
        $payload['subclauses']  = array_values($subs);

        $model->update($id, [
            'section_data' => json_encode($payload),
            'updated_by'   => $session->get('logined_user_id'),
            'updated_at'   => date('Y-m-d H:i:s'),
        ]);

        $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('organization/view_Implementation_Compliance/'.$id);
        return redirect()->to($redirectUrl)->with('success','Main clause updated and new sub-clauses added.');
    }



    public function edit_ImplementationCompliance($id)
    {
        $ImplementationCompliance = new ImplementationComplianceModel();
        $ImplementationCompliance = $ImplementationCompliance->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Implementation_compliance/edit', [
            'ImplementationCompliance' => $ImplementationCompliance,
            'organization' => $organization
        ]);
    }


    public function view_Implementation_Compliance($id)
    {
        $ImplementationCompliance = new ImplementationComplianceModel();
        $ImplementationCompliance = $ImplementationCompliance->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Implementation_compliance/view', [
            'ImplementationCompliance' => $ImplementationCompliance,
            'organization' => $organization
        ]);
    }


    public function insert_Implementation_compliance()
    {

   $session = session();
    $model   = new \App\Models\ImplementationComplianceModel();

    // --- Collect POST + FILES ---
    $main   = $this->request->getPost('main_clause') ?? [];
    $subs   = $this->request->getPost('subclauses') ?? [];     // may be empty
    $files  = $this->request->getFiles();                      // ['main_clause']['file'], ['subclauses'][i]['file']

    $errors = [];
    $sessionId  = (string) $session->get('entity_id');
    $userId     = (string) $session->get('logined_user_id');
    $associated = (string) $session->get('user_associated');

    // --- Paths ---
    $baseFolder  = "uploads/entity_profile/{$sessionId}/Implementation_compliance";
    $absoluteDir = FCPATH . $baseFolder;
    if (!is_dir($absoluteDir)) {
        @mkdir($absoluteDir, 0777, true);
    }

    // --- File rules ---
    $validExt = ['jpg','jpeg','png','pdf','doc','docx','xls','xlsx'];
    $maxSize  = 1500 * 1024 * 1024; // 2 MB

    // ========== MAIN CLAUSE ==========
    $mainOut = [
        'clause_no'      => trim($main['clause_no'] ?? ''),
        'requirement'    => trim($main['requirement'] ?? ''),
        'implementation' => trim($main['implementation'] ?? ''),
        'input_type'     => $main['input_type'] ?? '',  // optional
        'link'           => null,
        'file_path'      => null,
        'remark'         => trim($main['remark'] ?? ''),
    ];

    if ($mainOut['clause_no'] === '') {
        $errors[] = "Main Clause: Clause number is required.";
    }

    $mainFile = $files['main_clause']['file'] ?? null; // UploadedFile|null

    // Optional link/file validation (only if user provided)
    if ($mainOut['input_type'] === 'link') {
        $mainOut['link'] = trim($main['link'] ?? '');
        if ($mainOut['link'] !== '' && !filter_var($mainOut['link'], FILTER_VALIDATE_URL)) {
            $errors[] = "Main Clause: Link must be a valid URL.";
        }
    } elseif ($mainOut['input_type'] === 'file') {
        
        // If user selected "file" but didn’t attach one, that’s still OK (optional field)
    } else {
        // input_type empty → keep link/file null
        $mainOut['link'] = null;
        $mainOut['file_path'] = null;
    }

    // ========== SUB-CLAUSES ==========
    $subOut   = [];
    $subFiles = $files['subclauses'] ?? []; // array of ['file'=> UploadedFile] entries

    foreach ($subs as $i => $sc) {
        // Skip blank rows: everything empty AND no file
        $isBlank =
            trim($sc['clause_no'] ?? '') === '' &&
            trim($sc['requirement'] ?? '') === '' &&
            trim($sc['implementation'] ?? '') === '' &&
            trim($sc['remark'] ?? '') === '' &&
            ($sc['input_type'] ?? '') === '' &&
            trim($sc['link'] ?? '') === '' &&
            (empty($subFiles[$i]['file']) || !$subFiles[$i]['file'] instanceof \CodeIgniter\HTTP\Files\UploadedFile);

        if ($isBlank) continue;

        $row = [
            'clause_no'      => trim($sc['clause_no'] ?? ''),
            'requirement'    => trim($sc['requirement'] ?? ''),
            'implementation' => trim($sc['implementation'] ?? ''),
            'input_type'     => $sc['input_type'] ?? '', // optional
            'link'           => null,
            'file_path'      => null,
            'remark'         => trim($sc['remark'] ?? ''),
        ];

        $displayIdx = $i + 1;

        // Only clause number is required for sub-clauses
        if ($row['clause_no'] === '') {
            $errors[] = "Sub-Clause {$displayIdx}: Clause number is required.";
        }

        $thisFile = $subFiles[$i]['file'] ?? null;

        if ($row['input_type'] === 'link') {
            $row['link'] = trim($sc['link'] ?? '');
            if ($row['link'] !== '' && !filter_var($row['link'], FILTER_VALIDATE_URL)) {
                $errors[] = "Sub-Clause {$displayIdx}: Link must be a valid URL.";
            }
        } elseif ($row['input_type'] === 'file') {
            if ($thisFile && $thisFile->isValid() && $thisFile->getName() !== '') {
                if ($thisFile->getSize() > $maxSize) {
                    $errors[] = "Sub-Clause {$displayIdx}: File must be less than 2MB.";
                }
                if (!in_array(strtolower($thisFile->getExtension()), $validExt, true)) {
                    $errors[] = "Sub-Clause {$displayIdx}: Invalid file type.";
                }
            }
            // No upload supplied is okay (optional)
        } else {
            $row['link'] = null;
            $row['file_path'] = null;
        }

        $subOut[$i] = $row;
    }

    // ========== On validation errors ==========
    if (!empty($errors)) {
        $session->setFlashdata('validation_errors', $errors);
        return redirect()->back()->withInput();
    }

    // ========== Move files now (only those supplied) ==========
    try {
        // main
        if (($mainOut['input_type'] === 'file') && $mainFile && $mainFile->isValid() && $mainFile->getName() !== '') {
            $name = 'main_' . time() . '_' . $mainFile->getRandomName();
            $mainFile->move($absoluteDir, $name);
            $mainOut['file_path'] = $baseFolder . '/' . $name;
        }

        // subs
        foreach ($subOut as $i => &$row) {
            if ($row['input_type'] === 'file') {
                $f = $subFiles[$i]['file'] ?? null;
                if ($f && $f->isValid() && $f->getName() !== '') {
                    $name = 'sub_' . ($i + 1) . '_' . time() . '_' . $f->getRandomName();
                    $f->move($absoluteDir, $name);
                    $row['file_path'] = $baseFolder . '/' . $name;
                }
            }
        }
        unset($row);
    } catch (\Throwable $e) {
        // File move failed → show a friendly error
        $session->setFlashdata('validation_errors', ['File upload failed. Please try again.']);
        return redirect()->back()->withInput();
    }

    // ========== Build payload & insert ==========
    $payload = [
        'main_clause' => $mainOut,
        'subclauses'  => array_values($subOut), // reindex 0..n-1
    ];

    $finalData = [
        'section_data'  => json_encode($payload, JSON_UNESCAPED_SLASHES),
        'associated_by' => $associated,
        'entity_id'     => $sessionId,
        'created_by'    => $userId,
        'updated_by'    => $userId,
        'created_at'    => date('Y-m-d H:i:s'),
        'updated_at'    => date('Y-m-d H:i:s'),
        'status'        => 1,
    ];

    $db = \Config\Database::connect();
    $db->transStart();
    try {
        $model->insert($finalData);
        $db->transComplete();
    } catch (\Throwable $e) {
        $db->transRollback();
        $session->setFlashdata('validation_errors', ['Could not save the record. Please try again.']);
        return redirect()->back()->withInput();
    }

    $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
    return redirect()->to($redirectUrl)->with('success', 'Implementation compliance added successfully!');
    }










    public function add_ImplementationCompliance()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Implementation_compliance/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Implementation_compliance/index', ['organization' => $organization]);
    }
}