<?php

namespace App\Controllers\Mass_Balance_Register;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\MassBalanceRegisterModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Mass_Balance_Register extends BaseController
{


    public function delete_mass_balance_register($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $MassBalanceRegister = new MassBalanceRegisterModel();

        // Check if record exists
        $existing = $MassBalanceRegister->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', ' not found.');
        }

        // Update the status field to 0 (soft delete)
        $MassBalanceRegister->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Mass Balance Register   deleted successfully.');
    }


    public function update_mass_balance_register()
    {


       $rules = [
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Farm' => [
                'label'  => 'Farm',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop' => [
                'label'  => 'crop',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop_name' => [
                'label'  => 'crop',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Produce_Specifications' => [
                'label'  => 'Produce Specifications',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],

            'Production_Estimate' => [
                'label'  => 'Production Estimate (Qty)',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],
            'Harvested_Qty' => [
                'label'  => 'Harvested Qty',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],

            'Sales_Qty' => [
                'label'  => 'Sales Qty',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],


            'Closing_Inventory_Qty' => [
                'label'  => 'Closing Inventory Qty',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],
            'Sales_by_FPO' => [
                'label'  => 'Sales by FPO',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],

            'Crop_Quantity_Measure' => [
                'label'  => 'Crop Quantity Measure',
                'rules'  => 'permit_empty|in_list[Kilograms,Qunital,Tonnes,Pounds]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be one of: Kilograms, Qunital, Tonnes, Pounds.',
                ],
            ],


            'Season' => [
                'label'  => 'Season',
                'rules'  => 'required|in_list[Kharif,Rabi,Zaid]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be either Kharif or Rabi.',
                ],
            ],

            'year' => [
                'label'  => 'year',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be integer',
                ],
            ],

            'Remark' => [
                'label'  => 'Remark',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
        ];












        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'farmer_id' => $this->request->getPost('farmer'),
            'farm_id' => $this->request->getPost('Farm'),
            'crop_id' => $this->request->getPost('crop'),
            'crop_name' => implode(",", $this->request->getPost('crop_name')),
            'produce_specs' => $this->request->getPost('Produce_Specifications'),
            'crop_qty_measure' => $this->request->getPost('Crop_Quantity_Measure'),

            'production_estimate_qty' => $this->request->getPost('Production_Estimate'),
            'Harvested_Qty' => $this->request->getPost('Production_Estimate'),
            'Sales_Qty' => $this->request->getPost('Production_Estimate'),
            'Closing_Inventory_Qty' => $this->request->getPost('Production_Estimate'),
            'season' => $this->request->getPost('Season'),
            'year' => $this->request->getPost('year'),
            'Sales_by_FPO' => $this->request->getPost('Sales_by_FPO'),

            'remark' => $this->request->getPost('Remark'),





            'updated_by' => session()->get('logined_user_id'), // Empty for now,



        ];



        $insertId = $this->request->getPost('updating_id');



        $model = new MassBalanceRegisterModel();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success






                    $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        //         $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'packaging unit  updated successfully');
    }



    public function edit_mass_balance_register($id)
    {
        $MassBalanceRegiste = new MassBalanceRegisterModel();
        $MassBalanceRegiste = $MassBalanceRegiste->find($id);


        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Mass_Balance_Register/edit', [
            'MassBalanceRegiste' => $MassBalanceRegiste,
            'organization' => $organization
        ]);
    }


    public function view_mass_balance_registry($id)
    {
        $MassBalanceRegiste = new MassBalanceRegisterModel();
        $MassBalanceRegiste = $MassBalanceRegiste->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Mass_Balance_Register/view', [
            'MassBalanceRegiste' => $MassBalanceRegiste,
            'organization' => $organization
        ]);
    }


    public function insert_mass_balance_register()
    {




        $rules = [
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Farm' => [
                'label'  => 'Farm',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop' => [
                'label'  => 'crop',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop_name' => [
                'label'  => 'crop',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Produce_Specifications' => [
                'label'  => 'Produce Specifications',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],

            'Production_Estimate' => [
                'label'  => 'Production Estimate (Qty)',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],
            'Harvested_Qty' => [
                'label'  => 'Harvested Qty',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],

            'Sales_Qty' => [
                'label'  => 'Sales Qty',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],


            'Closing_Inventory_Qty' => [
                'label'  => 'Closing Inventory Qty',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],
            'Sales_by_FPO' => [
                'label'  => 'Sales by FPO',
                'rules'  => 'permit_empty|decimal',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],

            'Crop_Quantity_Measure' => [
                'label'  => 'Crop Quantity Measure',
                'rules'  => 'permit_empty|in_list[Kilograms,Qunital,Tonnes,Pounds]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be one of: Kilograms, Qunital, Tonnes, Pounds.',
                ],
            ],


            'Season' => [
                'label'  => 'Season',
                'rules'  => 'required|in_list[Kharif,Rabi,Zaid]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be either Kharif or Rabi.',
                ],
            ],

            'year' => [
                'label'  => 'year',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be integer',
                ],
            ],

            'Remark' => [
                'label'  => 'Remark',
                'rules'  => 'permit_empty|string',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
        ];


 


        if (!$this->validate($rules)) {



            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());


            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            'farmer_id' => $this->request->getPost('farmer'),
            'farm_id' => $this->request->getPost('Farm'),
            'crop_id' => $this->request->getPost('crop'),
            'crop_name' => implode(",", $this->request->getPost('crop_name')),
            'produce_specs' => $this->request->getPost('Produce_Specifications'),
            'crop_qty_measure' => $this->request->getPost('Crop_Quantity_Measure'),

            'production_estimate_qty' => $this->request->getPost('Production_Estimate'),
            'Harvested_Qty' => $this->request->getPost('Production_Estimate'),
            'Sales_Qty' => $this->request->getPost('Production_Estimate'),
            'Closing_Inventory_Qty' => $this->request->getPost('Production_Estimate'),
            'season' => $this->request->getPost('Season'),
            'year' => $this->request->getPost('year'),
            'Sales_by_FPO' => $this->request->getPost('Sales_by_FPO'),

            'remark' => $this->request->getPost('Remark'),

            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,


        ];










        $model = new MassBalanceRegisterModel;
        // // var_dump($data);

        $model->insert($data);










                $redirectUrl = $_COOKIE['contactTableUrl'] ?? base_url('index');
            return redirect()->to($redirectUrl)->with('success', 'Mass Balance Register  added successfully!');
    }










    public function add_new_Mass_Balance_Register()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Mass_Balance_Register/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Mass_Balance_Register/index', ['organization' => $organization]);
    }
}
