<?= view('Fpo/layout/header') ?>
<?= view('Fpo/layout/sidebar') ?>

<!--**********************************
            Header end ti-comment-alt
        ***********************************-->

<!--**********************************
            Sidebar start
        ***********************************-->

<!--********************************** 
            Sidebar end
        ***********************************-->

<!--**********************************
            Content body start
        ***********************************-->

<style>
    .dashboard-card {
        border: none;
        border-radius: 15px;
        padding: 25px;
        color: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    }

    .icon-box {
        font-size: 3rem;
        opacity: 0.8;
    }

    .badge-custom {
        font-size: 0.9rem;
        padding: 5px 10px;
        border-radius: 10px;
    }
</style>

<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <div class="d-flex align-items-center mb-4">
            <h3 class="mb-0 me-auto">New farmer</h3>

        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <?php if (session()->getTempdata('validation_errors')): ?>
                            <div class="alert alert-danger">
                                <?= session('validation_errors'); ?>

                            </div>

                        <?php endif; ?>



                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>



                        <form action="<?= base_url("Fpo/insert_farmer") ?>" id="form_upload" method="post" enctype="multipart/form-data">
                            <div class="row">


                                <input type="hidden" id="csrf_token" name="<?= csrf_token() ?>" value="<?= csrf_hash() ?>">








                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Farmer ID<span class="text-danger scale5 ms-2">*</span></label>

                                    <?php
                                    $session = session();
                                    $entityId = $session->get('entity_id');
                                    $autoGenerate = $session->get('auto_generate');
                                    $buildingId = '';

                                    if ($autoGenerate && $entityId) {
                                        // Connect to the database
                                        $db = \Config\Database::connect();
                                        $builder = $db->table('farmers');

                                        // Count all rows
                                        $count = $builder->countAll();

                                        // Generate unique building ID
                                        $buildingId = 'farmer-' . $entityId . '_' . ($count + 1);
                                    }
                                    ?>

                                    <input type="text" class="form-control" name="facility_id" placeholder="<?= !$autoGenerate ? 'Enter  ID' : '' ?>" aria-label="building-id" maxlength="8" value="<?= esc($buildingId) ?>"
                                        <?= $autoGenerate ? 'readonly' : '' ?> required>
                                </div>








                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Name of the Supervisor</label>
                                    <select class='form-control selected_supervisory' name="name_of_supervisor">
                                        <option value="" selected disabled>Select Supervisor</option>

                                        <?php
                                        $db = \Config\Database::connect();

                                        // Fetch farmer_supervisors list
                                        $supervisors = $db->table('farmer_supervisors')
                                            ->where('status', 1)
                                            ->where('associated_by', session()->get('user_associated'))
                                            ->where('entity_id', session()->get('entity_id'))
                                            ->get()
                                            ->getResult();

                                        // Define mapping of table names to readable names


                                        foreach ($supervisors as $fs) {
                                            $tableName = $fs->Supervisory_From;
                                            $supervisorId = $fs->Name_of_the_Supervisor;



                                            // Fetch supervisor info from the correct table
                                            $emp = $db->table($tableName)
                                                ->select('title, first_name, last_name')
                                                ->where('id', $supervisorId)
                                                ->get()
                                                ->getRow();

                                            if ($emp) {
                                                $fullName = $emp->title . ' ' . $emp->first_name . ' ' . $emp->last_name;
                                                $label = $fullName;
                                                echo "<option value='" . esc($fs->id) . "'>" . esc($label) . "</option>";
                                            }
                                        }
                                        ?>
                                    </select>
                                </div>




                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Title </label>
                                    <select class="form-control" name="title">
                                        <option value="" disabled <?= old('title') ? '' : 'selected' ?>>Choose...</option>
                                        <option value="Mr" <?= old('title') == 'Mr' ? 'selected' : '' ?>>Mr</option>
                                        <option value="Mrs" <?= old('title') == 'Mrs' ? 'selected' : '' ?>>Mrs</option>
                                        <option value="Ms" <?= old('title') == 'Ms' ? 'selected' : '' ?>>Ms</option>
                                    </select>
                                </div>
                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>First Name <span class='text-danger ms-2'>*</span></label>
                                    <input type='text' class='form-control <?= session('validation') && session('validation')->hasError('first_name') ? 'is-invalid' : '' ?>'
                                        name="first_name"
                                        placeholder='Enter First Name'
                                        maxlength='30'
                                        value="<?= old('first_name') ?>"
                                        required>
                                </div>

                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Middle Name</label>
                                    <input type='text' class='form-control <?= session('validation') && session('validation')->hasError('Middle_name') ? 'is-invalid' : '' ?>'
                                        name="Middle_name"
                                        placeholder='Enter Middle Name'
                                        maxlength='30'
                                        value="<?= old('Middle_name') ?>">
                                </div>

                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Last Name </label>
                                    <input type='text' class='form-control <?= session('validation') && session('validation')->hasError('Last_name') ? 'is-invalid' : '' ?>'
                                        name="Last_name"
                                        placeholder='Enter Last Name'
                                        maxlength='30'
                                        value="<?= old('Last_name') ?>">
                                </div>

                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Person Photo <span class='text-danger ms-2'>*</span></label>
                                    <input type='file' class='form-control <?= session('validation') && session('validation')->hasError('Person_Photo') ? 'is-invalid' : '' ?>'
                                        name="Person_Photo"
                                        accept="image/*"
                                        required>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Gender </label>
                                    <select class="form-control" aria-label="gender" name="Gender">
                                        <option value="">Select Gender</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>



                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Contact Number </label>
                                    <input type='text' class='form-control' name="contact_number" placeholder='Contact Number ' maxlength="10" pattern="[0-9]{10}">
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Address 1<span class="text-danger scale5 ms-2">*</span></label>
                                    <input type="text" class="form-control" placeholder="Address Line 1" aria-label="factory-address1" name="adresss_1"  required>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Address 2</label>
                                    <input type="text" class="form-control" placeholder="Address Line 2" aria-label="factory-address2" name="adresss_2" >
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Village</label>
                                    <input type="text" class="form-control" placeholder="Village" aria-label="factory-village" name="Village" >
                                </div>



                                <?php
                                $country = $organization['country'] ?? '';
                                $state = $organization['state'] ?? '';
                                $city = $organization['city'] ?? '';
                                ?>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> Country </label>
                                    <select class="form-control" id="country" name="country">
                                        <option value="<?= $country ?>" selected><?= $country ?></option>
                                    </select>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> State </label>
                                    <select class="form-control" id="state" name="state">
                                        <option value="<?= $state ?>" selected><?= $state ?></option>
                                    </select>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> City </label>
                                    <select class="form-control" id="city" name="city">
                                        <option value="<?= $city ?>" selected><?= $city ?></option>
                                    </select>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label"> PIN Code<span class="text-danger scale5 ms-2">*</span></label>
                                    <input type="text" maxlength="6" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 6);"
                                        class="form-control" placeholder="PIN Code" name="pin_code" aria-label="factory-pin-code" required>
                                </div>


                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Membership Start Date </label>
                                    <input type='date' class='form-control' name="Membership_Start_Date" placeholder='Membership Start Date'>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Insurance Coverage </label>
                                    <select class="form-control" name="insurance_coverage" required aria-label="insurance_coverage">
                                        <option value="" disabled selected>Select Option</option>
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Training Received </label>
                                    <select class="form-control" name="Training_Received" aria-label="training_received">
                                        <option value="" disabled selected>Select Option</option>
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Training Title </label>
                                    <input type="text" class="form-control" name="Training_Title" placeholder="Training Title" aria-label="training_title">
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Training Date<span class="text-danger scale5 ms-2">*</span></label>
                                    <input type="date" class="form-control" name="Training_Date" aria-label="training_date">
                                </div>

                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Conducted By<span class="text-danger scale5 ms-2">*</span></label>
                                    <input type="text" class="form-control" name="Conducted_By" placeholder="Conducted By" aria-label="conducted_by">
                                </div>






                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>Email id<span class="text-danger scale5 ms-2">*</span></label>
                                    <input type='email' class='form-control' name="email_id" required placeholder='Enter password'>
                                </div>

                                <div class='col-xl-3 col-md-3 mb-4'>
                                    <label class='form-label'>password<span class="text-danger scale5 ms-2">*</span></label>
                                    <input type='text' class='form-control' name="password" required placeholder='Enter password' minlength='8'>
                                </div>







                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Remarks </label>

                                    <textarea id="" class="form-control" placeholder="Remarks" name="Remark" aria-label="manufacturing-activities"></textarea>
                                    <!-- <input type="text" class="form-control" placeholder="Manufacturing activities" aria-label="manufacturing-activities" > -->
                                </div>






                                <div class="col-xl-3 col-md-3 mb-4">
                                    <label class="form-label">Photos </label>
                                    <input
                                        type="file"
                                        class="form-control"
                                        id="fileInput"
                                        accept="image/jpeg, image/png"
                                        name="Photos[]"
                                        multiple>
                                    <!-- Preview container with remove options -->
                                    <div id="filePreview" class="mt-3"></div>
                                </div>


                                <div class="col-xl-12 col-md-12 mb-4">
                                    <label class="form-label">documants </label>
                                    <div id="documentContainer">
                                        <div class="document-row row">
                                            <div class="col-xl-3 col-md-3 mb-4">
                                                <label class="form-label">Document Name </label>
                                                <input type="text" class="form-control" name="doc_name[]" placeholder="Enter Document Name">
                                            </div>
                                            <div class="col-xl-3 col-md-3 mb-4">
                                                <label class="form-label">Document Date </label>
                                                <input type="date" class="form-control" name="doc_date[]">
                                            </div>
                                            <div class="col-xl-3 col-md-3 mb-4">
                                                <label class="form-label">Upload document </label>
                                                <input type="file" class="form-control" accept="image/*,.pdf,application/pdf,
               .xls,.xlsx,.xlsm,.xlsb,.csv,
               application/vnd.ms-excel,
               application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,
               application/vnd.ms-excel.sheet.macroEnabled.12,
               text/csv" name="doc_file[]">
                                            </div>
                                            <!-- <div class="col-xl-3 col-md-3 mb-4 d-flex align-items-end">
                                            <button type="button" class="btn btn-danger remove-btn">Remove</button>
                                        </div> -->
                                        </div>
                                    </div>

                                    <div class="col-sm-3 m-b30">
                                        <button type="button" id="addMore" class="btn btn-primary mt-3">Add More</button>

                                    </div>
                                </div>

                            </div>

                    </div>





                    <div class="card-footer text-end">
                        <div>

                            <button type="submit" class="btn btn-primary force_subit">Submit</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>












<!--**********************************
            Content body end
        ***********************************-->

<!--**********************************
            Footer start
        ***********************************-->
<?= view('Fpo/layout/footer') ?>


<script>
    $(document).ready(function() {
        $("#addMore").click(function() {
            let newRow = `
                <div class="document-row row">
                    <div class="col-xl-3 col-md-3 mb-4">
                        <label class="form-label">Document Name </label>
                        <input type="text" class="form-control" name="doc_name[]" placeholder="Enter Document Name"  >
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4">
                        <label class="form-label">Document Date </label>
                        <input type="date" class="form-control" name="doc_date[]"  >
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4">
                       <label class="form-label">Upload document </label>
                        <input type="file" class="form-control" name="doc_file[]"      accept="image/*,.pdf,application/pdf,
               .xls,.xlsx,.xlsm,.xlsb,.csv,
               application/vnd.ms-excel,
               application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,
               application/vnd.ms-excel.sheet.macroEnabled.12,
               text/csv">
                    </div>
                    <div class="col-xl-3 col-md-3 mb-4 d-flex align-items-end">
                        <button type="button" class="btn btn-danger remove-btn">Remove</button>
                    </div>
                </div>`;
            $("#documentContainer").append(newRow);
        });

        $(document).on("click", ".remove-btn", function() {
            $(this).closest(".document-row").remove();
        });

        $("#documentForm").submit(function(e) {
            e.preventDefault();
            alert("Form Submitted with " + $("input[name='doc_name[]']").length + " documents!");
        });
    });
</script>

<!-- Selectize CSS -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

<!-- jQuery (Required) -->


<!-- Selectize JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>



<?php if (session()->get('validation_errors_2')): ?>
    <script>
        $(document).ready(function() {
            $(".force_subit").prop("disabled", false);
        });
    </script>
<?php endif; ?>


<script>
    $(".force_subit").click(function(e) {
        e.preventDefault(); // prevent default form submission

        const form = document.getElementById("form_upload");

        if (form.checkValidity()) {
            $(this).prop("disabled", true);
            form.submit(); // submit if valid
        } else {
            form.reportValidity(); // show HTML5 validation errors
        }
    });

    const form = document.getElementById('form_upload');

    form.addEventListener('submit', (e) => {





        // Re-assign uploadedFiles to file input before submit
        const dataTransfer = new DataTransfer();
        uploadedFiles.forEach(file => dataTransfer.items.add(file));
        fileInput.files = dataTransfer.files;


    });
</script>
<script>

</script>


<script>
    $(document).ready(function() {
        $('#designation').selectize({

        });
    });
    $(document).ready(function() {
        $('.selected_supervisory').selectize({

        });
    });
</script>



<script>
    $(document).ready(function() {
        function initSelectize(selector) {
            return $(selector).selectize({
                create: false,
                sortField: "text",
                placeholder: "Select an option",
            })[0].selectize;
        }

        let countrySelect = initSelectize("#country");
        let stateSelect = initSelectize("#state");
        let citySelect = initSelectize("#city");

        function loadCountries(selectedCountry) {
            $.get("https://countriesnow.space/api/v0.1/countries/positions", function(response) {
                if (!response.error) {
                    response.data.forEach(country => {
                        countrySelect.addOption({
                            value: country.name,
                            text: country.name
                        });
                    });

                    if (selectedCountry) {
                        countrySelect.setValue(selectedCountry, true);
                        loadStates(selectedCountry, "<?= $state ?>"); // preload state
                    }
                }
            });
        }

        function loadStates(country, selectedState = "") {
            stateSelect.clear();
            stateSelect.clearOptions();

            if (country) {
                $.ajax({
                    url: "https://countriesnow.space/api/v0.1/countries/states",
                    type: "POST",
                    contentType: "application/json",
                    data: JSON.stringify({
                        country: country
                    }),
                    success: function(response) {
                        if (!response.error) {
                            response.data.states.forEach(state => {
                                stateSelect.addOption({
                                    value: state.name,
                                    text: state.name
                                });
                            });

                            if (selectedState) {
                                stateSelect.setValue(selectedState, true);
                                loadCities(country, selectedState, "<?= $city ?>"); // preload city
                            }
                        }
                    }
                });
            }
        }

        function loadCities(country, state, selectedCity = "") {
            citySelect.clear();
            citySelect.clearOptions();

            if (country && state) {
                $.ajax({
                    url: "https://countriesnow.space/api/v0.1/countries/state/cities",
                    type: "POST",
                    contentType: "application/json",
                    data: JSON.stringify({
                        country: country,
                        state: state
                    }),
                    success: function(response) {
                        if (!response.error) {
                            response.data.forEach(city => {
                                citySelect.addOption({
                                    value: city,
                                    text: city
                                });
                            });

                            if (selectedCity) {
                                citySelect.setValue(selectedCity, true);
                            }
                        }
                    }
                });
            }
        }

        loadCountries("<?= $country ?>"); // Initial country load with selected value

        $("#country").change(function() {
            let selectedCountry = $(this).val();
            loadStates(selectedCountry);
        });

        $("#state").change(function() {
            let selectedState = $(this).val();
            loadCities($("#country").val(), selectedState);
        });
    });
</script>