﻿<!DOCTYPE html>
<html lang="en">

<head>

    <!-- PAGE TITLE HERE -->
    <title>TraceAudit </title>

    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <meta name="robots" content="index, follow">




    <!-- Mobile Specific -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Favicon icon -->
    <link rel="shortcut icon" type="image/png" href="assets/images/favicon.png">
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="<?= base_url(); ?>assets/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="<?= base_url(); ?>assets/vendor/bootstrap-datepicker-master/css/bootstrap-datepicker.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />


    <!-- Localization Tool -->
    <!-- <link href="assets/css/jquery.localizationTool.css" rel="stylesheet"> -->

    <!-- Style Css -->
    <link href="<?= base_url(); ?>assets/new_style_assets-25-07-25/css/style.css" rel="stylesheet" type="text/css">
    <link rel="icon" href="<?= base_url(); ?>assets/images/favicon_io/favicon.ico" type="image/x-icon">


</head>





<body>


    <div class="container-fluid p-0">
        <div class="row g-0">
            <div class="col-md-12"> <img src="<?= base_url(); ?>assets/new_style_assets-25-07-25/top-banner.jpg" alt="top banner" width="100%"></div>
        </div>
        <div class="row g-0 ">

            <!-- Left Panel -->
            <div class="col-md-8 left-panel">
                <img src="<?= base_url(); ?>assets/new_style_assets-25-07-25/logo.png" alt="TraceAudit Logo">
                <!--<h2>Your Digital Pathway <br> to Standards Compliance <br> and Market Trust</h2>-->
            </div>

            <!-- Right Panel -->
            <div class="col-md-4 right-panel">
                <div class="login-card text-center">
                    <h3>Sign In</h3>
                    <p>Access the Trace Audit panel using your email passcode</p>

                    <?php if (session()->getFlashdata('success')): ?>
                        <p style="color: green;" class="text-center mb-4"><?= session()->getFlashdata('success') ?></p>
                    <?php endif; ?>


                    <?php if (session()->getTempdata('validation_errors')): ?>
                        <div class="alert alert-danger">
                            <?= session('validation_errors'); ?>
                        </div>
                        <?php session()->removeTempdata('validation_errors'); // manual removal 
                        ?>
                    <?php endif; ?>
                    <div class=" mb-3">
                        <label for="selectjs">select account type</label>
                        <!-- Make sure the id is consistent -->
                        <select style="width:100%;text-transform: capitalize;" id="selectjs"
                            class="form-control selectjs" style="width:100%;">
                            <option <?= ($value == 'organisation') ? 'selected' : '' ?> value="organization_registy">register as organization</option>
                            <option <?= ($value == 'fpo') ? 'selected' : '' ?> value="farmer_organization">register as farmer organization</option>
                            <option <?= ($value  == 'farmer') ? 'selected' : '' ?> value="farmer">register as farmer</option>
                            <option <?= ($value  == 'audit_company') ? 'selected' : '' ?> value="audit_company">register as audit company</option>
                        </select>
                        <!-- Update the label's for attribute to match the select's id -->

                        <div class="form-floating-icon"></div>
                    </div>

                    <style>
                        .nav-item {
                            cursor: pointer;

                        }

                        .next-btn {
                            border-color: #2e1f7a;
                            background-color: #2e1f7a;
                        }

                        .next-btn:hover {
                            border-color: #2e1f7a;
                            background-color: #2e1f7a;
                        }

                        .btn-primary{

                             border-color: #2e1f7a !important;
                            background-color: #2e1f7a !important;
                        }

                        .next-btn:active {
                            color: var(--bs-btn-active-color);
                            background-color: var(--bs-btn-active-bg);
                            border-color: var(--bs-btn-active-border-color);
                        }

                        .next-btn:focus {
                            border-color: #cfe2ff;
                            background-color: #93a4f5;
                        }

                        .prev-btn {

                            background: #49416bff;
                            border-color: #49416bff;
                        }

                        .form-control {

                            font-size: 1rem !important;
                        }
                    </style>

                    <div class="card">
                        <div class="card-body">

                            <ul class="nav nav-tabs nav-pills nav-fill mt-5" id="formTabs" style=" font-size: medium; ">
                                <li class="nav-item"><a class="nav-link active" data-tab="0"><span class="material-icons material-icon">
                                            business_center
                                        </span></a></li>
                                <li class="nav-item"><a class="nav-link" data-tab="1"><span class="material-icons material-icon">store</span></a></li>
                                <li class="nav-item"><a class="nav-link" data-tab="2"><span class="material-icons material-icon">location_on</span></a></li>
                                <li class="nav-item"><a class="nav-link" data-tab="3"><span class="material-icons material-icon">account_circle</span></a></li>
                            </ul>

                            <div class="container mt-5  ">





                                <form id="multiStepForm" action="<?= base_url('entity_register/store'); ?>" method="post" enctype="multipart/form-data" novalidate>
                                    <input type="hidden" name="type" value="<?= $value ?>">
                                    <!-- <?= csrf_field() ?> -->

                                    <!-- Step 1: Organization Details -->
                                    <div class="step active">
                                        <div class="mb-3">
                                            <label class="form-label"><?= $id ?> Name</label>
                                            <input type="text" name="Organization_name" class="form-control required" maxlength="50">
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Date of Incorporation</label>
                                            <input type="date" name="Organization_Date_of_Establishment" class="form-control required">
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Registration Number (entity)</label>
                                            <input type="text" name="Organization_Registration_Number" class="form-control required" maxlength="30">
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Company Logo (JPEG/PNG, max 5MB)</label>
                                            <input type="file" name="Company_Logo" class="form-control required" accept=".jpg,.jpeg,.png">
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <button type="button" class="btn btn-primary next-btn">Next</button>
                                    </div>

                                    <!-- Step 2 -->
                                    <div class="step">
                                        <div class="mb-3">
                                            <label class="form-label">GSTIN / VAT ID</label>
                                            <input type="text" name="GST_Registration" class="form-control required" maxlength="15">
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Employer Income Tax Number</label>
                                            <input type="text" name="Income_Tax_PAN_No" class="form-control required" maxlength="15">
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Income Tax TAN Number</label>
                                            <input type="text" name="income_tax_tan_no" class="form-control required" maxlength="15">
                                            <small class="error-text">This field is required.</small>
                                        </div>



                                        <button type="button" class="btn btn-secondary prev-btn">Previous</button>
                                        <button type="button" class="btn btn-primary next-btn">Next</button>
                                    </div>

                                    <!-- Step 3: Address Details -->
                                    <div class="step">
                                        <div class="mb-3">
                                            <label class="form-label">Country</label>
                                            <select id="country" name="cuntry" class="form-control required">
                                                <option value="">Select Country</option>
                                            </select>
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">State</label>
                                            <select id="state" name="State" class="form-control required">
                                                <option value="">Select State</option>
                                            </select>
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">City</label>
                                            <select id="city" name="City" class="form-control required">
                                                <option value="">Select City</option>
                                            </select>
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <div class="form-floating form-floating-custom mb-3">
                                            <input type="text" name="Office_Address1" class="form-control required" id="office_address1" placeholder="Office Address 1" maxlength="50">
                                            <label for="office_address1">Office Address 1</label>
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <div class="form-floating form-floating-custom mb-3">
                                            <input type="text" name="Office_Address2" class="form-control" id="office_address2" placeholder="Office Address 2" maxlength="50">
                                            <label for="office_address2">Office Address 2</label>
                                        </div>

                                        <div class="form-floating form-floating-custom mb-3">
                                            <input type="text" name="Office_Village" class="form-control required" id="office_village" placeholder="Office Village" maxlength="30">
                                            <label for="office_village">Office Village</label>
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <div class="form-floating form-floating-custom mb-3">
                                            <input type="text" name="Office_PIN_Code" class="form-control required" id="office_pin" placeholder="Office PIN Code" maxlength="6" pattern="[0-9]{6}">
                                            <label for="office_pin">Office PIN Code</label>
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <button type="button" class="btn btn-secondary prev-btn">Previous</button>
                                        <button type="button" class="btn btn-primary next-btn">Next</button>
                                    </div>

                                    <!-- Step 4: Contact Details -->
                                    <div class="step">
                                        <div class="mb-3">
                                            <label class="form-label">Office Contact Number (Mobile)</label>
                                            <input type="text" name="Office_Contact_Mobile" class="form-control required" maxlength="10" pattern="[0-9]{10}">
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Office Contact Number (Fixedline)</label>
                                            <input type="text" name="Office_Contact_fixed_line" class="form-control required" maxlength="10" pattern="[0-9]{10}">
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Office Email ID</label>
                                            <input type="email" name="Email_id" class="form-control required"
                                                data-error-required="Office Email is required."
                                                data-error-format="Enter a valid email address."
                                                maxlength="50">
                                            <small class="error-text">This field is required.</small>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Password</label>
                                            <input type="password" name="password" class="form-control required"
                                                minlength="8"
                                                pattern="^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[\W_]).{8,}$"
                                                data-error-required="Password is required."
                                                data-error-pattern="Password must be at least 8 characters long and include uppercase, lowercase, number, and special character.">
                                            <small class="error-text" style="display: none; color: red;"></small>
                                        </div>

                                        <button type="button" class="btn btn-secondary prev-btn">Previous</button>
                                        <button type="submit" class="btn btn-primary">Register</button>
                                    </div>
                                </form>

                            </div>

                        </div>
                    </div>

                    <div class="text-center py-2">






                        <div class="mt-3 text-left">
                            <h6>Already have an account? <a href="<?= base_url(); ?>entity_login" class="text-secondary link-hover" style=" color: white !important; "> Sign
                                    In Instead</a></h6>
                            <!-- <div class="mt-5 text-center">
                                    <p>Already have an account ? <a href="singin.php" class="fw-medium text-decoration-underline"> Signin </a></p>
                                </div> -->

                        </div>


                        <!-- <div class="new-account mt-3">
                                <p>Already have an account? <a class="text-primary" href="page-login.html">Sign in</a>
                                </p>
                            </div> -->






                        <div class="text-center mt-5">
                            <p class="fw-medium text-gray">Copyright © 2025 - <span  >TraceAudit</span> </p>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </div>






    <!--**********************************
    Scripts
***********************************-->
    <!-- Required vendors -->
    <script src="<?= base_url(); ?>assets/vendor/global/global.min.js"></script>
    <!-- <script src="assets/vendor/bootstrap-select/dist/js/bootstrap-select.min.js"></script> -->
    <!-- <script src="assets/vendor/bootstrap-datepicker-master/js/bootstrap-datepicker.min.js"></script>
    <script src="assets/js/dlabnav-init.js"></script> -->
    <!-- <script src="assets/js/custom.min.js"></script> -->
    <!-- <script src="assets/js/demo.js"></script> -->
    <!-- <script src="assets/js/styleSwitcher.js"></script> -->



    <!-- localizationTool -->
    <!-- <script src="assets/js/jquery.localizationTool.js"></script> -->
    <!-- <script src="assets/js/translator.js"></script>	 -->

    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet">

    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>

    <!-- Selectize CSS -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css">

    <!-- jQuery (Required) -->


    <!-- Selectize JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>
    <style>
        .required {
            color: #000000;
        }

        .step {
            display: none;
        }

        .step.active {
            display: block;
        }

        .error-text {
            display: none;
            color: red;
            font-size: 14px;
        }

        .nav-tabs .nav-link.active {
            background-color: #2e1f7a;
            color: white;
        }

        .nav-link {

            color: #2e1f7a;
        }

        .nav-link:focus,
        .nav-link:hover {
            color: #2e1f7a;
        }
    </style>











    <script>
        $(".selectjs").change(function() {

            let curent_class = $(this).val();

            if (curent_class == "organization_registy") {

                location.replace("<?= base_url(); ?>")
            } else if (curent_class == "farmer_organization") {

                location.replace("<?= base_url(); ?>organization_registy/farmer_organization")
            } else if (curent_class == "farmer") {

                location.replace("<?= base_url(); ?>farmer")
            } else if (curent_class == "audit_company") {


                location.replace("<?= base_url(); ?>organization_registy/audit_company")
            }


        })






        $(document).ready(function() {
            $('input[name="Organization_Registration_Number"]').on('input', function() {
                if ($(this).val().length > 30) {
                    $(this).val($(this).val().substring(0, 30));
                }
            });




            $('input[name="GST_Registration"]').on('input', function() {
                if ($(this).val().length > 15) {
                    $(this).val($(this).val().substring(0, 15));
                }
            });


            $('input[name="Company_Logo"]').on('change', function() {
                var file = this.files[0]; // Get the uploaded file
                var allowedTypes = ['image/jpeg', 'image/png']; // Allowed file types
                var maxSize = 5 * 1024 * 1024; // 5 MB in bytes

                if (file) {
                    if (!allowedTypes.includes(file.type)) {
                        alert('Only JPEG and PNG formats are allowed.');
                        $(this).val(''); // Clear the input field
                        return;
                    }

                    if (file.size > maxSize) {
                        alert('File size must be less than 5 MB.');
                        $(this).val(''); // Clear the input field
                    }
                }
            });



            $('input[name="Income_Tax_PAN_No"]').on('input', function() {
                if ($(this).val().length > 15) {
                    $(this).val($(this).val().substring(0, 15));
                }
            });


            $('input[name="Income_Tax_PAN_No"]').on('input', function() {
                if ($(this).val().length > 15) {
                    $(this).val($(this).val().substring(0, 15));
                }
            });


            $('input[name="Income_Tax_tan_No"]').on('input', function() {
                let value = $(this).val().toUpperCase(); // Convert input to uppercase
                let validValue = value.replace(/[^A-Z0-9]/g, ''); // Allow only alphanumeric characters

                if (validValue.length > 10) {
                    validValue = validValue.substring(0, 10); // Limit to 10 characters
                }

                $(this).val(validValue);
            });




        });



        $(document).ready(function() {
            function initSelectize(selector) {
                return $(selector).selectize({
                    create: false,
                    sortField: "text",
                    placeholder: "Select an option",
                })[0].selectize;
            }

            // Initialize Selectize for dynamic selects
            initSelectize("#country");
            initSelectize("#state");
            initSelectize("#city");

            function loadCountries() {
                $.get("https://countriesnow.space/api/v0.1/countries/positions", function(response) {
                    if (!response.error) {
                        var countrySelect = $("#country")[0].selectize;
                        response.data.forEach(country => {
                            countrySelect.addOption({
                                value: country.name,
                                text: country.name
                            });
                        });
                    }
                });
            }

            function loadStates(country) {
                var stateSelect = $("#state")[0].selectize;
                stateSelect.clear();
                stateSelect.clearOptions();

                if (country) {
                    $.ajax({
                        url: "https://countriesnow.space/api/v0.1/countries/states",
                        type: "POST",
                        contentType: "application/json",
                        data: JSON.stringify({
                            country: country
                        }),
                        success: function(response) {
                            if (!response.error) {
                                response.data.states.forEach(state => {
                                    stateSelect.addOption({
                                        value: state.name,
                                        text: state.name
                                    });
                                });
                            }
                        }
                    });
                }
            }

            function loadCities(country, state) {
                var citySelect = $("#city")[0].selectize;
                citySelect.clear();
                citySelect.clearOptions();

                if (country && state) {
                    $.ajax({
                        url: "https://countriesnow.space/api/v0.1/countries/state/cities",
                        type: "POST",
                        contentType: "application/json",
                        data: JSON.stringify({
                            country: country,
                            state: state
                        }),
                        success: function(response) {
                            if (!response.error) {
                                response.data.forEach(city => {
                                    citySelect.addOption({
                                        value: city,
                                        text: city
                                    });
                                });
                            }
                        }
                    });
                }
            }

            loadCountries(); // Load Countries on Page Load

            $("#country").change(function() {
                loadStates($(this).val());
            });

            $("#state").change(function() {
                loadCities($("#country").val(), $(this).val());
            });


        });
    </script>




    <script>
        function validateFields(fields) {
            let isValid = true;

            fields.each(function() {
                const $input = $(this);
                const value = $input.val().trim();
                const type = $input.attr("type");
                const minLength = $input.attr("minlength");
                const pattern = $input.attr("pattern");
                const errorText = $input.siblings(".error-text");

                let error = "";

                // 1. Required field check
                if (!value) {
                    error = $input.data("error-required") || "This field is required.";
                }
                // 2. Minimum length check
                else if (minLength && value.length < parseInt(minLength)) {
                    error = $input.data("error-length") || `Minimum length is ${minLength}.`;
                }
                // 3. Email format check
                else if (type === "email" && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(value)) {
                    error = $input.data("error-format") || "Invalid email format.";
                }
                // 4. Password strength check using pattern
                else if ($input.attr("name") === "password") {
                    const passwordPattern = /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[\W_]).{8,}$/;
                    if (!passwordPattern.test(value)) {
                        error = $input.data("error-pattern") ||
                            "Password must be at least 8 characters long and include uppercase, lowercase, number, and special character.";
                    }
                }
                // 5. Pattern check for other fields (like phone numbers)
                else if (pattern && !new RegExp(pattern).test(value)) {
                    error = $input.data("error-format") || "Invalid format.";
                }
                // 6. File size check (if file input)
                else if (type === "file" && $input[0].files.length > 0) {
                    const file = $input[0].files[0];
                    const fileSizeMB = file.size / 1024 / 1024;
                    if (fileSizeMB > 5) {
                        error = "File must be less than 5MB.";
                    }
                }

                // Show or hide error
                if (error) {
                    errorText.text(error).show();
                    isValid = false;
                } else {
                    errorText.hide();
                }
            });

            return isValid;
        }







        $(document).ready(function() {
            let steps = $(".step");
            let tabs = $(".nav-tabs .nav-link");
            let currentStep = 0;

            function showStep(index) {
                steps.removeClass("active").eq(index).addClass("active");
                tabs.removeClass("active").eq(index).addClass("active");
                currentStep = index;
            }

            $(".next-btn").click(function() {
                const currentFields = steps.eq(currentStep).find(".required").filter("input, select");
                if (validateFields(currentFields)) {
                    showStep(currentStep + 1);
                }
            });

            $(".prev-btn").click(function() {
                showStep(currentStep - 1);
            });

            $(".nav-link").click(function() {
                let index = $(this).data("tab");
                showStep(index);
            });

            // Remove error message when input is valid
            $(".required").on("input change", function() {
                if ($(this).val().trim() !== "") {
                    $(this).siblings(".error-text").hide();
                }
            });

            $("#multiStepForm").submit(function(e) {
                let valid = true;
                let firstErrorTab = null;

                $(".required").filter("input, select").each(function() {
                    const $field = $(this);
                    const value = $field.val().trim();
                    const type = $field.attr("type");
                    const pattern = $field.attr("pattern");
                    const minLength = $field.attr("minlength");
                    const maxLength = $field.attr("maxlength");
                    const errorText = $field.siblings(".error-text");

                    let error = "";

                    if (!value) {
                        error = $field.data("error-required") || "This field is required.";
                    } else if (pattern && !new RegExp("^" + pattern + "$").test(value)) {
                        error = $field.data("error-pattern") || "Invalid format.";
                    } else if (type === "email" && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(value)) {
                        error = $field.data("error-format") || "Enter a valid email address.";
                    } else if (minLength && value.length < parseInt(minLength)) {
                        error = `Minimum ${minLength} characters required.`;
                    } else if (maxLength && value.length > parseInt(maxLength)) {
                        error = `Maximum ${maxLength} characters allowed.`;
                    }

                    if (error) {
                        errorText.text(error).show();
                        let stepIndex = steps.index($field.closest(".step"));
                        if (firstErrorTab === null) firstErrorTab = stepIndex;
                        valid = false;
                    } else {
                        errorText.text("").hide();
                    }
                });

                if (!valid) {
                    showStep(firstErrorTab);
                    e.preventDefault();
                }
            });
        });
    </script>
    <style>
        label {
            text-transform: capitalize;

        }
    </style>
</body>



</html>




<?php
$old = session()->get('_ci_old_input')['post'] ?? null;
?>

<?php if ($old || session()->getFlashdata('errors')): ?>
    <script>
        const oldValues = <?= json_encode($old, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;

        window.addEventListener('DOMContentLoaded', () => {
            if (!oldValues) return;

            const inputs = document.querySelectorAll('.form-control');

            inputs.forEach(input => {
                const name = input.name;
                if (!name || !(name in oldValues)) return;

                if (input.tagName.toLowerCase() === 'select') {
                    if (input.multiple && Array.isArray(oldValues[name])) {
                        [...input.options].forEach(option => {
                            option.selected = oldValues[name].includes(option.value);
                        });
                    } else {
                        input.value = oldValues[name];
                    }
                } else if (input.type === 'checkbox' || input.type === 'radio') {
                    if (Array.isArray(oldValues[name])) {
                        input.checked = oldValues[name].includes(input.value);
                    } else {
                        input.checked = input.value === oldValues[name];
                    }
                } else {
                    input.value = oldValues[name];
                }
            });
        });
    </script>
<?php endif; ?>


<?php if (session()->get('validation_errors_2')): ?>

    <?php


    ?>

    <script>
        const validationErrors = <?= json_encode(session()->get('validation_errors_2')) ?>;

        document.addEventListener('DOMContentLoaded', () => {
            Object.entries(validationErrors).forEach(([field, error]) => {
                const input = document.querySelector(`[name="${field}"]`);
                if (!input) return;

                input.classList.add('input-error');

                const errorDiv = document.createElement('div');
                errorDiv.className = 'field-error';
                errorDiv.textContent = error;

                const parent = input.closest('.form-group') || input.parentElement;
                if (parent && !parent.querySelector('.field-error')) {
                    parent.appendChild(errorDiv);
                }
            });
        });
    </script>
<?php endif; ?>