(function ($) {
	'use strict';

	// Chart builders
	function NewCustomers() {
		const options = {
			series: [{ name: 'Net Profit', data: [100, 300, 100, 400, 200, 400] }],
			chart: { type: 'area', height: 50, width: 100, toolbar: { show: false }, zoom: { enabled: false }, sparkline: { enabled: true } },
			colors: ['var(--primary)'],
			dataLabels: { enabled: false },
			legend: { show: false },
			stroke: { show: true, width: 3, curve: 'smooth', colors: ['var(--primary)'] },
			grid: { show: false, padding: { top: 0, right: 0, bottom: 0, left: 0 } },
			x: { categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May'], axisBorder: { show: false }, axisTicks: { show: false }, labels: { show: false }, crosshairs: { show: false }, tooltip: { enabled: true, offsetY: 0 } },
			y: { show: false },
			fill: {
				type: 'gradient', gradient: {
					colorStops: [
						{ offset: 0, color: 'var(--primary)', opacity: 1 },
						{ offset: 0.3, color: 'var(--primary)', opacity: 0.4 },
						{ offset: 100, color: 'var(--primary)', opacity: 0 }
					]
				}
			},
			tooltip: { enabled: false, y: { formatter: v => '$' + v + ' thousands' } },
			responsive: [{ breakpoint: 1400, options: { chart: { width: 70, height: 40 } } }]
		};
		new ApexCharts(document.querySelector("#NewCustomers"), options).render();
	}

	function NewCustomers1() {
		const options = {
			series: [{ name: 'Net Profit', data: [100, 300, 200, 400, 100, 400] }],
			chart: { type: 'area', height: 50, width: 100, toolbar: { show: false }, zoom: { enabled: false }, sparkline: { enabled: true } },
			colors: ['#0E8A74'],
			dataLabels: { enabled: false },
			legend: { show: false },
			stroke: { show: true, width: 3, curve: 'smooth', colors: ['#145650'] },
			grid: { show: false, padding: { top: 0, right: 0, bottom: 0, left: 0 } },
			x: { categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May'], axisBorder: { show: false }, axisTicks: { show: false }, labels: { show: false }, crosshairs: { show: false }, tooltip: { enabled: true, offsetY: 0 } },
			y: { show: false },
			fill: {
				type: 'gradient', gradient: {
					colorStops: [
						{ offset: 0, color: '#0E8A74', opacity: 1 },
						{ offset: 0.3, color: '#0E8A74', opacity: 0.4 },
						{ offset: 100, color: '#0E8A74', opacity: 0 }
					]
				}
			},
			tooltip: { enabled: false, y: { formatter: v => '$' + v + ' thousands' } },
			responsive: [{ breakpoint: 1400, options: { chart: { width: 70, height: 40 } } }]
		};
		new ApexCharts(document.querySelector("#NewCustomers1"), options).render();
	}

	function NewCustomers2() {
		const options = {
			series: [{ name: 'Net Profit', data: [100, 200, 100, 300, 200, 400] }],
			chart: { type: 'area', height: 50, width: 100, toolbar: { show: false }, zoom: { enabled: false }, sparkline: { enabled: true } },
			colors: ['#0E8A74'],
			dataLabels: { enabled: false },
			legend: { show: false },
			stroke: { show: true, width: 3, curve: 'smooth', colors: ['#3385D6'] },
			grid: { show: false, padding: { top: 0, right: 0, bottom: 0, left: 0 } },
			x: { categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May'], axisBorder: { show: false }, axisTicks: { show: false }, labels: { show: false }, crosshairs: { show: false }, tooltip: { enabled: true, offsetY: 0 } },
			y: { show: false },
			fill: {
				type: 'gradient', gradient: {
					colorStops: [
						{ offset: 0, color: '#3385D6', opacity: 1 },
						{ offset: 0.3, color: '#3385D6', opacity: 0.4 },
						{ offset: 100, color: '#3385D6', opacity: 0 }
					]
				}
			},
			tooltip: { enabled: false, y: { formatter: v => '$' + v + ' thousands' } },
			responsive: [{ breakpoint: 1400, options: { chart: { width: 70, height: 40 } } }]
		};
		new ApexCharts(document.querySelector("#NewCustomers2"), options).render();
	}

	function NewCustomers3() {
		const options = {
			series: [{ name: 'Net Profit', data: [100, 200, 100, 300, 200, 400] }],
			chart: { type: 'area', height: 50, width: 100, toolbar: { show: false }, zoom: { enabled: false }, sparkline: { enabled: true } },
			colors: ['#0E8A74'],
			dataLabels: { enabled: false },
			legend: { show: false },
			stroke: { show: true, width: 3, curve: 'smooth', colors: ['#B723AD'] },
			grid: { show: false, padding: { top: 0, right: 0, bottom: 0, left: 0 } },
			x: { categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May'], axisBorder: { show: false }, axisTicks: { show: false }, labels: { show: false }, crosshairs: { show: false }, tooltip: { enabled: true, offsetY: 0 } },
			y: { show: false },
			fill: {
				type: 'gradient', gradient: {
					colorStops: [
						{ offset: 0, color: '#B723AD', opacity: 1 },
						{ offset: 0.3, color: '#B723AD', opacity: 0.4 },
						{ offset: 100, color: '#B723AD', opacity: 0 }
					]
				}
			},
			tooltip: { enabled: false, y: { formatter: v => '$' + v + ' thousands' } },
			responsive: [{ breakpoint: 1400, options: { chart: { width: 70, height: 40 } } }]
		};
		new ApexCharts(document.querySelector("#NewCustomers3"), options).render();
	}

function generateRandomColors(count) {
  const colors = [];
  for (let i = 0; i < count; i++) {
    const color = '#' + Math.floor(Math.random()*16777215).toString(16).padStart(6, '0');
    colors.push(color);
  }
  return colors;
}


	function activityChart() {
		const element = document.querySelector(".datas_s_for_piechart");
		const labels = JSON.parse(element.getAttribute("data-labels"));
		const series = JSON.parse(element.getAttribute("data-series"));
const colors = generateRandomColors(labels.length);
		const options = {
			series: series,
			chart: { type: 'pie', height: 350 },
			labels: labels,
			colors: colors,
			legend: { position: 'right' },
			title: {
				text: 'Skills Distribution',
				style: { fontSize: '16px', fontWeight: 'bold' }
			},
			responsive: [{
				breakpoint: 480,
				options: {
					chart: { width: 200 },
					legend: { position: 'bottom' }
				}
			}]
		};

		new ApexCharts(document.querySelector("#vacancyChart"), options).render();
	}

	function activityBar1() {
		const options = {
			series: [{ name: 'Net Profit', data: [50, 40, 55, 25, 45, 40, 35, 55, 50, 25, 42, 35, 50] }],
			chart: { type: 'bar', height: 280, toolbar: { show: false } },
			plotOptions: { bar: { horizontal: false, columnWidth: '35%', endingShape: 'rounded' } },
			dataLabels: { enabled: false },
			colors: ['var(--primary)'],
			stroke: { show: true, width: 2, colors: ['transparent'] },
			xaxis: { categories: ['01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13'], labels: { style: { colors: 'var(--text)', fontSize: '13px', fontFamily: 'Poppins', fontWeight: 400 } }, axisTicks: { show: false }, axisBorder: { show: false } },
			yaxis: { labels: { style: { colors: 'var(--text)', fontSize: '13px', fontFamily: 'Poppins', fontWeight: 400 }, formatter: v => v } },
			grid: { show: true, strokeDashArray: 6, borderColor: 'var(--border)' },
			fill: { opacity: 1 }
		};
		const chart = new ApexCharts(document.querySelector("#activity1"), options);
		chart.render();

		$(".chart-tab .nav-link").on('click', function () {
			let data;
			switch ($(this).attr('data-series')) {
				case 'Daily': data = [60, 40, 50, 45, 60, 45, 35, 56, 45, 60, 36, 45, 60]; break;
				case 'Weekly': data = [55, 35, 45, 35, 55, 45, 35, 60, 40, 55, 45, 25, 45]; break;
				case 'Monthly': data = [50, 40, 55, 25, 45, 40, 35, 55, 50, 25, 42, 35, 50]; break;
				default: data = [50, 40, 55, 25, 45, 40, 35, 55, 50, 25, 42, 35, 50];
			}
			chart.updateSeries([{ name: 'Net Profit', data }]);
		});
	}

	function pieChart1() {
		const options = {
			series: [90, 68, 85],
			chart: { type: 'donut', height: 220 },
			dataLabels: { enabled: false },
			stroke: { width: 0 },
			colors: ['#1D92DF', '#4754CB', '#D55BC1'],
			legend: { show: false },
			responsive: [{ breakpoint: 1400, options: { chart: { height: 200 } } }]
		};
		new ApexCharts(document.querySelector("#pieChart1"), options).render();
	}

	function donutChart() {
		$("span.donut").peity("donut", { width: "100", height: "100" });
	}

	// Safe loader
	function safeRender(selector, fn) {
		if (document.querySelector(selector)) fn();
	}

	// On window load
	$(window).on('load', function () {
		setTimeout(function () {
			safeRender('#NewCustomers', NewCustomers);
			safeRender('#NewCustomers1', NewCustomers1);
			safeRender('#NewCustomers2', NewCustomers2);
			safeRender('#NewCustomers3', NewCustomers3);
			safeRender('#vacancyChart', activityChart);
			safeRender('#activity1', activityBar1);
			safeRender('#pieChart1', pieChart1);
			safeRender('span.donut', donutChart);
		}, 1000);
	});

})(jQuery);
