<?php

namespace App\Certificate\Certificate;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Contact_Person;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;
class Certificate extends BaseController
{

 
    public function delete_contact_person($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;
    
        $Contact_Person = new Contact_Person();
    
        // Check if record exists
        $existing = $Contact_Person->find($id);
    
        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }
    
        // Update the status field to 0 (soft delete)
        $Contact_Person->update($id, ['status' => 0]);
    
        // Optionally, add a success message
        return redirect()->back()->with('success', 'Contact person deactivated successfully.');
    }


    public function edit_contact_screen(){

 


$validationRules = [
    'title' => [
        'label' => 'Contact Person Title',
        'rules' => 'permit_empty|in_list[Mr,Mrs,Ms]',
        'errors' => [
            'in_list' => 'The {field} must be one of: Mr, Mrs, Ms.'
        ]
    ],

    'First_Name' => [
        'label' => 'Contact Person First Name',
        'rules' => 'required|string',
        'errors' => [
            'required' => 'The {field} is required.',
            'max_length' => 'The {field} must not exceed 30 characters.'
        ]
    ],

    'Middle_Name' => [
        'label' => 'Contact Person Middle Name',
        'rules' => 'permit_empty|string',
        'errors' => [
            'max_length' => 'The {field} must not exceed 30 characters.'
        ]
    ],

    'Last_Name' => [
        'label' => 'Contact Person Last Name',
        'rules' => 'permit_empty|string',
        'errors' => [
            'max_length' => 'The {field} must not exceed 30 characters.'
        ]
    ],

    'designation' => [
        'label' => 'Contact Person Designation',
        'rules' => 'required|numeric',
        'errors' => [
            'required' => 'The {field} is required.',
            'numeric' => 'The {field} must be a valid designation ID.'
        ]
    ],
 
    'Contact_Number' => [
        'label' => 'Contact Number',
        'rules' => 'required|numeric|exact_length[10]',
        'errors' => [
            'required' => 'The {field} is required.',
            'numeric' => 'The {field} must be a valid number.',
            'exact_length' => 'The {field} must be exactly 10 digits.'
        ]
    ],

    'Email_Address' => [
        'label' => 'Email Address',
        'rules' => 'required|valid_email|contact_person_email_id_cheek[Contact_Person.email]',
        'errors' => [
            'required' => 'The {field} is required.',
            'valid_email' => 'The {field} must be a valid email address.',
            'max_length' => 'The {field} must not exceed 50 characters.',
            'contact_person_email_id_cheek' => 'This email ID is already registered for the selected organization.',
        ]
    ],

     

    'Photo' => [
        'label' => 'Company Logo',
        'rules' => 'permit_empty|is_image[Photo]'
            . '|mime_in[Photo,image/jpeg,image/png,image/jpg]'
            . '|ext_in[Photo,jpg,jpeg,png]'
            . '|max_size[Photo,5120]',
        'errors' => [
            'is_image' => 'The file must be a valid image.',
            'mime_in' => 'Only JPEG and PNG images are allowed.',
            'ext_in' => 'Invalid file extension. Only JPG and PNG are allowed.',
            'max_size' => 'The image size must not exceed 5MB.',
        ]
        ],

    'Password' => [
    'label' => 'Password',
    'rules' => 'min_length[8]|permit_empty',  // 'permit_empty' makes it optional
    'errors' => [
        'min_length' => 'The {field} must be at least 8 characters long.',
    ]
],
];





if (!$this->validate($validationRules)) {


    session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
    // var_dump($this->validator->listErrors());
}


$data = [
    'Contact_Person_Title' => $this->request->getPost('title'),
    'Contact_Person_First_Name' => $this->request->getPost('First_Name'),
    'Contact_Person_Middle_Name' => $this->request->getPost('Middle_Name'),
    'Contact_Person_Last_Name' => $this->request->getPost('Last_Name'),
    'Designation' => $this->request->getPost('designation'),
    'Contact_Number' => $this->request->getPost('Contact_Number'),
     
    'email' => $this->request->getPost('Email_Address'),
    'updated_at' =>Time::now('Asia/Kolkata', 'Y-m-d H:i:s') ,
    'updated_by' =>session()->get('logined_user_id'),
     
    
    'entity_id' =>session()->get('entity_id'),
    'associated_by' =>session()->get('user_associated'),
     
    
];

$password = $this->request->getPost('Password');
if (!empty($password)) {
    $data['password'] = password_hash($password, PASSWORD_DEFAULT);
}



$contact_person_image = $this->request->getFile('Photo');

$session_id=session()->get('entity_id');

$contact_person_id = $this->request->getPost('contact_person_id');
$Contact_Person = new Contact_Person;
$existing = $Contact_Person->find($contact_person_id);


if ($contact_person_image && $contact_person_image->isValid() && !$contact_person_image->hasMoved()) {

    // Delete existing image before uploading new one
    if ($existing && !empty($existing['Person_Photo'])) {
        $oldImagePath = FCPATH . $existing['Person_Photo']; // Full path to old image
        if (file_exists($oldImagePath)) {
            unlink($oldImagePath); // Delete the old image
        }
    }

    // Validate extension
    $ext = $contact_person_image->getClientExtension();
    if (!in_array($ext, ['jpg', 'jpeg', 'png'])) {
        session()->set('validation_errors', "Invalid file type uploaded.");
        session()->markAsTempdata('validation_errors', 30);
        session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
    }

    // Generate new file name and path
    $logoName = $contact_person_image->getRandomName();
    $logoDir = "uploads/entity_profile/{$session_id}/contact_person/{$contact_person_id}";
    $logoPath = FCPATH . $logoDir;

    // Ensure directory exists
    if (!is_dir($logoPath)) {
        mkdir($logoPath, 0777, true);
    }

    // Move new image
    $contact_person_image->move($logoPath, $logoName);

    // Save relative path to session or DB
    $relativePath = $logoDir . '/' . $logoName;

    $data['Person_Photo'] =$relativePath;
}

$Contact_Person->update($contact_person_id,$data);


return redirect()->back()->with('success', 'Contact person updated successfully');

    }


    public function view_edit_screen($id)
    {
        $Contact_Person = new Contact_Person();
        $Contact_Person = $Contact_Person->find($id);
    
        $session = session();
        $id = $session->get('entity_id'); // or session('id');
    
        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);
    
        // Pass both variables in a single associative array to the view
        return view('organisation/contact_person/edit_contact_person', [
            'Contact_Person' => $Contact_Person,
            'organization' => $organization
        ]);
    }


    public function insert_contact_person()
    {

$table_to_cheek=session()->get('table');


        $validationRules = [
            'title' => [
                'label' => 'Contact Person Title',
                'rules' => 'permit_empty|in_list[Mr,Mrs,Ms]',
                'errors' => [
                    'in_list' => 'The {field} must be one of: Mr, Mrs, Ms.'
                ]
            ],
        
            'First_Name' => [
                'label' => 'Contact Person First Name',
                'rules' => 'required|string',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} must not exceed 30 characters.'
                ]
            ],
        
            'Middle_Name' => [
                'label' => 'Contact Person Middle Name',
                'rules' => 'permit_empty|string',
                'errors' => [
                    'max_length' => 'The {field} must not exceed 30 characters.'
                ]
            ],
        
            'Last_Name' => [
                'label' => 'Contact Person Last Name',
                'rules' => 'permit_empty|string',
                'errors' => [
                    'max_length' => 'The {field} must not exceed 30 characters.'
                ]
            ],
        
            'designation' => [
                'label' => 'Contact Person Designation',
                'rules' => 'required|numeric',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'numeric' => 'The {field} must be a valid designation ID.'
                ]
            ],
        
            'Contact_Number' => [
                'label' => 'Contact Number',
                'rules' => 'required|numeric|exact_length[10]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'numeric' => 'The {field} must be a valid number.',
                    'exact_length' => 'The {field} must be exactly 10 digits.'
                ]
            ],
        
            'Email_Address' => [ 
                'label' => 'Email Address',
                'rules' => 'required|valid_email|enity_user_email_cheek[Contact_Person.email]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'valid_email' => 'The {field} must be a valid email address.',
                    'max_length' => 'The {field} must not exceed 50 characters.',
                    'enity_user_email_cheek' => 'This email ID is already registered for the selected organization.',
                ]
            ],
        
            'Photo' => [
                'label' => 'Person Photo',
                'rules' => 'uploaded[Photo]|max_size[Photo,5120]|mime_in[Photo,image/jpeg,image/png]',
                'errors' => [
                    'uploaded' => 'The {field} is required.',
                    'max_size' => 'The {field} must not exceed 5MB.',
                    'mime_in' => 'The {field} must be a JPEG or PNG file.',
                    
                ]
            ],
        
            'Password' => [
                'label' => 'Password',
                'rules' => 'required|min_length[8]', 
                'errors' => [
                    'required' => 'The {field} is required.',
                    'min_length' => 'The {field} must be at least 8 characters long.'
                ]
            ],
        ];
        
        if (!$this->validate($validationRules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }
        // if (session()->has('user_type') && session()->get('user_type') !== null && session()->get('user_type') !== '') {
        //     echo "user_type: " . session()->get('user_type') . "<br>";
        // } else {
        //     echo "user_type not set or empty<br>";
        // }
        
        // if (session()->has('associated_with_id') && session()->get('associated_with_id') !== null && session()->get('associated_with_id') !== '') {
        //     echo "associated_with_id: " . session()->get('associated_with_id') . "<br>";
        // } else {
        //     echo "associated_with_id not set or empty<br>";
        // }
        

        // die();

        $data = [
            'Contact_Person_Title' => $this->request->getPost('title'),
            'Contact_Person_First_Name' => $this->request->getPost('First_Name'),
            'Contact_Person_Middle_Name' => $this->request->getPost('Middle_Name'),
            'Contact_Person_Last_Name' => $this->request->getPost('Last_Name'),
            'Designation' => $this->request->getPost('designation'),
            'Contact_Number' => $this->request->getPost('Contact_Number'),
             
            'email' => $this->request->getPost('Email_Address'),
            'created_by' =>session()->get('logined_user_id'),
            'password' =>session()->get('Password'),
            
            'entity_id' =>session()->get('entity_id'),
            'associated_by' =>session()->get('user_associated'),
             
            
        ];

        $model = new Contact_Person();  
        $model->insert($data);
        $insertId = $model->getInsertID();

        $session_id=session()->get('entity_id');

        $logo = $this->request->getFile('Photo');
        if ($logo && $logo->isValid() && !$logo->hasMoved()) {
            $logoName = $logo->getRandomName();
            $logoDir = "uploads/entity_profile/{$session_id}/contact_person/{$insertId}"; // Relative path
            $logoPath = FCPATH . $logoDir;

            // Make sure the folder exists
            if (!is_dir($logoPath)) {
                mkdir($logoPath, 0777, true);
            }

            // Move file
            $logo->move($logoPath, $logoName);

            // Final relative path to store in DB
            $relativePath = $logoDir . '/' . $logoName;

            // Update DB with logo path
            $model->update($insertId, ['Person_Photo' => $relativePath]);
        }



        
        return redirect()->back()->with('success', 'Contact person created successfully');




        // var_dump($insertId);

        // $session = session();
        // $id = $session->get('user_id'); // or session('id');

        // $loginModel = new Loginmodel();

        // $organization = $loginModel->find($id);
        // return view('organisation/contact_person/add_contact_person', ['organization' => $organization]);

    }



    public function add_Contact_Person()
    { 

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('organisation/contact_person/add_contact_person', ['organization' => $organization]);

    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
// echo "hi";
        return view('organisation/certificate/index', ['organization' => $organization]);

    }


}