<?php

namespace App\Controllers\Certificate;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\CertificationModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Certificate extends BaseController
{


    public function delete_cirtificate($id)
    {
        $cirtificate = new CertificationModel();
        $existing = $cirtificate->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'cirtificate not found.');
        }

        // Update the status field to 0 (soft delete)
        $cirtificate->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        return redirect()->back()->with('success', 'cirtificate deleted successfully.');
    }



    public function update_cirtificate()
    {

        helper(['form', 'url']);

        $certId = $this->request->getPost('cert_id');
        $certificationName = $this->request->getPost('cirtificate_name');
        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();


        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = 'uploads/entity_profile/' . $entityId . '/certification/' . $certId . '/';
        $uploadPath = FCPATH . $uploadFolder;

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }
        $model = new CertificationModel();
        $model->update($certId, [
            'certificate_name' => $certificationName,
            'suporting_documant' => json_encode($documents),
            'updated_by' => session()->get('logined_user_id'),
            'updated_at' => Time::now('Asia/Kolkata', 'Y-m-d H:i:s')
        ]);

        return redirect()->back()->with('success', 'Certification updated successfully!');
    }


    public function give_certificate_data()
    {

        $id = $this->request->getPost('data_id');
        $model = new CertificationModel();
        $row = $model->find($id);
        if ($row) {
            $row['suporting_documant'] = json_decode($row['suporting_documant'], true); // Convert JSON to array

            return $this->response->setJSON([
                'data' => $row,
                'csrfToken' => csrf_hash()
            ]);
        }

        return $this->response->setJSON([
            'error' => 'Data not found',
            'csrfToken' => csrf_hash()
        ]);
    }




    public function add_certificate()
    {

        $certificationName = $this->request->getPost('cirtificate_name');

        $model = new CertificationModel();
        // Step 1: Insert certification name to get the ID
        $model->insert([
            'certificate_name' => $certificationName,
            'suporting_documant' => '', // Empty for now,
            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,

        ]);

        $insertId = $model->getInsertID(); // Step 2: Get insert ID




        $entityId = session()->get('entity_id');
        $uploadPath = FCPATH . 'uploads/entity_profile/' . $entityId . '/certification/' . $insertId . '/';

        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];
        $documents = [];

        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);
                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => 'uploads/entity_profile/' . $entityId . '/certification/' . $insertId . '/' . $newName
                ];
            }
        }

        // Update record with document JSON
        $model->update($insertId, [
            'suporting_documant' => json_encode($documents)
        ]);

        return redirect()->back()->with('success', 'cirtificate deleted successfully');
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi";
        return view('' . $session->get('acessing_folder') . '/certificate/index', ['organization' => $organization]);
    }
}
