<?php

namespace App\Controllers\Certified_Audit;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Certified_audit_model;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Certified_Audit extends BaseController
{

 
    public function delete_cirtified_audit($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $Certified_audit = new Certified_audit_model();

        // Check if record exists   
        $existing = $Certified_audit->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $Certified_audit->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        return redirect()->back()->with('success', 'Certified audit   deleted successfully.');
    }


    public function update_certified_audit()
    {


        $rules = [
            'audit_categoery' => [
                'label' => 'Audit Category',
                'rules' => 'required|in_list[Initial,Surveillance,Renewal]',
                'errors' => [
                    'required' => 'Audit Category is required.',
                    'in_list' => 'Audit Category must be one of: Initial, Surveillance, Renewal',
                ]
            ],
            'recoed_date' => [
                'label' => 'Record Date',
                'rules' => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required' => 'Record Date is required.',
                    'valid_date' => 'Record Date must be in the format YYYY-MM-DDTHH:MM.',
                ]
            ],
            'location' => [
                'label' => 'Location',
                'rules' => 'required|max_length[255]',
                'errors' => [
                    'required' => 'Location is required.',
                    'max_length' => 'Location cannot exceed 255 characters.',
                ]
            ],

            'Certification_Body_Name' => [
                'label' => 'Certification Body Name',
                'rules' => 'required|max_length[255]',
                'errors' => [
                    'required' => 'Certification Body Name is required.',
                    'max_length' => 'Certification Body Name cannot exceed 255 characters.',
                ]
            ],

             

           

            'internal_audit_scope' => [
                'label' => 'Internal Audit Scope',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Audit Scope is required.',
                    'max_length' => 'Internal Audit Scope cannot exceed 1000 characters.',
                ]
            ],
            'internal_audit_checklist' => [
                'label' => 'Internal Audit Checklist',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Audit Checklist is required.',
                    'max_length' => 'Internal Audit Checklist cannot exceed 1000 characters.',
                ]
            ],
            'internal_non_conformities' => [
                'label' => 'Internal Non-Conformities',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Non-Conformities is required.',
                    'max_length' => 'Internal Non-Conformities cannot exceed 1000 characters.',
                ]
            ],
            'internal_opportunities' => [
                'label' => 'Internal Opportunities',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Opportunities is required.',
                    'max_length' => 'Internal Opportunities cannot exceed 1000 characters.',
                ]
            ],


            'description' => [
                'label' => 'Description',
                'rules' => 'required|max_length[2000]',
                'errors' => [
                    'required' => 'Description is required.',
                    'max_length' => 'Description cannot exceed 2000 characters.',
                ]
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'permit_empty|max_length[2000]',
                'errors' => [
                    'max_length' => 'Remark cannot exceed 2000 characters.',
                ]
            ],

            'Audit_Date' => [
                'label' => 'Audit Date',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Audit Date is required.',

                ]
            ],

        ];








      $data_1 = [];

        $location = $this->request->getPost('location');
        $others = $this->request->getPost('others');
        $selected_location_id = $this->request->getPost('selected_location_id');

        if ($location === 'Others') {
            $rules['others'] = [
                'label' => 'Other Location Name',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 50 characters.'
                ]
            ];


            if (!empty($_POST['others'])) {
                $data_1['Others'] = $_POST['others'];
            }
        }


        if ($location == 'Corporate_Office') {


            $data_1['Corporate_Office'] = null;
        }

        if ($location !== 'Corporate_Office' && $location !== 'Others') {
            $rules['selected_location_id'] = [
                'label' => 'Selected Location',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',

                ]
            ];

            if (!empty($_POST['selected_location_id'])) {
                $data_1[$location] = $_POST['selected_location_id'];
            }
        }


        





        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'record_date' => $this->request->getPost('recoed_date'),
            'audit_category' => $this->request->getPost('audit_categoery'),

            'internal_auditee_representative' =>  json_encode($this->request->getPost('auditee_name')),
            'location' => $this->request->getPost('location'),
            'AMSAudit_For' =>  json_encode($data_1),
           
            'internalAudit_schedule' => $this->request->getPost('internal_audit_schedule'),
            'internalAudit_scope' => $this->request->getPost('internal_audit_scope'),
            'internalAudit_checklist_used' => $this->request->getPost('internal_audit_checklist'),
            'internal_non_conformities_reported' => $this->request->getPost('internal_non_conformities'),
            'internal_opportunities_for_improvement' => $this->request->getPost('internal_opportunities'),


            'description' => $this->request->getPost('description'),
            'audit_date' => $this->request->getPost('Audit_Date'),
            'certification_body_name' => $this->request->getPost('Certification_Body_Name'),
            'No_of_days_of_Audit' => $this->request->getPost('No_of_days_of_Audit'),



            'remark' => $this->request->getPost('Remark'),
            




            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,



        ];





        $insertId = $this->request->getPost('updating_id');


        $session_id = session()->get('entity_id');



        $auditor_name = $this->request->getPost('auditor_name');

        $auditor_photo = $this->request->getFiles()['auditor_photo'];
        $existingauditor_photos = $this->request->getPost('existing_file_auditor_photo');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/certified_audit/{$insertId}/auditor/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($auditor_name as $i => $auditor_name) {
            $newFilePath = $existingauditor_photos[$i] ?? ''; // Default to existing

            if (isset($files['auditor_photo'][$i]) && $files['auditor_photo'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingauditor_photos[$i]) && file_exists(FCPATH . $existingauditor_photos[$i])) {
                    unlink(FCPATH . $existingauditor_photos[$i]);
                }

                $file = $files['auditor_photo'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $auditor_name,

                'file' => $newFilePath
            ];
        }

        $data['auditors'] = json_encode($documents);







        $report_date = $this->request->getPost('report_date');

        $report_file = $this->request->getFiles()['report_file'];
        $existing_report_file = $this->request->getPost('existing_report_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/certified_audit/{$insertId}/reports/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($report_date as $i => $report_date) {
            $newFilePath = $existing_report_file[$i] ?? ''; // Default to existing

            if (isset($files['report_file'][$i]) && $files['report_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingauditor_photos[$i]) && file_exists(FCPATH . $existingauditor_photos[$i])) {
                    unlink(FCPATH . $existingauditor_photos[$i]);
                }

                $file = $files['report_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'report_date' => $report_date,

                'report_file' => $newFilePath
            ];
        }

        $data['internal_final_audit_report'] = json_encode($documents);







        $report_date = $this->request->getPost('schedule_date');

        $report_file = $this->request->getFiles()['schedule_file'];
        $existing_report_file = $this->request->getPost('existing_schedule_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/certified_audit/{$insertId}/Audit_Schedule/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($report_date as $i => $report_date) {
            $newFilePath = $existing_report_file[$i] ?? ''; // Default to existing

            if (isset($files['schedule_file'][$i]) && $files['schedule_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingauditor_photos[$i]) && file_exists(FCPATH . $existingauditor_photos[$i])) {
                    unlink(FCPATH . $existingauditor_photos[$i]);
                }

                $file = $files['schedule_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'Schedule_date' => $report_date,

                'Schedule_file' => $newFilePath
            ];
        }

        $data['internalAudit_schedule'] = json_encode($documents);







        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/certified_audit/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['documants'] = json_encode($documents);


        $model = new Certified_audit_model();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success






            return redirect()->back()->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        // return redirect()->back()->with('success', 'packaging unit  updated successfully');
    }



    public function edit_cirtified_audit($id)
    {
       $Certified_audit = new Certified_audit_model();
        $Certified_audit = $Certified_audit->find($id);
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Certified_Audit/edit', [
              'Certified_audit' => $Certified_audit,
            'organization' => $organization
        ]);
    }


    public function view_citified_audit($id)
    {
        $Certified_audit = new Certified_audit_model();
        $Certified_audit = $Certified_audit->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Certified_Audit/view', [
            'Certified_audit' => $Certified_audit,
            'organization' => $organization
        ]);
    }


    public function certified_audit_insert()
    {




        $rules = [
            'audit_categoery' => [
                'label' => 'Audit Category',
                'rules' => 'required|in_list[Initial,Surveillance,Renewal]',
                'errors' => [
                    'required' => 'Audit Category is required.',
                    'in_list' => 'Audit Category must be one of: Initial, Surveillance, Renewal',
                ]
            ],
            'recoed_date' => [
                'label' => 'Record Date',
                'rules' => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required' => 'Record Date is required.',
                    'valid_date' => 'Record Date must be in the format YYYY-MM-DDTHH:MM.',
                ]
            ],
            'location' => [
                'label' => 'Location',
                'rules' => 'required|max_length[255]',
                'errors' => [
                    'required' => 'Location is required.',
                    'max_length' => 'Location cannot exceed 255 characters.',
                ]
            ],

            'Certification_Body_Name' => [
                'label' => 'Certification Body Name',
                'rules' => 'required|max_length[255]',
                'errors' => [
                    'required' => 'Certification Body Name is required.',
                    'max_length' => 'Certification Body Name cannot exceed 255 characters.',
                ]
            ],

             

           

            'internal_audit_scope' => [
                'label' => 'Internal Audit Scope',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Audit Scope is required.',
                    'max_length' => 'Internal Audit Scope cannot exceed 1000 characters.',
                ]
            ],
            'internal_audit_checklist' => [
                'label' => 'Internal Audit Checklist',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Audit Checklist is required.',
                    'max_length' => 'Internal Audit Checklist cannot exceed 1000 characters.',
                ]
            ],
            'internal_non_conformities' => [
                'label' => 'Internal Non-Conformities',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Non-Conformities is required.',
                    'max_length' => 'Internal Non-Conformities cannot exceed 1000 characters.',
                ]
            ],
            'internal_opportunities' => [
                'label' => 'Internal Opportunities',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Opportunities is required.',
                    'max_length' => 'Internal Opportunities cannot exceed 1000 characters.',
                ]
            ],


            'description' => [
                'label' => 'Description',
                'rules' => 'required|max_length[2000]',
                'errors' => [
                    'required' => 'Description is required.',
                    'max_length' => 'Description cannot exceed 2000 characters.',
                ]
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'permit_empty|max_length[2000]',
                'errors' => [
                    'max_length' => 'Remark cannot exceed 2000 characters.',
                ]
            ],

            'Audit_Date' => [
                'label' => 'Audit Date',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Audit Date is required.',

                ]
            ],

        ];





       $data_1 = [];

        $location = $this->request->getPost('location');
        $others = $this->request->getPost('others');
        $selected_location_id = $this->request->getPost('selected_location_id');

        if ($location === 'Others') {
            $rules['others'] = [
                'label' => 'Other Location Name',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 50 characters.'
                ]
            ];


            if (!empty($_POST['others'])) {
                $data_1['Others'] = $_POST['others'];
            }
        }


        if ($location == 'Corporate_Office') {


            $data_1['Corporate_Office'] = null;
        }

        if ($location !== 'Corporate_Office' && $location !== 'Others') {
            $rules['selected_location_id'] = [
                'label' => 'Selected Location',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',

                ]
            ];

            if (!empty($_POST['selected_location_id'])) {
                $data_1[$location] = $_POST['selected_location_id'];
            }
        }

        

        if (!$this->validate($rules)) {



            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());


            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            'record_date' => $this->request->getPost('recoed_date'),
            'audit_category' => $this->request->getPost('audit_categoery'),

            'internal_auditee_representative' =>  json_encode($this->request->getPost('auditee_name')),
            'location' => $this->request->getPost('location'),
            'AMSAudit_For' =>  json_encode($data_1),
           
            'internalAudit_schedule' => $this->request->getPost('internal_audit_schedule'),
            'internalAudit_scope' => $this->request->getPost('internal_audit_scope'),
            'internalAudit_checklist_used' => $this->request->getPost('internal_audit_checklist'),
            'internal_non_conformities_reported' => $this->request->getPost('internal_non_conformities'),
            'internal_opportunities_for_improvement' => $this->request->getPost('internal_opportunities'),


            'description' => $this->request->getPost('description'),
            'audit_date' => $this->request->getPost('Audit_Date'),
            'certification_body_name' => $this->request->getPost('Certification_Body_Name'),
            'No_of_days_of_Audit' => $this->request->getPost('No_of_days_of_Audit'),



            'remark' => $this->request->getPost('Remark'),
            'audit_id' => $this->request->getPost('facility_id'),


            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
           


        ];










        $model = new Certified_audit_model;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();













        $auditor_name = $this->request->getPost('auditor_name');

        $auditor_photo = $this->request->getFiles()['auditor_photo'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/certified_audit/{$insertId}/auditor";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/certified_audit/{$insertId}/auditor";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($auditor_name as $i => $name) {

            $file = $auditor_photo[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'auditors' => json_encode($documents)
        ]);







        $report_date = $this->request->getPost('report_date');
        $report_file = $this->request->getFiles()['report_file'];

        $entityId = session()->get('entity_id');
        $reports = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/certified_audit/{$insertId}/reports";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/certified_audit/{$insertId}/reports";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($report_date as $i => $name) {

            $file = $report_file[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $reports[] = [
                    'report_date' => $name,
                    'report_file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'internal_final_audit_report' => json_encode($reports)
        ]);








        $schedule_date = $this->request->getPost('schedule_date');
        $schedule_file = $this->request->getFiles()['schedule_file'];

        $entityId = session()->get('entity_id');
        $Audit_Schedule = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/certified_audit/{$insertId}/Audit_Schedule";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/certified_audit/{$insertId}/Audit_Schedule";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($schedule_date as $i => $name) {

            $file = $schedule_file[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $Audit_Schedule[] = [

                    'Schedule_date' => $name,
                    'Schedule_file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'internalAudit_schedule' => json_encode($Audit_Schedule)
        ]);







        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/certified_audit/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/certified_audit/{$insertId}/documants";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'documants' => json_encode($documents)
        ]);



















        return redirect()->back()->with('success', 'certified audit  added successfully!');
    }










    public function add_new_Certified_audit()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Certified_Audit/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Certified_Audit/index', ['organization' => $organization]);
    }
}
