<?php

namespace App\Controllers\Crop_details;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Farm_crop_details_model;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Crop_details extends BaseController
{


    public function delete_farm_crop($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $Farm_cro = new Farm_crop_details_model();

        // Check if record exists
        $existing = $Farm_cro->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $Farm_cro->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        return redirect()->back()->with('success', 'crop   deleted successfully.');
    }


    public function update_crop_farm()
    {




        $rules = [
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Farm' => [
                'label'  => 'Farm',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop' => [
                'label'  => 'crop',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop_name' => [
                'label'  => 'crop',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Produce_Specifications' => [
                'label'  => 'Produce Specifications',
                'rules'  => 'required|string|max_length[50]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'Crop_Quantity_Measure' => [
                'label'  => 'Crop Quantity Measure',
                'rules'  => 'required|in_list[Kilograms,Qunital,Tonnes,Pounds]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be one of: Kilograms, Qunital, Tonnes, Pounds.',
                ],
            ],
            'Production_Estimate' => [
                'label'  => 'Production Estimate (Qty)',
                'rules'  => 'required|decimal|greater_than[0]',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],
            'Crop_Date' => [
                'label'  => 'Crop Date',
                'rules'  => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date (YYYY-MM-DD).',
                ],
            ],
            'Harvested_Date' => [
                'label'  => 'Harvested Date',
                'rules'  => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date (YYYY-MM-DD).',
                ],
            ],
            'Crop_Sales_Qty' => [
                'label'  => 'Crop Sales Quantity',
                'rules'  => 'required|decimal|greater_than_equal_to[0]',
                'errors' => [
                    'required'                => 'The {field} field is required.',
                    'decimal'                 => 'The {field} must be a decimal number.',
                    'greater_than_equal_to'   => 'The {field} cannot be negative.',
                ],
            ],
            'Sales_Date' => [
                'label'  => 'Sales Date',
                'rules'  => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date (YYYY-MM-DD).',
                ],
            ],
            'Inventory_Qty_Location_Wise' => [
                'label'  => 'Inventory Quantity Location Wise',
                'rules'  => 'required|decimal|greater_than_equal_to[0]',
                'errors' => [
                    'required'                => 'The {field} field is required.',
                    'decimal'                 => 'The {field} must be a decimal number.',
                    'greater_than_equal_to'   => 'The {field} cannot be negative.',
                ],
            ],
            'Season' => [
                'label'  => 'Season',
                'rules'  => 'required|in_list[Kharif,Rabi]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be either Kharif or Rabi.',
                ],
            ],
            'Crop_Certification_Standard' => [
                'label'  => 'Crop Certification Standard',
                'rules'  => 'required|string|max_length[100]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 100 characters.',
                ],
            ],
            'Remark' => [
                'label'  => 'Remark',
                'rules'  => 'permit_empty|string|max_length[250]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
        ];




        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'farmer_id' => $this->request->getPost('farmer'),
            'farm_id' => $this->request->getPost('Farm'),
            'crop_id' => $this->request->getPost('crop'),
            'crop_name' =>implode(",",$this->request->getPost('crop_name')),
            'produce_specs' => $this->request->getPost('Produce_Specifications'),
            'crop_qty_measure' => $this->request->getPost('Crop_Quantity_Measure'),
            'production_estimate_qty' => $this->request->getPost('Production_Estimate'),
            'crop_date' => $this->request->getPost('Crop_Date'),
            'harvested_date' => $this->request->getPost('Harvested_Date'),
            'crop_sales_qty' => $this->request->getPost('Crop_Sales_Qty'),
            'sales_date' => $this->request->getPost('Sales_Date'),
            'inventory_qty_location_wise' => $this->request->getPost('Inventory_Qty_Location_Wise'),
            'season' => $this->request->getPost('Season'),
            'crop_certification_standard' => $this->request->getPost('Crop_Certification_Standard'),
            'remark' => $this->request->getPost('Remark'),


            
           
            'updated_by' => session()->get('logined_user_id'), // Empty for now,




        ];


        $insertId = $this->request->getPost('updating_id');




        $session_id = session()->get('entity_id');






       













        $model = new Farm_crop_details_model();



        $model->update($insertId, $data);




        return redirect()->back()->with('success', 'crop details  updated successfully');
    }



    public function edit_farm_crop($id)
    {
        $Farm_crop = new Farm_crop_details_model();
        $Farm_crop = $Farm_crop->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Crop_details/edit', [
            'Farm_crop' => $Farm_crop,
            'organization' => $organization
        ]);
    }


    public function view_farm_crop($id)
    {
        $Farm_crop = new Farm_crop_details_model();
        $Farm_crop = $Farm_crop->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Crop_details/view', [
            'Farm_crop' => $Farm_crop,
            'organization' => $organization
        ]);
    }


    public function insert_crop_form_assinge()
    {



        $rules = [
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Farm' => [
                'label'  => 'Farm',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop' => [
                'label'  => 'crop',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop_name' => [
                'label'  => 'crop',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Produce_Specifications' => [
                'label'  => 'Produce Specifications',
                'rules'  => 'required|string|max_length[50]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'Crop_Quantity_Measure' => [
                'label'  => 'Crop Quantity Measure',
                'rules'  => 'required|in_list[Kilograms,Qunital,Tonnes,Pounds]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be one of: Kilograms, Qunital, Tonnes, Pounds.',
                ],
            ],
            'Production_Estimate' => [
                'label'  => 'Production Estimate (Qty)',
                'rules'  => 'required|decimal|greater_than[0]',
                'errors' => [
                    'required'     => 'The {field} field is required.',
                    'decimal'      => 'The {field} must be a decimal number.',
                    'greater_than' => 'The {field} must be greater than zero.',
                ],
            ],
            'Crop_Date' => [
                'label'  => 'Crop Date',
                'rules'  => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date (YYYY-MM-DD).',
                ],
            ],
            'Harvested_Date' => [
                'label'  => 'Harvested Date',
                'rules'  => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date (YYYY-MM-DD).',
                ],
            ],
            'Crop_Sales_Qty' => [
                'label'  => 'Crop Sales Quantity',
                'rules'  => 'required|decimal|greater_than_equal_to[0]',
                'errors' => [
                    'required'                => 'The {field} field is required.',
                    'decimal'                 => 'The {field} must be a decimal number.',
                    'greater_than_equal_to'   => 'The {field} cannot be negative.',
                ],
            ],
            'Sales_Date' => [
                'label'  => 'Sales Date',
                'rules'  => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date (YYYY-MM-DD).',
                ],
            ],
            'Inventory_Qty_Location_Wise' => [
                'label'  => 'Inventory Quantity Location Wise',
                'rules'  => 'required|decimal|greater_than_equal_to[0]',
                'errors' => [
                    'required'                => 'The {field} field is required.',
                    'decimal'                 => 'The {field} must be a decimal number.',
                    'greater_than_equal_to'   => 'The {field} cannot be negative.',
                ],
            ],
            'Season' => [
                'label'  => 'Season',
                'rules'  => 'required|in_list[Kharif,Rabi]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be either Kharif or Rabi.',
                ],
            ],
            'Crop_Certification_Standard' => [
                'label'  => 'Crop Certification Standard',
                'rules'  => 'required|string|max_length[100]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 100 characters.',
                ],
            ],
            'Remark' => [
                'label'  => 'Remark',
                'rules'  => 'permit_empty|string|max_length[250]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
        ];



 

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }




 


        $data = [
            'farmer_id' => $this->request->getPost('farmer'),
            'farm_id' => $this->request->getPost('Farm'),
            'crop_id' => $this->request->getPost('crop'),
            'crop_name' =>implode(",",$this->request->getPost('crop_name')),
            'produce_specs' => $this->request->getPost('Produce_Specifications'),
            'crop_qty_measure' => $this->request->getPost('Crop_Quantity_Measure'),
            'production_estimate_qty' => $this->request->getPost('Production_Estimate'),
            'crop_date' => $this->request->getPost('Crop_Date'),
            'harvested_date' => $this->request->getPost('Harvested_Date'),
            'crop_sales_qty' => $this->request->getPost('Crop_Sales_Qty'),
            'sales_date' => $this->request->getPost('Sales_Date'),
            'inventory_qty_location_wise' => $this->request->getPost('Inventory_Qty_Location_Wise'),
            'season' => $this->request->getPost('Season'),
            'crop_certification_standard' => $this->request->getPost('Crop_Certification_Standard'),
            'remark' => $this->request->getPost('Remark'),


            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,




        ];


        $model = new Farm_crop_details_model;
        // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();



         










        return redirect()->back()->with('success', 'crop added successfully!');
    }





    public function add_new_crop()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Crop_details/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Crop_details/index', ['organization' => $organization]);
    }
}
