<?php

namespace App\Controllers;

use App\Models\Loginmodel;
use App\Models\Farmer_module;
use CodeIgniter\Database\Exceptions\DataException;

class EntityRegister extends BaseController
{


    public function logout()
    { 

        session()->destroy();

        // Redirect to the login page (or home page)
        return redirect()->to('/entity_login'); // Update this to your actual login page URL


    }



    public function reset_password()
    {


        $password = $this->request->getPost('password');


        $inputOtp = session()->get('user_entered_otp');



        if (session()->has('otp_code')) {
            if ($inputOtp === session()->get('otp_code')) {



                $email_adress = session()->get('Email_id');


                $db = \Config\Database::connect();
                $tables = [
                    'Contact_Person',
                    'entity_profiles',
                    'farmers',
                    'farmer_supervisors',
                    'internal_auditors',
                    'internal_inspectors',
                    'subcontractors',
                    'employee',
                ];
                $found = false;
                $matchedTable = '';
                $userData = null;

                $emailFound = false;
                $passwordMatched = false;
                $matchedTable = '';
                $userData = null;

                foreach ($tables as $table) {
                    $builder = $db->table($table);
                    $builder->where('email', $email_adress);
                    $builder->where('status', 1);
                    $user = $builder->get()->getRow();

                    if ($user) {
                        $emailFound = true;
                        $matchedTable = $table;
                        $userData = $user;
                        break;
                    }
                }


                if (! $matchedTable) {
                    // No active user found
                    return redirect()->back()
                        ->with('error', 'No active account found for that email.');
                }


                // 2) Hash the new password
                $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

                // 3) Update the password in the matched table
                $updated = $db->table($matchedTable)
                    ->where('email', $email_adress)
                    ->update(['password' => $hashedPassword]);

                if ($updated) {


                    return redirect()->to('/entity_login')
                        ->with('success', 'Your password has been reset successfully.');
                } else {
                    return redirect()->back()
                        ->with('error', 'Failed to update password. Please try again.');
                }
            } else {



                session()->set('validation_errors', 'Invalid OTP entered.');
                session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

                session()->set('validation_errors_2', $this->validator->getErrors());
                session()->markAsTempdata('validation_errors_2', 30);




                return redirect()->back()->withInput();
            }
        }
    }

    public function for_get_otp_verifying()
    {
        // Get the input OTP as integer
        $inputOtp = (int) $this->request->getPost('otp');

        // Check if session has OTP stored
        if (session()->has('otp_code')) {
            $sessionOtp = (int) session()->get('otp_code');

            if ($inputOtp === $sessionOtp) {

                // Optional: Remove OTP from session to prevent reuse
                // session()->remove('otp_code');

                // Set OTP verified flag or any other needed session value
                session()->set('user_entered_otp', $inputOtp);

                // Redirect to password reset view
                return view('new_password_enter_screen');
            } else {

                return redirect()->to('/otp_screen_for_forget')->with('error', 'Invalid OTP entered.');
            }
        } else {


            return redirect()->to('/otp_screen_for_forget')->with('error', 'OTP expired or not found.');
        }
    }
















    public function otp_screen_for_forget()
    {
        return view('forget_otp_screen');
    }
    public function send_otp_for_ferget_password()
    {

        $otp = rand(100000, 999999);
        $validationRules = [
            'Email_id' => [
                'label' => 'Email address',
                'rules' => 'required|valid_email',
                'errors' => [
                    'required' => 'Email is required.',
                    'valid_email' => 'Please enter a valid email address.',
                ],
            ],


        ];


        if (!$this->validate($validationRules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds


            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }




        $login_email = $this->request->getPost('Email_id');


        $db = \Config\Database::connect();
        $tables = [
            'Contact_Person',
            'entity_profiles',
            'farmers',
            'farmer_supervisors',
            'internal_auditors',
            'internal_inspectors',
            'subcontractors',
            'employee',
        ];
        $found = false;
        $matchedTable = '';
        $userData = null;

        $emailFound = false;
        $passwordMatched = false;
        $matchedTable = '';
        $userData = null;

        foreach ($tables as $table) {
            $builder = $db->table($table);
            $builder->where('email', $login_email);
            $builder->where('status', 1);
            $user = $builder->get()->getRow();

            if ($user) {
                $emailFound = true;
                break;
            }
        }

        if ($emailFound) {

            $email = \Config\Services::email();

            $email->setTo($this->request->getPost('Email_id'));
            $email->setSubject('Test Email from CI4');
            $email->setMessage('<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Secure OTP Verification</title>
<style>
    /* Base Styles */
    body {
        font-family: Arial, sans-serif;
        background-color: #f8f9fa;
        margin: 0;
        padding: 20px;
        color: #333;
        line-height: 1.5;
    }
    .container {
        background-color: #ffffff;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        padding: 25px;
        max-width: 600px;
        margin: 0 auto;
    }
    
    /* Header Styles */
    .header {
        text-align: center;
        margin-bottom: 25px;
        padding-bottom: 15px;
        border-bottom: 1px solid #eee;
    }
    .header img {
        max-width: 180px;
        height: auto;
        margin-bottom: 15px;
    }
    .header h2 {
        color: #2c3e50;
        margin: 0;
        font-size: 22px;
    }
    
    /* Content Styles */
    .content h3 {
        color: #2c3e50;
        margin-top: 0;
        font-size: 18px;
    }
    .otp-code {
        font-weight: bold;
        font-size: 28px;
        color: #007BFF;
        margin: 25px 0;
        text-align: center;
        letter-spacing: 5px;
        padding: 10px;
        background-color: #f8f9fa;
        border-radius: 5px;
        display: inline-block;
        width: 100%;
    }
    
    /* Warning Box */
    .warning {
        background-color: #fff8f8;
        border-left: 4px solid #ff4444;
        padding: 15px;
        margin: 25px 0;
        font-size: 14px;
        border-radius: 0 4px 4px 0;
    }
    .warning strong {
        color: #d32f2f;
        display: block;
        margin-bottom: 8px;
        font-size: 15px;
    }
    .warning ol {
        margin: 10px 0 0 20px;
        padding: 0;
    }
    .warning li {
        margin-bottom: 8px;
    }
    .warning ul {
        margin: 5px 0 0 20px;
        padding: 0;
        list-style-type: circle;
    }
    
    /* Contact Info */
    .contact-info {
        margin-top: 25px;
        padding-top: 15px;
        border-top: 1px solid #eee;
        font-size: 14px;
    }
    .contact-info strong {
        display: block;
        margin-bottom: 8px;
    }
    .contact-info a {
        color: #007BFF;
        text-decoration: none;
    }
    
    /* Footer */
    .footer {
        text-align: center;
        margin-top: 25px;
        font-size: 12px;
        color: #777;
        padding-top: 15px;
        border-top: 1px solid #eee;
    }
    
    /* Responsive */
    @media only screen and (max-width: 600px) {
        .container {
            padding: 15px;
        }
        .otp-code {
            font-size: 24px;
        }
    }
</style>
</head>
<body>

<div class="container">
<div class="header">
    <img src="' . base_url() . 'assets/logo/krishi-gap-logo.png" alt="Company Logo">
    <h2>Secure OTP Verification</h2>
</div>

<div class="content">
    
    <p>Your One-Time Password (OTP) for verification is:</p>
    <div class="otp-code">' . $otp . '</div>
    <p>This code expires in <strong>10 minutes</strong></p>
    
    <div class="warning">
        <strong>⚠ Important Security Notice</strong>
        <ol>
            <li><strong>Use this OTP immediately</strong> on our verification page</li>
            <li><strong>Never share</strong> this code - Company staff will never ask for it</li>
            <li>If you didn `t request this OTP:
                <ul>
                    <li>Reset your password immediately</li>
                    <li>Contact support using the information below</li>
                </ul>
            </li>
        </ol>
    </div>
    
    <div class="contact-info">
        <strong>Need help?</strong>
        <p>📞 <a href="tel:+11234567890">+1 (123) 456-7890</a> (24/7 support)</p>
        <p>✉ <a href="mailto:support@yourcompany.com">support@yourcompany.com</a></p>
        <p>🌐 <a href="https://yourcompany.com/support">yourcompany.com/support</a></p>
    </div>
</div>

<div class="footer">
    <p>© 2023 YourCompany. All rights reserved.</p>
    <p>This is an automated message - please do not reply directly to this email</p>
</div>
</div>

</body>
</html>');

            if ($email->send()) {


                session()->set('Email_id', $this->request->getPost('Email_id'));


                session()->set('otp_code', $otp);


                session()->set('reciver_email', $this->request->getPost('Email_id'));
                session()->set('user_name', "  ");

                session()->markAsTempdata('otp_code', 12000); // 300 seconds = 5 minutes

                return redirect()->to('otp_screen_for_forget')->with('success', 'Registration successful!');
            } else {
                echo "❌ Failed to send email.<br><br>";
                echo "<pre>" . print_r($email->printDebugger(['headers', 'subject', 'body']), true) . "</pre>";
            }
        }
    }

    public function forget_password()
    {

        return view('forget_password');
    }
    public function login_funtion()
    {



        helper(['form']); // Load form helper


        $validationRules = [
            'Email_id' => [
                'label' => 'Email address',
                'rules' => 'required|valid_email',
                'errors' => [
                    'required' => 'Email is required.',
                    'valid_email' => 'Please enter a valid email address.',
                ],
            ],
            'password' => [
                'label' => 'Password',
                'rules' => 'required|min_length[8]',
                'errors' => [
                    'required' => 'Password is required.',
                    'min_length' => 'Password must be at least 8 characters long.',
                ],
            ],

        ];




        if (!$this->validate($validationRules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds


            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }






        // $throttler = \Config\Services::throttler();
        // if (!$throttler->check($this->request->getIPAddress(), 5, MINUTE)) {
        //     return redirect()->back()->with('error', 'Too many attempts. Try again later.');
        // }


        $email = $this->request->getPost('Email_id');
        $password = $this->request->getPost('password');

        $db = \Config\Database::connect();
        $tables = [
            'Contact_Person',
            'entity_profiles',
            'farmers',
            'farmer_supervisors',
            'internal_auditors',
            'internal_inspectors',
            'subcontractors',
            'employee',
        ];

        $found = false;
        $matchedTable = '';
        $userData = null;

        $emailFound = false;
        $passwordMatched = false;
        $matchedTable = '';
        $userData = null;

        foreach ($tables as $table) {
            $builder = $db->table($table);
            $builder->where('email', $email);
            $builder->where('status', 1);
            $user = $builder->get()->getRow();

            if ($user) {
                $emailFound = true;
                if (password_verify($password, $user->password)) {
                    $passwordMatched = true;
                    $matchedTable = $table;
                    $userData = $user;
                    break;
                }
            }
        }


        if ($emailFound && $passwordMatched) {





            if ($matchedTable == "farmers") {




                try {
                    $builder = $db->table("farmers");
                    $user = $builder
                        ->where('email', $email)
                        ->get()
                        ->getRowArray();



                    if (!$user || !password_verify($password, $user['password'])) {
                        session()->set('validation_errors', 'Invalid login credentials.');
                        session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds
                        return redirect()->back()->withInput();
                    }


                    $logBuilder = $db->table('register_log');
                    $query = $logBuilder
                        ->where('user_id', $user['id'])
                        ->where('user_table', $table)
                        ->get();

                    $result = $query->getRow(); // Use getResult() for multiple rows
                    $thisIsEntityLogin = is_null($user['associated_by']) ? false : true;


                    // Set session
                    session()->set([
                        'logined_user_id' => $result->id,
                        'user_email' => $user['email'],
                        'user_associated' => 'farmers',
                        'user_type' => "farmers", 
                        'table' => $table,
                        'entity_id' => $user['id'],
                        'this_is_entity_login' => $thisIsEntityLogin,
                        'isLoggedIn' => true
                    ]);
                } catch (DataException $e) {


                    session()->set('validation_errors', 'Incorrect Username or Password');
                    session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds


                    return redirect()->back()->withInput();
                }
            } else {




                if ($matchedTable == "entity_profiles") {


                    try {
                        $builder = $db->table($matchedTable);
                        $user = $builder
                            ->where('email', $email)

                            ->where('status', 1)

                            ->get()
                            ->getRowArray();

                        if (!$user || !password_verify($password, $user['password'])) {

                            session()->set('validation_errors', 'Invalid login credentials.');
                            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds
                            return redirect()->back()->withInput();
                        }


                        $logBuilder = $db->table('register_log');
                        $query = $logBuilder
                            ->where('user_id', $user['id'])
                            ->where('user_table', $matchedTable)
                            ->get();

                        $result = $query->getRow(); // Use getResult() for multiple rows



                        session()->set([
                            'logined_user_id' => $result->id,
                            'user_email' => $user['email'],
                            'user_associated' => $user['user_type'],
                            'table' => $table,
                            'entity_id' => $user['id'],
                            'this_is_entity_login' => true,
                            'isLoggedIn' => true
                        ]);
                    } catch (DataException $e) {
                        session()->set('validation_errors', 'Incorrect Username or Password');
                        session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds


                        return redirect()->back()->withInput();
                    }
                } else {



                    try {
                        $builder = $db->table($matchedTable);
                        $user = $builder
                            ->where('email', $email)

                            ->where('status', 1)

                            ->get()
                            ->getRowArray();

                        if (!$user || !password_verify($password, $user['password'])) {
                            session()->set('validation_errors', 'Invalid login credentials.');
                            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds
                            return redirect()->back()->withInput();
                        }


                        $logBuilder = $db->table('register_log');
                        $query = $logBuilder
                            ->where('user_id', $user['id'])
                            ->where('user_table', $table)
                            ->get();

                        $result = $query->getRow(); // Use getResult() for multiple rows

                        if (!$result) {
                            session()->set('validation_errors', 'Invalid login credentials.');
                            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds
                            return redirect()->back()->withInput();
                        }


                        session()->set([
                            'logined_user_id' => $result->id,
                            'user_funtional_id' => $user['id'],
                            'user_email' => $user['email'],
                            'user_associated' => $user['associated_by'],
                            'table' => $table,
                            'entity_id' => $user['entity_id'],
                            'this_is_entity_login' => false,
                            'isLoggedIn' => true
                        ]);
                    } catch (DataException $e) {
                        session()->set('validation_errors', 'Incorrect Username or Password');
                        session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds


                        return redirect()->back()->withInput();
                    }
                }
            }



               

 


            switch (session()->get('user_associated')) {
                case "organisation":
                    return redirect()->to('/organization');
                case "fpo":
                    return redirect()->to('/Fpo');
                case "farmers":
                  
                    return redirect()->to('/farmer_login');
                case "audit_company":
                    return redirect()->to('/audit_company');
                default:
                  
                    return redirect()->to('/entity_login')->with('error', 'Invalid login type.');
            }
            // return or proceed to login
        } elseif ($emailFound && !$passwordMatched) {



            session()->set('validation_errors', "❌ Password is incorrect.");
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds


            session()->set('validation_errors_2', "❌ Password is incorrect.");
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        } else {


            session()->set('validation_errors', "❌ Email not found in any table.");
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds


            session()->set('validation_errors_2', "❌ Email not found in any table.");
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }











        // var_dump($_POST);


    }



    public function check_user_roles()
    {

        $tables = ['entity_profiles', 'Contact_Person', 'employee', 'subcontractors', 'internal_inspectors', 'internal_auditors', 'farmer_supervisors', 'auditors'];


        $email = $this->request->getPost('email');
        $type = $this->request->getPost('type_value');

        $response = [];

        $db = \Config\Database::connect();

        foreach ($tables as $table) {


            if ($table == "entity_profiles") {

                $builder = $db->table($table);
                $count = $builder->where('email', $email)
                    ->where('status', 1)
                    ->where('user_type', $type)
                    ->countAllResults();
            } else {

                $builder = $db->table($table);
                $count = $builder->where('email', $email)
                    ->where('status', 1)
                    ->where('associated_by', $type)
                    ->countAllResults();
            }



            if ($count > 0) {
                $response[] = [
                    'table' => $table,

                ];
            }
        }




        return $this->response->setJSON([
            'response' => $response, // Corrected here
            'csrfToken' => csrf_hash()
        ]);




        // return $this->response->setJSON($response);

        // var_dump($response);

    }



    public function login()
    {
        return view('login_page');
    }

    public function resend_otp()
    {

        $otp = rand(100000, 999999); // generate new OTP
        session()->set('otp_code', $otp);
        session()->set('new_otp', $otp);
        session()->markAsTempdata('otp_code', 11200); // 10 minutes

        $email_id = session()->get('reciver_email');
        $name = session()->get('user_name');


        $email = \Config\Services::email();

        $email->setTo($email_id);
        $email->setSubject('Test Email from CI4');
        $email->setMessage('<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secure OTP Verification</title>
    <style>
        /* Base Styles */
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
            color: #333;
            line-height: 1.5;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 25px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* Header Styles */
        .header {
            text-align: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
        }
        .header img {
            max-width: 180px;
            height: auto;
            margin-bottom: 15px;
        }
        .header h2 {
            color: #2c3e50;
            margin: 0;
            font-size: 22px;
        }
        
        /* Content Styles */
        .content h3 {
            color: #2c3e50;
            margin-top: 0;
            font-size: 18px;
        }
        .otp-code {
            font-weight: bold;
            font-size: 28px;
            color: #007BFF;
            margin: 25px 0;
            text-align: center;
            letter-spacing: 5px;
            padding: 10px;
            background-color: #f8f9fa;
            border-radius: 5px;
            display: inline-block;
            width: 100%;
        }
        
        /* Warning Box */
        .warning {
            background-color: #fff8f8;
            border-left: 4px solid #ff4444;
            padding: 15px;
            margin: 25px 0;
            font-size: 14px;
            border-radius: 0 4px 4px 0;
        }
        .warning strong {
            color: #d32f2f;
            display: block;
            margin-bottom: 8px;
            font-size: 15px;
        }
        .warning ol {
            margin: 10px 0 0 20px;
            padding: 0;
        }
        .warning li {
            margin-bottom: 8px;
        }
        .warning ul {
            margin: 5px 0 0 20px;
            padding: 0;
            list-style-type: circle;
        }
        
        /* Contact Info */
        .contact-info {
            margin-top: 25px;
            padding-top: 15px;
            border-top: 1px solid #eee;
            font-size: 14px;
        }
        .contact-info strong {
            display: block;
            margin-bottom: 8px;
        }
        .contact-info a {
            color: #007BFF;
            text-decoration: none;
        }
        
        /* Footer */
        .footer {
            text-align: center;
            margin-top: 25px;
            font-size: 12px;
            color: #777;
            padding-top: 15px;
            border-top: 1px solid #eee;
        }
        
        /* Responsive */
        @media only screen and (max-width: 600px) {
            .container {
                padding: 15px;
            }
            .otp-code {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        <img src="' . base_url() . 'assets/logo/krishi-gap-logo.png" alt="Company Logo">
        <h2>Secure OTP Verification</h2>
    </div>
    
    <div class="content">
        <h3>Hello, ' . $name . '!</h3>
        <p>Your One-Time Password (OTP) for verification is:</p>
        <div class="otp-code">' . $otp . '</div>
        <p>This code expires in <strong>10 minutes</strong></p>
        
        <div class="warning">
            <strong>⚠ Important Security Notice</strong>
            <ol>
                <li><strong>Use this OTP immediately</strong> on our verification page</li>
                <li><strong>Never share</strong> this code - Company staff will never ask for it</li>
                <li>If you didn `t request this OTP:
                    <ul>
                        <li>Reset your password immediately</li>
                        <li>Contact support using the information below</li>
                    </ul>
                </li>
            </ol>
        </div>
        
        <div class="contact-info">
            <strong>Need help?</strong>
            <p>📞 <a href="tel:+11234567890">+1 (123) 456-7890</a> (24/7 support)</p>
            <p>✉ <a href="mailto:support@yourcompany.com">support@yourcompany.com</a></p>
            <p>🌐 <a href="https://yourcompany.com/support">yourcompany.com/support</a></p>
        </div>
    </div>
    
    <div class="footer">
        <p>© 2023 YourCompany. All rights reserved.</p>
        <p>This is an automated message - please do not reply directly to this email</p>
    </div>
</div>

</body>
</html>');

        if ($email->send()) {

            return redirect()->back()->with('success', 'A new OTP has been sent.');
        } else {
            echo "❌ Failed to send email.<br><br>";
            echo "<pre>" . print_r($email->printDebugger(['headers', 'subject', 'body']), true) . "</pre>";
        }
    }





    public function index()
    {

        // echo "hi";
        return view('organization');
    }

    public function farmer_organization()
    {
        return view('farmer_organization');
    }


    public function farmer()
    {
        return view('farmer_register');
    }


    public function audit_company()
    {
        return view('audit_organization');
    }


    public function otp_screen()
    {
        return view('otp_screen');
    }


    public function verify_otp_submit()
    {

        $inputOtp = $this->request->getPost('otp');

        $inputOtp = (int)$inputOtp;

        // echo gettype(session()->get('otp_code'));



        if (session()->has('otp_code')) {
            if ($inputOtp === session()->get('otp_code')) {
                // session()->remove('otp_code');
                $tableName = session()->get('type');
                $insertId = session()->get('insertId');


                $db = \Config\Database::connect();
                $builder = $db->table($tableName);
                $builder->where('id', $insertId);
                $builder->update(['status' => 1]);



                // Step 2: Insert into thamil_krishigap table
                $logBuilder = $db->table('register_log');
                $logBuilder->insert([
                    'user_id'    => $insertId,
                    'user_table' => $tableName,
                    'name_of_the_user' => session()->get('user_name')
                ]);


                session()->remove('otp_code');


                return redirect()->to('entity_login')->with('success', 'Account created successfully.');
            } else {
                return redirect()->back()->with('error', 'Invalid OTP.');
            }
        } else {
            return redirect()->back()->with('error', 'OTP expired.');
        }

        // return view('otp_screen');
    }


    public function store_farmar()
    {
        $throttler = \Config\Services::throttler();
        if (!$throttler->check($this->request->getIPAddress(), 5, MINUTE)) {
            return redirect()->back()->with('error', 'Too many attempts. Try again later.');
        }

        $rules = [
            'Title' => [
                'label' => 'Title',
                'rules' => 'permit_empty|in_list[Mr,Mrs,Ms]',
                'errors' => [
                    'in_list' => 'Title must be Mr, Mrs, or Ms.',
                ]
            ],
            'firt_name' => [
                'label' => 'First Name',
                'rules' => 'required|max_length[30]',
                'errors' => [
                    'required' => 'First name is required.',
                    'max_length' => 'First name must not exceed 30 characters.',
                ]
            ],
            'middle_name' => [
                'label' => 'Middle Name',
                'rules' => 'permit_empty|max_length[30]',
                'errors' => [
                    'max_length' => 'Middle name must not exceed 30 characters.',
                ]
            ],
            'last_name' => [
                'label' => 'Last Name',
                'rules' => 'permit_empty|max_length[30]',
                'errors' => [
                    'max_length' => 'Last name must not exceed 30 characters.',
                ]
            ],
            'Date_of_Birth' => [
                'label' => 'Date of Birth',
                'rules' => 'permit_empty|valid_date',
                'errors' => [
                    'valid_date' => 'Please enter a valid date.',
                ]
            ],
            'Income_Tax_Number' => [
                'label' => 'Income Tax Number',
                'rules' => 'required|alpha_numeric|exact_length[10]',
                'errors' => [
                    'required' => 'Income Tax Number is required.',
                    'alpha_numeric' => 'Income Tax Number must be alphanumeric.',
                    'exact_length' => 'Income Tax Number must be exactly 10 characters.',
                ]
            ],

            // Permanent Address
            'Permanent_Address1' => [
                'label' => 'Permanent Address Line 1',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'Permanent Address Line 1 is required.',
                    'max_length' => 'Address must not exceed 50 characters.',
                ]
            ],
            'Permanent_Address2' => [
                'label' => 'Permanent Address Line 2',
                'rules' => 'permit_empty|max_length[50]',
                'errors' => [
                    'max_length' => 'Address must not exceed 50 characters.',
                ]
            ],
            'Permanent_Village' => [
                'label' => 'Permanent Village',
                'rules' => 'permit_empty|max_length[30]',
                'errors' => [
                    'max_length' => 'Village name must not exceed 30 characters.',
                ]
            ],
            'Permanent_cuntry' => [
                'label' => 'Permanent Country',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select permanent country.',
                ]
            ],
            'Permanent_State' => [
                'label' => 'Permanent State',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select permanent state.',
                ]
            ],
            'Permanent_City' => [
                'label' => 'Permanent City',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select permanent city.',
                ]
            ],
            'Permanent_PIN_Code' => [
                'label' => 'Permanent PIN Code',
                'rules' => 'required|numeric|exact_length[6]',
                'errors' => [
                    'required' => 'PIN Code is required.',
                    'numeric' => 'PIN Code must be numeric.',
                    'exact_length' => 'PIN Code must be exactly 6 digits.',
                ]
            ],

            // Communication Address
            'Communication_Address1' => [
                'label' => 'Communication Address Line 1',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'Communication Address Line 1 is required.',
                    'max_length' => 'Address must not exceed 50 characters.',
                ]
            ],
            'Communication_Address2' => [
                'label' => 'Communication Address Line 2',
                'rules' => 'permit_empty|max_length[50]',
                'errors' => [
                    'max_length' => 'Address must not exceed 50 characters.',
                ]
            ],
            'Communication_Village' => [
                'label' => 'Communication Village',
                'rules' => 'permit_empty|max_length[30]',
                'errors' => [
                    'max_length' => 'Village name must not exceed 30 characters.',
                ]
            ],
            'Communication_cuntry' => [
                'label' => 'Communication Country',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select communication country.',
                ]
            ],
            'Communication_State' => [
                'label' => 'Communication State',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select communication state.',
                ]
            ],
            'Communication_City' => [
                'label' => 'Communication City',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select communication city.',
                ]
            ],
            'Communication_PIN_Code' => [
                'label' => 'Communication PIN Code',
                'rules' => 'required|numeric|exact_length[6]',
                'errors' => [
                    'required' => 'PIN Code is required.',
                    'numeric' => 'PIN Code must be numeric.',
                    'exact_length' => 'PIN Code must be exactly 6 digits.',
                ]
            ],

            // Contact Info
            'Contact_Number_mobile' => [
                'label' => 'Mobile Number',
                'rules' => 'required|numeric|exact_length[10]',
                'errors' => [
                    'required' => 'Mobile number is required.',
                    'numeric' => 'Mobile number must be numeric.',
                    'exact_length' => 'Mobile number must be exactly 10 digits.',
                ]
            ],
            'Contact_Number_Fixedline' => [
                'label' => 'Fixedline Number',
                'rules' => 'permit_empty|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Fixedline number must be numeric.',
                    'exact_length' => 'Fixedline number must be exactly 10 digits.',
                ]
            ],

            'Email_id' => [
                'label' => 'Email ID',
                'rules' => 'required|valid_email|max_length[50]|unique_email_across_tables',
                'errors' => [
                    'required' => 'Email is required.',
                    'valid_email' => 'Please enter a valid email address.',
                    'max_length' => 'Email must not exceed 50 characters.',
                    'is_unique' => 'This email is already registered.',
                ]
            ],

            'password' => [
                'label' => 'Password',
                'rules' => 'required|min_length[8]',
                'errors' => [
                    'required' => 'Password is required.',
                    'min_length' => 'Password must be at least 8 characters.',
                ]
            ]
        ];


        if (!$this->validate($rules)) {

            // var_dump($this->validator->listErrors());
            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }



        $otp = rand(100000, 999999);


        // $email->setFrom('your_email@gmail.com', 'Your Name');
        $email = \Config\Services::email();

        $email->setTo($this->request->getPost('Email_id'));
        $email->setSubject('Test Email from CI4');
        $email->setMessage('<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secure OTP Verification</title>
    <style>
        /* Base Styles */
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
            color: #333;
            line-height: 1.5;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 25px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* Header Styles */
        .header {
            text-align: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
        }
        .header img {
            max-width: 180px;
            height: auto;
            margin-bottom: 15px;
        }
        .header h2 {
            color: #2c3e50;
            margin: 0;
            font-size: 22px;
        }
        
        /* Content Styles */
        .content h3 {
            color: #2c3e50;
            margin-top: 0;
            font-size: 18px;
        }
        .otp-code {
            font-weight: bold;
            font-size: 28px;
            color: #007BFF;
            margin: 25px 0;
            text-align: center;
            letter-spacing: 5px;
            padding: 10px;
            background-color: #f8f9fa;
            border-radius: 5px;
            display: inline-block;
            width: 100%;
        }
        
        /* Warning Box */
        .warning {
            background-color: #fff8f8;
            border-left: 4px solid #ff4444;
            padding: 15px;
            margin: 25px 0;
            font-size: 14px;
            border-radius: 0 4px 4px 0;
        }
        .warning strong {
            color: #d32f2f;
            display: block;
            margin-bottom: 8px;
            font-size: 15px;
        }
        .warning ol {
            margin: 10px 0 0 20px;
            padding: 0;
        }
        .warning li {
            margin-bottom: 8px;
        }
        .warning ul {
            margin: 5px 0 0 20px;
            padding: 0;
            list-style-type: circle;
        }
        
        /* Contact Info */
        .contact-info {
            margin-top: 25px;
            padding-top: 15px;
            border-top: 1px solid #eee;
            font-size: 14px;
        }
        .contact-info strong {
            display: block;
            margin-bottom: 8px;
        }
        .contact-info a {
            color: #007BFF;
            text-decoration: none;
        }
        
        /* Footer */
        .footer {
            text-align: center;
            margin-top: 25px;
            font-size: 12px;
            color: #777;
            padding-top: 15px;
            border-top: 1px solid #eee;
        }
        
        /* Responsive */
        @media only screen and (max-width: 600px) {
            .container {
                padding: 15px;
            }
            .otp-code {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        <img src="' . base_url() . 'assets/logo/krishi-gap-logo.png" alt="Company Logo">
        <h2>Secure OTP Verification</h2>
    </div>
    
    <div class="content">
        <h3>Hello, ' . $this->request->getPost('Organization_name') . '!</h3>
        <p>Your One-Time Password (OTP) for verification is:</p>
        <div class="otp-code">' . $otp . '</div>
        <p>This code expires in <strong>10 minutes</strong></p>
        
        <div class="warning">
            <strong>⚠ Important Security Notice</strong>
            <ol>
                <li><strong>Use this OTP immediately</strong> on our verification page</li>
                <li><strong>Never share</strong> this code - Company staff will never ask for it</li>
                <li>If you didn `t request this OTP:
                    <ul>
                        <li>Reset your password immediately</li>
                        <li>Contact support using the information below</li>
                    </ul>
                </li>
            </ol>
        </div>
        
        <div class="contact-info">
            <strong>Need help?</strong>
            <p>📞 <a href="tel:+11234567890">+1 (123) 456-7890</a> (24/7 support)</p>
            <p>✉ <a href="mailto:support@yourcompany.com">support@yourcompany.com</a></p>
            <p>🌐 <a href="https://yourcompany.com/support">yourcompany.com/support</a></p>
        </div>
    </div>
    
    <div class="footer">
        <p>© 2023 YourCompany. All rights reserved.</p>
        <p>This is an automated message - please do not reply directly to this email</p>
    </div>
</div>

</body>
</html>');

        if ($email->send()) {


            $model = new Farmer_module();


            $data = [
                'title' => $this->request->getPost('Title'),
                'first_name' => $this->request->getPost('firt_name'),
                'middle_name' => $this->request->getPost('middle_name'),
                'last_name' => $this->request->getPost('last_name'),
                'dob' => $this->request->getPost('Date_of_Birth'),
                'income_tax_number' => $this->request->getPost('Income_Tax_Number'),

                // Permanent Address
                'permanent_address1' => $this->request->getPost('Permanent_Address1'),
                'permanent_address2' => $this->request->getPost('Permanent_Address2'),
                'permanent_village' => $this->request->getPost('Permanent_Village'),
                'permanent_country' => $this->request->getPost('Permanent_cuntry'),
                'permanent_state' => $this->request->getPost('Permanent_State'),
                'permanent_city' => $this->request->getPost('Permanent_City'),
                'permanent_pincode' => $this->request->getPost('Permanent_PIN_Code'),

                // Communication Address
                'communication_address1' => $this->request->getPost('Communication_Address1'),
                'communication_address2' => $this->request->getPost('Communication_Address2'),
                'communication_village' => $this->request->getPost('Communication_Village'),
                'communication_country' => $this->request->getPost('Communication_cuntry'),
                'communication_state' => $this->request->getPost('Communication_State'),
                'communication_city' => $this->request->getPost('Communication_City'),
                'communication_pincode' => $this->request->getPost('Communication_PIN_Code'),

                // Contact Info
                'contact_mobile' => $this->request->getPost('Contact_Number_mobile'),
                'contact_fixedline' => $this->request->getPost('Contact_Number_Fixedline'),

                // Credentials
                'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
                'email' => $this->request->getPost('Email_id'),
            ];
            $model->insert($data);
            $insertId = $model->getInsertID();
            // return redirect()->to('entity_login')->with('success', 'Registration successful!');


            session()->set('otp_code', $otp);
            session()->set('type', 'farmers');
            session()->set('insertId', $insertId);
            session()->set('reciver_email', $this->request->getPost('Email_id'));
            session()->set('user_name', $this->request->getPost('firt_name'));
            session()->markAsTempdata('otp_code', 12000); // 300 seconds = 5 minutes

            return redirect()->to('verify_otp')->with('success', 'Registration successful!');
        } else {
            echo "❌ Failed to send email.<br><br>";
            echo "<pre>" . print_r($email->printDebugger(['headers', 'subject', 'body']), true) . "</pre>";
        }
    }

    public function store()
    {

        $throttler = \Config\Services::throttler();
        if (!$throttler->check($this->request->getIPAddress(), 5, MINUTE)) {
            return redirect()->back()->with('error', 'Too many attempts. Try again later.');
        }
        // var_dump($_POST);

        // helper(['form', 'url']);

        $rules = [
            'Organization_name' => [
                'label' => 'Establishment Name',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'Please enter the establishment name.',
                    'max_length' => 'Establishment name must not exceed 50 characters.',
                ]
            ],
            'Organization_Date_of_Establishment' => [
                'label' => 'Date of Incorporation',
                'rules' => 'required|valid_date',
                'errors' => [
                    'required' => 'Please select the date of incorporation.',
                    'valid_date' => 'Please enter a valid date in MM/DD/YYYY format.',
                ]
            ],
            'Organization_Registration_Number' => [
                'label' => 'Registration Number',
                'rules' => 'required|max_length[30]',
                'errors' => [
                    'required' => 'Registration number is required.',
                    'max_length' => 'Registration number must not exceed 30 characters.',
                ]
            ],
            'GST_Registration' => [
                'label' => 'GSTIN / VAT ID',
                'rules' => 'required|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'GSTIN / VAT ID must be alphanumeric.',
                    'max_length' => 'GSTIN / VAT ID must not exceed 15 characters.',
                    'required' => 'GSTIN / VAT ID number is required.',
                ]
            ],
            // Company logo would be handled separately in file validation

            'Income_Tax_PAN_No' => [
                'label' => 'Employer Income Tax Number',
                'rules' => 'required|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'Income Tax Number must be alphanumeric.',
                    'max_length' => 'Income Tax Number must not exceed 15 characters.',
                    'required' => 'Employer Income Tax  number is required.',
                ]
            ],

            'Office_Address1' => [
                'label' => 'Office Address Line 1',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'Office Address Line 1 is required.',
                    'max_length' => 'Office Address must not exceed 50 characters.',
                ]
            ],

            'Office_Address2' => [
                'label' => 'Office Address Line 2',
                'rules' => 'permit_empty|max_length[50]',
                'errors' => [
                    'max_length' => 'Office Address Line 2 must not exceed 50 characters.',
                ]
            ],

            'Office_Village' => [
                'label' => 'Office Village',
                'rules' => 'permit_empty|max_length[30]',
                'errors' => [
                    'max_length' => 'Office Village must not exceed 30 characters.',
                ]
            ],

            'cuntry' => [
                'label' => 'Country',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a country.',
                ]
            ],

            'State' => [
                'label' => 'State',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a state.',
                ]
            ],

            'City' => [
                'label' => 'City',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a city.',
                ]
            ],

            'Office_PIN_Code' => [
                'label' => 'PIN Code',
                'rules' => 'required|numeric|exact_length[6]',
                'errors' => [
                    'required' => 'PIN Code is required.',
                    'numeric' => 'PIN Code must contain only numbers.',
                    'exact_length' => 'PIN Code must be exactly 6 digits.',
                ]
            ],

            'Office_Contact_Mobile' => [
                'label' => 'Mobile Number',
                'rules' => 'required|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Mobile number must be numeric.',
                    'exact_length' => 'Mobile number must be exactly 10 digits.',
                    'required' => 'Mobile Number is required.',
                ]
            ],

            'contact_fixedline' => [
                'label' => 'Fixedline Number',
                'rules' => 'permit_empty|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Fixedline number must be numeric.',
                    'exact_length' => 'Fixedline number must be exactly 10 digits.',
                ]
            ],

            'Email_id' => [
                'label' => 'Email ID',
                'rules' => 'required|valid_email|max_length[50]|unique_email_across_tables',
                'errors' => [
                    'required' => 'Email is required.',
                    'valid_email' => 'Please enter a valid email address.',
                    'max_length' => 'Email must not exceed 50 characters.',
                    'is_unique' => 'This email ID is already registered. Please use another one.',
                    'unique_email_across_tables' => 'This email ID is already registered for the selected user type.',
                ]
            ],

            'password' => [
                'label' => 'Password',
                'rules' => 'required|min_length[8]',
                'errors' => [
                    'required' => 'Password is required.',
                    'min_length' => 'Password must be at least 8 characters.',
                ]
            ],

            'type' => [
                'label' => 'User Type',
                'rules' => 'required|in_list[organisation,fpo,audit_company]',
                'errors' => [
                    'required' => 'Please select a user type.',
                    'in_list' => 'User type must be Organisation, FPO, or Audit Company.',
                ]
            ],
            'Company_Logo' => [
                'label' => 'Company Logo',
                'rules' => 'uploaded[Company_Logo]'
                    . '|is_image[Company_Logo]'
                    . '|mime_in[Company_Logo,image/jpeg,image/png]'
                    . '|ext_in[Company_Logo,jpg,jpeg,png]'
                    . '|max_size[Company_Logo,5120]', // 5120 KB = 5 MB
                'errors' => [
                    'uploaded' => 'Please upload a company logo.',
                    'is_image' => 'The file must be an image.',
                    'mime_in' => 'Only JPEG and PNG images are allowed.',
                    'ext_in' => 'Invalid file extension. Only JPG and PNG are allowed.',
                    'max_size' => 'The image size must not exceed 5MB.',
                ]
            ],
        ];


        // if (!$this->validate($rules)) {
        //     return redirect()->back()->withInput()->with('validation', $this->validator);
        // }
        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 120); // stores for 60 seconds
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }

        // if (!$this->validate($rules)) {
        //     $file = $this->request->getFile('Company_Logo');

        //     // Debug upload status (optional)
        //     if ($file && $file->isValid()) {
        //         echo "Uploaded file name: " . $file->getName();
        //     } else {
        //         echo "Upload Error: " . $file->getErrorString();
        //     }

        //     var_dump($this->validator->getErrors());
        //     die();
        //     // OPTIONAL: Debugging purposes
        //     // var_dump($this->validator->getErrors());

        //     // Store validation errors in temp session for 1 minute (60 seconds)
        //     session()->setTempdata('validation_errors', $this->validator->listErrors(), 60);

        //     return redirect()->back()->withInput(); // Go back to form with old input
        // }


        // 1. Generate 6-digit OTP
        $otp = rand(100000, 999999);


        // $email->setFrom('your_email@gmail.com', 'Your Name');
        $email = \Config\Services::email();

        $email->setTo($this->request->getPost('Email_id'));
        $email->setSubject('Test Email from CI4');
        $email->setMessage('<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secure OTP Verification</title>
    <style>
        /* Base Styles */
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
            color: #333;
            line-height: 1.5;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 25px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* Header Styles */
        .header {
            text-align: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
        }
        .header img {
            max-width: 180px;
            height: auto;
            margin-bottom: 15px;
        }
        .header h2 {
            color: #2c3e50;
            margin: 0;
            font-size: 22px;
        }
        
        /* Content Styles */
        .content h3 {
            color: #2c3e50;
            margin-top: 0;
            font-size: 18px;
        }
        .otp-code {
            font-weight: bold;
            font-size: 28px;
            color: #007BFF;
            margin: 25px 0;
            text-align: center;
            letter-spacing: 5px;
            padding: 10px;
            background-color: #f8f9fa;
            border-radius: 5px;
            display: inline-block;
            width: 100%;
        }
        
        /* Warning Box */
        .warning {
            background-color: #fff8f8;
            border-left: 4px solid #ff4444;
            padding: 15px;
            margin: 25px 0;
            font-size: 14px;
            border-radius: 0 4px 4px 0;
        }
        .warning strong {
            color: #d32f2f;
            display: block;
            margin-bottom: 8px;
            font-size: 15px;
        }
        .warning ol {
            margin: 10px 0 0 20px;
            padding: 0;
        }
        .warning li {
            margin-bottom: 8px;
        }
        .warning ul {
            margin: 5px 0 0 20px;
            padding: 0;
            list-style-type: circle;
        }
        
        /* Contact Info */
        .contact-info {
            margin-top: 25px;
            padding-top: 15px;
            border-top: 1px solid #eee;
            font-size: 14px;
        }
        .contact-info strong {
            display: block;
            margin-bottom: 8px;
        }
        .contact-info a {
            color: #007BFF;
            text-decoration: none;
        }
        
        /* Footer */
        .footer {
            text-align: center;
            margin-top: 25px;
            font-size: 12px;
            color: #777;
            padding-top: 15px;
            border-top: 1px solid #eee;
        }
        
        /* Responsive */
        @media only screen and (max-width: 600px) {
            .container {
                padding: 15px;
            }
            .otp-code {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        <img src="' . base_url() . 'assets/logo/krishi-gap-logo.png" alt="Company Logo">
        <h2>Secure OTP Verification</h2>
    </div>
    
    <div class="content">
        <h3>Hello, ' . $this->request->getPost('Organization_name') . '!</h3>
        <p>Your One-Time Password (OTP) for verification is:</p>
        <div class="otp-code">' . $otp . '</div>
        <p>This code expires in <strong>10 minutes</strong></p>
        
        <div class="warning">
            <strong>⚠ Important Security Notice</strong>
            <ol>
                <li><strong>Use this OTP immediately</strong> on our verification page</li>
                <li><strong>Never share</strong> this code - Company staff will never ask for it</li>
                <li>If you didn `t request this OTP:
                    <ul>
                        <li>Reset your password immediately</li>
                        <li>Contact support using the information below</li>
                    </ul>
                </li>
            </ol>
        </div>
        
        <div class="contact-info">
            <strong>Need help?</strong>
            <p>📞 <a href="tel:+11234567890">+1 (123) 456-7890</a> (24/7 support)</p>
            <p>✉ <a href="mailto:support@yourcompany.com">support@yourcompany.com</a></p>
            <p>🌐 <a href="https://yourcompany.com/support">yourcompany.com/support</a></p>
        </div>
    </div>
    
    <div class="footer">
        <p>© 2023 YourCompany. All rights reserved.</p>
        <p>This is an automated message - please do not reply directly to this email</p>
    </div>
</div>

</body>
</html>');

        if ($email->send()) {
            $model = new Loginmodel();

            // Handle file upload


            $data = [
                'establishment_name' => $this->request->getPost('Organization_name'),
                'incorporation_date' => $this->request->getPost('Organization_Date_of_Establishment'),
                'registration_number' => $this->request->getPost('Organization_Registration_Number'),
                'gstin_or_vat_id' => $this->request->getPost('GST_Registration'),
                // 'company_logo' => $logoName,
                'employer_income_tax_number' => $this->request->getPost('Income_Tax_PAN_No'),
                'contact_fixedline' => $this->request->getPost('Office_Contact_fixed_line'),
                // 'Income_Tax_TAN_No' => $this->request->getPost('Income_Tax_tan_No'),
                'address_line1' => $this->request->getPost('Office_Address1'),
                'address_line2' => $this->request->getPost('Office_Address2'),
                'village' => $this->request->getPost('Office_Village'),
                'country' => $this->request->getPost('cuntry'),
                'state' => $this->request->getPost('State'),
                'city' => $this->request->getPost('City'),
                'pin_code' => $this->request->getPost('Office_PIN_Code'),
                'contact_mobile' => $this->request->getPost('Office_Contact_Mobile'),
                'contact_fixedline' => $this->request->getPost('Office_Contact_fixed_line'),
                'email' => $this->request->getPost('Email_id'),
                'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
                'user_type' => $this->request->getPost('type'),
            ];



            // var_dump($data);
            $model->insert($data);
            $insertId = $model->getInsertID();

            $logo = $this->request->getFile('Company_Logo');
            if ($logo && $logo->isValid() && !$logo->hasMoved()) {
                $logoName = $logo->getRandomName();
                $logoDir = "uploads/entity_profile/{$insertId}/logo"; // Relative path
                $logoPath = FCPATH . $logoDir;

                // Make sure the folder exists
                if (!is_dir($logoPath)) {
                    mkdir($logoPath, 0777, true);
                }

                // Move file
                $logo->move($logoPath, $logoName);

                // Final relative path to store in DB
                $relativePath = $logoDir . '/' . $logoName;

                // Update DB with logo path
                $model->update($insertId, ['company_logo' => $relativePath]);
            }

            session()->set('otp_code', $otp);
            session()->set('type', 'entity_profiles');
            session()->set('insertId', $insertId);
            session()->set('reciver_email', $this->request->getPost('Email_id'));
            session()->set('user_name', $this->request->getPost('Organization_name'));
            session()->markAsTempdata('otp_code', 12000); // 300 seconds = 5 minutes

            return redirect()->to('verify_otp')->with('success', 'Registration successful!');
        } else {
            echo "❌ Failed to send email.<br><br>";
            echo "<pre>" . print_r($email->printDebugger(['headers', 'subject', 'body']), true) . "</pre>";
        }
    }
}
