<?php

namespace App\Controllers\Farm_inspection;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Farm_inspectio_model;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Farm_inspection extends BaseController
{


    public function delete_farm_inspection($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $farm_inspection = new Farm_inspectio_model();

        // Check if record exists
        $existing = $farm_inspection->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', ' not found.');
        }

        // Update the status field to 0 (soft delete)
        $farm_inspection->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        return redirect()->back()->with('success', ' farm inspection   deleted successfully.');
    }


    public function UPDATE_farm_inspection()
    {


        $rules = [
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Farm' => [
                'label'  => 'Farm',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop' => [
                'label'  => 'crop',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop_name' => [
                'label'  => 'crop',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],

            'inspection_date' => [
                'label'  => 'inspection date',
                'rules'  => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date (YYYY-MM-DD).',
                ],
            ],
            'inspector_name' => [
                'label'  => 'inspector_name',
                'rules'  => 'required|string|max_length[50]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'non_conformities_reported' => [
                'label'  => 'non_conformities_reported',
                'rules'  => 'required|string|max_length[250]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'corrective_actions_taken' => [
                'label'  => 'corrective_actions_taken',
                'rules'  => 'required|string|max_length[250]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],

            'corrective_action_approved' => [
                'label'  => 'corrective_action_approved',
                'rules'  => 'required|string|max_length[250]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],



            'Record_Date' => [
                'label'  => 'Record_Date',
                'rules'  => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date (YYYY-MM-DD).',
                ],
            ],

            'Season' => [
                'label'  => 'Season',
                'rules'  => 'required|in_list[Kharif,Rabi,Zaid]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be either Kharif or Rabi.',
                ],
            ],

            'year' => [
                'label'  => 'year',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be integer',
                ],
            ],
            'audit_remarks' => [
                'label'  => 'audit_remarks',
                'rules'  => 'permit_empty|string|max_length[250]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
        ];











        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'farmer_id' => $this->request->getPost('farmer'),
            'farm_id' => $this->request->getPost('Farm'),
            'crop_id' => $this->request->getPost('crop'),
            'crop_name' => implode(",", $this->request->getPost('crop_name')),
            'Record_Date' => $this->request->getPost('Record_Date'),
            'Inspection_Date' => $this->request->getPost('inspection_date'),

            'Inspector_Name' => $this->request->getPost('inspector_name'),
            'Non-Conformities_Reported' => $this->request->getPost('non_conformities_reported'),
            'Corrective_Actions_Taken' => $this->request->getPost('corrective_actions_taken'),
            'Corrective_Action_Approved_and_Closed' => $this->request->getPost('corrective_action_approved'),
            'season' => $this->request->getPost('Season'),
            'year' => $this->request->getPost('year'),
            'remark' => $this->request->getPost('Remark'),



            'updated_by' => session()->get('logined_user_id'), // Empty for now,



        ];



        $insertId = $this->request->getPost('updating_id');

        $entityId = session()->get('entity_id');


        









        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/internal_farm_inspection/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['documents'] = json_encode($documents);


        $model = new Farm_inspectio_model();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success






            return redirect()->back()->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        // return redirect()->back()->with('success', 'packaging unit  updated successfully');
    }



    public function edit_farm_inspection($id)
    {
         $farm_inspection = new Farm_inspectio_model();
        $farm_inspection = $farm_inspection->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/farm_inspection/edit', [
              'farm_inspection' => $farm_inspection,
            'organization' => $organization
        ]);
    }


    public function view_non_internal_farm_inspection($id)
    {
        $farm_inspection = new Farm_inspectio_model();
        $farm_inspection = $farm_inspection->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/farm_inspection/view', [
            'farm_inspection' => $farm_inspection,
            'organization' => $organization
        ]);
    }


    public function insert_farm_inspection()
    {




        $rules = [
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Farm' => [
                'label'  => 'Farm',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop' => [
                'label'  => 'crop',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'crop_name' => [
                'label'  => 'crop',
                'rules'  => 'required',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],

            'inspection_date' => [
                'label'  => 'inspection date',
                'rules'  => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date (YYYY-MM-DD).',
                ],
            ],
            'inspector_name' => [
                'label'  => 'inspector_name',
                'rules'  => 'required|string|max_length[50]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'non_conformities_reported' => [
                'label'  => 'non_conformities_reported',
                'rules'  => 'required|string|max_length[250]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
            'corrective_actions_taken' => [
                'label'  => 'corrective_actions_taken',
                'rules'  => 'required|string|max_length[250]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],

            'corrective_action_approved' => [
                'label'  => 'corrective_action_approved',
                'rules'  => 'required|string|max_length[250]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],



            'Record_Date' => [
                'label'  => 'Record_Date',
                'rules'  => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'valid_date' => 'The {field} must be a valid date (YYYY-MM-DD).',
                ],
            ],

            'Season' => [
                'label'  => 'Season',
                'rules'  => 'required|in_list[Kharif,Rabi,Zaid]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be either Kharif or Rabi.',
                ],
            ],

            'year' => [
                'label'  => 'year',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be integer',
                ],
            ],
            'audit_remarks' => [
                'label'  => 'audit_remarks',
                'rules'  => 'permit_empty|string|max_length[250]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
        ];






        if (!$this->validate($rules)) {



            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());


            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            'farmer_id' => $this->request->getPost('farmer'),
            'farm_id' => $this->request->getPost('Farm'),
            'crop_id' => $this->request->getPost('crop'),
            'crop_name' => implode(",", $this->request->getPost('crop_name')),
            'Record_Date' => $this->request->getPost('Record_Date'),
            'Inspection_Date' => $this->request->getPost('inspection_date'),

            'Inspector_Name' => $this->request->getPost('inspector_name'),
            'Non-Conformities_Reported' => $this->request->getPost('non_conformities_reported'),
            'Corrective_Actions_Taken' => $this->request->getPost('corrective_actions_taken'),
            'Corrective_Action_Approved_and_Closed' => $this->request->getPost('corrective_action_approved'),
            'season' => $this->request->getPost('Season'),
            'year' => $this->request->getPost('year'),
            'remark' => $this->request->getPost('Remark'),

            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,


        ];





 






        $model = new Farm_inspectio_model;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();































        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/farm_inspection/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/farm_inspection/{$insertId}/documants";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'documents' => json_encode($documents)
        ]);



















        return redirect()->back()->with('success', 'farm inspection  added successfully!');
    }










    public function add_farm_inspection()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/farm_inspection/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/farm_inspection/index', ['organization' => $organization]);
    }
}
