<?php

namespace App\Controllers;

use App\Models\Loginmodel;
use CodeIgniter\Database\Exceptions\DataException;

class Fpo extends BaseController
{



    public function verify_otp()
    {

        return view('Fpo/verify_otp');
    }

    public function verify_otp_and_update_profile()
    {


        $inputOtp = $this->request->getPost('otp');

        $inputOtp = (int)$inputOtp;

        // echo gettype(session()->get('otp_code'));



        if (session()->has('otp_code')) {
            if ($inputOtp === session()->get('otp_code')) {
                // session()->remove('otp_code');

                $tableName = session()->get('table');;
                $insertId = session()->get('entity_id');

                $data_to_update = session()->get('updated_data');

                $loginModel = new Loginmodel();
                $session = session();
                $id = $session->get('entity_id'); // or session('id');
                // var_dump($data_to_update);

                if (session()->get('is_file_uploaded') === true && session()->has('file_path')) {

                    $tempPath = FCPATH . session()->get('file_path'); // full path from session


                    $destinationDir = FCPATH . "uploads/entity_profile/{$insertId}/logo/";
                    $fileName = basename($tempPath);

                    $newFilePath = $destinationDir . $fileName;

                    if (rename($tempPath, $newFilePath)) {
                        // ✅ Move successful, you can update DB or continue process
                        // Optionally unset session






                        $organization = $loginModel->find($id);

                        $oldFilePath = FCPATH . $organization['company_logo'];
                        if (is_file($oldFilePath)) {
                            unlink($oldFilePath);
                        }

                        // Update new file path in DB (relative path)
                        $relativePath = "uploads/entity_profile/{$id}/logo/" . $fileName;
                        $loginModel->update($id, ['company_logo' => $relativePath]);
                        // var_dump($newFilePath);
                        // session()->remove('is_file_uploaded');
                        // session()->remove('file_path');
                    } else {
                        // ❌ Failed to move
                        log_message('error', 'Failed to move uploaded file to organization folder.');
                    }
                }
                session()->remove('otp_code');
                if ($loginModel->update($id, $data_to_update)) {




                    $db = \Config\Database::connect();

                    // Define the data to update
                    $data = [
                        'name_of_the_user' => $data_to_update['establishment_name'],

                    ];

                    // Specify the condition for which the record should be updated
                    $builder = $db->table('register_log');

                    // Perform the update
                    $builder->set($data)
                        ->where('user_id', $id)  // Use the appropriate condition (e.g., primary key or other unique column)
                        ->where('user_table', 'entity_profiles')  // Use the appropriate condition (e.g., primary key or other unique column)
                        ->update();




                    return redirect()->to('Fpo/org_Profile')->with('success', 'Fpo data updated successfully!');
                } else {
                    return redirect()->back()->with('error', 'Failed to update data');
                }



                // return redirect()->to('entity_login')->with('success', 'Account created successfully.');
            } else {
                return redirect()->back()->with('error', 'Invalid OTP.');
            }
        } else {
            return redirect()->back()->with('error', 'OTP expired.');
        }
    }













    public function org_profile_edit()
    {

        $rules = [
            'comp_name' => [
                'label' => 'Establishment Name',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'Please enter the establishment name.',
                    'max_length' => 'Establishment name must not exceed 50 characters.',
                ]
            ],

            'legal_identity' => [
                'label' => 'Legal Identity',
                'rules' => 'required|in_list[Private Limited,Public Company,Partnership,Limited Liability Company]',
                'errors' => [
                    'required' => 'Please select the legal identity.',
                    'in_list' => 'Legal identity must be one of: Private Limited, Public Company, Partnership, or Limited Liability Company.',
                ]
            ],

            'Organization_Date_of_Establishment' => [
                'label' => 'Date of Incorporation',
                'rules' => 'required|valid_date',
                'errors' => [
                    'required' => 'Please select the date of incorporation.',
                    'valid_date' => 'Please enter a valid date in MM/DD/YYYY format.',
                ]
            ],
            'Registration_number' => [
                'label' => 'Registration Number',
                'rules' => 'required|max_length[30]',
                'errors' => [
                    'required' => 'Registration number is required.',
                    'max_length' => 'Registration number must not exceed 30 characters.',
                ]
            ],
            'gst_registration' => [
                'label' => 'GSTIN / VAT ID',
                'rules' => 'permit_empty|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'GSTIN / VAT ID must be alphanumeric.',
                    'max_length' => 'GSTIN / VAT ID must not exceed 15 characters.',
                ]
            ],
            // Company logo would be handled separately in file validation

            'income_tax_pan_no' => [
                'label' => 'Employer Income Tax Number',
                'rules' => 'permit_empty|alpha_numeric|max_length[15]',
                'errors' => [
                    'alpha_numeric' => 'Income Tax Number must be alphanumeric.',
                    'max_length' => 'Income Tax Number must not exceed 15 characters.',
                ]
            ],

            'adress_1' => [
                'label' => 'Office Address Line 1',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'Office Address Line 1 is required.',
                    'max_length' => 'Office Address must not exceed 50 characters.',
                ]
            ],

            'address_2' => [
                'label' => 'Office Address Line 2',
                'rules' => 'permit_empty|max_length[50]',
                'errors' => [
                    'max_length' => 'Office Address Line 2 must not exceed 50 characters.',
                ]
            ],

            'village' => [
                'label' => 'Office Village',
                'rules' => 'permit_empty|max_length[30]',
                'errors' => [
                    'max_length' => 'Office Village must not exceed 30 characters.',
                ]
            ],

            'country' => [
                'label' => 'Country',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a country.',
                ]
            ],

            'state' => [
                'label' => 'State',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a state.',
                ]
            ],

            'city' => [
                'label' => 'City',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a city.',
                ]
            ],

            'Pincode' => [
                'label' => 'PIN Code',
                'rules' => 'required|numeric|exact_length[6]',
                'errors' => [
                    'required' => 'PIN Code is required.',
                    'numeric' => 'PIN Code must contain only numbers.',
                    'exact_length' => 'PIN Code must be exactly 6 digits.',
                ]
            ],

            'contact_number_mobile' => [
                'label' => 'Mobile Number',
                'rules' => 'permit_empty|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Mobile number must be numeric.',
                    'exact_length' => 'Mobile number must be exactly 10 digits.',
                ]
            ],

            'contact_number_fixed_line' => [
                'label' => 'Fixedline Number',
                'rules' => 'permit_empty|numeric|exact_length[10]',
                'errors' => [
                    'numeric' => 'Fixedline number must be numeric.',
                    'exact_length' => 'Fixedline number must be exactly 10 digits.',
                ]
            ],

            'email' => [
                'label' => 'Email ID',
                'rules' => 'required|valid_email|max_length[50]|is_unique_email_per_type_org_profile[entity_profiles.email]',
                'errors' => [
                    'required' => 'Email is required.',
                    'valid_email' => 'Please enter a valid email address.',
                    'max_length' => 'Email must not exceed 50 characters.',
                    'is_unique' => 'This email ID is already registered. Please use another one.',
                    'is_unique_email_per_type_org_profile' => 'This email ID is already registered for the selected user type.',
                ]
            ],

            'password' => [
                'label' => 'Password',
                'rules' => 'permit_empty|min_length[8]',
                'errors' => [
                    'min_length' => 'Password must be at least 8 characters.',
                ]
            ],


            'comp_logo' => [
                'label' => 'Company Logo',
                'rules' => 'permit_empty|is_image[comp_logo]'
                    . '|mime_in[comp_logo,image/jpeg,image/png,image/jpg]'
                    . '|ext_in[comp_logo,jpg,jpeg,png]'
                    . '|max_size[comp_logo,5120]',
                'errors' => [
                    'is_image' => 'The file must be a valid image.',
                    'mime_in' => 'Only JPEG and PNG images are allowed.',
                    'ext_in' => 'Invalid file extension. Only JPG and PNG are allowed.',
                    'max_size' => 'The image size must not exceed 5MB.',
                ]
            ]

        ];

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
            // var_dump($this->validator->listErrors());
        }
        session()->set('is_file_uploaded', false);

        $data = [
            'establishment_name' => $this->request->getPost('comp_name'),
            'incorporation_date' => $this->request->getPost('Organization_Date_of_Establishment'),
            'registration_number' => $this->request->getPost('Registration_number'),
            'gstin_or_vat_id' => $this->request->getPost('gst_registration'),
            // 'company_logo' => $logoName,
            'employer_income_tax_number' => $this->request->getPost('income_tax_pan_no'),
            // 'contact_fixedline' => $this->request->getPost('Office_Contact_fixed_line'),
            // 'Income_Tax_TAN_No' => $this->request->getPost('Income_Tax_tan_No'),
            'address_line1' => $this->request->getPost('adress_1'),
            'address_line2' => $this->request->getPost('address_2'),
            'village' => $this->request->getPost('village'),
            'country' => $this->request->getPost('country'),
            'state' => $this->request->getPost('state'),
            'city' => $this->request->getPost('city'),
            'pin_code' => $this->request->getPost('Pincode'),
            'contact_mobile' => $this->request->getPost('contact_number_mobile'),
            'contact_fixedline' => $this->request->getPost('contact_number_fixed_line'),
            'email' => $this->request->getPost('email'),
            'Legal_identity' => $this->request->getPost('legal_identity'),
            'updated_by' => session()->get('logined_user_id'),



        ];

        $password = $this->request->getPost('password');
        if (!empty($password)) {
            $data['password'] = password_hash($password, PASSWORD_DEFAULT);
        }


        // var_dump($data);

        // die();

        $logo = $this->request->getFile('comp_logo');


        if ($logo && $logo->isValid() && !$logo->hasMoved()) {
            // Re-validate file type for double safety (optional)
            $ext = $logo->getClientExtension();
            if (!in_array($ext, ['jpg', 'jpeg', 'png'])) {
                session()->set('validation_errors', "Invalid file type uploaded.");
                session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds




                return redirect()->back()->withInput();
            }

            $logoName = $logo->getRandomName();
            $logoDir = "uploads/temp/logo"; // Relative path
            $logoPath = FCPATH . $logoDir;

            // Make sure the folder exists
            if (!is_dir($logoPath)) {
                mkdir($logoPath, 0777, true);
            }

            // Move file to destination
            $logo->move($logoPath, $logoName);

            // Final relative path to store in DB
            $relativePath = $logoDir . '/' . $logoName;

            session()->set('is_file_uploaded', true);
            session()->set('file_path', $relativePath);
        }

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);

        // 1. Generate 6-digit OTP
        $otp = rand(100000, 999999);


        // $email->setFrom('your_email@gmail.com', 'Your Name');
        $email = \Config\Services::email();

        $email->setTo($organization['email']);
        $email->setSubject('Test Email from CI4');
        $email->setMessage('<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secure OTP Verification</title>
    <style>
        /* Base Styles */
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 20px;
            color: #333;
            line-height: 1.5;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 25px;
            max-width: 600px;
            margin: 0 auto;
        }
        
        /* Header Styles */
        .header {
            text-align: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
        }
        .header img {
            max-width: 180px;
            height: auto;
            margin-bottom: 15px;
        }
        .header h2 {
            color: #2c3e50;
            margin: 0;
            font-size: 22px;
        }
        
        /* Content Styles */
        .content h3 {
            color: #2c3e50;
            margin-top: 0;
            font-size: 18px;
        }
        .otp-code {
            font-weight: bold;
            font-size: 28px;
            color: #007BFF;
            margin: 25px 0;
            text-align: center;
            letter-spacing: 5px;
            padding: 10px;
            background-color: #f8f9fa;
            border-radius: 5px;
            display: inline-block;
            width: 100%;
        }
        
        /* Warning Box */
        .warning {
            background-color: #fff8f8;
            border-left: 4px solid #ff4444;
            padding: 15px;
            margin: 25px 0;
            font-size: 14px;
            border-radius: 0 4px 4px 0;
        }
        .warning strong {
            color: #d32f2f;
            display: block;
            margin-bottom: 8px;
            font-size: 15px;
        }
        .warning ol {
            margin: 10px 0 0 20px;
            padding: 0;
        }
        .warning li {
            margin-bottom: 8px;
        }
        .warning ul {
            margin: 5px 0 0 20px;
            padding: 0;
            list-style-type: circle;
        }
        
        /* Contact Info */
        .contact-info {
            margin-top: 25px;
            padding-top: 15px;
            border-top: 1px solid #eee;
            font-size: 14px;
        }
        .contact-info strong {
            display: block;
            margin-bottom: 8px;
        }
        .contact-info a {
            color: #007BFF;
            text-decoration: none;
        }
        
        /* Footer */
        .footer {
            text-align: center;
            margin-top: 25px;
            font-size: 12px;
            color: #777;
            padding-top: 15px;
            border-top: 1px solid #eee;
        }
        
        /* Responsive */
        @media only screen and (max-width: 600px) {
            .container {
                padding: 15px;
            }
            .otp-code {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        <img src="' . base_url() . 'assets/logo/krishi-gap-logo.png" alt="Company Logo">
        <h2>Secure OTP Verification</h2>
    </div>
    
    <div class="content">
        <h3>Hello, ' . $organization['establishment_name'] . '!</h3>
        <p>Your One-Time Password (OTP) for updating profile is:</p>
        <div class="otp-code">' . $otp . '</div>
        <p>This code expires in <strong>10 minutes</strong></p>
        
        <div class="warning">
            <strong>⚠ Important Security Notice</strong>
            <ol>
                <li><strong>Use this OTP immediately</strong> on our verification page</li>
                <li><strong>Never share</strong> this code - Company staff will never ask for it</li>
                <li>If you didn `t request this OTP:
                    <ul>
                        <li>Reset your password immediately</li>
                        <li>Contact support using the information below</li>
                    </ul>
                </li>
            </ol>
        </div>
        
        <div class="contact-info">
            <strong>Need help?</strong>
            <p>📞 <a href="tel:+11234567890">+1 (123) 456-7890</a> (24/7 support)</p>
            <p>✉ <a href="mailto:support@yourcompany.com">support@yourcompany.com</a></p>
            <p>🌐 <a href="https://yourcompany.com/support">yourcompany.com/support</a></p>
        </div>
    </div>
    
    <div class="footer">
        <p>© 2023 YourCompany. All rights reserved.</p>
        <p>This is an automated message - please do not reply directly to this email</p>
    </div>
</div>

</body>
</html>');

        if ($email->send()) {

            var_dump($data);
            session()->set('otp_code', $otp);

            session()->set('updated_data', $data);
            session()->set('reciver_email', $organization['email']);
            session()->set('user_name', $organization['establishment_name']);
            session()->markAsTempdata('otp_code', 12000); // 300 seconds = 5 minutes
 
            return redirect()->to('Fpo/verify_otp')->with('success', 'Registration successful!');
        } else {
            echo "❌ Failed to send email.<br><br>";
            echo "<pre>" . print_r($email->printDebugger(['headers', 'subject', 'body']), true) . "</pre>";
        }
    }

    public function org_Profile()
    {

        $session = session();


        $id = $session->get('entity_id');
        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);


        // var_dump($organization);
        return view('Fpo/org_profile_page', ['organization' => $organization]);
    }



    public function toggleAutoId()
    {

        $newValue = $this->request->getPost('value');
        $entityId = session()->get('entity_id');

        // Example update
        $db = \Config\Database::connect();
        $db->table('entity_profiles')
            ->where('id', $entityId)
            ->update(['audo_id_gendrator' => $newValue]);

        return $this->response->setJSON(['status' => 'success', 'newValue' => $newValue]);
    }





    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);


        return view('Fpo/index', ['organization' => $organization]);
    }




} 