<?php

namespace App\Controllers\Implementation_compliance;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\ImplementationComplianceModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Implementation_compliance extends BaseController
{


    public function delete_ImplementationCompliance($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $ImplementationComplianc = new ImplementationComplianceModel();

        // Check if record exists
        $existing = $ImplementationComplianc->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $ImplementationComplianc->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        return redirect()->back()->with('success', 'data deleted successfully.');
    }


    public function update_Implementation_compliance()
    {

        $rules = [

            'requirement_clause' => [
                'rules' => 'required|max_length[250]',
                'errors' => [
                    'required' => 'Standard Requirement Clause is required.',
                    'max_length' => 'Max 250 characters allowed.',
                ]
            ],
            'implementation' => [
                'rules' => 'required|max_length[250]',
                'errors' => [
                    'required' => 'Implementation is required.',
                    'max_length' => 'Max 250 characters allowed.',
                ]
            ],
            'upload_type' => [
                'rules' => 'required|in_list[file,link]',
                'errors' => [
                    'required' => 'Please select upload type (file or link).',
                    'in_list' => 'Upload type must be either "file" or "link".',
                ]
            ],
            'Remark' => [
                'rules' => 'permit_empty|regex_match[/^[a-zA-Z0-9\s\.\,\-\(\)]+$/]|max_length[250]',
                'errors' => [
                    'regex_match' => 'Only alphabets, numbers, spaces, dots, commas, dashes, and brackets are allowed.',
                    'max_length' => 'Max 250 characters allowed in remarks.',
                ]
            ]
        ];


        $uploadType = $this->request->getPost('upload_type');

        if ($uploadType === 'file') {

            $file = $this->request->getFile('file_path');
            if ($file && $file->isValid() && !$file->hasMoved()) {

                $rules['file_path'] = [
                    'rules' => 'uploaded[file_path]|max_size[file_path,2048]|ext_in[file_path,jpg,jpeg,png,pdf,doc,docx,xls,xlsx]',
                    'errors' => [
                        'uploaded' => 'Please upload a file.',
                        'max_size' => 'File size must not exceed 2MB.',
                        'ext_in' => 'Allowed file types: jpg, jpeg, png, pdf, doc, docx.',
                    ]
                ];
            }
        } elseif ($uploadType === 'link') {
            $rules['link'] = [
                'rules' => 'required|valid_url',
                'errors' => [
                    'required' => 'Link is required.',
                    'valid_url' => 'Please enter a valid URL.',
                ]
            ];
        }



        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [

            'requirement_clause' => $this->request->getPost('requirement_clause'),
            'implementation'  => $this->request->getPost('implementation'),

            'remarks'          => $this->request->getPost('Remark'),
            'upload_type'          => $this->request->getPost('upload_type'),

            // Handling file or link input
            'file_path'       => null,
            'link'            => $this->request->getPost('upload_type') === 'link' ? $this->request->getPost('link') : null,

            
            'updated_by'      => session()->get('logined_user_id'),
             
            'updated_at'      => date('Y-m-d H:i:s'),
            'status'          => 1 // Assuming the default status is 1 (active)
        ];


        $new_uploaded_image = $this->request->getFile('file_path');
        $session_id = session()->get('entity_id');
        $updating_id = $this->request->getPost('updating_id');
        $model = new ImplementationComplianceModel;
        $existing = $model->find($updating_id);


        if ($new_uploaded_image && $new_uploaded_image->isValid() && !$new_uploaded_image->hasMoved()) {

            // Delete existing image before uploading new one
            if ($existing && !empty($existing['file_path'])) {
                $oldImagePath = FCPATH . $existing['file_path']; // Full path to old image
                if (file_exists($oldImagePath)) {
                    unlink($oldImagePath); // Delete the old image
                }
            }

            // Validate extension

            // Generate new file name and path
            $logoName = $new_uploaded_image->getRandomName();
            $logoDir = "uploads/entity_profile/{$session_id}/Implementation_compliance/{$updating_id}";
            $logoPath = FCPATH . $logoDir;

            // Ensure directory exists
            if (!is_dir($logoPath)) {
                mkdir($logoPath, 0777, true);
            }

            // Move new image
            $new_uploaded_image->move($logoPath, $logoName);

            // Save relative path to session or DB
            $relativePath = $logoDir . '/' . $logoName;

            $data['file_path'] = $relativePath;
        }

        $model->update($updating_id, $data);
        return redirect()->back()->with('success', 'data  updated successfully');
    }



    public function edit_ImplementationCompliance($id)
    {
        $ImplementationCompliance = new ImplementationComplianceModel();
        $ImplementationCompliance = $ImplementationCompliance->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Implementation_compliance/edit', [
            'ImplementationCompliance' => $ImplementationCompliance,
            'organization' => $organization
        ]);
    }


    public function view_Implementation_Compliance($id)
    {
        $ImplementationCompliance = new ImplementationComplianceModel();
        $ImplementationCompliance = $ImplementationCompliance->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Implementation_compliance/view', [
            'ImplementationCompliance' => $ImplementationCompliance,
            'organization' => $organization
        ]);
    }


    public function insert_Implementation_compliance()
    {



        $rules = [

            'requirement_clause' => [
                'rules' => 'required|max_length[250]',
                'errors' => [
                    'required' => 'Standard Requirement Clause is required.',
                    'max_length' => 'Max 250 characters allowed.',
                ]
            ],
            'implementation' => [
                'rules' => 'required|max_length[250]',
                'errors' => [
                    'required' => 'Implementation is required.',
                    'max_length' => 'Max 250 characters allowed.',
                ]
            ],
            'upload_type' => [
                'rules' => 'required|in_list[file,link]',
                'errors' => [
                    'required' => 'Please select upload type (file or link).',
                    'in_list' => 'Upload type must be either "file" or "link".',
                ]
            ],
            'Remark' => [
                'rules' => 'permit_empty|regex_match[/^[a-zA-Z0-9\s\.\,\-\(\)]+$/]|max_length[250]',
                'errors' => [
                    'regex_match' => 'Only alphabets, numbers, spaces, dots, commas, dashes, and brackets are allowed.',
                    'max_length' => 'Max 250 characters allowed in remarks.',
                ]
            ]
        ];
        $uploadType = $this->request->getPost('upload_type');

        if ($uploadType === 'file') {
            $rules['file_path'] = [
                'rules' => 'uploaded[file_path]|max_size[file_path,2048]|ext_in[file_path,jpg,jpeg,png,pdf,doc,docx,xls,xlsx]',
                'errors' => [
                    'uploaded' => 'Please upload a file.',
                    'max_size' => 'File size must not exceed 2MB.',
                    'ext_in' => 'Allowed file types: jpg, jpeg, png, pdf, doc, docx.',
                ]
            ];
        } elseif ($uploadType === 'link') {
            $rules['link'] = [
                'rules' => 'required|valid_url',
                'errors' => [
                    'required' => 'Link is required.',
                    'valid_url' => 'Please enter a valid URL.',
                ]
            ];
        }


        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [

            'requirement_clause' => $this->request->getPost('requirement_clause'),
            'implementation'  => $this->request->getPost('implementation'),

            'remarks'          => $this->request->getPost('Remark'),
            'upload_type'          => $this->request->getPost('upload_type'),

            // Handling file or link input
            'file_path'       => null,
            'link'            => $this->request->getPost('upload_type') === 'link' ? $this->request->getPost('link') : null,

            // Additional session-based fields
            'associated_by'   => session()->get('user_associated'),
            'entity_id'       => session()->get('entity_id'),
            'created_by'      => session()->get('logined_user_id'),
            'updated_by'      => session()->get('logined_user_id'),
            'created_at'      => date('Y-m-d H:i:s'),
            'updated_at'      => date('Y-m-d H:i:s'),
            'status'          => 1 // Assuming the default status is 1 (active)
        ];




        $model = new ImplementationComplianceModel;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();


        $session_id = session()->get('entity_id');

        if ($uploadType === 'file') {
            $logo = $this->request->getFile('file_path');
            if ($logo && $logo->isValid() && !$logo->hasMoved()) {
                $logoName = $logo->getRandomName();
                $logoDir = "uploads/entity_profile/{$session_id}/Implementation_compliance/{$insertId}"; // Relative path
                $logoPath = FCPATH . $logoDir;

                // Make sure the folder exists
                if (!is_dir($logoPath)) {
                    mkdir($logoPath, 0777, true);
                }

                // Move file
                $logo->move($logoPath, $logoName);

                // Final relative path to store in DB
                $relativePath = $logoDir . '/' . $logoName;

                // Update DB with logo path
                $model->update($insertId, ['file_path' => $relativePath]);
            }
        }











        return redirect()->back()->with('success', 'Implementation compliance  added successfully!');
    }










    public function add_ImplementationCompliance()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Implementation_compliance/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Implementation_compliance/index', ['organization' => $organization]);
    }
}
