<?php

namespace App\Controllers\Internal_Inspectors;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\InternalInspectorModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Internal_Inspectors extends BaseController
{


    public function delete_internal_inspector($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $internal_inspector = new InternalInspectorModel();

        // Check if record exists
        $existing = $internal_inspector->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $internal_inspector->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        return redirect()->back()->with('success', 'internal inspector deleted successfully.');
    }


    public function update_internal_inspector()
    {

        $rules = [
            'title' => [
                'label' => 'Title',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a title.'
                ]
            ],
            'first_name' => [
                'label' => 'First Name',
                'rules' => 'required|alpha_space',
                'errors' => [
                    'required' => 'First name is required.',
                    'alpha_space' => 'First name can only contain letters and spaces.'
                ]
            ],
            'Middle_name' => [
                'label' => 'Middle name',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Middle name is required.',
                ]
            ],
            'Last_name' => [
                'label' => 'Last Name',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Last name is required.',
                ]
            ],
            'facility_id' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Employee ID is required.',
                ]
            ],

            'date_of_appointment' => [
                'rules' => 'required|valid_date',
                'errors' => [
                    'required' => 'Appointment date is required.',
                    'valid_date' => 'Please enter a valid date.',
                ]
            ],
            'Qualification' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Qualification is required.',
                ]
            ],
            'Experience' => [
                'rules' => 'required|numeric',
                'errors' => [
                    'required' => 'Years of experience is required.',
                    'numeric' => 'Experience must be a number.',
                ]
            ],
            'Experience_m' => [
                'rules' => 'required|numeric|less_than[12]',
                'errors' => [
                    'required' => 'Months of experience is required.',
                    'numeric' => 'Experience (months) must be a number.',
                    'less_than' => 'Months must be less than 12.',
                ]
            ],
            'designation' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Designation is required.',
                ]
            ],
            'skill_catagery' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Skill category is required.',
                ]
            ],




            'skills' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'At least one skill must be selected.',
                ]
            ],
            'department' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'department must be selected.',
                ]
            ],
            'designation' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Designation must be selected.',
                ]
            ],
            'role' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'role must be selected.',
                ]
            ],
            'email_id' => [
                'label' => 'Email Address',
                'rules' => 'required|valid_email|max_length[50]|unique_email_across_tables_on_update[internal_inspectors.email]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'valid_email' => 'The {field} must be a valid email address.',
                    'max_length' => 'The {field} must not exceed 50 characters.',
                    'enity_user_email_cheek' => 'This email ID is already registered for the selected organization.',
                ]
            ],

            'evaluated_by' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select who evaluated the employee.',
                ]
            ],

            'name_of_the_evaluator' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the name of the evaluator.',
                ]
            ],
            'internal_or_external' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the name of the internal or external.',
                ]
            ],
            'training_completed' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the name of the training completed.',
                ]
            ],
            'inspections_completed' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the name of the inspections completed.',
                ]
            ],
            'responsibilites' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the name of the responsibilites.',
                ]
            ],

        ];






      $data_1 = [];

        $location = $this->request->getPost('location');
        $others = $this->request->getPost('others');
        $selected_location_id = $this->request->getPost('selected_location_id');

        if ($location === 'Others') {
            $rules['others'] = [
                'label' => 'Other Location Name',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 50 characters.'
                ]
            ];


            if (!empty($_POST['others'])) {
                $data_1['Others'] = $_POST['others'];
            }
        }


        if ($location == 'Corporate_Office') {


            $data_1['Corporate_Office'] = null;
        }

        if ($location !== 'Corporate_Office' && $location !== 'Others') {
            $rules['selected_location_id'] = [
                'label' => 'Selected Location',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',

                ]
            ];

            if (!empty($_POST['selected_location_id'])) {
                $data_1[$location] = $_POST['selected_location_id'];
            }
        }

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'title' => $this->request->getPost('title'),
            'first_name' => $this->request->getPost('first_name'),
            'middle_name' => $this->request->getPost('Middle_name'),
            'last_name' => $this->request->getPost('Last_name'),
            'ID_Number' => $this->request->getPost('facility_id'),

            'date_of_appointment' => $this->request->getPost('date_of_appointment'),
            'Qualifications' => $this->request->getPost('Qualification'),
            'experience_years' => $this->request->getPost('Experience'),
            'experience_months' => $this->request->getPost('Experience_m'),
            'designation' => $this->request->getPost('designation'),
            // 'skills' => $this->request->getPost('Ownership'),
'department' => $this->request->getPost('department'),
            'role' => $this->request->getPost('role'),


            'email' => $this->request->getPost('email_id'),
            'evaluated_by' => $this->request->getPost('evaluated_by'),
            'name_of_the_evaluator' => $this->request->getPost('name_of_the_evaluator'),


            'internal_or_external' => $this->request->getPost('internal_or_external'),
            'trainings_completed' => $this->request->getPost('training_completed'),
            'inspections_completed' => $this->request->getPost('inspections_completed'),
            'responsibilities_assigned' => $this->request->getPost('responsibilites'),



            'remark' => $this->request->getPost('Remark'),


            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'location' => json_encode($data_1), // Empty for now,


        ];


        $password = $this->request->getPost('Password');
        if (!empty($password)) {
            $data['password'] = password_hash($password, PASSWORD_DEFAULT);
        }

        $Reporting_Authority = $this->request->getPost('Reporting_Authority');
        if (!empty($Reporting_Authority)) {
            $data['reporting_authority'] = $this->request->getPost('Reporting_Authority');
        }



        $skills = $this->request->getPost('skill_catagery');
        if (!empty($skills)) {


            $data_2[$skills] = $this->request->getPost('skills');
            $data['skills'] = json_encode($data_2);
        }


        $remaining_images = json_decode($this->request->getPost('remaining_images'), true);

        $mergedArray = $remaining_images;
        $insertId = $this->request->getPost('updating_id');

        $photos = $this->request->getFileMultiple('Photos');


        $session_id = session()->get('entity_id');
        if ($photos && count($photos) > 0) {
            $photoPaths = [];
            $errors = [];

            foreach ($photos as $index => $photo) {
                // Validate file
                if (!$photo->isValid() || $photo->hasMoved()) {
                    $errors[] = "File {$photo->getName()} is not valid or already moved.";
                    continue;
                }

                // Validate file type
                $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp', 'image/bmp', 'image/tiff']; // Added image/jpg as well
                if (!in_array($photo->getMimeType(), $allowedTypes)) {
                    $errors[] = "File {$photo->getName()} must be a JPEG or PNG image.";
                    continue;
                }

                // Validate file size (e.g., max 2MB)
                $maxSize = 5 * 1024 * 1024; // 2MB in bytes
                if ($photo->getSize() > $maxSize) {
                    $errors[] = "File {$photo->getName()} exceeds the maximum size of 2MB.";
                    continue;
                }




                // Passed all validations — save file
                $photoName = $photo->getRandomName();
                $photoDir = "uploads/entity_profile/{$session_id}/Internal_Inspectors/{$insertId}/photos/";
                $photoPath = FCPATH . $photoDir;

                if (!is_dir($photoPath)) {
                    mkdir($photoPath, 0777, true);
                }

                $photo->move($photoPath, $photoName);
                $relativePath = $photoDir . '/' . $photoName;
                $photoPaths[] = $relativePath;
            }

            // Save valid paths if any
            if (!empty($photoPaths)) {

                $mergedArray = array_merge($photoPaths, $remaining_images);


                $folderPath = FCPATH .  "uploads/entity_profile/{$session_id}/Internal_Inspectors/{$insertId}/photos/";
                $keepFilenames = array_map('basename', $mergedArray);

                // Scan folder
                $filesInFolder = scandir($folderPath);

                foreach ($filesInFolder as $file) {
                    if ($file === '.' || $file === '..') continue;

                    // If the file is NOT in the keep list, delete it
                    if (!in_array($file, $keepFilenames)) {
                        $filePath = $folderPath . DIRECTORY_SEPARATOR . $file;
                        if (is_file($filePath)) {
                            unlink($filePath);
                        }
                    }
                }
            }

            // Handle errors (e.g., flash message or log)
            if (!empty($errors)) {

                // Example: pass to view or flashdata
                var_dump($errors);
                var_dump($_FILES['Photos']);


                session()->set('validation_errors', $this->validator->listErrors());
                session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds
            }
        }

        $data['photo'] = json_encode($mergedArray);





        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/Internal_Inspectors/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['documents'] = json_encode($documents);


        $model = new InternalInspectorModel();

        $existing = $model->find($insertId);




        $files = $this->request->getFileMultiple('Person_Photo');
        $data['Person_Photo'] = null;

        if (is_array($files) && count($files) > 0) {
            $uploadedFirstImage = false;

            foreach ($files as $file) {
                if ($file->isValid() && !$file->hasMoved()) {
                    $ext = strtolower($file->getClientExtension());
                    $allowed = ['jpeg', 'jpg', 'png', 'webp', 'gif', 'bmp', 'tiff'];

                    if (!in_array($ext, $allowed)) {
                        session()->set('validation_errors', "Invalid file type uploaded.");
                        session()->markAsTempdata('validation_errors', 30);



                        return redirect()->back()->withInput();
                    }

                    if ($existing && !empty($existing['Person_Photo'])) {
                        $oldImagePath = FCPATH . $existing['Person_Photo']; // Full path to old image
                        if (file_exists($oldImagePath)) {
                            unlink($oldImagePath); // Delete the old image
                        }
                    }




                    // Prepare upload directory
                    $logoName = $file->getRandomName();
                    $logoDir = "uploads/entity_profile/{$session_id}/Employee/{$insertId}/photos/";
                    $logoPath = FCPATH . $logoDir;

                    if (!is_dir($logoPath)) {
                        mkdir($logoPath, 0777, true);
                    }

                    // Delete existing image only once for the first valid file
                    if (!$uploadedFirstImage && $existing && !empty($existing['Person_Photo'])) {
                        $oldImagePath = FCPATH . $existing['Person_Photo'];
                        if (file_exists($oldImagePath)) {
                            unlink($oldImagePath);
                        }
                    }

                    // Move the file
                    $file->move($logoPath, $logoName);

                    // Save the first image's path
                    if (!$uploadedFirstImage) {
                        $data['Person_Photo'] = $logoDir . '/' . $logoName;
                        $uploadedFirstImage = true;
                    }

                    // Optionally: save all file paths in array for future use
                    // $all_uploaded_paths[] = $logoDir . '/' . $logoName;
                }
            }
        }


        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success

            $db = \Config\Database::connect();

            // Get the new designation_id from POST
            $newDesignationId = $this->request->getPost('designation');

            // Optional: Validate the input
            if (!empty($newDesignationId)) {
                // Perform the update manually
                $builder = $db->table('internal_inspectors');
                $builder->where('id', $insertId);
                $update = $builder->update(['designation' => $newDesignationId]);
            }


            $db = \Config\Database::connect();

            // Define the data to update
            $data_new = [
                'name_of_the_user' => $this->request->getPost('title') . ' ' . $this->request->getPost('first_name') . ' ' . $this->request->getPost('Middle_name') . ' ' . $this->request->getPost('Last_name'),

            ];

            // Specify the condition for which the record should be updated
            $builder = $db->table('register_log');

            // Perform the update
            $builder->set($data_new)
                ->where('user_id', $insertId)  // Use the appropriate condition (e.g., primary key or other unique column)
                ->where('user_table', 'internal_inspectors')  // Use the appropriate condition (e.g., primary key or other unique column)
                ->update();



            //    var_dump($_POST['designation']);
            return redirect()->back()->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        // return redirect()->back()->with('success', 'packaging unit  updated successfully');
    }



    public function edit_internal_inspector($id)
    {
        $Internal_Inspectors = new InternalInspectorModel();
        $Internal_Inspectors = $Internal_Inspectors->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Internal_Inspectors/edit', [
            'Internal_Inspectors' => $Internal_Inspectors,
            'organization' => $organization
        ]);
    }


    public function view_internal_inspectors($id)
    {
        $Internal_Inspectors = new InternalInspectorModel();
        $Internal_Inspectors = $Internal_Inspectors->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Internal_Inspectors/view', [
            'Internal_Inspectors' => $Internal_Inspectors,
            'organization' => $organization
        ]);
    }


    public function insert_Internal_Inspectors()
    {



        $rules = [
            'title' => [
                'label' => 'Title',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select a title.'
                ]
            ],
            'first_name' => [
                'label' => 'First Name',
                'rules' => 'required|alpha_space',
                'errors' => [
                    'required' => 'First name is required.',
                    'alpha_space' => 'First name can only contain letters and spaces.'
                ]
            ],
            'Middle_name' => [
                'label' => 'Middle name',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Middle name is required.',
                ]
            ],
            'Last_name' => [
                'label' => 'Last Name',
                'rules' => 'permit_empty',
                'errors' => [
                    'required' => 'Last name is required.',
                ]
            ],
            'facility_id' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Employee ID is required.',
                ]
            ],

            'date_of_appointment' => [
                'rules' => 'required|valid_date',
                'errors' => [
                    'required' => 'Appointment date is required.',
                    'valid_date' => 'Please enter a valid date.',
                ]
            ],
            'Qualification' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Qualification is required.',
                ]
            ],
            'Experience' => [
                'rules' => 'required|numeric',
                'errors' => [
                    'required' => 'Years of experience is required.',
                    'numeric' => 'Experience must be a number.',
                ]
            ],
            'Experience_m' => [
                'rules' => 'required|numeric|less_than[12]',
                'errors' => [
                    'required' => 'Months of experience is required.',
                    'numeric' => 'Experience (months) must be a number.',
                    'less_than' => 'Months must be less than 12.',
                ]
            ],
            'department' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'department must be selected.',
                ]
            ],
            'designation' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Designation must be selected.',
                ]
            ],
            'role' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'role must be selected.',
                ]
            ],
            'skill_catagery' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Skill category is required.',
                ]
            ],

            'password' => [
                'rules' => 'required|min_length[8]',
                'errors' => [
                    'required' => 'Password is required.',
                    'min_length' => 'Password must be at least 8 characters long.',
                ]
            ],


            'skills' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'At least one skill must be selected.',
                ]
            ],
            'email_id' => [
                'label' => 'Email Address',
                'rules' => 'required|valid_email|max_length[50]|unique_email_across_tables',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'valid_email' => 'The {field} must be a valid email address.',
                    'max_length' => 'The {field} must not exceed 50 characters.',
                    'enity_user_email_cheek' => 'This email ID is already registered for the selected organization.',
                ]
            ],

            'evaluated_by' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please select who evaluated the employee.',
                ]
            ],

            'name_of_the_evaluator' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the name of the evaluator.',
                ]
            ],
            'internal_or_external' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the name of the internal or external.',
                ]
            ],
            'training_completed' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the name of the training completed.',
                ]
            ],
            'inspections_completed' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the name of the inspections completed.',
                ]
            ],
            'responsibilites' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Please enter the name of the responsibilites.',
                ]
            ],
            'Person_Photo' => [
                'label' => 'Person Photo',
                'rules' => 'uploaded[Person_Photo]|max_size[Person_Photo,5120]|is_image[Person_Photo]',
                'errors' => [
                    'uploaded' => 'The {field} is required.',
                    'max_size' => 'The {field} must not exceed 5MB.',
                    'mime_in' => 'The {field} must be a JPEG or PNG file.',

                ]
            ],
        ];

        $data_1 = [];

        $location = $this->request->getPost('location');
        $others = $this->request->getPost('others');
        $selected_location_id = $this->request->getPost('selected_location_id');

        if ($location === 'Others') {
            $rules['others'] = [
                'label' => 'Other Location Name',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 50 characters.'
                ]
            ];


            if (!empty($_POST['others'])) {
                $data_1['Others'] = $_POST['others'];
            }
        }


        if ($location == 'Corporate_Office') {


            $data_1['Corporate_Office'] = null;
        }

        if ($location !== 'Corporate_Office' && $location !== 'Others') {
            $rules['selected_location_id'] = [
                'label' => 'Selected Location',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',

                ]
            ];

            if (!empty($_POST['selected_location_id'])) {
                $data_1[$location] = $_POST['selected_location_id'];
            }
        }
        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            'title' => $this->request->getPost('title'),
            'first_name' => $this->request->getPost('first_name'),
            'middle_name' => $this->request->getPost('Middle_name'),
            'last_name' => $this->request->getPost('Last_name'),
            'ID_Number' => $this->request->getPost('facility_id'),

            'date_of_appointment' => $this->request->getPost('date_of_appointment'),
            'Qualifications' => $this->request->getPost('Qualification'),
            'experience_years' => $this->request->getPost('Experience'),
            'experience_months' => $this->request->getPost('Experience_m'),
            'designation' => $this->request->getPost('designation'),
            // 'skills' => $this->request->getPost('Ownership'),
            'department' => $this->request->getPost('department'),
            'role' => $this->request->getPost('role'),

            'email' => $this->request->getPost('email_id'),
            'evaluated_by' => $this->request->getPost('evaluated_by'),
            'name_of_the_evaluator' => $this->request->getPost('name_of_the_evaluator'),


            'internal_or_external' => $this->request->getPost('internal_or_external'),
            'trainings_completed' => $this->request->getPost('training_completed'),
            'inspections_completed' => $this->request->getPost('inspections_completed'),
            'responsibilities_assigned' => $this->request->getPost('responsibilites'),



            'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
            'remark' => $this->request->getPost('Remark'),

            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'location' => json_encode($data_1), // Empty for now,


        ];



        $Reporting_Authority = $this->request->getPost('Reporting_Authority');
        if (!empty($Reporting_Authority)) {
            $data['reporting_authority'] = $this->request->getPost('Reporting_Authority');
        }


        $skills = $this->request->getPost('skill_catagery');
        if (!empty($skills)) {


            $data_2[$skills] = $this->request->getPost('skills');
            $data['skill'] = json_encode($data_2);
        }


        $model = new InternalInspectorModel;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();





        $photos = $this->request->getFileMultiple('Photos');

        $session_id = session()->get('entity_id');
        if ($photos && count($photos) > 0) {
            $photoPaths = [];
            $errors = [];

            foreach ($photos as $index => $photo) {
                // Validate file
                if (!$photo->isValid() || $photo->hasMoved()) {
                    $errors[] = "File {$photo->getName()} is not valid or already moved.";
                    continue;
                }

                // Validate file type
                $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp', 'image/bmp', 'image/tiff']; // Added image/jpg as well
                if (!in_array($photo->getMimeType(), $allowedTypes)) {
                    $errors[] = "File {$photo->getName()} must be a JPEG or PNG image.";
                    continue;
                }

                // Validate file size (e.g., max 2MB)
                $maxSize = 5 * 1024 * 1024; // 2MB in bytes
                if ($photo->getSize() > $maxSize) {
                    $errors[] = "File {$photo->getName()} exceeds the maximum size of 2MB.";
                    continue;
                }




                // Passed all validations — save file
                $photoName = $photo->getRandomName();
                $photoDir = "uploads/entity_profile/{$session_id}/Internal_Inspectors/{$insertId}/photos";
                $photoPath = FCPATH . $photoDir;

                if (!is_dir($photoPath)) {
                    mkdir($photoPath, 0777, true);
                }

                $photo->move($photoPath, $photoName);
                $relativePath = $photoDir . '/' . $photoName;
                $photoPaths[] = $relativePath;
            }

            // Save valid paths if any
            if (!empty($photoPaths)) {
                $model->update($insertId, ['photo' => json_encode($photoPaths)]);
            }

            // Handle errors (e.g., flash message or log)
            if (!empty($errors)) {

                // Example: pass to view or flashdata

                session()->set('validation_errors', $this->validator->listErrors());
                session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

                // var_dump($errors);
            }
        }





        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/Internal_Inspectors/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/Internal_Inspectors/{$insertId}/documants";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'documents' => json_encode($documents)
        ]);


        $logo = $this->request->getFile('Person_Photo');
        if ($logo && $logo->isValid() && !$logo->hasMoved()) {
            $logoName = $logo->getRandomName();
            $logoDir = "uploads/entity_profile/{$session_id}/Internal_Inspectors/{$insertId}/Person_Photo/"; // Relative path
            $logoPath = FCPATH . $logoDir;

            // Make sure the folder exists
            if (!is_dir($logoPath)) {
                mkdir($logoPath, 0777, true);
            }

            // Move file
            $logo->move($logoPath, $logoName);

            // Final relative path to store in DB
            $relativePath = $logoDir . '/' . $logoName;

            // Update DB with logo path
            $model->update($insertId, ['Person_Photo' => $relativePath]);
        }






        $db = \Config\Database::connect();

        // Define the data to insert
        $data_new = [
            'name_of_the_user' => $this->request->getPost('title') . ' ' . $this->request->getPost('first_name') . ' ' . $this->request->getPost('Middle_name') . ' ' . $this->request->getPost('Last_name'),
            'user_id' => $insertId, // Ensure you're including the user_id here
            'user_table' => 'internal_inspectors', // Set the user_table value as required
        ];

        // Specify the table where the data should be inserted
        $builder = $db->table('register_log');

        // Perform the insert
        $builder->insert($data_new);


        return redirect()->back()->with('success', 'internal inspector  added successfully!');
    }










    public function add_internal_inspectors()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Internal_Inspectors/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Internal_Inspectors/index', ['organization' => $organization]);
    }
}
