<?php

namespace App\Controllers\Internal_audit;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\InternalAuditModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Internal_audit extends BaseController
{


    public function delete_internal_audit($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $internal_audit = new InternalAuditModel();

        // Check if record exists
        $existing = $internal_audit->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $internal_audit->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        return redirect()->back()->with('success', 'internal audit   deleted successfully.');
    }


    public function update_internal_audit()
    {

        $rules = [
            'audit_categoery' => [
                'label' => 'Audit Category',
                'rules' => 'required|in_list[Initial,Surveillance,Renewal]',
                'errors' => [
                    'required' => 'Audit Category is required.',
                    'in_list' => 'Audit Category must be one of: Initial, Surveillance, Renewal',
                ]
            ],
            'recoed_date' => [
                'label' => 'Record Date',
                'rules' => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required' => 'Record Date is required.',
                    'valid_date' => 'Record Date must be in the format YYYY-MM-DDTHH:MM.',
                ]
            ],
            'location' => [
                'label' => 'Location',
                'rules' => 'required|max_length[255]',
                'errors' => [
                    'required' => 'Location is required.',
                    'max_length' => 'Location cannot exceed 255 characters.',
                ]
            ],
             
            'audit_type' => [
                'label' => 'Audit Type',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Audit Type is required.',
                    'in_list' => 'Audit Type must be one of: Operational, Financial, Compliance.',
                ]
            ],
             
            'Department' => [
                'label' => 'Department',
                'rules' => 'required|integer|greater_than[0]',
                'errors' => [
                    'required' => 'Department is required.',
                    'greater_than' => 'Department must be a valid integer greater than 0.',
                ]
            ],
            'internal_audit_schedule' => [
                'label' => 'Internal Audit Schedule',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Audit Schedule is required.',
                    'max_length' => 'Internal Audit Schedule cannot exceed 1000 characters.',
                ]
            ],
            'internal_audit_scope' => [
                'label' => 'Internal Audit Scope',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Audit Scope is required.',
                    'max_length' => 'Internal Audit Scope cannot exceed 1000 characters.',
                ]
            ],
            'internal_audit_checklist' => [
                'label' => 'Internal Audit Checklist',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Audit Checklist is required.',
                    'max_length' => 'Internal Audit Checklist cannot exceed 1000 characters.',
                ]
            ],
            'internal_non_conformities' => [
                'label' => 'Internal Non-Conformities',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Non-Conformities is required.',
                    'max_length' => 'Internal Non-Conformities cannot exceed 1000 characters.',
                ]
            ],
            'internal_opportunities' => [
                'label' => 'Internal Opportunities',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Opportunities is required.',
                    'max_length' => 'Internal Opportunities cannot exceed 1000 characters.',
                ]
            ],
            'internal_corrective_actions_taken' => [
                'label' => 'Internal Corrective Actions Taken',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Corrective Actions Taken is required.',
                    'max_length' => 'Internal Corrective Actions Taken cannot exceed 1000 characters.',
                ]
            ],
            'internal_corrective_actions_closed' => [
                'label' => 'Internal Corrective Actions Closed',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Corrective Actions Closed is required.',
                    'max_length' => 'Internal Corrective Actions Closed cannot exceed 1000 characters.',
                ]
            ],
            'internal_final_audit_report' => [
                'label' => 'Internal Final Audit Report',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Final Audit Report is required.',
                    'max_length' => 'Internal Final Audit Report cannot exceed 1000 characters.',
                ]
            ],
            'description' => [
                'label' => 'Description',
                'rules' => 'required|max_length[2000]',
                'errors' => [
                    'required' => 'Description is required.',
                    'max_length' => 'Description cannot exceed 2000 characters.',
                ]
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'permit_empty|max_length[2000]',
                'errors' => [
                    'max_length' => 'Remark cannot exceed 2000 characters.',
                ]
            ],

        ];






 $data_1 = [];

        $location = $this->request->getPost('location');
        $others = $this->request->getPost('others');
        $selected_location_id = $this->request->getPost('selected_location_id');

        if ($location === 'Others') {
            $rules['others'] = [
                'label' => 'Other Location Name',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 50 characters.'
                ]
            ];


            if (!empty($_POST['others'])) {
                $data_1['Others'] = $_POST['others'];
            }
        }


        if ($location == 'Corporate_Office') {


            $data_1['Corporate_Office'] = null;
        }

        if ($location !== 'Corporate_Office' && $location !== 'Others') {
            $rules['selected_location_id'] = [
                'label' => 'Selected Location',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',

                ]
            ];

            if (!empty($_POST['selected_location_id'])) {
                $data_1[$location] = $_POST['selected_location_id'];
            }
        }



        $data_2 = [];

        $audit_type = $this->request->getPost('audit_type');
        $others_in_audit_type = $this->request->getPost('others_in_audit_type');


        if ($audit_type != 'Others') {

            $rules['audit_type'] = [
                'label' => 'Audit Type',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 30 characters.'
                ]
            ];

            if (!empty($audit_type)) {
                $data_2[$audit_type] = NULL;
            }
        } else {

            $rules['others_in_audit_type'] = [
                'label' => 'Audit Type',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 30 characters.'
                ]
            ];

             if (!empty($others_in_audit_type)) {
               $data_2[$audit_type] = $others_in_audit_type;
            }
           
        }





        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());
          
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'record_date' => $this->request->getPost('recoed_date'),
            'audit_category' => $this->request->getPost('audit_categoery'),

            'internal_auditee_representative' =>  json_encode($this->request->getPost('auditee_name')),
            'location' => $this->request->getPost('location'),
            'audit_for' =>  json_encode($data_1),
            'audit_type' =>  json_encode($data_2),
            'department' => $this->request->getPost('Department'),
            'internalAudit_schedule' => $this->request->getPost('internal_audit_schedule'),
            'internalAudit_scope' => $this->request->getPost('internal_audit_scope'),
            'internalAudit_checklist_used' => $this->request->getPost('internal_audit_checklist'),
            'internal_non_conformities_reported' => $this->request->getPost('internal_non_conformities'),
            'internal_opportunities_for_improvement' => $this->request->getPost('internal_opportunities'),
            'internal_corrective_actions_taken' => $this->request->getPost('internal_corrective_actions_taken'),
            'internal_corrective_actions_closed' => $this->request->getPost('internal_corrective_actions_closed'),
            'internal_final_audit_report' => $this->request->getPost('internal_final_audit_report'),
            'description' => $this->request->getPost('description'),
             


            'remark' => $this->request->getPost('Remark'),
            


            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            


        ];


 

        
        $insertId = $this->request->getPost('updating_id');

         
        $session_id = session()->get('entity_id');
     

        
        $auditor_name = $this->request->getPost('auditor_name');
         
        $auditor_photo = $this->request->getFiles()['auditor_photo'];
        $existingauditor_photos = $this->request->getPost('existing_file_auditor_photo');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/Internal_audit/{$insertId}/auditor/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($auditor_name as $i => $auditor_name) {
            $newFilePath = $existingauditor_photos[$i] ?? ''; // Default to existing

            if (isset($files['auditor_photo'][$i]) && $files['auditor_photo'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingauditor_photos[$i]) && file_exists(FCPATH . $existingauditor_photos[$i])) {
                    unlink(FCPATH . $existingauditor_photos[$i]);
                }

                $file = $files['auditor_photo'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $auditor_name,
                
                'file' => $newFilePath
            ];
        }

        $data['auditors'] = json_encode($documents);





        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/Internal_audit/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['documants'] = json_encode($documents);


        $model = new InternalAuditModel();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success

            



            
            return redirect()->back()->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        // return redirect()->back()->with('success', 'packaging unit  updated successfully');
    }



    public function edit_internal_audit($id)
    {
        $internal_audit = new InternalAuditModel();
        $internal_audit = $internal_audit->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Internal_audit/edit', [
            'internal_audit' => $internal_audit,
            'organization' => $organization
        ]);
    }


    public function view_internal_audit($id)
    {
        $internal_audit = new InternalAuditModel();
        $internal_audit = $internal_audit->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Internal_audit/view', [
            'internal_audit' => $internal_audit,
            'organization' => $organization
        ]);
    }


    public function insert_internal_audit()
    {



        
        $rules = [
            'audit_categoery' => [
                'label' => 'Audit Category',
                'rules' => 'required|in_list[Initial,Surveillance,Renewal]',
                'errors' => [
                    'required' => 'Audit Category is required.',
                    'in_list' => 'Audit Category must be one of: Initial, Surveillance, Renewal',
                ]
            ],
            'recoed_date' => [
                'label' => 'Record Date',
                'rules' => 'required|valid_date[Y-m-d]',
                'errors' => [
                    'required' => 'Record Date is required.',
                    'valid_date' => 'Record Date must be in the format YYYY-MM-DDTHH:MM.',
                ]
            ],
            'location' => [
                'label' => 'Location',
                'rules' => 'required|max_length[255]',
                'errors' => [
                    'required' => 'Location is required.',
                    'max_length' => 'Location cannot exceed 255 characters.',
                ]
            ],
             
            'audit_type' => [
                'label' => 'Audit Type',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Audit Type is required.',
                    'in_list' => 'Audit Type must be one of: Operational, Financial, Compliance.',
                ]
            ],
             
            'Department' => [
                'label' => 'Department',
                'rules' => 'required|integer|greater_than[0]',
                'errors' => [
                    'required' => 'Department is required.',
                    'greater_than' => 'Department must be a valid integer greater than 0.',
                ]
            ],
            'internal_audit_schedule' => [
                'label' => 'Internal Audit Schedule',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Audit Schedule is required.',
                    'max_length' => 'Internal Audit Schedule cannot exceed 1000 characters.',
                ]
            ],
            'internal_audit_scope' => [
                'label' => 'Internal Audit Scope',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Audit Scope is required.',
                    'max_length' => 'Internal Audit Scope cannot exceed 1000 characters.',
                ]
            ],
            'internal_audit_checklist' => [
                'label' => 'Internal Audit Checklist',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Audit Checklist is required.',
                    'max_length' => 'Internal Audit Checklist cannot exceed 1000 characters.',
                ]
            ],
            'internal_non_conformities' => [
                'label' => 'Internal Non-Conformities',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Non-Conformities is required.',
                    'max_length' => 'Internal Non-Conformities cannot exceed 1000 characters.',
                ]
            ],
            'internal_opportunities' => [
                'label' => 'Internal Opportunities',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Opportunities is required.',
                    'max_length' => 'Internal Opportunities cannot exceed 1000 characters.',
                ]
            ],
            'internal_corrective_actions_taken' => [
                'label' => 'Internal Corrective Actions Taken',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Corrective Actions Taken is required.',
                    'max_length' => 'Internal Corrective Actions Taken cannot exceed 1000 characters.',
                ]
            ],
            'internal_corrective_actions_closed' => [
                'label' => 'Internal Corrective Actions Closed',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Corrective Actions Closed is required.',
                    'max_length' => 'Internal Corrective Actions Closed cannot exceed 1000 characters.',
                ]
            ],
            'internal_final_audit_report' => [
                'label' => 'Internal Final Audit Report',
                'rules' => 'required|max_length[1000]',
                'errors' => [
                    'required' => 'Internal Final Audit Report is required.',
                    'max_length' => 'Internal Final Audit Report cannot exceed 1000 characters.',
                ]
            ],
            'description' => [
                'label' => 'Description',
                'rules' => 'required|max_length[2000]',
                'errors' => [
                    'required' => 'Description is required.',
                    'max_length' => 'Description cannot exceed 2000 characters.',
                ]
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'permit_empty|max_length[2000]',
                'errors' => [
                    'max_length' => 'Remark cannot exceed 2000 characters.',
                ]
            ],

        ];




 $data_1 = [];

        $location = $this->request->getPost('location');
        $others = $this->request->getPost('others');
        $selected_location_id = $this->request->getPost('selected_location_id');

        if ($location === 'Others') {
            $rules['others'] = [
                'label' => 'Other Location Name',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 50 characters.'
                ]
            ];


            if (!empty($_POST['others'])) {
                $data_1['Others'] = $_POST['others'];
            }
        }


        if ($location == 'Corporate_Office') {


            $data_1['Corporate_Office'] = null;
        }

        if ($location !== 'Corporate_Office' && $location !== 'Others') {
            $rules['selected_location_id'] = [
                'label' => 'Selected Location',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',

                ]
            ];

            if (!empty($_POST['selected_location_id'])) {
                $data_1[$location] = $_POST['selected_location_id'];
            }
        }



        $data_2 = [];

        $audit_type = $this->request->getPost('audit_type');
        $others_in_audit_type = $this->request->getPost('others_in_audit_type');


        if ($audit_type != 'Others') {

            $rules['audit_type'] = [
                'label' => 'Audit Type',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 30 characters.'
                ]
            ];

            if (!empty($audit_type)) {
                $data_2[$audit_type] = NULL;
            }
        } else {

            $rules['others_in_audit_type'] = [
                'label' => 'Audit Type',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 30 characters.'
                ]
            ];

             if (!empty($others_in_audit_type)) {
               $data_2[$audit_type] = $others_in_audit_type;
            }
           
        }

        if (!$this->validate($rules)) {


          
            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());

         
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }


        




        $data = [
            'record_date' => $this->request->getPost('recoed_date'),
            'audit_category' => $this->request->getPost('audit_categoery'),

            'internal_auditee_representative' =>  json_encode($this->request->getPost('auditee_name')),
            'location' => $this->request->getPost('location'),
            'audit_for' =>  json_encode($data_1),
            'audit_type' =>  json_encode($data_2),
            'department' => $this->request->getPost('Department'),
            'internalAudit_schedule' => $this->request->getPost('internal_audit_schedule'),
            'internalAudit_scope' => $this->request->getPost('internal_audit_scope'),
            'internalAudit_checklist_used' => $this->request->getPost('internal_audit_checklist'),
            'internal_non_conformities_reported' => $this->request->getPost('internal_non_conformities'),
            'internal_opportunities_for_improvement' => $this->request->getPost('internal_opportunities'),
            'internal_corrective_actions_taken' => $this->request->getPost('internal_corrective_actions_taken'),
            'internal_corrective_actions_closed' => $this->request->getPost('internal_corrective_actions_closed'),
            'internal_final_audit_report' => $this->request->getPost('internal_final_audit_report'),
            'description' => $this->request->getPost('Remark'),
             


            'remark' => $this->request->getPost('description'),
            'audit_id' => $this->request->getPost('facility_id'),


            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
 

        ];



       

        

     


        $model = new InternalAuditModel;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();

       
    




       





        $auditor_name = $this->request->getPost('auditor_name');
         
        $auditor_photo = $this->request->getFiles()['auditor_photo'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/Internal_audit/{$insertId}/auditor";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/Internal_audit/{$insertId}/auditor";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($auditor_name as $i => $name) {
            
            $file = $auditor_photo[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'auditors' => json_encode($documents)
        ]);





 

 




        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/Internal_audit/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/Internal_audit/{$insertId}/documants";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'documants' => json_encode($documents)
        ]);



















        return redirect()->back()->with('success', 'internal audit   added successfully!');
    }










    public function add_internal_audit()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Internal_audit/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session(); 
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Internal_audit/index', ['organization' => $organization]);
    }
}
