<?php

namespace App\Controllers\Manuals_and_documants;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Manuvals_and_documents;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Manuals_and_documants extends BaseController
{


    public function delete_manuvals_and_documants($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $Manuvals_and_documents = new Manuvals_and_documents();

        // Check if record exists
        $existing = $Manuvals_and_documents->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $Manuvals_and_documents->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        return redirect()->back()->with('success', 'data deleted successfully.');
    }


    public function update_manuvals_and_documants()
    {

        $rules = [

            'Department' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Department is required.',
                ]
            ],
            'Category' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Category is required.',
                ]
            ],
            'Remark' => [
                'rules' => 'permit_empty|regex_match[/^[a-zA-Z0-9\s\.\,\-\(\)]+$/]',
                'errors' => [
                    'regex_match' => 'Only alphabets, numbers, spaces, dots, commas, dashes, and brackets are allowed.',
                ]
            ],

        ];





         
        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'department' => $this->request->getPost('Department'),

            'Category' => $this->request->getPost('Category'),

             
            'remark' => $this->request->getPost('Remark'),


            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
          


        ];


        $password = $this->request->getPost('Password');
        if (!empty($password)) {
            $data['password'] = password_hash($password, PASSWORD_DEFAULT);
        }

        $Reporting_Authority = $this->request->getPost('Reporting_Authority');
        if (!empty($Reporting_Authority)) {
            $data['reporting_authority'] = $this->request->getPost('Reporting_Authority');
        }



        $skills = $this->request->getPost('skill_catagery');
        if (!empty($skills)) {


            $data_2[$skills] = $this->request->getPost('skills');
            $data['skills'] = json_encode($data_2);
        }


      
        $insertId = $this->request->getPost('updating_id');

    
 





        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/Manuvals_and_documents/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['documants'] = json_encode($documents);


        $model = new Manuvals_and_documents();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success

             



            //    var_dump($_POST['designation']);
            return redirect()->back()->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        // return redirect()->back()->with('success', 'packaging unit  updated successfully');
    }



    public function edit_manuvals_and_documants($id)
    {
        $Manuvals_and_documents = new Manuvals_and_documents();
        $Manuvals_and_documents = $Manuvals_and_documents->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Manuals_and_documants/edit', [
            'Manuvals_and_documents' => $Manuvals_and_documents,
            'organization' => $organization
        ]);
    }


    public function view_manuvals_and_documants($id)
    {
        $Manuvals_and_documents = new Manuvals_and_documents();
        $Manuvals_and_documents = $Manuvals_and_documents->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Manuals_and_documants/view', [
            'Manuvals_and_documents' => $Manuvals_and_documents,
            'organization' => $organization
        ]);
    }


    public function insert_Department()
    {



        $rules = [

            'Department' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Department is required.',
                ]
            ],
            'Category' => [
                'rules' => 'required',
                'errors' => [
                    'required' => 'Category is required.',
                ]
            ],
            'Remark' => [
                'rules' => 'permit_empty|regex_match[/^[a-zA-Z0-9\s\.\,\-\(\)]+$/]',
                'errors' => [
                    'regex_match' => 'Only alphabets, numbers, spaces, dots, commas, dashes, and brackets are allowed.',
                ]
            ],

        ];

        

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            
            'department' => $this->request->getPost('Department'),
            'Category' => $this->request->getPost('Category'),



             
            'remark' => $this->request->getPost('Remark'),

            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
           


        ];



         

        $model = new Manuvals_and_documents;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();





 





        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/Manuvals_and_documents/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/Manuvals_and_documents/{$insertId}/documants";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'documants' => json_encode($documents)
        ]);



        return redirect()->back()->with('success', 'Manuvals and documents  added successfully!');
    }










    public function add_manuals_documents()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Manuals_and_documants/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Manuals_and_documants/index', ['organization' => $organization]);
    }
}
