<?php

namespace App\Controllers\Other_documents_reports;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\OtherDocsReportModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Other_documents_reports extends BaseController
{


    public function delete_document_report($id)
    {
        

        $OtherDocsReport = new OtherDocsReportModel();

        // Check if record exists
        $existing = $OtherDocsReport->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $OtherDocsReport->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        return redirect()->back()->with('success', 'data deleted successfully.');
    }


    public function update_document_report()
    {

         $rules = [

            'Certification_Standard' => [
                'rules' => 'required|in_list[IndGAP,Global GAP,Organic NPOP,Organic NOP]',
                'errors' => [
                    'required' => 'Certification Standard is required.',
                    'in_list' => 'Certification Standard must be one of: IndGAP, Global GAP, Organic NPOP, Organic NOP.'
                ]
            ],
            'Plant_Protection_Products' => [
                'rules'  => 'required|max_length[250]',
                'errors' => [
                    'required'   => 'Plant Protection Products is required.',
                    'max_length' => 'Plant Protection Products cannot exceed 250 characters.',
                ],
            ],
            'Fertilizers_Micronutrients' => [
                'rules'  => 'required|max_length[250]',
                'errors' => [
                    'required'   => 'Fertilizers/Micro Nutrients is required.',
                    'max_length' => 'Fertilizers/Micro Nutrients cannot exceed 250 characters.',
                ],
            ],
            'Organic_inputs' => [
                'rules'  => 'required|max_length[250]',
                'errors' => [
                    'required'   => 'Organic Inputs is required.',
                    'max_length' => 'Organic Inputs cannot exceed 250 characters.',
                ],
            ],
            'Seeds_Propagation_Material' => [
                'rules'  => 'required|max_length[250]',
                'errors' => [
                    'required'   => 'Seeds/Propagation Material is required.',
                    'max_length' => 'Seeds/Propagation Material cannot exceed 250 characters.',
                ],
            ],
            'Sampling_Date' => [
                'rules'  => 'required|valid_date',
                'errors' => [
                    'required'   => 'Sampling Date is required.',
                    'valid_date' => 'Sampling Date must be a valid date (YYYY-MM-DD).',
                ],
            ],
            'Qty_Collected' => [
                'rules'  => 'required|integer|max_length[5]',
                'errors' => [
                    'required'   => 'Qty Collected is required.',
                    'integer'    => 'Qty Collected must be a number.',
                    'max_length' => 'Qty Collected cannot exceed 5 digits.',
                ],
            ],
            'Who_Collected' => [
                'rules'  => 'required|max_length[50]',
                'errors' => [
                    'required'   => 'Who Collected is required.',
                    'max_length' => 'Who Collected cannot exceed 50 characters.',
                ],
            ],
            'Test_Report_Date' => [
                'rules'  => 'required|valid_date',
                'errors' => [
                    'required'   => 'Test Report Date is required.',
                    'valid_date' => 'Test Report Date must be a valid date (YYYY-MM-DD).',
                ],
            ],
            'Lab_Name' => [
                'rules'  => 'required|max_length[50]',
                'errors' => [
                    'required'   => 'Lab Name is required.',
                    'max_length' => 'Lab Name cannot exceed 50 characters.',
                ],
            ],
            'Lab_Type' => [
                'rules'  => 'required|in_list[Internal,External]',
                'errors' => [
                    'required' => 'Lab Type is required.',
                    'in_list'  => 'Lab Type must be either Internal or External.',
                ],
            ],
            'Report_Result' => [
                'rules'  => 'required|in_list[Positive,Negative]',
                'errors' => [
                    'required' => 'Report Result is required.',
                    'in_list'  => 'Report Result must be either Positive or Negative.',
                ],
            ],
            'Report_Summary' => [
                'rules'  => 'permit_empty|max_length[250]',
                'errors' => [
                    'required'   => 'Report Summary is required.',
                    'max_length' => 'Report Summary cannot exceed 250 characters.',
                ],
            ],
            'Bank_Name' => [
                'rules'  => 'required|max_length[50]',
                'errors' => [
                    'required'   => 'Bank Name is required.',
                    'max_length' => 'Bank Name cannot exceed 50 characters.',
                ],
            ],
            'Bank_Branch' => [
                'rules'  => 'required|max_length[100]',
                'errors' => [
                    'required'   => 'Bank Branch is required.',
                    'max_length' => 'Bank Branch cannot exceed 100 characters.',
                ],
            ],
            'Bank_Account_Number' => [
                'rules'  => 'required|max_length[20]',
                'errors' => [
                    'required'   => 'Bank Account Number is required.',
                    'max_length' => 'Bank Account Number cannot exceed 20 characters.',
                ],
            ],
            'Bank_IFSC' => [
                'rules'  => 'required|alpha_numeric|max_length[11]',
                'errors' => [
                    'required'      => 'IFSC Code is required.',
                    'alpha_numeric' => 'IFSC Code must contain only letters and numbers.',
                    'max_length'    => 'IFSC Code cannot exceed 11 characters.',
                ],
            ],
            'remarks' => [
                'rules' => 'permit_empty|max_length[250]',
                'errors' => [
                    'max_length' => 'Remarks cannot exceed 250 characters.'
                ]
            ]

        ];






        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
                       'certification_standard'        => $this->request->getPost('Certification_Standard'),
            'plant_protection_products'     => $this->request->getPost('Plant_Protection_Products'),
            'fertilizers_micro_nutrients'   => $this->request->getPost('Fertilizers_Micronutrients'),
            'organic_inputs'                => $this->request->getPost('Organic_inputs'),
            'seeds_propagation_material'    => $this->request->getPost('Seeds_Propagation_Material'),
            'sampling_date'                 => $this->request->getPost('Sampling_Date'),
            'qty_collected'                 => $this->request->getPost('Qty_Collected'),
            'who_collected'                 => $this->request->getPost('Who_Collected'),
            'test_report_date'              => $this->request->getPost('Test_Report_Date'),
            'lab_name'                      => $this->request->getPost('Lab_Name'),
            'lab_type'                      => $this->request->getPost('Lab_Type'),
            'report_result'                 => $this->request->getPost('Report_Result'),

            'report_summary'                => $this->request->getPost('Report_Summary'),
            'bank_name'                     => $this->request->getPost('Bank_Name'),
            'bank_branch'                   => $this->request->getPost('Bank_Branch'),
            'bank_account_number'           => $this->request->getPost('Bank_Account_Number'),
            'bank_ifsc_code'                => $this->request->getPost('Bank_IFSC'),
            'remarks'                       => $this->request->getPost('Remarks'),


            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            



        ];


        


        $insertId = $this->request->getPost('updating_id');








        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/other_documents_and_reports/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['document'] = json_encode($documents);


        $model = new OtherDocsReportModel();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success





            //    var_dump($_POST['designation']);
            return redirect()->back()->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        // return redirect()->back()->with('success', 'packaging unit  updated successfully');
    }



    public function edit_document_report($id)
    {
        $OtherDocsReport = new OtherDocsReportModel();
        $OtherDocsReport = $OtherDocsReport->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Other_documents_reports/edit', [
            'OtherDocsReport' => $OtherDocsReport,
            'organization' => $organization
        ]);
    }


    public function view_document_report($id)
    {
        $OtherDocsReport = new OtherDocsReportModel();
        $OtherDocsReport = $OtherDocsReport->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Other_documents_reports/view', [
            'OtherDocsReport' => $OtherDocsReport,
            'organization' => $organization
        ]);
    }


    public function insert_document_and_report()
    {



        $rules = [

            'Certification_Standard' => [
                'rules' => 'required|in_list[IndGAP,Global GAP,Organic NPOP,Organic NOP]',
                'errors' => [
                    'required' => 'Certification Standard is required.',
                    'in_list' => 'Certification Standard must be one of: IndGAP, Global GAP, Organic NPOP, Organic NOP.'
                ]
            ],
            'Plant_Protection_Products' => [
                'rules'  => 'required|max_length[250]',
                'errors' => [
                    'required'   => 'Plant Protection Products is required.',
                    'max_length' => 'Plant Protection Products cannot exceed 250 characters.',
                ],
            ],
            'Fertilizers_Micronutrients' => [
                'rules'  => 'required|max_length[250]',
                'errors' => [
                    'required'   => 'Fertilizers/Micro Nutrients is required.',
                    'max_length' => 'Fertilizers/Micro Nutrients cannot exceed 250 characters.',
                ],
            ],
            'Organic_inputs' => [
                'rules'  => 'required|max_length[250]',
                'errors' => [
                    'required'   => 'Organic Inputs is required.',
                    'max_length' => 'Organic Inputs cannot exceed 250 characters.',
                ],
            ],
            'Seeds_Propagation_Material' => [
                'rules'  => 'required|max_length[250]',
                'errors' => [
                    'required'   => 'Seeds/Propagation Material is required.',
                    'max_length' => 'Seeds/Propagation Material cannot exceed 250 characters.',
                ],
            ],
            'Sampling_Date' => [
                'rules'  => 'required|valid_date',
                'errors' => [
                    'required'   => 'Sampling Date is required.',
                    'valid_date' => 'Sampling Date must be a valid date (YYYY-MM-DD).',
                ],
            ],
            'Qty_Collected' => [
                'rules'  => 'required|integer|max_length[5]',
                'errors' => [
                    'required'   => 'Qty Collected is required.',
                    'integer'    => 'Qty Collected must be a number.',
                    'max_length' => 'Qty Collected cannot exceed 5 digits.',
                ],
            ],
            'Who_Collected' => [
                'rules'  => 'required|max_length[50]',
                'errors' => [
                    'required'   => 'Who Collected is required.',
                    'max_length' => 'Who Collected cannot exceed 50 characters.',
                ],
            ],
            'Test_Report_Date' => [
                'rules'  => 'required|valid_date',
                'errors' => [
                    'required'   => 'Test Report Date is required.',
                    'valid_date' => 'Test Report Date must be a valid date (YYYY-MM-DD).',
                ],
            ],
            'Lab_Name' => [
                'rules'  => 'required|max_length[50]',
                'errors' => [
                    'required'   => 'Lab Name is required.',
                    'max_length' => 'Lab Name cannot exceed 50 characters.',
                ],
            ],
            'Lab_Type' => [
                'rules'  => 'required|in_list[Internal,External]',
                'errors' => [
                    'required' => 'Lab Type is required.',
                    'in_list'  => 'Lab Type must be either Internal or External.',
                ],
            ],
            'Report_Result' => [
                'rules'  => 'required|in_list[Positive,Negative]',
                'errors' => [
                    'required' => 'Report Result is required.',
                    'in_list'  => 'Report Result must be either Positive or Negative.',
                ],
            ],
            'Report_Summary' => [
                'rules'  => 'permit_empty|max_length[250]',
                'errors' => [
                    'required'   => 'Report Summary is required.',
                    'max_length' => 'Report Summary cannot exceed 250 characters.',
                ],
            ],
            'Bank_Name' => [
                'rules'  => 'required|max_length[50]',
                'errors' => [
                    'required'   => 'Bank Name is required.',
                    'max_length' => 'Bank Name cannot exceed 50 characters.',
                ],
            ],
            'Bank_Branch' => [
                'rules'  => 'required|max_length[100]',
                'errors' => [
                    'required'   => 'Bank Branch is required.',
                    'max_length' => 'Bank Branch cannot exceed 100 characters.',
                ],
            ],
            'Bank_Account_Number' => [
                'rules'  => 'required|max_length[20]',
                'errors' => [
                    'required'   => 'Bank Account Number is required.',
                    'max_length' => 'Bank Account Number cannot exceed 20 characters.',
                ],
            ],
            'Bank_IFSC' => [
                'rules'  => 'required|alpha_numeric|max_length[11]',
                'errors' => [
                    'required'      => 'IFSC Code is required.',
                    'alpha_numeric' => 'IFSC Code must contain only letters and numbers.',
                    'max_length'    => 'IFSC Code cannot exceed 11 characters.',
                ],
            ],
            'remarks' => [
                'rules' => 'permit_empty|max_length[250]',
                'errors' => [
                    'max_length' => 'Remarks cannot exceed 250 characters.'
                ]
            ]

        ];



        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [

            'certification_standard'        => $this->request->getPost('Certification_Standard'),
            'plant_protection_products'     => $this->request->getPost('Plant_Protection_Products'),
            'fertilizers_micro_nutrients'   => $this->request->getPost('Fertilizers_Micronutrients'),
            'organic_inputs'                => $this->request->getPost('Organic_inputs'),
            'seeds_propagation_material'    => $this->request->getPost('Seeds_Propagation_Material'),
            'sampling_date'                 => $this->request->getPost('Sampling_Date'),
            'qty_collected'                 => $this->request->getPost('Qty_Collected'),
            'who_collected'                 => $this->request->getPost('Who_Collected'),
            'test_report_date'              => $this->request->getPost('Test_Report_Date'),
            'lab_name'                      => $this->request->getPost('Lab_Name'),
            'lab_type'                      => $this->request->getPost('Lab_Type'),
            'report_result'                 => $this->request->getPost('Report_Result'),

            'report_summary'                => $this->request->getPost('Report_Summary'),
            'bank_name'                     => $this->request->getPost('Bank_Name'),
            'bank_branch'                   => $this->request->getPost('Bank_Branch'),
            'bank_account_number'           => $this->request->getPost('Bank_Account_Number'),
            'bank_ifsc_code'                => $this->request->getPost('Bank_IFSC'),
            'remarks'                       => $this->request->getPost('remarks'),

            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,



        ];





        $model = new OtherDocsReportModel;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();











        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/other_documents_and_reports/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/other_documents_and_reports/{$insertId}/documants";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'document' => json_encode($documents)
        ]);



        return redirect()->back()->with('success', 'Report added successfully!');
    }










    public function add_documants_and_reports()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Other_documents_reports/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Other_documents_reports/index', ['organization' => $organization]);
    }
}
