<?php

namespace App\Controllers\Product_sampling;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Product_sampling_model;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Product_sampling extends BaseController
{


    public function delete_product_sampling($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $Product_sampling = new Product_sampling_model();

        // Check if record exists
        $existing = $Product_sampling->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $Product_sampling->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        return redirect()->back()->with('success', 'Product sampling deleted successfully.');
    }


    public function update_product_sampling()
    {

        $rules = [
            'Sampling_Date' => [
                'label' => 'Sampling Date',
                'rules' => 'required|valid_date[Y-m-d\TH:i]',
                'errors' => [
                    'required' => 'Sampling Date is required.',
                    'valid_date' => 'Sampling Date must be in YYYY-MM-DD format.'
                ]
            ],
            'Department' => [
                'label' => 'Department',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Department is required.'
                ]
            ],
            'Qty_Collected' => [
                'label' => 'Quantity Collected',
                'rules' => 'required|integer|greater_than_equal_to[1]',
                'errors' => [
                    'required' => 'Quantity Collected is required.',
                    'integer' => 'Quantity Collected must be an integer.',
                    'greater_than_equal_to' => 'Quantity Collected must be at least 1.'
                ]
            ],
            'Who_Collected' => [
                'label' => 'Who Collected',
                'rules' => 'required|max_length[100]',
                'errors' => [
                    'required' => 'Who Collected is required.',
                    'max_length' => 'Who Collected cannot exceed 100 characters.'
                ]
            ],
            'Test_Report_Date' => [
                'label' => 'Test Report Date',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Test Report Date is required.',
                    'valid_date' => 'Test Report Date must be in YYYY-MM-DD format.'
                ]
            ],
            'Lab_Name' => [
                'label' => 'Lab Name',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'Lab Name is required.',
                    'max_length' => 'Lab Name cannot exceed 50 characters.'
                ]
            ],
            'Lab_Type' => [
                'label' => 'Lab Type',
                'rules' => 'required|in_list[Internal,External]',
                'errors' => [
                    'required' => 'Lab Type is required.',
                    'in_list' => 'Lab Type must be either Internal or External.'
                ]
            ],
            'Test_Outcome' => [
                'label' => 'Test Outcome',
                'rules' => 'required|in_list[Positive,Negative]',
                'errors' => [
                    'required' => 'Test Outcome is required.',
                    'in_list' => 'Test Outcome must be either Positive or Negative.'
                ]
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'permit_empty|regex_match[/^[a-zA-Z0-9\s\.\,\-\(\)]+$/]|max_length[250]',
                'errors' => [
                    'regex_match' => 'Remark can only contain alphabets, numbers, spaces, dots, commas, dashes, and brackets.',
                    'max_length' => 'Remark cannot exceed 250 characters.'
                ]
            ],

            'Sampling_Description' => [
                'label' => 'Sampling Description',
                'rules' => 'permit_empty|regex_match[/^[a-zA-Z0-9\s\.\,\-\(\)]+$/]|max_length[250]',
                'errors' => [
                    'regex_match' => 'Sampling Description can only contain alphabets, numbers, spaces, dots, commas, dashes, and brackets.',
                    'max_length' => 'Sampling Description cannot exceed 250 characters.'
                ]
            ],
            'submission_date_time' => [
                'label' => 'Submission to the Lab Date and Time',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Submission to the Lab Date and Time is required.',
                    'valid_date' => 'Submission to the Lab Date and Time must be in YYYY-MM-DD format.'
                ]
            ],

            'Category' => [
                'label' => 'Category',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Category required.',

                ]
            ],

        ];






     $data_1 = [];

        $location = $this->request->getPost('location');
        $others = $this->request->getPost('others');
        $selected_location_id = $this->request->getPost('selected_location_id');

        if ($location === 'Others') {
            $rules['others'] = [
                'label' => 'Other Location Name',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 50 characters.'
                ]
            ];


            if (!empty($_POST['others'])) {
                $data_1['Others'] = $_POST['others'];
            }
        }


        if ($location == 'Corporate_Office') {


            $data_1['Corporate_Office'] = null;
        }

        if ($location !== 'Corporate_Office' && $location !== 'Others') {
            $rules['selected_location_id'] = [
                'label' => 'Selected Location',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',

                ]
            ];

            if (!empty($_POST['selected_location_id'])) {
                $data_1[$location] = $_POST['selected_location_id'];
            }
        }

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'sampling_date' => $this->request->getPost('Sampling_Date'),

            'department_id' => $this->request->getPost('Department'),
            'qty_collected' => $this->request->getPost('Qty_Collected'),
            'who_collected' => $this->request->getPost('Who_Collected'),
            'test_report_date' => $this->request->getPost('Test_Report_Date'),
            'lab_name' => $this->request->getPost('Lab_Name'),
            'lab_type' => $this->request->getPost('Lab_Type'),
            'report_result' => $this->request->getPost('Test_Outcome'),
            'sampling_description' => $this->request->getPost('Sampling_Description'),
            'submission_to_the_Lab_date_time' => $this->request->getPost('submission_date_time'),
            'Category' => $this->request->getPost('Category'),







            'remark' => $this->request->getPost('Remark'),


            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'sampling_for' => json_encode($data_1), // Empty for now,


        ];


        
        $insertId = $this->request->getPost('updating_id');

         
        $session_id = session()->get('entity_id');
     

        





        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/Product_sampling/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['documents'] = json_encode($documents);


        $model = new Product_sampling_model();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success

            



            
            return redirect()->back()->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        // return redirect()->back()->with('success', 'packaging unit  updated successfully');
    }



    public function edit_product_sampling($id)
    {
        $Product_sampling = new Product_sampling_model();
        $Product_sampling = $Product_sampling->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Product_sampling/edit', [
            'Product_sampling' => $Product_sampling,
            'organization' => $organization
        ]);
    }


    public function view_product_sampling($id)
    {
        $Product_sampling = new Product_sampling_model();
        $Product_sampling = $Product_sampling->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Product_sampling/view', [
            'Product_sampling' => $Product_sampling,
            'organization' => $organization
        ]);
    }


    public function insert_product_Sampling()
    {



        $rules = [
            'Sampling_Date' => [
                'label' => 'Sampling Date',
                'rules' => 'required|valid_date[Y-m-d\TH:i]',
                'errors' => [
                    'required' => 'Sampling Date is required.',
                    'valid_date' => 'Sampling Date must be in YYYY-MM-DD format.'
                ]
            ],
            'Department' => [
                'label' => 'Department',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Department is required.'
                ]
            ],
            'Qty_Collected' => [
                'label' => 'Quantity Collected',
                'rules' => 'required|integer|greater_than_equal_to[1]',
                'errors' => [
                    'required' => 'Quantity Collected is required.',
                    'integer' => 'Quantity Collected must be an integer.',
                    'greater_than_equal_to' => 'Quantity Collected must be at least 1.'
                ]
            ],
            'Who_Collected' => [
                'label' => 'Who Collected',
                'rules' => 'required|max_length[100]',
                'errors' => [
                    'required' => 'Who Collected is required.',
                    'max_length' => 'Who Collected cannot exceed 100 characters.'
                ]
            ],
            'Test_Report_Date' => [
                'label' => 'Test Report Date',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Test Report Date is required.',
                    'valid_date' => 'Test Report Date must be in YYYY-MM-DD format.'
                ]
            ],
            'Lab_Name' => [
                'label' => 'Lab Name',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'Lab Name is required.',
                    'max_length' => 'Lab Name cannot exceed 50 characters.'
                ]
            ],
            'Lab_Type' => [
                'label' => 'Lab Type',
                'rules' => 'required|in_list[Internal,External]',
                'errors' => [
                    'required' => 'Lab Type is required.',
                    'in_list' => 'Lab Type must be either Internal or External.'
                ]
            ],
            'Test_Outcome' => [
                'label' => 'Test Outcome',
                'rules' => 'required|in_list[Positive,Negative]',
                'errors' => [
                    'required' => 'Test Outcome is required.',
                    'in_list' => 'Test Outcome must be either Positive or Negative.'
                ]
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'permit_empty|regex_match[/^[a-zA-Z0-9\s\.\,\-\(\)]+$/]|max_length[250]',
                'errors' => [
                    'regex_match' => 'Remark can only contain alphabets, numbers, spaces, dots, commas, dashes, and brackets.',
                    'max_length' => 'Remark cannot exceed 250 characters.'
                ]
            ],

            'Sampling_Description' => [
                'label' => 'Sampling Description',
                'rules' => 'permit_empty|regex_match[/^[a-zA-Z0-9\s\.\,\-\(\)]+$/]|max_length[250]',
                'errors' => [
                    'regex_match' => 'Remark can only contain alphabets, numbers, spaces, dots, commas, dashes, and brackets.',
                    'max_length' => 'Remark cannot exceed 250 characters.'
                ]
            ],
            'submission_date_time' => [
                'label' => 'Submission to the Lab Date and Time',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Submission to the Lab Date and Time is required.',
                    'valid_date' => 'Submission to the Lab Date and Time must be in YYYY-MM-DD format.'
                ]
            ],

            'Category' => [
                'label' => 'Category',
                'rules' => 'required',
                'errors' => [
                    'required' => 'Category required.',

                ]
            ],

        ];

      $data_1 = [];

        $location = $this->request->getPost('location');
        $others = $this->request->getPost('others');
        $selected_location_id = $this->request->getPost('selected_location_id');

        if ($location === 'Others') {
            $rules['others'] = [
                'label' => 'Other Location Name',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 50 characters.'
                ]
            ];


            if (!empty($_POST['others'])) { 
                $data_1['Others'] = $_POST['others'];
            }
        }


        if ($location == 'Corporate_Office') {


            $data_1['Corporate_Office'] = null;
        }

        if ($location !== 'Corporate_Office' && $location !== 'Others') {
            $rules['selected_location_id'] = [
                'label' => 'Selected Location',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',

                ]
            ];

            if (!empty($_POST['selected_location_id'])) {
                $data_1[$location] = $_POST['selected_location_id'];
            }
        }

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());

            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            'sampling_date' => $this->request->getPost('Sampling_Date'),

            'department_id' => $this->request->getPost('Department'),
            'qty_collected' => $this->request->getPost('Qty_Collected'),
            'who_collected' => $this->request->getPost('Who_Collected'),
            'test_report_date' => $this->request->getPost('Test_Report_Date'),
            'lab_name' => $this->request->getPost('Lab_Name'),
            'lab_type' => $this->request->getPost('Lab_Type'),
            'report_result' => $this->request->getPost('Test_Outcome'),
            'sampling_description' => $this->request->getPost('Sampling_Description'),
            'submission_to_the_Lab_date_time' => $this->request->getPost('submission_date_time'),
            'Category' => $this->request->getPost('Category'),







            'remark' => $this->request->getPost('Remark'),

            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'sampling_for' => json_encode($data_1), // Empty for now,


        ];






        $model = new Product_sampling_model;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();






        $session_id = session()->get('entity_id');





        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/Product_sampling/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/Product_sampling/{$insertId}/documants";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'documents' => json_encode($documents)
        ]);



        return redirect()->back()->with('success', 'product sampling  added successfully!');
    }










    public function add_product_sampling()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Product_sampling/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Product_sampling/index', ['organization' => $organization]);
    }
}
