<?php

namespace App\Controllers\Soil_management;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Soil_managment;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Soil_management extends BaseController
{


    public function delete_soil_type($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $Soil_managment = new Soil_managment();

        // Check if record exists
        $existing = $Soil_managment->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $Soil_managment->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        return redirect()->back()->with('success', 'data deleted successfully.');
    }


    public function update_soil_type()
    {

        $rules = [
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Farm' => [
                'label'  => 'Farm',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            
            
            'soil_type' => [
                'label'  => 'soil type',
                'rules'  => 'required|in_list[Loamy,Chalky,Peaty,Silty,Sandy,Clay]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be one of: Loamy,Chalky,Peaty,Silty,Sandy,Clay.',
                ],
            ],
             
             'Soil_Conservation_Practices' => [
                'label'  => 'Soil Conservation Practices',
                'rules'  => 'required|string|max_length[250]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'Soil_Contamination_Control' => [
                'label'  => 'Soil Contamination Control',
                'rules'  => 'required|string|max_length[250]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],'Soil_Erosion_Prevention' => [
                'label'  => 'Soil Erosion Prevention',
                'rules'  => 'required|string|max_length[250]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ], 
            'Remark' => [
                'label'  => 'Remark',
                'rules'  => 'permit_empty|string|max_length[250]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
        ];





         
        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());
            // die();
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'farmer_id' => $this->request->getPost('farmer'),
            'farm_id' => $this->request->getPost('Farm'),
            'soil_type' => $this->request->getPost('soil_type'),
            'soil_conservation_practices' => $this->request->getPost('Soil_Conservation_Practices'),
            'soil_contamination_control' => $this->request->getPost('Soil_Contamination_Control'),
            'soil_erosion_prevention' => $this->request->getPost('Soil_Erosion_Prevention'),



             
            'remark' => $this->request->getPost('Remark'),


            'updated_by' => session()->get('logined_user_id'), // Empty for now,
             
          


        ];


       



        

      
        $insertId = $this->request->getPost('updating_id');

    
 





        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/soil_management/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['document'] = json_encode($documents);


        $model = new Soil_managment();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success

             



            //    var_dump($_POST['designation']);
            return redirect()->back()->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        // return redirect()->back()->with('success', 'packaging unit  updated successfully');
    }



    public function edit_soil_type($id)
    {
        $Soil_managment = new Soil_managment();
        $Soil_managment = $Soil_managment->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/soil_management/edit', [
            'Soil_managment' => $Soil_managment,
            'organization' => $organization
        ]);
    }


    public function view_soil_management($id)
    {
        $Soil_managment = new Soil_managment();
        $Soil_managment = $Soil_managment->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/soil_management/view', [
            'Soil_managment' => $Soil_managment,
            'organization' => $organization
        ]);
    }


    public function inser_soil()
    {



        $rules = [
            'farmer' => [
                'label'  => 'farmer',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            'Farm' => [
                'label'  => 'Farm',
                'rules'  => 'required|integer',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'integer'  => 'The {field} must be a valid ID.',
                ],
            ],
            
            
            'soil_type' => [
                'label'  => 'soil type',
                'rules'  => 'required|in_list[Loamy,Chalky,Peaty,Silty,Sandy,Clay]',
                'errors' => [
                    'required' => 'Please select a {field}.',
                    'in_list'  => 'The {field} must be one of: Loamy,Chalky,Peaty,Silty,Sandy,Clay.',
                ],
            ],
             
             'Soil_Conservation_Practices' => [
                'label'  => 'Soil Conservation Practices',
                'rules'  => 'required|string|max_length[250]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],
            'Soil_Contamination_Control' => [
                'label'  => 'Soil Contamination Control',
                'rules'  => 'required|string|max_length[250]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ],'Soil_Erosion_Prevention' => [
                'label'  => 'Soil Erosion Prevention',
                'rules'  => 'required|string|max_length[250]',
                'errors' => [
                    'required'   => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot exceed 50 characters.',
                ],
            ], 
            'Remark' => [
                'label'  => 'Remark',
                'rules'  => 'permit_empty|string|max_length[250]',
                'errors' => [
                    'max_length' => 'The {field} cannot exceed 250 characters.',
                ],
            ],
        ];
        

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            
            'farmer_id' => $this->request->getPost('farmer'),
            'farm_id' => $this->request->getPost('Farm'),
            'soil_type' => $this->request->getPost('soil_type'),
            'soil_conservation_practices' => $this->request->getPost('Soil_Conservation_Practices'),
            'soil_contamination_control' => $this->request->getPost('Soil_Contamination_Control'),
            'soil_erosion_prevention' => $this->request->getPost('Soil_Erosion_Prevention'),



             
            'remark' => $this->request->getPost('Remark'),

            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
           


        ];



         

        $model = new Soil_managment;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();





 





        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/soil_management/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/soil_management/{$insertId}/documants";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'document' => json_encode($documents)
        ]);



        return redirect()->back()->with('success', 'soil type  added successfully!');
    }










    public function add_new_soil_management()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/soil_management/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/soil_management/index', ['organization' => $organization]);
    }
}
