<?php

namespace App\Controllers\Standerd_cirtificate;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\Standerd_certificates_model;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Standerd_cirtificate extends BaseController
{


    public function delete_standed_cirtificate($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $standered_cirtificate = new Standerd_certificates_model();

        // Check if record exists
        $existing = $standered_cirtificate->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $standered_cirtificate->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        return redirect()->back()->with('success', 'Standerd cirtificate  deleted successfully.');
    }


    public function update_Standed_cirtificate()
    {

      
       
        $rules = [
            'audit_categoery' => [
        'label' => 'Audit Category',
        'rules' => 'required|in_list[Initial,Surveillance,Renewal]',
    ],
    'Certification_Body_Name' => [
        'label' => 'Certification Body Name',
        'rules' => 'required|string|max_length[255]',
    ],
    'Certificate_Name' => [
        'label' => 'Certificate Name',
        'rules' => 'required|string|max_length[100]',
    ],
    'Certificate_Issue_Date' => [
        'label' => 'Certificate Issue Date',
        'rules' => 'required|valid_date[Y-m-d]',
    ],
    'Certificate_Expiry_Date' => [
        'label' => 'Certificate Expiry Date',
        'rules' => 'required|valid_date[Y-m-d]',
    ],
    'Certificate_Renewal_Date' => [
        'label' => 'Certificate Renewal Date',
        'rules' => 'required|valid_date[Y-m-d]',
    ],
    'Remark' => [
        'label' => 'Remark',
        'rules' => 'permit_empty|max_length[250]',
    ],
    'year' => [
        'label' => 'year',
        'rules' => 'required|string',
    ],
        ];








 



        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            var_dump($this->validator->listErrors());
          
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'certificate_name' => $this->request->getPost('Certificate_Name'),
            'certificate_issue_date' => $this->request->getPost('Certificate_Issue_Date'),
            'certificate_expiry_date' => $this->request->getPost('Certificate_Expiry_Date'),
            'certificate_renewal_date' => $this->request->getPost('Certificate_Renewal_Date'),
            'certificate_body_name' => $this->request->getPost('Certification_Body_Name'),
            'certificate_category' => $this->request->getPost('audit_categoery'),
            'year' => $this->request->getPost('year'),
            'remark' => $this->request->getPost('Remark'),

            
           
            


            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            


        ];


 

        
        $insertId = $this->request->getPost('updating_id');

         
        $session_id = session()->get('entity_id');
     

        
       





        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/standerd_cirtificate/{$insertId}/documants/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['certificate_upload'] = json_encode($documents);


        $model = new Standerd_certificates_model();



        // $model->update($insertId,$data);


        $success = $model->update($insertId, $data);

        if ($success) {
            // Success

            



            
            return redirect()->back()->with('success', 'Data updated successfully.');
        } else {
            // Failure - log or show error
            $error = $model->errors(); // Get validation or DB errors (if any)
            log_message('error', 'Update failed: ' . json_encode($error));
            return redirect()->back()->with('error', 'Failed to update data. Please try again.');
        }


        // return redirect()->back()->with('success', 'packaging unit  updated successfully');
    }



    public function edit_standerd_cirtificate($id)
    {
        $standerd_cirtificate = new Standerd_certificates_model();
        $standerd_cirtificate = $standerd_cirtificate->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Standerd_cirtificate/edit', [
            'standerd_cirtificate' => $standerd_cirtificate,
            'organization' => $organization
        ]);
    }


    public function view_standerd_cirtificate($id)
    {
        $standerd_cirtificate = new Standerd_certificates_model();
        $standerd_cirtificate = $standerd_cirtificate->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/Standerd_cirtificate/view', [
            'standerd_cirtificate' => $standerd_cirtificate,
            'organization' => $organization
        ]);
    }


    public function insert_standerd_cirtificate()
    {



        
        $rules = [
            'audit_categoery' => [
        'label' => 'Audit Category',
        'rules' => 'required|in_list[Initial,Surveillance,Renewal]',
    ],
    'Certification_Body_Name' => [
        'label' => 'Certification Body Name',
        'rules' => 'required|string|max_length[255]',
    ],
    'Certificate_Name' => [
        'label' => 'Certificate Name',
        'rules' => 'required|string|max_length[100]',
    ],
    'Certificate_Issue_Date' => [
        'label' => 'Certificate Issue Date',
        'rules' => 'required|valid_date[Y-m-d]',
    ],
    'Certificate_Expiry_Date' => [
        'label' => 'Certificate Expiry Date',
        'rules' => 'required|valid_date[Y-m-d]',
    ],
    'Certificate_Renewal_Date' => [
        'label' => 'Certificate Renewal Date',
        'rules' => 'required|valid_date[Y-m-d]',
    ],
    'Remark' => [
        'label' => 'Remark',
        'rules' => 'permit_empty|max_length[250]',
    ],
    'year' => [
        'label' => 'year',
        'rules' => 'required|string',
    ],
        ];





        

        if (!$this->validate($rules)) {


          
            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());

         
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }


        




        $data = [
            'certificate_name' => $this->request->getPost('Certificate_Name'),
            'certificate_issue_date' => $this->request->getPost('Certificate_Issue_Date'),
            'certificate_expiry_date' => $this->request->getPost('Certificate_Expiry_Date'),
            'certificate_renewal_date' => $this->request->getPost('Certificate_Renewal_Date'),
            'certificate_body_name' => $this->request->getPost('Certification_Body_Name'),
            'certificate_category' => $this->request->getPost('audit_categoery'),
            'year' => $this->request->getPost('year'),
            'remark' => $this->request->getPost('Remark'),

            


            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
 

        ];



       

        

     


        $model = new Standerd_certificates_model;
        // // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();

       
    




       





        




 

 




        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/standerd_cirtificate/{$insertId}/documants";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/standerd_cirtificate/{$insertId}/documants";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'certificate_upload' => json_encode($documents)
        ]);



















        return redirect()->back()->with('success', 'standerd cirtificate   added successfully!');
    }










    public function add_new_standerd_cirtificate()
    { 

        $session = session(); 
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/Standerd_cirtificate/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session(); 
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id); 
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/Standerd_cirtificate/index', ['organization' => $organization]);
    }
}
 