<?php

namespace App\Controllers\Storage;

use App\Controllers\BaseController;

use App\Models\Loginmodel;
use App\Models\OrgStorageDetailsModel;
use CodeIgniter\Database\Exceptions\DataException;
use CodeIgniter\I18n\Time;

class Storage extends BaseController
{


    public function delete_storage($id)
    {
        // Optional: Echo or log the ID if needed
        // echo $id;

        $storage = new OrgStorageDetailsModel();

        // Check if record exists
        $existing = $storage->find($id);

        if (!$existing) {
            return redirect()->back()->with('error', 'Contact person not found.');
        }

        // Update the status field to 0 (soft delete)
        $storage->update($id, [
            'status'      => 0,
            'updated_at'  => Time::now('Asia/Kolkata', 'Y-m-d H:i:s'),
            'updated_by'  => session()->get('logined_user_id'),
        ]);

        // Optionally, add a success message
        return redirect()->back()->with('success', 'storage   deleted successfully.');
    }


    public function update_storage()
    {




        $rules = [
            'Name' => [
                'label' => 'storage Name',
                'rules' => 'required|max_length[30]',
                'errors' => [
                    'required' => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot be longer than 30 characters.',
                ]
            ],
            'facility_id' => [
                'label' => 'facility ID',
                'rules' => 'required|max_length[100]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} cannot be longer than 8 characters.',
                ]
            ],
            'loc_lat' => [
                'label' => 'Latitude',
                'rules' => 'required|decimal',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'decimal' => 'The {field} must be a decimal value.',
                ]
            ],
            'loc_log' => [
                'label' => 'Longitude',
                'rules' => 'required|decimal',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'decimal' => 'The {field} must be a decimal value.',
                ]
            ],
            'adresss_1' => [
                'label' => 'Address Line 1',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} cannot be longer than 50 characters.',
                ]
            ],
            'adresss_2' => [
                'label' => 'Address Line 2',
                'rules' => 'permit_empty|max_length[50]',
                'errors' => [
                    'max_length' => 'The {field} cannot be longer than 50 characters.',
                ]
            ],
            'Village' => [
                'label' => 'Village',
                'rules' => 'permit_empty|max_length[30]',
                'errors' => [
                    'max_length' => 'The {field} cannot be longer than 30 characters.',
                ]
            ],
            'country' => [
                'label' => 'Country',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'state' => [
                'label' => 'State',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'city' => [
                'label' => 'City',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'pin_code' => [
                'label' => 'Pin Code',
                'rules' => 'required|numeric|max_length[6]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'numeric' => 'The {field} must be numeric.',
                    'max_length' => 'The {field} cannot be longer than 6 digits.',
                ]
            ],
            'Ownership' => [
                'label' => 'Ownership',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'type_of_Structure' => [
                'label' => 'Type of Structure',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'Area' => [
                'label' => 'Area',
                'rules' => 'required|decimal',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'decimal' => 'The {field} must be a decimal value.',
                ]
            ],
            'Responsible_Person_Name' => [
                'label' => 'Responsible Person Name',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} cannot be longer than 50 characters.',
                ]
            ],
            'Responsible_Person_Designation' => [
                'label' => 'Responsible Person Designation',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} cannot be longer than 50 characters.',
                ]
            ],
            'Responsible_Person_Number' => [
                'label' => 'Responsible Person Number',
                'rules' => 'required|numeric|max_length[10]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'numeric' => 'The {field} must be numeric.',
                    'max_length' => 'The {field} cannot be longer than 10 digits.',
                ]
            ],
            'Commodities_Stored' => [
                'label' => 'Commodities Stored',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'permit_empty|max_length[250]',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'location' => [
                'label' => 'Location',
                'rules' => 'required|string',
                'errors' => [
                    'required' => 'The {field} field is required.',
                ]
            ],
            'number_of_years_leasehold' => [
                'label' => 'Number of Years Leasehold',
                'rules' => 'permit_empty|integer',
                'errors' => [
                    'integer' => 'The {field} must be a valid number.',
                ]
            ],

        ];



        $data_1 = [];

        $location = $this->request->getPost('location');
        $others = $this->request->getPost('others');
        $selected_location_id = $this->request->getPost('selected_location_id');

        if ($location === 'Others') {
            $rules['others'] = [
                'label' => 'Other Location Name',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 50 characters.'
                ]
            ];


            if (!empty($_POST['others'])) {
                $data_1['Others'] = $_POST['others'];
            }
        }


        if ($location == 'Corporate_Office') {


            $data_1['Corporate_Office'] = null;
        }

        if ($location !== 'Corporate_Office' && $location !== 'Others') {
            $rules['selected_location_id'] = [
                'label' => 'Selected Location',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',

                ]
            ];

            if (!empty($_POST['selected_location_id'])) {
                $data_1[$location] = $_POST['selected_location_id'];
            }
        }

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            // var_dump($this->validator->listErrors());
            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }





        $data = [
            'name' => $this->request->getPost('Name'),
            'facility_id' => $this->request->getPost('facility_id'),
            'location_lat' => $this->request->getPost('loc_lat'),
            'location_long' => $this->request->getPost('loc_log'),
            'strg_address1' => $this->request->getPost('adresss_1'),
            'strg_address2' => $this->request->getPost('adresss_2'),
            'strg_village' => $this->request->getPost('Village'),
            'strg_country' => $this->request->getPost('country'),
            'strg_state' => $this->request->getPost('state'),
            'strg_city' => $this->request->getPost('city'),
            'strg_pin_code' => $this->request->getPost('pin_code'),
            'ownership' => $this->request->getPost('Ownership'),
            'number_of_years_leasehold' => $this->request->getPost('number_of_years_leasehold'),
            'type_of_structure' => $this->request->getPost('type_of_Structure'),
            'area_sq_meters' => $this->request->getPost('Area'),
            'Responsible_Person_Name' => $this->request->getPost('Responsible_Person_Name'),
            'Designation' => $this->request->getPost('Responsible_Person_Designation'),
            'Contact_Number' => $this->request->getPost('Responsible_Person_Number'),
            'commodities_stored' => $this->request->getPost('Commodities_Stored'),
            'remark' => $this->request->getPost('Remark'),

            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'location' => json_encode($data_1), // Empty for now,


        ];


        $remaining_images = json_decode($this->request->getPost('remaining_images'), true);

        $mergedArray = $remaining_images;
        $insertId = $this->request->getPost('updating_id');

        $photos = $this->request->getFileMultiple('Photos');


        $session_id = session()->get('entity_id');
        if ($photos && count($photos) > 0) {
            $photoPaths = [];
            $errors = [];

            foreach ($photos as $index => $photo) {
                // Validate file
                if (!$photo->isValid() || $photo->hasMoved()) {
                    $errors[] = "File {$photo->getName()} is not valid or already moved.";
                    continue;
                }

                // Validate file type
                $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp', 'image/bmp', 'image/tiff']; // Added image/jpg as well
                if (!in_array($photo->getMimeType(), $allowedTypes)) {
                    $errors[] = "File {$photo->getName()} must be a JPEG or PNG image.";
                    continue;
                }

                // Validate file size (e.g., max 2MB)
                $maxSize = 5 * 1024 * 1024; // 2MB in bytes
                if ($photo->getSize() > $maxSize) {
                    $errors[] = "File {$photo->getName()} exceeds the maximum size of 2MB.";
                    continue;
                }




                // Passed all validations — save file
                $photoName = $photo->getRandomName();
                $photoDir = "uploads/entity_profile/{$session_id}/storage_unites/{$insertId}/photos/";
                $photoPath = FCPATH . $photoDir;

                if (!is_dir($photoPath)) {
                    mkdir($photoPath, 0777, true);
                }

                $photo->move($photoPath, $photoName);
                $relativePath = $photoDir . '/' . $photoName;
                $photoPaths[] = $relativePath;
            }

            // Save valid paths if any
            if (!empty($photoPaths)) {

                $mergedArray = array_merge($photoPaths, $remaining_images);


                $folderPath = FCPATH .  "uploads/entity_profile/{$session_id}/storage_unites/{$insertId}/photos/";
                $keepFilenames = array_map('basename', $mergedArray);

                // Scan folder
                $filesInFolder = scandir($folderPath);

                foreach ($filesInFolder as $file) {
                    if ($file === '.' || $file === '..') continue;

                    // If the file is NOT in the keep list, delete it
                    if (!in_array($file, $keepFilenames)) {
                        $filePath = $folderPath . DIRECTORY_SEPARATOR . $file;
                        if (is_file($filePath)) {
                            unlink($filePath);
                        }
                    }
                }
            }

            // Handle errors (e.g., flash message or log)
            if (!empty($errors)) {

                // Example: pass to view or flashdata
                var_dump($errors);
                var_dump($_FILES['Photos']);


                session()->set('validation_errors', $this->validator->listErrors());
                session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds
            }
        }

        $data['photo'] = json_encode($mergedArray);





        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $existingFiles = $this->request->getPost('existing_file');
        $files = $this->request->getFiles();

        $documents = [];
        $entityId = session()->get('entity_id');
        $uploadFolder = "uploads/entity_profile/{$entityId}/storage_unites/{$insertId}/Document/";
        $uploadPath = FCPATH . $uploadFolder;


        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }
        foreach ($docNames as $i => $docName) {
            $newFilePath = $existingFiles[$i] ?? ''; // Default to existing

            if (isset($files['doc_file'][$i]) && $files['doc_file'][$i]->isValid()) {
                // Delete old file
                if (!empty($existingFiles[$i]) && file_exists(FCPATH . $existingFiles[$i])) {
                    unlink(FCPATH . $existingFiles[$i]);
                }

                $file = $files['doc_file'][$i];
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName); // Move to new path
                $newFilePath = $uploadFolder . $newName; // Save relative path
            }

            $documents[] = [
                'name' => $docName,
                'date' => $docDates[$i],
                'file' => $newFilePath
            ];
        }

        $data['Document'] = json_encode($documents);
















        $model = new OrgStorageDetailsModel();



        $model->update($insertId, $data);




        return redirect()->back()->with('success', 'storage  updated successfully');
    }



    public function edit_storage($id)
    {
        $storage = new OrgStorageDetailsModel();
        $storage = $storage->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/storage/edit', [
            'storage' => $storage,
            'organization' => $organization
        ]);
    }


    public function view_storage_details($id)
    {
        $storage = new OrgStorageDetailsModel();
        $storage = $storage->find($id);

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();
        $organization = $loginModel->find($id);

        // Pass both variables in a single associative array to the view
        return view('' . $session->get('acessing_folder') . '/storage/view', [
            'storage' => $storage,
            'organization' => $organization
        ]);
    }


    public function insert_storage()
    {



        $rules = [
            'Name' => [
                'label' => 'storage Name',
                'rules' => 'required|max_length[30]',
                'errors' => [
                    'required' => 'The {field} field is required.',
                    'max_length' => 'The {field} cannot be longer than 30 characters.',
                ]
            ],
            'facility_id' => [
                'label' => 'facility ID',
                'rules' => 'required|max_length[100]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} cannot be longer than 8 characters.',
                ]
            ],
            'loc_lat' => [
                'label' => 'Latitude',
                'rules' => 'required|decimal',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'decimal' => 'The {field} must be a decimal value.',
                ]
            ],
            'loc_log' => [
                'label' => 'Longitude',
                'rules' => 'required|decimal',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'decimal' => 'The {field} must be a decimal value.',
                ]
            ],
            'adresss_1' => [
                'label' => 'Address Line 1',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} cannot be longer than 50 characters.',
                ]
            ],
            'adresss_2' => [
                'label' => 'Address Line 2',
                'rules' => 'permit_empty|max_length[50]',
                'errors' => [
                    'max_length' => 'The {field} cannot be longer than 50 characters.',
                ]
            ],
            'Village' => [
                'label' => 'Village',
                'rules' => 'permit_empty|max_length[30]',
                'errors' => [
                    'max_length' => 'The {field} cannot be longer than 30 characters.',
                ]
            ],
            'country' => [
                'label' => 'Country',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'state' => [
                'label' => 'State',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'city' => [
                'label' => 'City',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'pin_code' => [
                'label' => 'Pin Code',
                'rules' => 'required|numeric|max_length[6]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'numeric' => 'The {field} must be numeric.',
                    'max_length' => 'The {field} cannot be longer than 6 digits.',
                ]
            ],
            'Ownership' => [
                'label' => 'Ownership',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'type_of_Structure' => [
                'label' => 'Type of Structure',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'Area' => [
                'label' => 'Area',
                'rules' => 'required|decimal',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'decimal' => 'The {field} must be a decimal value.',
                ]
            ],
            'Responsible_Person_Name' => [
                'label' => 'Responsible Person Name',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} cannot be longer than 50 characters.',
                ]
            ],
            'Responsible_Person_Designation' => [
                'label' => 'Responsible Person Designation',
                'rules' => 'required|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'max_length' => 'The {field} cannot be longer than 50 characters.',
                ]
            ],
            'Responsible_Person_Number' => [
                'label' => 'Responsible Person Number',
                'rules' => 'required|numeric|max_length[10]',
                'errors' => [
                    'required' => 'The {field} is required.',
                    'numeric' => 'The {field} must be numeric.',
                    'max_length' => 'The {field} cannot be longer than 10 digits.',
                ]
            ],
            'Commodities_Stored' => [
                'label' => 'Commodities Stored',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'Remark' => [
                'label' => 'Remark',
                'rules' => 'permit_empty|max_length[250]',
                'errors' => [
                    'required' => 'The {field} is required.',
                ]
            ],
            'location' => [
                'label' => 'Location',
                'rules' => 'required|string',
                'errors' => [
                    'required' => 'The {field} field is required.',
                ]
            ],

            'number_of_years_leasehold' => [
                'label' => 'Number of Years Leasehold',
                'rules' => 'permit_empty|integer',
                'errors' => [
                    'integer' => 'The {field} must be a valid number.',
                ]
            ],
        ];

        $data_1 = [];

        $location = $this->request->getPost('location');
        $others = $this->request->getPost('others');
        $selected_location_id = $this->request->getPost('selected_location_id');

        if ($location === 'Others') {
            $rules['others'] = [
                'label' => 'Other Location Name',
                'rules' => 'required|string|max_length[50]',
                'errors' => [
                    'required' => 'The {field} is required when selecting "Others".',
                    'max_length' => 'The {field} must not exceed 50 characters.'
                ]
            ];


            if (!empty($_POST['others'])) {
                $data_1['Others'] = $_POST['others'];
            }
        }


        if ($location == 'Corporate_Office') {


            $data_1['Corporate_Office'] = null;
        }

        if ($location !== 'Corporate_Office' && $location !== 'Others') {
            $rules['selected_location_id'] = [
                'label' => 'Selected Location',
                'rules' => 'required',
                'errors' => [
                    'required' => 'The {field} is required.',

                ]
            ];

            if (!empty($_POST['selected_location_id'])) {
                $data_1[$location] = $_POST['selected_location_id'];
            }
        }

        if (!$this->validate($rules)) {


            session()->set('validation_errors', $this->validator->listErrors());
            session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds

            session()->set('validation_errors_2', $this->validator->getErrors());
            session()->markAsTempdata('validation_errors_2', 30);




            return redirect()->back()->withInput();
        }







        $data = [
            'name' => $this->request->getPost('Name'),
            'facility_id' => $this->request->getPost('facility_id'),
            'location_lat' => $this->request->getPost('loc_lat'),
            'location_long' => $this->request->getPost('loc_log'),
            'strg_address1' => $this->request->getPost('adresss_1'),
            'strg_address2' => $this->request->getPost('adresss_2'),
            'strg_village' => $this->request->getPost('Village'),
            'strg_country' => $this->request->getPost('country'),
            'strg_state' => $this->request->getPost('state'),
            'strg_city' => $this->request->getPost('city'),
            'strg_pin_code' => $this->request->getPost('pin_code'),
            'ownership' => $this->request->getPost('Ownership'),
            'number_of_years_leasehold' => $this->request->getPost('number_of_years_leasehold'),
            'type_of_structure' => $this->request->getPost('type_of_Structure'),
            'area_sq_meters' => $this->request->getPost('Area'),
            'Responsible_Person_Name' => $this->request->getPost('Responsible_Person_Name'),
            'Designation' => $this->request->getPost('Responsible_Person_Designation'),
            'Contact_Number' => $this->request->getPost('Responsible_Person_Number'),
            'commodities_stored' => $this->request->getPost('Commodities_Stored'),
            'remark' => $this->request->getPost('Remark'),
            'associated_by' => session()->get('user_associated'), // Empty for now,
            'entity_id' => session()->get('entity_id'), // Empty for now,
            'created_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'updated_by' => session()->get('logined_user_id'), // Empty for now,
            'location' => json_encode($data_1), // Empty for now,


        ];


        $model = new OrgStorageDetailsModel;
        // var_dump($data);
        $model->insert($data);
        $insertId = $model->getInsertID();

        $photos = $this->request->getFileMultiple('Photos');

        $session_id = session()->get('entity_id');
        if ($photos && count($photos) > 0) {
            $photoPaths = [];
            $errors = [];

            foreach ($photos as $index => $photo) {
                // Validate file
                if (!$photo->isValid() || $photo->hasMoved()) {
                    $errors[] = "File {$photo->getName()} is not valid or already moved.";
                    continue;
                }

                // Validate file type
                $allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp', 'image/bmp', 'image/tiff']; // Added image/jpg as well
                if (!in_array($photo->getMimeType(), $allowedTypes)) {
                    $errors[] = "File {$photo->getName()} must be a JPEG or PNG image.";
                    continue;
                }

                // Validate file size (e.g., max 2MB)
                $maxSize = 5 * 1024 * 1024; // 2MB in bytes
                if ($photo->getSize() > $maxSize) {
                    $errors[] = "File {$photo->getName()} exceeds the maximum size of 2MB.";
                    continue;
                }




                // Passed all validations — save file
                $photoName = $photo->getRandomName();
                $photoDir = "uploads/entity_profile/{$session_id}/storage_unites/{$insertId}/photos";
                $photoPath = FCPATH . $photoDir;

                if (!is_dir($photoPath)) {
                    mkdir($photoPath, 0777, true);
                }

                $photo->move($photoPath, $photoName);
                $relativePath = $photoDir . '/' . $photoName;
                $photoPaths[] = $relativePath;
            }

            // Save valid paths if any
            if (!empty($photoPaths)) {
                $model->update($insertId, ['photo' => json_encode($photoPaths)]);
            }

            // Handle errors (e.g., flash message or log)
            if (!empty($errors)) {

                // Example: pass to view or flashdata

                session()->set('validation_errors', $this->validator->listErrors());
                session()->markAsTempdata('validation_errors', 30); // stores for 60 seconds
            }
        }



        $docNames = $this->request->getPost('doc_name');
        $docDates = $this->request->getPost('doc_date');
        $docFiles = $this->request->getFiles()['doc_file'];

        $entityId = session()->get('entity_id');
        $documents = [];

        $uploadPath = FCPATH . "uploads/entity_profile/{$entityId}/storage_unites/{$insertId}/Document";
        $relativeBasePath = "uploads/entity_profile/{$entityId}/storage_unites/{$insertId}/Document";

        // Create directory if not exists
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        // Loop and process each document
        foreach ($docNames as $i => $name) {
            $date = $docDates[$i];
            $file = $docFiles[$i];

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $file->getRandomName();
                $file->move($uploadPath, $newName);

                $documents[] = [
                    'name' => $name,
                    'date' => $date,
                    'file' => "{$relativeBasePath}/{$newName}"
                ];
            }
        }

        $model->update($insertId, [
            'Document' => json_encode($documents)
        ]);











        return redirect()->back()->with('success', 'storage added successfully!');
    }


    public function get_details_of_unites()
    {

        $table = $this->request->getPost('data');


        $db = \Config\Database::connect();
        $builder = $db->table($table);


        $builder->select('id, name')
            ->where('status', 1)
            ->where('associated_by', session()->get('user_associated'))
            ->where('entity_id', session()->get('entity_id'));

        $query = $builder->get();
        $rows = $query->getResultArray();


        if (!empty($rows)) {
            return $this->response->setJSON([
                'data' => $rows,
                'csrfToken' => csrf_hash()
            ]);
        }

        return $this->response->setJSON([
            'error' => 'Data not found',
            'csrfToken' => csrf_hash()
        ]);
    }




    public function add_storage()
    {

        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        return view('' . $session->get('acessing_folder') . '/storage/add', ['organization' => $organization]);
    }



    public function index()
    {
        $session = session();
        $id = $session->get('entity_id'); // or session('id');

        $loginModel = new Loginmodel();

        $organization = $loginModel->find($id);
        // echo "hi"; 
        return view('' . $session->get('acessing_folder') . '/storage/index', ['organization' => $organization]);
    }
}
