<?php

namespace Elementor;

class Grogin_Home_Image_Widget extends Widget_Base {

    public function get_name() {
        return 'grogin-home-image';
    }
    public function get_title() {
        return 'Home Image (K)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'grogin' ];
    }

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'plugin-name' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$defaultimage = plugins_url( 'images/hero.png', __DIR__ );
		
        $this->start_controls_tabs( 'icon_tabs');
		$this->start_controls_tab( 'image_tab',
			[ 'label'  => esc_html__( 'Image', 'grogin-core' ) ]
		);
		
        $this->add_control( 'image',
            [
                'label' => esc_html__( 'Image', 'grogin-core' ),
                'type' => Controls_Manager::MEDIA,
				'default' => ['url' => $defaultimage],
            ]
        );
		
		/*****   END CONTROLS TAB ******/
		$this->end_controls_tab();
		/*****  CONTROLS TAB START   ******/
        $this->start_controls_tab( 'icon_tab',
            [ 'label' => esc_html__( 'Icon', 'grogin-core' ) ]
        );
		
		$this->add_control(
			'switcher_icon',
			[
				'label' => esc_html__( 'Use Custom Icon', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'grogin-core' ),
				'label_off' => esc_html__( 'No', 'grogin-core' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);
		
		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'grogin-core' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-facebook-f',
					'library' => 'fa-brands',
				],
                'label_block' => true,
				'condition' => ['switcher_icon' => '']
			]
		);
		
        $this->add_control( 'custom_icon',
            [
                'label' => esc_html__( 'Custom Icon', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'klb-social-icon-facebook',
                'description'=> 'You can add icon code. for example: klb-social-icon-facebook',
				'condition' => ['switcher_icon' => 'yes']
            ]
        );
		
		$this->end_controls_tab();
        $this->end_controls_tabs();
		/*****   END CONTROLS TABS ******/
		
        $this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Oliga makyngen. Nelis. Somonat ohöv. Preng voren dolare.',
                'description'=> 'Add a title.',
				'label_block' => true,
            ]
        );
		
        $this->add_control( 'subtitle',
            [
                'label' => esc_html__( 'Subtitle', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Weekend Discount',
                'description'=> 'Add a subtitle.',
				'label_block' => true,
            ]
        );
		
        $this->add_control( 'desc',
            [
                'label' => esc_html__( 'Description', 'grogin-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Dysplastisk mitredes men kontaktlös kortbetalning. Dystism. Tens nisperade. Trikist redängar inklusive uns.',
                'description'=> 'Add a description.',
				'label_block' => true,
            ]
        );

		
        $this->add_control( 'btn_title',
            [
                'label' => esc_html__( 'Button Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Shop Now ',
                'pleaceholder' => esc_html__( 'Enter button title here', 'grogin-core' ),
            ]
        );
		
        $this->add_control( 'btn_link',
            [
                'label' => esc_html__( 'Button Link', 'grogin-core' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => esc_html__( 'Place URL here', 'grogin-core' )
            ]
        );
		
		$this->add_control( 'download_btn_title',
            [
                'label' => esc_html__( 'Download Button Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Download App',
                'pleaceholder' => esc_html__( 'Enter button title here', 'grogin-core' ),
            ]
        );
		
        $this->add_control( 'download_btn_link',
            [
                'label' => esc_html__( 'Button Link', 'grogin-core' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => esc_html__( 'Place URL here', 'grogin-core' )
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
		
		/*****   START CONTROLS SECTION   ******/
		
		$this->start_controls_section('grogin_styling',
            [
                'label' => esc_html__( ' Style', 'grogin-core' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
		
		$this->add_responsive_control( 'home_slider_alignment',
            [
                'label' => esc_html__( 'Alignment', 'grogin-core' ),
                'type' => Controls_Manager::CHOOSE,
                'selectors' => ['{{WRAPPER}} .text-block' => 'text-align: {{VALUE}};'],
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'grogin-core' ),
                        'icon' => 'eicon-text-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'grogin-core' ),
                        'icon' => 'eicon-text-align-center'
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'grogin-core' ),
                        'icon' => 'eicon-text-align-right'
                    ]
                ],
                'toggle' => true,
                
            ]
        );
		
		$this->add_control( 'image_heading',
            [
                'label' => esc_html__( 'IMAGE', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[
				'name' => 'css_filters',
				'selector' => '{{WRAPPER}} .entry-media img',
			]
		);
		
		$this->add_control( 'title_heading',
            [
                'label' => esc_html__( 'TITLE', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_control( 'title_color',
			[
               'label' => esc_html__( 'Title Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .entry-title' => 'color: {{VALUE}} !important;']
			]
        );
		
		$this->add_responsive_control( 'title_size',
            [
                'label' => esc_html__( 'Title Size', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1000,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-title' => 'font-size: {{SIZE}}px !important;' ],
            ]
        );
		
		$this->add_responsive_control( 'title_weight',
            [
                'label' => esc_html__( 'Title Weight', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 1000,
                'step' => 100,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-title' => 'font-weight: {{SIZE}} !important;' ],
            ]
        );
		
		$this->add_control( 'title_line_height_style',
            [
                'label' => esc_html__( 'Line-height', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .entry-title ' => 'line-height: {{VALUE}}em !important;']
            ]
        );
		
		$this->add_control( 'title_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .entry-title ' => 'opacity: {{VALUE}} ;']
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'selector' => '{{WRAPPER}} .entry-title',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                
                'selector' => '{{WRAPPER}} .entry-body .entry-title',
				
            ]
        );
		
		$this->add_control( 'subtitle_heading',
            [
                'label' => esc_html__( 'SUBTITLE', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_control( 'subtitle_color',
           [
               'label' => esc_html__( 'Subtitle Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .banner-badge' => 'color: {{VALUE}};']
           ]
        );
		
		$this->add_control( 'subtitle_bgcolor',
           [
               'label' => esc_html__( 'Subtitle Background Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .banner-badge' => 'background-color: {{VALUE}};']
           ]
        );
		
		$this->add_control( 'subtitle_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .banner-badge ' => 'opacity: {{VALUE}} ;']
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'subtitle_text_shadow',
				'selector' => '{{WRAPPER}} .banner-badge',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                
                'selector' => '{{WRAPPER}} .banner-badge',
				
            ]
        );
		
		$this->add_control( 'description_heading',
            [
                'label' => esc_html__( 'DESCRIPTION', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_control( 'description_color',
			[
               'label' => esc_html__( 'Description Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .entry-content p' => 'color: {{VALUE}};']
			]
        );
		
		$this->add_responsive_control( 'desc_size',
            [
                'label' => esc_html__( 'Description Size', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-content p' => 'font-size: {{SIZE}}px !important;' ],
            ]
        );
		
		$this->add_responsive_control( 'desc_weight',
            [
                'label' => esc_html__( 'Description Weight', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 1000,
                'step' => 100,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-content p' => 'font-weight: {{SIZE}} !important;' ],
            ]
        );
		
		$this->add_control( 'desc_line_height_style',
            [
                'label' => esc_html__( 'Line-height', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .entry-content p ' => 'line-height: {{VALUE}}em !important;']
            ]
        );
		
		$this->add_control( 'description_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .entry-content p ' => 'opacity: {{VALUE}} ;']
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'description_text_shadow',
				'selector' => '{{WRAPPER}} .entry-content p ',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                
                'selector' => '{{WRAPPER}} .entry-content p',
				
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
		
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('btn_styling',
            [
                'label' => esc_html__( ' Button Style', 'grogin-core' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                
                'selector' => '{{WRAPPER}} a.btn-primary  '
            ]
        );
		
		$this->add_control( 'btn_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} a.btn-primary' => 'opacity: {{VALUE}} ;'],
            ]
        );
		
		$this->add_control( 'btn_color',
            [
                'label' => esc_html__( 'Color', 'grogin-core' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} a.btn-primary' => 'color: {{VALUE}};']
            ]
        );
       
	    $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'label' => esc_html__( 'Border', 'grogin-core' ),
                'selector' => '{{WRAPPER}} a.btn-primary ',
            ]
        );
        
		$this->add_responsive_control( 'btn_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'grogin-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} a.btn-primary' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;'],
            ]
        );
		
		$this->add_responsive_control( 'btn_padding',
            [
                'label' => esc_html__( 'Padding', 'grogin-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} a.btn-primary' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],              
            ]
        );
       
		$this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'btn_background',
                'label' => esc_html__( 'Background', 'grogin-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} a.btn-primary',
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
		
		/*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('download_btn_styling',
            [
                'label' => esc_html__( 'Download Button Style', 'grogin-core' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'download_btn_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                
                'selector' => '{{WRAPPER}} a.btn-black  '
            ]
        );
		
		$this->add_control( 'download_btn_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} a.btn-black' => 'opacity: {{VALUE}} ;'],
            ]
        );
		
		$this->add_control( 'download_btn_color',
            [
                'label' => esc_html__( 'Color', 'grogin-core' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} a.btn-black' => 'color: {{VALUE}};']
            ]
        );
       
	    $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'download_btn_border',
                'label' => esc_html__( 'Border', 'grogin-core' ),
                'selector' => '{{WRAPPER}} a.btn-black ',
            ]
        );
        
		$this->add_responsive_control( 'download_btn_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'grogin-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} a.btn-black' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;'],
            ]
        );
		
		$this->add_responsive_control( 'download_btn_padding',
            [
                'label' => esc_html__( 'Padding', 'grogin-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} a.btn-black' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],              
            ]
        );
       
		$this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'download_btn_background',
                'label' => esc_html__( 'Background', 'grogin-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} a.btn-black',
            ]
        );
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$target = $settings['btn_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['btn_link']['nofollow'] ? ' rel="nofollow"' : '';
		
		$downloadnofollow = $settings['download_btn_link']['nofollow'] ? ' rel="nofollow"' : '';
		$downloadtarget = $settings['download_btn_link']['is_external'] ? ' target="_blank"' : '';
		
		$output = '';		
		
		echo '<div class="custom-background gradient-primary pt-30 sm-pt-60">';
		echo '<div class="container">';
		echo '<div class="row align-items-center">';
		echo '<div class="col col-12 col-sm-6 col-md-5">';
		echo '<div class="text-block">';
		echo '<div class="entry-header mb-10">';
		echo '<span class="banner-badge green">'.esc_html($settings['subtitle']).'</span>';
		echo '</div><!-- entry-header -->';
		echo '<div class="entry-body mb-10 sm-mb-24 md-mb-40">';
		echo '<h2 class="entry-title text-26 sm-text-36 md-text-48 fw-bold lh-1-1 text-primary-active">'.esc_html($settings['title']).'</h2>';
		echo '<div class="entry-content pr-0 md-pr-30">';
		echo '<p class="text-13 sm-text-14 md-text-16 lh-base">'.esc_html($settings['desc']).'</p>';
		echo '</div><!-- entry-content -->';
		echo '</div><!-- entry-body -->';
		echo '<div class="entry-footer d-flex flex-wrap align-items-center gap-3">';
		if($settings['btn_title']){
			echo '<a href="'.esc_url($settings['btn_link']['url']).'" '.esc_attr($target.$nofollow).' class="btn btn-primary mobile-small icon-right">'.esc_html($settings['btn_title']).' <i class="klb-icon-move-right"></i></a>';
		}
		if($settings['download_btn_title']){
			echo '<a href="'.esc_url($settings['download_btn_link']['url']).'" '.esc_attr($downloadtarget.$downloadnofollow).' class="btn btn-black mobile-small icon-left"><i class="klb-icon-upload"></i> '.esc_html($settings['download_btn_title']).'</a>';
		}
		echo '</div><!-- entry-footer -->';
		echo '</div><!-- text-block -->';
		echo '</div><!-- col -->';
		echo '<div class="col col-12 col-sm-6 col-md-7">';
		echo '<div class="entry-media pl-0 sm-pl-60">';
		
		if($settings['image']['url']){
			echo '<img src="'.esc_url($settings['image']['url']).'" alt="">';
		} else {
			if($settings['switcher_icon'] == 'yes'){
				echo '<i class="'.esc_attr($settings['custom_icon']).'"></i>';
			} else {
				Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'false' ] );						
			}
		}	
		
		
		echo '</div><!-- entry-media -->';
		echo '</div><!-- col -->';
		echo '</div><!-- row -->';
		echo '</div><!-- container -->';
		echo '</div><!-- custom-background -->';
		
	}

}
