<?php

namespace Elementor;

class Grogin_Latest_Blog_Widget extends Widget_Base {
    use Grogin_Helper;

    public function get_name() {
        return 'grogin-latest-blog';
    }
    public function get_title() {
        return 'Lateste Posts (K)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'grogin' ];
    }

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'grogin-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Our News',
                'pleaceholder' => esc_html__( 'Add a title.', 'grogin-core' ),
            ]
        );
		
		$this->add_control( 'desc',
            [
                'label' => esc_html__( 'Description', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Some of the new products arriving this weeks',
                'pleaceholder' => esc_html__( 'Add a description.', 'grogin-core' ),
            ]
        );
		
		$this->add_control( 'btn_title',
            [
                'label' => esc_html__( 'Button Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'View All ',
                'pleaceholder' => esc_html__( 'Enter button title here', 'grogin-core' ),
            ]
        );
		
        $this->add_control( 'btn_link',
            [
                'label' => esc_html__( 'Button Link', 'grogin-core' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => esc_html__( 'Place URL here', 'grogin-core' )
            ]
        );
		
				
		$this->add_control( 'column',
			[
				'label' => esc_html__( 'Column', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '3',
				'options' => [
					'3'   => esc_html__( '4 Columns', 'grogin-core' ),
					'4'	  => esc_html__( '3 Columns', 'grogin-core' ),
					'6'	  => esc_html__( '2 Columns', 'grogin-core' ),
				],
			]
		);
		
		$this->add_control( 'tablet_column',
			[
				'label' => esc_html__( 'Tablet Column', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '6',
				'options' => [
					'3'   => esc_html__( '4 Columns', 'grogin-core' ),
					'4'	  => esc_html__( '3 Columns', 'grogin-core' ),
					'6'	  => esc_html__( '2 Columns', 'grogin-core' ),
				],
			]
		);
		
		$this->add_control( 'mobile_column',
			[
				'label' => esc_html__( 'Mobile Column', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '12',
				'options' => [
					'6'	  => esc_html__( '2 Columns', 'grogin-core' ),
					'12'  => esc_html__( '1 Columns', 'grogin-core' ),
				],
			]
		);
		
        $this->add_control( 'post_count',
            [
                'label' => esc_html__( 'Posts Per Page', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => count( get_posts( array('post_type' => 'post', 'post_status' => 'publish', 'fields' => 'ids', 'posts_per_page' => '-1') ) ),
                'default' => 4
            ]
        );
		
		$this->add_control( 'excerpt_size',
            [
                'label' => esc_html__( 'Excerpt Size', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'default' => 15
            ]
        );
		
        $this->add_control( 'category_filter',
            [
                'label' => esc_html__( 'Category', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->grogin_get_categories(),
                'description' => 'Select Category(s)',
				'label_block' => true,
            ]
        );
		
        $this->add_control( 'post_filter',
            [
                'label' => esc_html__( 'Specific Post(s)', 'naturally' ),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $this->grogin_get_posts(),
                'description' => 'Select Specific Post(s)',
				'label_block' => true,
            ]
        );
		
        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'grogin-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'grogin-core' ),
                    'DESC' => esc_html__( 'Descending', 'grogin-core' )
                ],
                'default' => 'DESC'
            ]
        );
		
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'grogin-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'grogin-core' ),
                    'menu_order' => esc_html__( 'Menu Order', 'grogin-core' ),
                    'rand' => esc_html__( 'Random', 'grogin-core' ),
                    'date' => esc_html__( 'Date', 'grogin-core' ),
                    'title' => esc_html__( 'Title', 'grogin-core' ),
                ],
                'default' => 'date',
            ]
        );
		
		$this->add_control(
			'disable_pagination',
			[
				'label' => esc_html__('Disable Pagination', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'grogin-core' ),
				'label_off' => esc_html__( 'No', 'grogin-core' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);
		
        $this->add_responsive_control( 'image_width',
            [
                'label' => esc_html__( 'Image Width', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '298',
                'pleaceholder' => esc_html__( 'Set the product image width.', 'grogin-core' )
            ]
        );
		
        $this->add_responsive_control( 'image_height',
            [
                'label' => esc_html__( 'Image Height', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '206',
                'pleaceholder' => esc_html__( 'Set the product image height.', 'grogin-core' )
            ]
        );
		
		/*****   END CONTROLS SECTION   ******/
		$this->end_controls_section();
		
		/*****   START CONTROLS SECTION   ******/
		$this->start_controls_section('grogin_styling',
            [
                'label' => esc_html__( ' Style', 'grogin' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
		
		$this->add_control( 'title_heading',
            [
                'label' => esc_html__( 'TITLE', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_responsive_control( 'title_size',
            [
                'label' => esc_html__( 'Title Size', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .site-module-header .entry-title' => 'font-size: {{SIZE}}px !important;' ],
            ]
        );
		
		$this->add_responsive_control( 'title_weight',
            [
                'label' => esc_html__( 'Title Weight', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 1000,
                'step' => 100,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .site-module-header .entry-title' => 'font-weight: {{SIZE}} !important;' ],
            ]
        );
		
		$this->add_control( 'title_color',
			[
               'label' => esc_html__( 'Title Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .site-module-header .entry-title' => 'color: {{VALUE}};']
			]
        );
		
		$this->add_control( 'title_hvrcolor',
			[
               'label' => esc_html__( 'Title Hover Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}}  .site-module-header .entry-title:hover' => 'color: {{VALUE}};']
			]
        );
		
		$this->add_control( 'title_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .site-module-header .entry-title ' => 'opacity: {{VALUE}} ;']
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'selector' => '{{WRAPPER}} .site-module-header .entry-title',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                
                'selector' => '{{WRAPPER}} .site-module-header .entry-title',
				
            ]
        );
		
		$this->add_control( 'subtitle_heading',
            [
                'label' => esc_html__( 'SUBTITLE', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before',
            ]
        );
		
		$this->add_responsive_control( 'subtitle_size',
            [
                'label' => esc_html__( 'Subtitle Size', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .site-module-header p ' => 'font-size: {{SIZE}}px !important;' ],
            ]
        );
		
		$this->add_responsive_control( 'subtitle_weight',
            [
                'label' => esc_html__( 'Subtitle Weight', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 1000,
                'step' => 100,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .site-module-header p ' => 'font-weight: {{SIZE}} !important;' ],
            ]
        );
		
		$this->add_control( 'subtitle_color',
			[
               'label' => esc_html__( 'Subtitle Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .site-module-header p' => 'color: {{VALUE}} !important;'],
			]
        );
		
		$this->add_control( 'subtitle_hvrcolor',
			[
               'label' => esc_html__( 'Subtitle Hover Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .site-module-header p:hover' => 'color: {{VALUE}} !important;'],
			]
        );
		
		$this->add_control( 'subtitle_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .site-module-header p ' => 'opacity: {{VALUE}} ;'],
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'subtitle_text_shadow',
				'selector' => '{{WRAPPER}} .site-module-header p ',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                
                'selector' => '{{WRAPPER}} .site-module-header p',
				
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
		
		/*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('btn_styling',
            [
                'label' => esc_html__( ' Button Style', 'grogin-core' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                
                'selector' => '{{WRAPPER}} a.btn  '
            ]
        );
		
		$this->add_control( 'btn_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} a.btn' => 'opacity: {{VALUE}} ;'],
            ]
        );
		
		$this->add_control( 'btn_color',
            [
                'label' => esc_html__( 'Color', 'grogin-core' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} a.btn' => 'color: {{VALUE}};']
            ]
        );
		
		$this->add_responsive_control( 'btn_icon_size',
            [
                'label' => esc_html__( 'Button Icon Size', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} a.btn i' => 'font-size: {{SIZE}}px !important;' ],
            ]
        );
		
	    $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'label' => esc_html__( 'Border', 'grogin-core' ),
                'selector' => '{{WRAPPER}} a.btn ',
            ]
        );
        
		$this->add_responsive_control( 'btn_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'grogin-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} a.btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;'],
            ]
        );
		
		$this->add_responsive_control( 'btn_padding',
            [
                'label' => esc_html__( 'Padding', 'grogin-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => ['{{WRAPPER}} a.btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'],              
            ]
        );
       
		$this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'btn_background',
                'label' => esc_html__( 'Background', 'grogin-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} a.btn',
            ]
        );
		
		$this->add_responsive_control( 'btn_height',
            [
                'label' => esc_html__( 'Button Height', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1000,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} a.btn' => 'height: {{SIZE}}px !important;' ],
            ]
        );

		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/	
	}

	protected function render() {
		$settings = $this->get_settings_for_display();		
		$target = $settings['btn_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['btn_link']['nofollow'] ? ' rel="nofollow"' : '';
		
		$output = '';
		
		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}
	
		$args = array(
			'post_type' => 'post',
			'posts_per_page' => $settings['post_count'],
			'order'          => 'DESC',
			'post_status'    => 'publish',
			'paged' 			=> $paged,
            'post__in'       => $settings['post_filter'],
            'order'          => $settings['order'],
			'orderby'        => $settings['orderby'],
            'category__in'     => $settings['category_filter'],
		);
		
		$output .= '<div class="site-module blog-module">';
		
		if($settings['title']){
			$output .= '<div class="site-module-header d-flex flex-wrap align-items-center justify-content-between mb-10 md-mb-20">';
			$output .= '<div class="col d-inline-flex flex-wrap align-items-center gap-0-5 gap-md-3">';
			$output .= '<h3 class="entry-title text-16 md-text-18 fw-bold mb-0">'.esc_html($settings['title']).'</h3>';
			$output .= '<p class="text-13 text-gray-400 mb-0">'.esc_html($settings['desc']).'</p>';
			$output .= '</div><!-- col -->';
			if($settings['btn_title']){
				$output .= '<div class="col flex-auto">';
				$output .= '<a href="'.esc_url($settings['btn_link']['url']).'" '.esc_attr($target.$nofollow).' class="btn btn-white xs rounded icon-right btn-more"><span>'.esc_html($settings['btn_title']).' <i class="klb-icon-move-right"></i></span> <i class="klb-icon-more-horizontal"></i></a>';
				$output .= '</div><!-- col -->';
			}
			$output .= '</div><!-- site-module-header -->';	
		}

		$output .= '<div class="site-module-body">';
		$output .= '<div class="row">';
		
		$count = 1;
		$loop = new \WP_Query( $args );
		if ( $loop->have_posts() ) {
			while ( $loop->have_posts() ) : $loop->the_post();
				global $product;
				global $post;
				global $woocommerce;
			
				$id = get_the_ID();
				
				$att=get_post_thumbnail_id();
				$image_src = wp_get_attachment_image_src( $att, 'full' );
				if($image_src){
				$image_src = $image_src[0];
				}
				if($settings['image_width'] && $settings['image_height']){
					$imageresize = grogin_resize( $image_src, $settings['image_width'], $settings['image_height'], true, true, true );  
				} else {
					$imageresize = $image_src;
				}

				$taxonomy = strip_tags( get_the_term_list($post->ID, 'category', '', ', ', '') );
				
				$output .= '<div class="col col-'.esc_attr($settings['mobile_column']).' col-md-'.esc_attr($settings['tablet_column']).' col-lg-'.esc_attr($settings['column']).'">';
				$output .= '<div class="post">';
				$output .= '<div class="post-thumbnail">';
				$output .= '<div class="post-category">';
				$output .= '<a href="'.get_permalink().'">'.esc_html($taxonomy).'</a>';
				$output .= '</div><!-- post-category -->';
				if($image_src){
					$output .= '<div class="post-gallery position-relative overflow-hidden entry-media rounded-base">';
					$output .= '<a href="'.get_permalink().'"><img src="'.esc_url($imageresize).'" alt="'.the_title_attribute( 'echo=0' ).'"/></a>';
					$output .= '</div><!-- post-gallery -->';
				}
				$output .= '</div><!-- post-thumbnail -->';
				$output .= '<div class="post-body">';
				$output .= '<h3 class="entry-title text-18"><a href="'.get_permalink().'">'.get_the_title().'</a></h3>';
				$output .= '<div class="entry-excerpt">';
				$output .= '<p>'.grogin_limit_words(get_the_excerpt(), $settings['excerpt_size']).' </p>';
				$output .= '</div><!-- entry-excerpt -->';
				$output .= '<div class="entry-post-meta">';
				$output .= '<span class="meta-item meta-author">';
				$output .= '<span>'.esc_html__('by','grogin-core').'</span>';
				$output .= '<a href="'.get_permalink().'">'.get_the_author().'</a>';
				$output .= '</span><!-- meta-item -->';
				$output .= '<span class="meta-item meta-comment">';
				$output .= '<a href="'.get_permalink().'">'.get_the_date('j M Y').'</a>';
				$output .= '</span><!-- meta-item -->';
				$output .= '</div><!-- entry-post-meta -->';
				$output .= '</div><!-- post-body -->';
				$output .= '</div><!-- post -->';
				$output .= '</div><!-- col -->';			
				
			endwhile;
		
			if($settings['disable_pagination'] != 'yes'){
				ob_start();
				get_template_part( 'post-format/pagination' );
				$output .= '<div class="col-12">'. ob_get_clean().'</div>';
			}
		}
		wp_reset_postdata();
		
		
		$output .= '</div>';
		$output .= '</div>';
        $output .= '</div>';  

		
		echo $output;
	}

}
