<?php

namespace Elementor;

class Grogin_Product_Banner2_Widget extends Widget_Base {
    use Grogin_Helper;
	
    public function get_name() {
        return 'grogin-product-banner2';
    }
    public function get_title() {
        return 'Product Banner 2 (K)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'grogin' ];
    }

	protected function register_controls() {
		
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'grogin-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$defaultimage = plugins_url( 'images/banner-20.jpg', __DIR__ );
		
		$repeater = new Repeater();
        $repeater->add_control( 'image',
            [
                'label' => esc_html__( 'Image', 'grogin-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => $defaultimage],
            ]
        );
		
        $repeater->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Prelingar. Hösaska. Vareligen. Anime.',
                'description'=> 'Add a title.',
				'label_block' => true,
            ]
        );
		
        $repeater->add_control( 'subtitle',
            [
                'label' => esc_html__( 'Subtitle', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Only This Week',
                'description'=> 'Add a subtitle.',
				'label_block' => true,
            ]
        );
		
		$repeater->add_control( 'desc',
            [
                'label' => esc_html__( 'Description', 'grogin-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => 'Multira osongen. Vint parastat...',
                'description'=> 'Add a description.',
				'label_block' => true,
            ]
        );
		
		 $repeater->add_control( 'btn_title',
            [
                'label' => esc_html__( 'Button Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Shop Now',
                'pleaceholder' => esc_html__( 'Enter button title here', 'grogin-core' ),
            ]
        );
		
        $repeater->add_control( 'btn_link',
            [
                'label' => esc_html__( 'Button Link', 'grogin-core' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => esc_html__( 'Place URL here', 'grogin-core' )
            ]
        );
		
		$this->add_control( 'banner_items',
            [
                'label' => esc_html__( 'Banner Items', 'grogin-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => ['url' => $defaultimage],
                        'title' => 'Novent odonde tris förutom osam oaktat.',
                        'subtitle' => 'Only This Week',
                        'desc' => 'Multira osongen. Vint parastat...',
						'btn_title' => ' Shop Now ',
                        'btn_link' => '#',
                    ],
                    [
                        'image' => ['url' => $defaultimage],
                        'title' => 'Novent odonde tris förutom osam oaktat.',
                        'subtitle' => 'Only This Week',
                        'desc' => 'Multira osongen. Vint parastat...',
						'btn_title' => ' Shop Now ',
                        'btn_link' => '#',
                    ],
                ]
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/	
		
		/***** START QUERY CONTROLS SECTION *****/
		$this->grogin_query_elementor_controls($post_count = 6, $column = 6);
		/***** END QUERY CONTROLS SECTION *****/
		
		/*****   START CONTROLS SECTION   ******/
		$this->start_controls_section('grogin_styling',
            [
                'label' => esc_html__( ' Style', 'grogin-core' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
		
		$this->add_responsive_control( 'banner_box_text_alignment',
            [
                'label' => esc_html__( 'Alignment Text', 'grogin-core' ),
                'type' => Controls_Manager::CHOOSE,
                'selectors' => ['{{WRAPPER}} .entry-inner' => 'text-align: {{VALUE}};'],
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'grogin-core' ),
                        'icon' => 'eicon-text-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'grogin-core' ),
                        'icon' => 'eicon-text-align-center'
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'grogin-core' ),
                        'icon' => 'eicon-text-align-right'
                    ]
                ],
                'toggle' => true,
                
            ]
        );
		
		$this->add_control( 'image_heading',
            [
                'label' => esc_html__( 'IMAGE', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[
				'name' => 'css_filters',
				'selector' => '{{WRAPPER}}  .entry-media img',
			]
		);
		
		$this->add_control( 'title_heading',
            [
                'label' => esc_html__( 'TITLE', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_responsive_control( 'title_size',
            [
                'label' => esc_html__( 'Title Size', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-title' => 'font-size: {{SIZE}}px !important;' ],
            ]
        );
		
		$this->add_responsive_control( 'title_weight',
            [
                'label' => esc_html__( 'Title Weight', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 1000,
                'step' => 100,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-title' => 'font-weight: {{SIZE}} !important;' ],
            ]
        );
		
		$this->add_control( 'title_line_height_style',
            [
                'label' => esc_html__( 'Line-height', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .entry-title ' => 'line-height: {{VALUE}}em !important;']
            ]
        );
		
		$this->add_control( 'title_color',
			[
               'label' => esc_html__( 'Title Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .entry-title' => 'color: {{VALUE}} !important;']
			]
        );
		
		$this->add_control( 'title_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .entry-title ' => 'opacity: {{VALUE}} ;']
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'selector' => '{{WRAPPER}} .entry-title',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                
                'selector' => '{{WRAPPER}} .entry-title',
				
            ]
        );
		
		$this->add_control( 'subtitle_heading',
            [
                'label' => esc_html__( 'SUBTITLE', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_responsive_control( 'subtitle_size',
            [
                'label' => esc_html__( 'Subtitle Size', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-subtitle' => 'font-size: {{SIZE}}px !important;' ],
            ]
        );
		
		$this->add_responsive_control( 'subtitle_weight',
            [
                'label' => esc_html__( 'Subtitle Weight', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 1000,
                'step' => 100,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-subtitle' => 'font-weight: {{SIZE}} !important;' ],
            ]
        );
		
		$this->add_control( 'subtitle_color',
			[
               'label' => esc_html__( 'Subtitle Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .entry-subtitle' => 'color: {{VALUE}} !important;']
			]
        );
		
		$this->add_control( 'subtitle_bgcolor',
			[
               'label' => esc_html__( 'Subtitle Background Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .entry-subtitle' => 'background-color: {{VALUE}} !important;']
			]
        );
		
		$this->add_control( 'subtitle_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .entry-subtitle ' => 'opacity: {{VALUE}} ;']
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'subtitle_text_shadow',
				'selector' => '{{WRAPPER}} .entry-subtitle',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                
                'selector' => '{{WRAPPER}} .entry-subtitle',
				
            ]
        );
		
		$this->add_control( 'description_heading',
            [
                'label' => esc_html__( 'DESCRIPTION', 'grogin-core' ),
                'type' => Controls_Manager::HEADING,
				'separator' => 'before'
            ]
        );
		
		$this->add_responsive_control( 'desc_size',
            [
                'label' => esc_html__( 'Description Size', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1000,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-content p' => 'font-size: {{SIZE}}px !important;' ],
            ]
        );
		
		$this->add_responsive_control( 'desc_weight',
            [
                'label' => esc_html__( 'Description Weight', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 1000,
                'step' => 100,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .entry-content p' => 'font-weight: {{SIZE}} !important;' ],
            ]
        );
		
		$this->add_control( 'desc_line_height_style',
            [
                'label' => esc_html__( 'Line-height', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .entry-content p ' => 'line-height: {{VALUE}}em !important;']
            ]
        );
		
		$this->add_control( 'desc_color',
			[
               'label' => esc_html__( 'Description Color', 'grogin-core' ),
               'type' => Controls_Manager::COLOR,
               'default' => '',
               'selectors' => ['{{WRAPPER}} .entry-content p' => 'color: {{VALUE}} !important;']
			]
        );
		
		$this->add_control( 'description_opacity_important_style',
            [
                'label' => esc_html__( 'Opacity', 'grogin-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 1,
                'step' => 0.1,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .entry-content p ' => 'opacity: {{VALUE}} ;']
            ]
        );
		
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'description_text_shadow',
				'selector' => '{{WRAPPER}} .entry-content p ',
			]
		);
		
		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typo',
                'label' => esc_html__( 'Typography', 'grogin-core' ),
                
                'selector' => '{{WRAPPER}} .entry-content p',
				
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		
		$output = '';		
		
		$terms = get_terms( array(
			'taxonomy' => 'product_cat',
			'hide_empty' => true,
			'parent'    => 0,
			'include'   => $settings['cat_filter'],
			'order'          => $settings['order'],
			'orderby'        => $settings['orderby']
		) );
		
		
		$output .= '<div class="site-module products-grid-module style-6">';
		$output .= '<div class="site-module-body border-block bg-white">';
		
		if ( $settings['banner_items'] ) {
			
			$output .= '<div class="column d-flex flex-wrap">';
			
			foreach ( $settings['banner_items'] as $item ) {
				$target = $item['btn_link']['is_external'] ? ' target="_blank"' : '';
				$nofollow = $item['btn_link']['nofollow'] ? ' rel="nofollow"' : '';
				
					$output .= '<div class="inner-column">';
					$output .= '<div class="site-banner overflow-hidden rounded-base" style="--banner-tablet-height: 220px; --banner-mobile-height: 200px;" data-color="dark">';
					$output .= '<div class="entry-wrapper d-flex align-items-center strech p-20 sm-p-30">';
					$output .= '<div class="entry-inner max-w-60 sm-max-w-60 md-max-w-50">';
					$output .= '<div class="entry-header mb-7">';
					$output .= '<h5 class="entry-subtitle badge text-12 fw-semibold text-orange-900 bg-orange-100">'.esc_html($item['subtitle']).'</h5>';
					$output .= '</div><!-- entry-header -->';
					$output .= '<div class="entry-body mb-10">';
					$output .= '<h2 class="entry-title text-18 md-text-28 fw-bold lh-sm lt-tighter text-gray-900">'.esc_html($item['title']).'</h2>';
					$output .= '<div class="entry-content pr-0 md-pr-30">';
					$output .= '<p class="text-13 lh-base text-gray-500">'.esc_html($item['desc']).'</p>';
					$output .= '</div><!-- entry-content -->';
					$output .= '</div><!-- entry-body -->';
					
					if($item['btn_title']){	
						$output .= '<div class="entry-footer d-flex flex-wrap align-items-center gap-3">';
						$output .= '<a href="'.esc_url($item['btn_link']['url']).'" class="btn btn-white xs rounded icon-right" '.esc_attr($target.$nofollow).'>'.esc_html($item['btn_title']).' <i class="klb-icon-move-right"></i></a>';
						$output .= '</div><!-- entry-footer -->';
					} 

					$output .= '</div><!-- entry-inner -->';
					$output .= '</div><!-- entry-wrapper -->';
					$output .= '<div class="entry-media">';
					$output .= '<img src="'.esc_url($item['image']['url']).'" alt="">';
					$output .= '</div><!-- entry-media -->';
					$output .= '<a href="'.esc_url($item['btn_link']['url']).'" class="overlay-link"></a>';
					$output .= '</div><!-- site-banner -->';
					$output .= '</div><!-- inner-column -->';
			}	
			
			$output .= '</div><!-- column -->';
			
		}
		
		$output .= '<div class="column">';
		$output .= '<div class="products column-'.esc_attr($settings['mobile_column']).' sm-column-'.esc_attr($settings['tablet_column']).' md-column-'.esc_attr($settings['column']).'">';
       $output .= $this->grogin_elementor_product_loop($settings);            
		$output .= '</div><!-- products -->';
		$output .= '</div><!-- column -->';
		$output .= '</div><!-- site-module-body -->';
		$output .= '</div><!-- site-module -->';
		
		echo $output;
	}

}
