<?php

namespace Elementor;

class Grogin_Product_Brands_Widget extends Widget_Base {
    use Grogin_Helper;
	
    public function get_name() {
        return 'grogin-product-brands';
    }
    public function get_title() {
        return 'Product Brands (K)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'grogin' ];
    }

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'grogin-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
        $this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'All Brands'
            ]
        );
		
		$this->add_control( 'letter_nav',
			[
				'label' => esc_html__( 'Letter Navigation', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'True', 'grogin-core' ),
				'label_off' => esc_html__( 'False', 'grogin-core' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		
		$this->add_control( 'hide_empty',
			[
				'label' => esc_html__( 'Hide Empty', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'True', 'grogin-core' ),
				'label_off' => esc_html__( 'False', 'grogin-core' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		
		$this->add_control( 'column',
			[
				'label' => esc_html__( 'Column', 'grogin-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => '5',
				'options' => [
					'0' => esc_html__( 'Select Column', 'grogin-core' ),
					'2' 	  => esc_html__( '2 Columns', 'grogin-core' ),
					'3'		  => esc_html__( '3 Columns', 'grogin-core' ),
					'4'		  => esc_html__( '4 Columns', 'grogin-core' ),
					'5'		  => esc_html__( '5 Columns', 'grogin-core' ),
					'6'		  => esc_html__( '6 Columns', 'grogin-core' ),
				],
			]
		);
		
        $this->add_control( 'order',
            [
                'label' => esc_html__( 'Select Order', 'grogin-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__( 'Ascending', 'grogin-core' ),
                    'DESC' => esc_html__( 'Descending', 'grogin-core' )
                ],
                'default' => 'ASC'
            ]
        );
		
        $this->add_control( 'orderby',
            [
                'label' => esc_html__( 'Order By', 'grogin-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'id' => esc_html__( 'Post ID', 'grogin-core' ),
                    'menu_order' => esc_html__( 'Menu Order', 'grogin-core' ),
                    'rand' => esc_html__( 'Random', 'grogin-core' ),
                    'date' => esc_html__( 'Date', 'grogin-core' ),
                    'title' => esc_html__( 'Title', 'grogin-core' ),
                ],
                'default' => 'title',
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$terms = get_terms( array(
		  'taxonomy'   => 'product_brand',
		  'hide_empty' => $settings['hide_empty'],
		  'orderby'    => $settings['orderby'],
		  'order'      => $settings['order'],
		) );

		$groups = array();
		foreach ( $terms as $t ) {
		  $name = $t->name;
		  
		  $first = mb_substr( trim($name), 0, 1, 'UTF-8' );

		  $map = array('Ç'=>'C','Ğ'=>'G','İ'=>'I','I'=>'I','Ö'=>'O','Ş'=>'S','Ü'=>'U',
					   'ç'=>'C','ğ'=>'G','ı'=>'I','i'=>'I','ö'=>'O','ş'=>'S','ü'=>'U');
		  $first = strtr($first, $map);

		  $first = mb_strtoupper($first, 'UTF-8');

		  if ( ! preg_match('/[A-Z]/', $first) ) {
			$first = '#';
		  }

		  if ( ! isset($groups[$first]) ) $groups[$first] = array();
		  $groups[$first][] = $t;
		}

		ksort($groups);

		echo '<div class="klb-brand-section" style="--brand-cols: '.esc_attr($settings['column']).'">';
		
		echo '<div class="product-header">';
		if($settings['column']){
			echo '<h3 class="entry-title">'.esc_html($settings['title']).'</h3>';
		}
		if($settings['letter_nav']) {
			echo '<div class="klb-brand-section__nav">';
			foreach (array_merge(range('A','Z'), array('#')) as $L){
				if ( isset($groups[$L]) ){
					echo '<a href="#brand-letter-'.esc_attr($L).'">'.esc_html($L).'</a>';
				} else {
					echo '<span class="disabled">'.esc_html($L).'</span>';
				}
			}
			echo '</div>';
		}
		echo '</div>';
		foreach ( $groups as $letter => $items ){
			echo '<section class="brand-group" id="brand-letter-'.esc_attr($letter).'">';
			echo '<h2 class="brand-letter">'.esc_html($letter).'</h2>';
			echo '<ul class="brand-list">';
			foreach ( $items as $term ){
				$link = get_term_link( $term );
				echo '<li class="brand-item">';
				echo '<a href="'.esc_url($link).'">'.esc_html($term->name).'</a>';
				echo '<span class="brand-count">('.esc_html($term->count).')</span>';
				echo '</li>';
			}
			echo '</ul>';
			echo '</section>';
		}
		echo '</div>';
		
	}

}
