<?php

namespace Elementor;

class Grogin_Text_List_Widget extends Widget_Base {

    public function get_name() {
        return 'grogin-text-list';
    }
    public function get_title() {
        return 'Text List (K)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'grogin' ];
    }

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', 'grogin-core' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control( 'title',
            [
                'label' => esc_html__( 'Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Bread & Rolls',
                'pleaceholder' => esc_html__( 'Enter item title here.', 'grogin-core' )
            ]
        );
		
		$repeater = new Repeater();

        $repeater->add_control( 'subtitle',
            [
                'label' => esc_html__( 'Title', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'White Sliced Bread',
                'pleaceholder' => esc_html__( 'Enter item title here.', 'grogin-core' )
            ]
        );
		
		$repeater->add_control(
			'switcher_icon',
			[
				'label' => esc_html__( 'Use Custom Icon', 'grogin-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'grogin-core' ),
				'label_off' => esc_html__( 'No', 'grogin-core' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);
		
		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'grogin-core' ),
				'type' => Controls_Manager::ICONS,
				'default' => [],
                'label_block' => true,
				'condition' => ['switcher_icon' => '']
			]
		);
		
        $repeater->add_control( 'custom_icon',
            [
                'label' => esc_html__( 'Custom Icon', 'grogin-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'klb-ecommerce-icon-discount-bold',
                'description'=> 'You can add icon code. for example: klb-ecommerce-icon-discount-bold',
				'condition' => ['switcher_icon' => 'yes']
            ]
        );
		
		$repeater->add_control( 'menu_link',
            [
                'label' => esc_html__( 'Link', 'chakta' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => esc_html__( 'Place URL here', 'chakta' )
            ]
        );
		
		$this->add_control( 'menu_items',
            [
                'label' => esc_html__( 'Items', 'grogin-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [	
						'switcher_icon' => '',
						'custom_icon' => '',
                        'subtitle' => 'White Sliced Bread',
						'menu_link' => '#',

                    ],
                    [
						'switcher_icon' => '',
						'custom_icon' => '',
                        'subtitle' => 'White Bread',
						'menu_link' => '#',
                    ],
                    [
						'switcher_icon' => '',
						'custom_icon' => '',
                        'subtitle' => 'Buns & Rolls',
						'menu_link' => '#',
                    ],
					[
						'switcher_icon' => '',
						'custom_icon' => '',
                        'subtitle' => 'Sandwich Bread',
						'menu_link' => '#',
                    ],

                ]
            ]
        );
		
		$this->end_controls_section();
		/*****   END CONTROLS SECTION   ******/
		
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		
		if ( $settings['menu_items'] ) {	
			echo '<div class="mega-menu-wrapper">';
			echo '<div class="mega-grouped-items mega-sub-list">';
			echo '<div class="mega-grouped-label">'.esc_html($settings['title']).'</div>';
			echo '<ul class="sub-menu-list">';
			
			foreach ( $settings['menu_items'] as $item ) {
				$target = $item['menu_link']['is_external'] ? ' target="_blank"' : '';
				$nofollow = $item['menu_link']['nofollow'] ? ' rel="nofollow"' : '';
				
				echo '<li>';
				if($item['switcher_icon'] == 'yes'){
					echo '<i class="'.esc_attr($item['custom_icon']).'"></i>';
				} else {
					Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'false' ] );						
				}  
				echo '<a href="'.esc_url($item['menu_link']['url']).'" '.esc_attr($target.$nofollow).'>'.esc_html($item['subtitle']).'</a>';
				echo '</li>';	
			}
			
			echo '</ul>';
			echo '</div>';
			echo '</div>';
			
		}
	}

}
