<?php

/*************************************************
## Scripts
*************************************************/
function grogin_coupon_popup_scripts() {
	wp_register_style( 'klb-coupon-popup',   plugins_url( 'css/coupon-banner-popup.css', __FILE__ ), false, '1.0');
	wp_register_script( 'klb-coupon-popup',  plugins_url( 'js/coupon-banner-popup.js', __FILE__ ), true );

}
add_action( 'wp_enqueue_scripts', 'grogin_coupon_popup_scripts' );

add_action('wp_footer', 'grogin_coupon_popup'); 
function grogin_coupon_popup() { 

	if ( ! apply_filters( 'grogin_coupon_popup', true ) ) {
		return;
	}

	if(get_theme_mod('grogin_coupon_banner_popup_toggle',0) == 1){
		wp_enqueue_script('jquery-cookie');
		wp_enqueue_script('klb-coupon-popup');
		wp_enqueue_style('klb-coupon-popup');

		$couponpopup  = isset( $_COOKIE['coupon-popup-visible'] ) ? $_COOKIE['coupon-popup-visible'] : 'hide';
		
		if($couponpopup == 'disable'){
			return;
		}

		?>
		
		  <div id="coupon-popup" class="klb-site-coupon" style="opacity:0;" data-expires="<?php echo esc_attr(get_theme_mod('grogin_coupon_banner_popup_expire_date')); ?>">
			<div class="coupon-wrapper">
			<?php if (get_theme_mod( 'grogin_coupon_banner_image' )) { ?>
				<div class="coupon-image">
					<img src="<?php echo esc_url( wp_get_attachment_url(get_theme_mod( 'grogin_coupon_banner_image' )) ); ?>">
				</div>
			<?php } ?>
			  <div class="coupon-inner">

				<div class="coupon-close">
				  <i class="klb-icon-x"></i>
				</div><!-- coupon-close -->

				<h5 class="entry-title"><?php echo esc_html(get_theme_mod('grogin_coupon_banner_popup_title')); ?></h5>

				<div class="entry-desc">
				  <p><?php echo grogin_sanitize_data(get_theme_mod('grogin_coupon_banner_popup_subtitle')); ?></p>
				</div><!-- entry-desc -->

				<div class="copy-url">
				  <p class="text-12 text-gray-500"><?php esc_html_e('Click below to get your coupon code','grogin-core'); ?></p>
				  <div class="site-url">
					<span class="url text-12"><?php echo esc_html(get_theme_mod('grogin_coupon_banner_popup_code')); ?></span>
					<span class="copy-text"><span class="copy"><?php esc_html_e('COPY','grogin-core'); ?></span><span class="copied d-none"><?php esc_html_e('COPIED','grogin-core'); ?></span></span>
				  </div><!-- site-url -->
				</div>
				
				<p>
					<label class="form-checkbox privacy_policy">
						<input type="checkbox" name="dontshow" class="dontshow" value="1">
						<span><?php esc_html_e('Don\'t show this popup again.','grogin-core'); ?></span>
					</label>
				</p>


			  </div><!-- coupon-inner -->
			  <div class="coupon-popup-overlay"></div>
			</div><!-- coupon-wrapper -->
			
		  </div><!-- klb-site-coupon -->

		<?php
	}
}