(function ($) {
  "use strict";
  
	var win = $( window );
	var body = $( 'body' );
	var popup = $( '.klb-site-coupon' ),		
	popupClose = $( '.klb-site-coupon .coupon-close, .klb-site-coupon .button-close' ),
	popupExpires = popup.data( 'expires' ),
	popupOverlay = $( '.coupon-popup-overlay' );
	

	if (!( Cookies.get( 'coupon-popup-visible' ) ) ) {
		win.on( 'load', function() {
			body.addClass( 'coupon-banner-popup-visible' );
		});
	}

	$(".klb-site-coupon .dontshow").click(function() {
		if ($(this).is(":checked")) {
			Cookies.set( 'coupon-popup-visible', 'disable', { expires: popupExpires, path: '/' });
		} else {
			Cookies.remove('coupon-popup-visible')
		}
	});

	popupClose.on('click', function(){
		body.removeClass( 'coupon-banner-popup-visible' );
		return false;
	});
	
	popupOverlay.on('click', function(){
		body.removeClass( 'coupon-banner-popup-visible' );
		return false;
	});
	
	
    const socialHolder = document.querySelector('.klb-site-coupon');

      if (socialHolder !== null) {
        const urlHolder = socialHolder.querySelector('.site-url');
        const urlText = urlHolder.querySelector('.url').innerHTML;
        const copyText = urlHolder.querySelector('.copy-text .copy');
        const copiedText = urlHolder.querySelector('.copy-text .copied');
        const closeButton = socialHolder.querySelector('.close-button');
        const urlHolderOverlay = socialHolder.querySelector('.share-buttons-overlay');

        const copyContent = async() => {
          try {
            await navigator.clipboard.writeText(urlText);
            copyText.classList.add('d-none');
            copiedText.classList.remove('d-none');
            setTimeout(() => {
              copyText.classList.remove('d-none');
              copiedText.classList.add('d-none');
            }, 700)
          } catch (err) {
            console.error('Failed to copy: ', err);
          }
        }

        urlHolder.addEventListener('click', copyContent);
        
    }

}(jQuery));
