<?php
/*======
*
* Kirki Settings
*
======*/
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Kirki' ) ) {
	return;
}

Kirki::add_config(
	'grogin_customizer', array(
		'capability'  => 'edit_theme_options',
		'option_type' => 'theme_mod',
	)
);

/*======
*
* Sections
*
======*/
$sections = array(
	'shop_settings' => array (
		esc_attr__( 'Shop Settings', 'grogin-core' ),
		esc_attr__( 'You can customize the shop settings.', 'grogin-core' ),
	),
	
	'blog_settings' => array (
		esc_attr__( 'Blog Settings', 'grogin-core' ),
		esc_attr__( 'You can customize the blog settings.', 'grogin-core' ),
	),

	'header_settings' => array (
		esc_attr__( 'Header Settings', 'grogin-core' ),
		esc_attr__( 'You can customize the header settings.', 'grogin-core' ),
	),

	'main_color' => array (
		esc_attr__( 'Main Color', 'grogin-core' ),
		esc_attr__( 'You can customize the main color.', 'grogin-core' ),
	),

	'elementor_templates' => array (
		esc_attr__( 'Elementor Templates', 'grogin-core' ),
		esc_attr__( 'You can customize the elementor templates.', 'grogin-core' ),
	),
	
	'map_settings' => array (
		esc_attr__( 'Map Settings', 'grogin-core' ),
		esc_attr__( 'You can customize the map settings.', 'grogin-core' ),
	),

	'footer_settings' => array (
		esc_attr__( 'Footer Settings', 'grogin-core' ),
		esc_attr__( 'You can customize the footer settings.', 'grogin-core' ),
	),
	
	'grogin_widgets' => array (
		esc_attr__( 'Grogin Widgets', 'grogin-core' ),
		esc_attr__( 'You can customize the grogin widgets.', 'grogin-core' ),
	),

	'gdpr_settings' => array (
		esc_attr__( 'GDPR Settings', 'grogin-core' ),
		esc_attr__( 'You can customize the GDPR settings.', 'grogin-core' ),
	),

	'newsletter_settings' => array (
		esc_attr__( 'Newsletter Settings', 'grogin-core' ),
		esc_attr__( 'You can customize the Newsletter Popup settings.', 'grogin-core' ),
	),
	
	'maintenance_settings' => array (
		esc_attr__( 'Maintenance Settings', 'grogin-core' ),
		esc_attr__( 'You can customize the Maintenance settings.', 'grogin-core' ),
	),
	
	'typography_settings' => array (
		esc_attr__( 'Grogin Typography', 'grogin-core' ),
		esc_attr__( 'You can customize the Typography settings.', 'grogin-core' ),
	),
	
	'other_settings' => array (
		esc_attr__( 'Other', 'grogin-core' ),
		esc_attr__( 'You can customize the other settings.', 'grogin-core' ),
	),
	
	'coupon_banner_popup' => array (
		esc_attr__( 'Coupon Banner Settings', 'grogin-core' ),
		esc_attr__( 'You can customize the Coupon Banner Popup settings.', 'grogin-core' ),
	),
);

foreach ( $sections as $section_id => $section ) {
	$section_args = array(
		'title' => $section[0],
		'description' => $section[1],
	);

	if ( isset( $section[2] ) ) {
		$section_args['type'] = $section[2];
	}

	if( $section_id == "colors" ) {
		Kirki::add_section( str_replace( '-', '_', $section_id ), $section_args );
	} else {
		Kirki::add_section( 'grogin_' . str_replace( '-', '_', $section_id ) . '_section', $section_args );
	}
}


/*======
*
* Fields
*
======*/
function grogin_customizer_add_field ( $args ) {
	Kirki::add_field(
		'grogin_customizer',
		$args
	);
}

	/*====== Header ==================================================================================*/
		/*====== Header Panels ======*/
		Kirki::add_panel (
			'grogin_header_panel',
			array(
				'title' => esc_html__( 'Header Settings', 'grogin-core' ),
				'description' => esc_html__( 'You can customize the header from this panel.', 'grogin-core' ),
			)
		);

		$sections = array (
			'header_logo' => array(
				esc_attr__( 'Logo', 'grogin-core' ),
				esc_attr__( 'You can customize the logo which is on header..', 'grogin-core' )
			),
		
			'header_general' => array(
				esc_attr__( 'Header General', 'grogin-core' ),
				esc_attr__( 'You can customize the header.', 'grogin-core' )
			),
			
			'header_product_tab' => array(
				esc_attr__( 'Header Products Tab', 'grogin-core' ),
				esc_attr__( 'You can customize the header products tab.', 'grogin-core' )
			),
			
			'header_product_tab2' => array(
				esc_attr__( 'Header Products Tab 2', 'grogin-core' ),
				esc_attr__( 'You can customize the header products tab 2.', 'grogin-core' )
			),
			
			'header_search' => array(
				esc_attr__( 'Header Search', 'grogin-core' ),
				esc_attr__( 'You can customize the loader.', 'grogin-core' )
			),
			
			'header_notification' => array(
				esc_attr__( 'Header Notification', 'grogin-core' ),
				esc_attr__( 'You can customize the header notification.', 'grogin-core' )
			),

			'canvas_menu' => array(
				esc_attr__( 'Canvas Menu Contact Box', 'grogin-core' ),
				esc_attr__( 'You can customize the canvas menu contact box.', 'grogin-core' )
			),

			'header_preloader' => array(
				esc_attr__( 'Preloader', 'grogin-core' ),
				esc_attr__( 'You can customize the loader.', 'grogin-core' )
			),
			
			'header1_style' => array(
				esc_attr__( 'Header 1 Style', 'grogin-core' ),
				esc_attr__( 'You can customize the style.', 'grogin-core' )
			),
			
			'header2_style' => array(
				esc_attr__( 'Header 2 Style', 'grogin-core' ),
				esc_attr__( 'You can customize the style.', 'grogin-core' )
			),
			
			'header3_style' => array(
				esc_attr__( 'Header 3 Style', 'grogin-core' ),
				esc_attr__( 'You can customize the style.', 'grogin-core' )
			),
			
			'header4_style' => array(
				esc_attr__( 'Header 4 Style', 'grogin-core' ),
				esc_attr__( 'You can customize the style.', 'grogin-core' )
			),
			
			'header5_style' => array(
				esc_attr__( 'Header 5 Style', 'grogin-core' ),
				esc_attr__( 'You can customize the style.', 'grogin-core' )
			),
			
			'mini_cart_style' => array(
				esc_attr__( 'Mini Cart Style', 'grogin-core' ),
				esc_attr__( 'You can customize the mini cart style settings.', 'grogin-core' )
			),
			
		);

		foreach ( $sections as $section_id => $section ) {
			$section_args = array(
				'title' => $section[0],
				'description' => $section[1],
				'panel' => 'grogin_header_panel',
			);

			if ( isset( $section[2] ) ) {
				$section_args['type'] = $section[2];
			}

			Kirki::add_section( 'grogin_' . str_replace( '-', '_', $section_id ) . '_section', $section_args );
		}
		
		/*====== Logo ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'image',
				'settings' => 'grogin_logo',
				'label' => esc_attr__( 'Logo', 'grogin-core' ),
				'description' => esc_attr__( 'You can upload a logo.', 'grogin-core' ),
				'section' => 'grogin_header_logo_section',
				'choices' => array(
					'save_as' => 'id',
				),
			)
		);
		
		/*====== Logo White======*/
		grogin_customizer_add_field (
			array(
				'type' => 'image',
				'settings' => 'grogin_logo_white',
				'label' => esc_attr__( 'Logo White', 'grogin-core' ),
				'description' => esc_attr__( 'You can upload a logo white.', 'grogin-core' ),
				'section' => 'grogin_header_logo_section',
				'choices' => array(
					'save_as' => 'id',
				),
			)
		);
		
		/*====== Logo Text ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_logo_text',
				'label' => esc_attr__( 'Set Logo Text', 'grogin-core' ),
				'description' => esc_attr__( 'You can set logo as text.', 'grogin-core' ),
				'section' => 'grogin_header_logo_section',
				'default' => 'Grogin',
			)
		);

		/*====== Logo Size ======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'slider',
				'settings'    => 'grogin_logo_size',
				'label'       => esc_html__( 'Logo Size', 'grogin-core' ),
				'description' => esc_attr__( 'You can set size of the logo.', 'grogin-core' ),
				'section'     => 'grogin_header_logo_section',
				'default'     => '34',
				'transport'   => 'auto',
				'choices'     => [
					'min'  => 5,
					'max'  => 100,
					'step' => 1,
				],
			)
		);
		
		/*====== Mobil Logo Size ======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'slider',
				'settings'    => 'grogin_mobil_logo_size',
				'label'       => esc_html__( 'Mobile Logo Size', 'grogin-core' ),
				'description' => esc_attr__( 'You can set size of the mobil logo.', 'grogin-core' ),
				'section'     => 'grogin_header_logo_section',
				'default'     => '30',
				'transport'   => 'auto',
				'choices'     => [
					'min'  => 5,
					'max'  => 100,
					'step' => 1,
				],
			)
		);
		
		/*====== Header Type ======*/
		grogin_customizer_add_field(
			array (
				'type'        => 'select',
				'settings'    => 'grogin_header_type',
				'label'       => esc_html__( 'Header Type', 'grogin-core' ),
				'section'     => 'grogin_header_general_section',
				'default'     => 'type1',
				'priority'    => 10,
				'choices'     => array(
					'type1' => esc_attr__( 'Type 1', 'grogin-core' ),
					'type2' => esc_attr__( 'Type 2', 'grogin-core' ),
					'type3' => esc_attr__( 'Type 3', 'grogin-core' ),
					'type4' => esc_attr__( 'Type 4', 'grogin-core' ),
					'type5' => esc_attr__( 'Type 5', 'grogin-core' ),
				) 
			) 
		);

		/*====== Middle Sticky Header Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_sticky_header',
				'label' => esc_attr__( 'Sticky Header', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of the header.', 'grogin-core' ),
				'section' => 'grogin_header_general_section',
				'default' => '0',
			)
		);

		/*====== Mobile Sticky Header Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_mobile_sticky_header',
				'label' => esc_attr__( 'Mobile Sticky Header', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of the header on the mobile.', 'grogin-core' ),
				'section' => 'grogin_header_general_section',
				'default' => '0',
			)
		);
		
		/*====== Location Filter Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_location_filter',
				'label' => esc_attr__( 'Location Filter', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of the location filter on the header.', 'grogin-core' ),
				'section' => 'grogin_header_general_section',
				'default' => '0',
			)
		);
		
		/*====== Header Account Icon ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_account',
				'label' => esc_attr__( 'Account Icon / Login', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable User Login/Signup on the header.', 'grogin-core' ),
				'section' => 'grogin_header_general_section',
				'default' => '0',
			)
		);
		
		/*====== Header Popup Login ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_popup_login',
				'label' => esc_attr__( 'Popup Login?', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable the popup login on the header.', 'grogin-core' ),
				'section' => 'grogin_header_general_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_account',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Popup Login Image======*/
		grogin_customizer_add_field (
			array(
				'type' => 'image',
				'settings' => 'grogin_header_popup_login_image',
				'label' => esc_attr__( 'Popup Login Image', 'grogin-core' ),
				'description' => esc_attr__( 'You can upload an image.', 'grogin-core' ),
				'section' => 'grogin_header_general_section',
				'choices' => array(
					'save_as' => 'id',
				),
				'required' => array(
					array(
					  'setting'  => 'grogin_header_popup_login',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Cart Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_cart',
				'label' => esc_attr__( 'Header Cart', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of the mini cart on the header.', 'grogin-core' ),
				'section' => 'grogin_header_general_section',
				'default' => '0',
			)
		);
		
		/*====== Header Mini Cart Type ======*/
		grogin_customizer_add_field(
			array (
			'type'        => 'radio-buttonset',
			'settings'    => 'grogin_header_mini_cart_type',
			'label'       => esc_html__( 'Mini Cart Type', 'grogin-core' ),
			'section'     => 'grogin_header_general_section',
			'default'     => 'default',
			'priority'    => 10,
			'choices'     => array(
				'sidecart' => esc_attr__( 'Side Cart', 'grogin-core' ),
				'default' => esc_attr__( 'Default', 'grogin-core' ),
			),
			'required' => array(
				array(
				  'setting'  => 'grogin_header_cart',
				  'operator' => '==',
				  'value'    => '1',
				),
			),
			) 
		);
		
		/*====== Header Mini Cart Notice ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_header_mini_cart_notice',
				'label' => esc_attr__( 'Mini Cart Notice', 'grogin-core' ),
				'description' => esc_attr__( 'You can add a text for the mini cart.', 'grogin-core' ),
				'section' => 'grogin_header_general_section',
				'default' => '',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_cart',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Sidebar ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_sidebar',
				'label' => esc_attr__( 'Sidebar Menu', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable Sidebar Menu', 'grogin-core' ),
				'section' => 'grogin_header_general_section',
				'default' => '0',
			)
		);

		/*====== Header Sidebar Collapse ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_sidebar_collapse',
				'label' => esc_attr__( 'Disable Collapse on Frontpage', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable Sidebar Collapse on Home Page.', 'grogin-core' ),
				'section' => 'grogin_header_general_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_sidebar',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Top Left Menu Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_top_left_menu',
				'label' => esc_attr__( 'Top Left Menu', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable the top left menu.', 'grogin-core' ),
				'section' => 'grogin_header_general_section',
				'default' => '0',
			)
		);
		
		/*====== Top Right Menu Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_top_right_menu',
				'label' => esc_attr__( 'Top Right Menu', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable the top right menu.', 'grogin-core' ),
				'section' => 'grogin_header_general_section',
				'default' => '0',
			)
		);
		
		/*====== Categories Popup Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_categories_popup',
				'label' => esc_attr__( 'Categories Popup', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable the categories popup.', 'grogin-core' ),
				'section' => 'grogin_header_general_section',
				'default' => '0',
			)
		);
		
		/*====== Header Products Tab Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_products_tab',
				'label' => esc_attr__( 'Products Tab', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable Products Tab', 'grogin-core' ),
				'section' => 'grogin_header_product_tab_section',
				'default' => '0',
			)
		);
		
		/*====== Header Products Tab Button Title ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_header_products_button_title',
				'label' => esc_attr__( 'Button Title', 'grogin-core' ),
				'description' => esc_attr__( 'You can add a text for the button.', 'grogin-core' ),
				'section' => 'grogin_header_product_tab_section',
				'default' => 'Almost Finished <span class="badge gradient-red">SALE</span>',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Products Tab Title ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_header_products_tab_title',
				'label' => esc_attr__( 'Tab Title', 'grogin-core' ),
				'description' => esc_attr__( 'You can add a title for the tab.', 'grogin-core' ),
				'section' => 'grogin_header_product_tab_section',
				'default' => 'Soon stocks will run out',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Products Tab Subtitle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_header_products_tab_subtitle',
				'label' => esc_attr__( 'Tab Subtitle', 'grogin-core' ),
				'description' => esc_attr__( 'You can add a subtitle for the tab.', 'grogin-core' ),
				'section' => 'grogin_header_product_tab_section',
				'default' => 'Dont miss this opportunity while supplies last.',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Products Tab On Sale ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_products_tab_on_sale',
				'label' => esc_attr__( 'On Sale Products?', 'grogin-core' ),
				'section' => 'grogin_header_product_tab_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Products Tab Featured ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_products_tab_featured',
				'label' => esc_attr__( 'Featured Products?', 'grogin-core' ),
				'section' => 'grogin_header_product_tab_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Products Tab Best Selling ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_products_tab_best_selling',
				'label' => esc_attr__( 'Best Selling Products?', 'grogin-core' ),
				'section' => 'grogin_header_product_tab_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);

		/*====== Header Products Tab Hide Out of Stock ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_products_tab_hide_out_of_stock_items',
				'label' => esc_attr__( 'Hide Out of Stock Items?', 'grogin-core' ),
				'section' => 'grogin_header_product_tab_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab2',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Products Tab Post count ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_header_products_tab_post_count',
				'label' => esc_attr__( 'Posts Count', 'grogin-core' ),
				'section' => 'grogin_header_product_tab_section',
				'default' => '6',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Products Tab 2 Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_products_tab2',
				'label' => esc_attr__( 'Products Tab 2', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable Products Tab', 'grogin-core' ),
				'section' => 'grogin_header_product_tab2_section',
				'default' => '0',
			)
		);
		
		/*====== Header Products Tab 2 Button Title ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_header_products2_button_title',
				'label' => esc_attr__( 'Button Title', 'grogin-core' ),
				'description' => esc_attr__( 'You can add a text for the button.', 'grogin-core' ),
				'section' => 'grogin_header_product_tab2_section',
				'default' => 'Trending Products',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab2',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Products Tab 2 Title ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_header_products_tab2_title',
				'label' => esc_attr__( 'Tab Title', 'grogin-core' ),
				'description' => esc_attr__( 'You can add a title for the tab.', 'grogin-core' ),
				'section' => 'grogin_header_product_tab2_section',
				'default' => 'Soon stocks will run out',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab2',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Products Tab 2 Subtitle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_header_products_tab2_subtitle',
				'label' => esc_attr__( 'Tab Subtitle', 'grogin-core' ),
				'description' => esc_attr__( 'You can add a subtitle for the tab.', 'grogin-core' ),
				'section' => 'grogin_header_product_tab2_section',
				'default' => 'Dont miss this opportunity while supplies last.',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab2',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Products Tab 2 On Sale ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_products_tab2_on_sale',
				'label' => esc_attr__( 'On Sale Products?', 'grogin-core' ),
				'section' => 'grogin_header_product_tab2_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab2',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Products Tab 2 Featured ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_products_tab2_featured',
				'label' => esc_attr__( 'Featured Products?', 'grogin-core' ),
				'section' => 'grogin_header_product_tab2_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab2',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);

		/*====== Header Products Tab 2 Best Selling ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_products_tab2_best_selling',
				'label' => esc_attr__( 'Best Selling Products?', 'grogin-core' ),
				'section' => 'grogin_header_product_tab2_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab2',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);

		/*====== Header Products Tab 2 Hide Out of Stock ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_products_tab2_hide_out_of_stock_items',
				'label' => esc_attr__( 'Hide Out of Stock Items?', 'grogin-core' ),
				'section' => 'grogin_header_product_tab2_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab2',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Products Tab 2 Post count ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_header_products_tab2_post_count',
				'label' => esc_attr__( 'Posts Count', 'grogin-core' ),
				'section' => 'grogin_header_product_tab2_section',
				'default' => '6',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_products_tab2',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Search Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_search',
				'label' => esc_attr__( 'Header Search', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of the search on the header.', 'grogin-core' ),
				'section' => 'grogin_header_search_section',
				'default' => '0',
			)
		);
		
		/*====== Header Search Type ======*/
		grogin_customizer_add_field(
			array (
				'type'        => 'select',
				'settings'    => 'grogin_header_search_type',
				'label'       => esc_html__( 'Header Search Type', 'grogin-core' ),
				'section'     => 'grogin_header_search_section',
				'default'     => 'type1',
				'choices'     => array(
					'type1' => esc_attr__( 'Type 1', 'grogin-core' ),
					'type2' => esc_attr__( 'Type 2', 'grogin-core' ),
				),
				'required' => array(
					array(
					  'setting'  => 'grogin_header_search',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			) 
		);
		
		/*====== Ajax Search Form ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_ajax_search_form',
				'label' => esc_attr__( 'Ajax Search Form', 'grogin-core' ),
				'description' => esc_attr__( 'Enable ajax search form for the header search.', 'grogin-core' ),
				'section' => 'grogin_header_search_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_header_search',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Top Notification Text Toggle======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_top_notification_toggle',
				'label' => esc_attr__( 'Top Notification', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of the notification on the header.', 'grogin-core' ),
				'section' => 'grogin_header_notification_section',
				'default' => '0',
			)
		);
		
		/*====== Top Notification Content ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'textarea',
				'settings' => 'grogin_top_notification_content',
				'label' => esc_attr__( 'Top Notification Content', 'grogin-core' ),
				'description' => esc_attr__( 'You can add a text for the notification content.', 'grogin-core' ),
				'section' => 'grogin_header_notification_section',
				'default' => 'We deliver to you every day from <strong class="text-orange-600">7:00 to 23:00</strong>',
				'required' => array(
					array(
					  'setting'  => 'grogin_top_notification_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Top Notification Count Toggle======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_top_notification_count_toggle',
				'label' => esc_attr__( 'Top Notification Count', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of the notification count on the header.', 'grogin-core' ),
				'section' => 'grogin_header_notification_section',
				'default' => '0',
			)
		);
		
		/*====== Top Notification Count Title ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'textarea',
				'settings' => 'grogin_top_notification_count_title',
				'label' => esc_attr__( 'Top Notification Count Title', 'grogin-core' ),
				'description' => esc_attr__( 'You can add a text for the notification count.', 'grogin-core' ),
				'section' => 'grogin_header_notification_section',
				'default' => 'FREE delivery & 40% Discount for next 3 orders! Place your 1st order in.',
				'active_callback' => [
					[
					  'setting'  => 'grogin_top_notification_count_toggle',
					  'operator' => '==',
					  'value'    => '1',
					],
				],
			)
		);
		
		/*====== Top Notification Count Description ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'textarea',
				'settings' => 'grogin_top_notification_count_desc',
				'label' => esc_attr__( 'Top Notification Count Description', 'grogin-core' ),
				'description' => esc_attr__( 'You can add a text for the notification count.', 'grogin-core' ),
				'section' => 'grogin_header_notification_section',
				'default' => 'Until the end of the sale:',
				'active_callback' => [
					[
					  'setting'  => 'grogin_top_notification_count_toggle',
					  'operator' => '==',
					  'value'    => '1',
					],
				],
			)
		);
		
		/*====== Top Notification Count Date ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'date',
				'settings' => 'grogin_top_notification_count_date',
				'label' => esc_attr__( 'Top Notification Count Date', 'grogin-core' ),
				'description' => esc_attr__( 'You can add a date for the notification count.', 'grogin-core' ),
				'section' => 'grogin_header_notification_section',
				'default' => '',
				'active_callback' => [
					[
					  'setting'  => 'grogin_top_notification_count_toggle',
					  'operator' => '==',
					  'value'    => '1',
					],
				],
			)
		);
		
		/*====== Top Notification Count Date Image======*/
		grogin_customizer_add_field (
			array(
				'type' => 'image',
				'settings' => 'grogin_top_notification_count_date_image',
				'label' => esc_attr__( 'Top Notification Count Date Image', 'grogin-core' ),
				'description' => esc_attr__( 'You can upload an image.', 'grogin-core' ),
				'section' => 'grogin_header_notification_section',
				'choices' => array(
					'save_as' => 'id',
				),
				'active_callback' => [
					[
					  'setting'  => 'grogin_top_notification_count_toggle',
					  'operator' => '==',
					  'value'    => '1',
					],
				],
			)
		);
		
		/*====== Top Notification Count Date Background Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#634C9F',
				'settings' => 'grogin_top_notification_count_date_bg_color',
				'label' => esc_attr__( 'Top Notification Count Date Background Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
				'priority'    => 15,
				'section' => 'grogin_header_notification_section',
				'choices'     => [
					'alpha' => true,
				],
				'active_callback' => [
					[
					  'setting'  => 'grogin_top_notification_count_toggle',
					  'operator' => '==',
					  'value'    => '1',
					],
				],
			)
		);	
		
		/*====== Top Notification Count Date Font Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#FFF',
				'settings' => 'grogin_top_notification_count_date_font_color',
				'label' => esc_attr__( 'Top Notification Count Date Font Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
				'priority'    => 15,
				'section' => 'grogin_header_notification_section',
				'choices'     => [
					'alpha' => true,
				],
				'active_callback' => [
					[
					  'setting'  => 'grogin_top_notification_count_toggle',
					  'operator' => '==',
					  'value'    => '1',
					],
				],
			)
		);
		
		/*====== Canvas Bottom Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_canvas_bottom_menu',
				'label' => esc_attr__( 'Canvas Bottom Menu', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable the canvas bottom menu.', 'grogin-core' ),
				'section' => 'grogin_canvas_menu_section',
				'default' => '0',
			)
		);
		
		/*====== Canvas Bottom Menu Title ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_canvas_bottom_menu_title',
				'label' => esc_attr__( 'Canvas Bottom Menu Title', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a title.', 'grogin-core' ),
				'section' => 'grogin_canvas_menu_section',
				'default' => '',
				'active_callback' => [
					[
					  'setting'  => 'grogin_canvas_bottom_menu',
					  'operator' => '==',
					  'value'    => '1',
					],
				],
			)
		);

		/*====== Canvas Menu Contact Box Title ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_canvas_menu_contact_title',
				'label' => esc_attr__( 'Contact Title', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a title.', 'grogin-core' ),
				'section' => 'grogin_canvas_menu_section',
				'default' => '',
			)
		);
		
		/*====== Canvas Menu Contact Box ======*/
		new \Kirki\Field\Repeater(
			array(
				'settings' => 'grogin_canvas_menu_contact_box',
				'label' => esc_attr__( 'Contact Box', 'grogin-core' ),
				'description' => esc_attr__( 'You can set the contact box.', 'grogin-core' ),
				'section' => 'grogin_canvas_menu_section',
				'fields' => array(
					'menu_contact_box_icon' => array(
						'type' => 'text',
						'label' => esc_attr__( 'Icon', 'grogin-core' ),
						'description' => esc_attr__( 'You can set an icon. for example; "klb-icon-phone-call"', 'grogin-core' ),
					),
					'menu_contact_box_title' => array(
						'type' => 'textarea',
						'label' => esc_attr__( ' Title', 'grogin-core' ),
						'description' => esc_attr__( 'You can enter a text.', 'grogin-core' ),
					),
					'menu_contact_box_subtitle' => array(
						'type' => 'text',
						'label' => esc_attr__( 'Subtitle', 'grogin-core' ),
						'description' => esc_attr__( 'You can enter a text.', 'grogin-core' ),
					),
				),
			)
		);

		/*====== PreLoader Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_preloader',
				'label' => esc_attr__( 'Enable Loader', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable the loader.', 'grogin-core' ),
				'section' => 'grogin_header_preloader_section',
				'default' => '0',
			)
		);	
		
	/*====== Header 1 Style ================*/		
			
			/*====== Header 1 Top Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#FFFFFF',
					'settings' => 'grogin_header1_top_bg_color',
					'label' => esc_attr__( 'Header Top Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header1_style_section',
				)
			);	
			
			/*====== Header 1 Top Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#6b7280',
					'settings' => 'grogin_header1_top_font_color',
					'label' => esc_attr__( 'Header Top Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header1_style_section',
				)
			);
			
			/*====== Header 1 Top Font Hover Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header1_top_font_hvrcolor',
					'label' => esc_attr__( 'Header Top Font Hover Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for hover color.', 'grogin-core' ),
					'section' => 'grogin_header1_style_section',
				)
			);
			
			/*====== Header 1 Top Submenu Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header1_top_submenu_font_color',
					'label' => esc_attr__( 'Header Top Submenu Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header1_style_section',
				)
			);
			
			/*====== Header 1 Top Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#e5e7eb',
					'settings' => 'grogin_header1_top_border_color',
					'label' => esc_attr__( 'Header Top Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header1_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);
			
			/*====== Header 1 Main Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#fff',
					'settings' => 'grogin_header1_main_bg_color',
					'label' => esc_attr__( 'Header Main Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header1_style_section',
				)
			);
			
			/*====== Header 1 Main Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header1_main_font_color',
					'label' => esc_attr__( 'Header Main Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header1_style_section',
				)
			);
			
			
			/*====== Header 1 Main Icon Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header1_main_icon_color',
					'label' => esc_attr__( 'Header Main Icon Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header1_style_section',
				)
			);
			
			/*====== Header 1 Bottom Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#fff',
					'settings' => 'grogin_header1_bottom_bg_color',
					'label' => esc_attr__( 'Header Bottom Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header1_style_section',
				)
			);
			
			/*====== Header 1 Bottom Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#e5e7eb',
					'settings' => 'grogin_header1_bottom_border_color',
					'label' => esc_attr__( 'Header Bottom Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header1_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);	
			
			/*====== Header1 Bottom Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header1_bottom_font_color',
					'label' => esc_attr__( 'Header Bottom Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header1_style_section',
				)
			);
			
			
			/*====== Header1 Bottom Font Hover Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#634c9f',
					'settings' => 'grogin_header1_bottom_font_hvrcolor',
					'label' => esc_attr__( 'Header Bottom Font Hover Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header1_style_section',
				)
			);
			
			/*====== Header 1 Bottom Submenu Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#111827',
					'settings' => 'grogin_header1_bottom_submenu_font_color',
					'label' => esc_attr__( 'Header Main Submenu Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header1_style_section',
				)
			);
			
		/*====== Header 2 Style ================*/		
			
			/*====== Header 2 Top Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#FFFFFF',
					'settings' => 'grogin_header2_top_bg_color',
					'label' => esc_attr__( 'Header Top Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
				)
			);	
			
			/*====== Header 2 Top Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#6b7280',
					'settings' => 'grogin_header2_top_font_color',
					'label' => esc_attr__( 'Header Top Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
				)
			);
			
			/*====== Header 2 Top Font Hover Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header2_top_font_hvrcolor',
					'label' => esc_attr__( 'Header Top Font Hover Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for hover color.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
				)
			);
			
			/*====== Header 2 Top Submenu Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header2_top_submenu_font_color',
					'label' => esc_attr__( 'Header Top Submenu Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
				)
			);
			
			/*====== Header 2 Top Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#e5e7eb',
					'settings' => 'grogin_header2_top_border_color',
					'label' => esc_attr__( 'Header Top Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);
			
			/*====== Header 2 Main Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#fff',
					'settings' => 'grogin_header2_main_bg_color',
					'label' => esc_attr__( 'Header Main Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
				)
			);
			
			/*====== Header 2 Main Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#e5e7eb',
					'settings' => 'grogin_header2_main_border_color',
					'label' => esc_attr__( 'Header Main Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);	
			
			/*====== Header 2 Main Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header2_main_font_color',
					'label' => esc_attr__( 'Header Main Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
				)
			);
			
			
			/*====== Header 2 Main Icon Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header2_main_icon_color',
					'label' => esc_attr__( 'Header Main Icon Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
				)
			);
			
			/*====== Header 2 Bottom Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#fff',
					'settings' => 'grogin_header2_bottom_bg_color',
					'label' => esc_attr__( 'Header Bottom Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
				)
			);
			
			/*====== Header 2 Bottom Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#e5e7eb',
					'settings' => 'grogin_header2_bottom_border_color',
					'label' => esc_attr__( 'Header Bottom Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);	
			
			/*====== Header 2 Bottom Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header2_bottom_font_color',
					'label' => esc_attr__( 'Header Bottom Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
				)
			);
			
			
			/*====== Header 2 Bottom Font Hover Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#634c9f',
					'settings' => 'grogin_header2_bottom_font_hvrcolor',
					'label' => esc_attr__( 'Header Bottom Font Hover Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
				)
			);
			
			/*====== Header 2 Bottom Submenu Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#111827',
					'settings' => 'grogin_header2_bottom_submenu_font_color',
					'label' => esc_attr__( 'Header Main Submenu Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header2_style_section',
				)
			);	
			
		/*====== Header 3 Style ================*/		
			
			/*====== Header 3 Top Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#FFFFFF',
					'settings' => 'grogin_header3_top_bg_color',
					'label' => esc_attr__( 'Header Top Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
				)
			);	
			
			/*====== Header 3 Top Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#6b7280',
					'settings' => 'grogin_header3_top_font_color',
					'label' => esc_attr__( 'Header Top Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
				)
			);
			
			/*====== Header 3 Top Font Hover Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header3_top_font_hvrcolor',
					'label' => esc_attr__( 'Header Top Font Hover Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for hover color.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
				)
			);
			
			/*====== Header 3 Top Submenu Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header3_top_submenu_font_color',
					'label' => esc_attr__( 'Header Top Submenu Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
				)
			);
			
			/*====== Header 3 Top Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#e5e7eb',
					'settings' => 'grogin_header3_top_border_color',
					'label' => esc_attr__( 'Header Top Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);
			
			/*====== Header 3 Main Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#fff',
					'settings' => 'grogin_header3_main_bg_color',
					'label' => esc_attr__( 'Header Main Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
				)
			);
			
			/*====== Header 3 Main Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#e5e7eb',
					'settings' => 'grogin_header3_main_border_color',
					'label' => esc_attr__( 'Header Main Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);	
			
			/*====== Header 3 Main Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header3_main_font_color',
					'label' => esc_attr__( 'Header Main Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
				)
			);
			
			
			/*====== Header 3 Main Icon Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header3_main_icon_color',
					'label' => esc_attr__( 'Header Main Icon Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
				)
			);
			
			/*====== Header 3 Bottom Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#fff',
					'settings' => 'grogin_header3_bottom_bg_color',
					'label' => esc_attr__( 'Header Bottom Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
				)
			);
			
			/*====== Header 3 Bottom Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#e5e7eb',
					'settings' => 'grogin_header3_bottom_border_color',
					'label' => esc_attr__( 'Header Bottom Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);	
			
			/*====== Header 3 Bottom Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header3_bottom_font_color',
					'label' => esc_attr__( 'Header Bottom Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
				)
			);
			
			
			/*====== Header 3 Bottom Font Hover Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#634c9f',
					'settings' => 'grogin_header3_bottom_font_hvrcolor',
					'label' => esc_attr__( 'Header Bottom Font Hover Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
				)
			);
			
			/*====== Header 3 Bottom Submenu Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#111827',
					'settings' => 'grogin_header3_bottom_submenu_font_color',
					'label' => esc_attr__( 'Header Main Submenu Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header3_style_section',
				)
			);

		/*====== Header 4 Style ================*/		
			
			/*====== Header 4 Top Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#39245f',
					'settings' => 'grogin_header4_top_bg_color',
					'label' => esc_attr__( 'Header Top Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
				)
			);	
			
			/*====== Header 4 Top Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#f3f4f6',
					'settings' => 'grogin_header4_top_font_color',
					'label' => esc_attr__( 'Header Top Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
				)
			);
			
			/*====== Header 4 Top Font Hover Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#f3f4f6',
					'settings' => 'grogin_header4_top_font_hvrcolor',
					'label' => esc_attr__( 'Header Top Font Hover Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for hover color.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
				)
			);
			
			/*====== Header 4 Top Submenu Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#111827',
					'settings' => 'grogin_header4_top_submenu_font_color',
					'label' => esc_attr__( 'Header Top Submenu Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
				)
			);
			
			/*====== Header 4 Top Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '',
					'settings' => 'grogin_header4_top_border_color',
					'label' => esc_attr__( 'Header Top Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);
			
			/*====== Header 4 Main Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#634c9f',
					'settings' => 'grogin_header4_main_bg_color',
					'label' => esc_attr__( 'Header Main Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
				)
			);
			
			/*====== Header 4 Main Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#dee2e6',
					'settings' => 'grogin_header4_main_border_color',
					'label' => esc_attr__( 'Header Main Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);	
			
			/*====== Header 4 Main Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#f9fafb',
					'settings' => 'grogin_header4_main_font_color',
					'label' => esc_attr__( 'Header Main Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
				)
			);
			
			
			/*====== Header 4 Main Icon Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#f9fafb',
					'settings' => 'grogin_header4_main_icon_color',
					'label' => esc_attr__( 'Header Main Icon Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
				)
			);
			
			/*====== Header 4 Bottom Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#fff',
					'settings' => 'grogin_header4_bottom_bg_color',
					'label' => esc_attr__( 'Header Bottom Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
				)
			);
			
			/*====== Header 4 Bottom Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#e5e7eb',
					'settings' => 'grogin_header4_bottom_border_color',
					'label' => esc_attr__( 'Header Bottom Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);	
			
			/*====== Header 4 Bottom Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header4_bottom_font_color',
					'label' => esc_attr__( 'Header Bottom Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
				)
			);
			
			
			/*====== Header 4 Bottom Font Hover Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#634c9f',
					'settings' => 'grogin_header4_bottom_font_hvrcolor',
					'label' => esc_attr__( 'Header Bottom Font Hover Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
				)
			);
			
			/*====== Header 4 Bottom Submenu Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#111827',
					'settings' => 'grogin_header4_bottom_submenu_font_color',
					'label' => esc_attr__( 'Header Main Submenu Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header4_style_section',
				)
			);	

		/*====== Header 5 Style ================*/		
			
			/*====== Header 5 Top Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#39245f',
					'settings' => 'grogin_header5_top_bg_color',
					'label' => esc_attr__( 'Header Top Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
				)
			);	
			
			/*====== Header 5 Top Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#f3f4f6',
					'settings' => 'grogin_header5_top_font_color',
					'label' => esc_attr__( 'Header Top Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
				)
			);
			
			/*====== Header 5 Top Font Hover Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#f3f4f6',
					'settings' => 'grogin_header5_top_font_hvrcolor',
					'label' => esc_attr__( 'Header Top Font Hover Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for hover color.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
				)
			);
			
			/*====== Header 5 Top Submenu Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#111827',
					'settings' => 'grogin_header5_top_submenu_font_color',
					'label' => esc_attr__( 'Header Top Submenu Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
				)
			);
			
			/*====== Header 5 Top Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '',
					'settings' => 'grogin_header5_top_border_color',
					'label' => esc_attr__( 'Header Top Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);
			
			/*====== Header 5 Main Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#634c9f',
					'settings' => 'grogin_header5_main_bg_color',
					'label' => esc_attr__( 'Header Main Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
				)
			);
			
			/*====== Header 5 Main Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#dee2e6',
					'settings' => 'grogin_header5_main_border_color',
					'label' => esc_attr__( 'Header Main Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);	
			
			/*====== Header 5 Main Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#f9fafb',
					'settings' => 'grogin_header5_main_font_color',
					'label' => esc_attr__( 'Header Main Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
				)
			);
			
			
			/*====== Header 5 Main Icon Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#f9fafb',
					'settings' => 'grogin_header5_main_icon_color',
					'label' => esc_attr__( 'Header Main Icon Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
				)
			);
			
			/*====== Header 5 Bottom Background Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#fff',
					'settings' => 'grogin_header5_bottom_bg_color',
					'label' => esc_attr__( 'Header Bottom Background Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  background.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
				)
			);
			
			/*====== Header 5 Bottom Border Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#e5e7eb',
					'settings' => 'grogin_header5_bottom_border_color',
					'label' => esc_attr__( 'Header Bottom Border Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
					'choices'     => [
						'alpha' => true,
					],
				)
			);	
			
			/*====== Header 5 Bottom Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#030712',
					'settings' => 'grogin_header5_bottom_font_color',
					'label' => esc_attr__( 'Header Bottom Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
				)
			);
			
			
			/*====== Header 5 Bottom Font Hover Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#634c9f',
					'settings' => 'grogin_header5_bottom_font_hvrcolor',
					'label' => esc_attr__( 'Header Bottom Font Hover Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
				)
			);
			
			/*====== Header 5 Bottom Submenu Font Color ======*/
			grogin_customizer_add_field (
				array(
					'type' => 'color',
					'default' => '#111827',
					'settings' => 'grogin_header5_bottom_submenu_font_color',
					'label' => esc_attr__( 'Header Main Submenu Font Color', 'grogin-core' ),
					'description' => esc_attr__( 'You can set a color for  color.', 'grogin-core' ),
					'section' => 'grogin_header5_style_section',
				)
			);			
			
	/*====== Mini Cart Style Settings =======================================================*/
		
		/*====== View cart Button Background Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#fff',
				'settings' => 'grogin_mini_cart_view_cart_button_bg_color',
				'label' => esc_attr__( 'View cart Button Background Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for background.', 'grogin-core' ),
				'section' => 'grogin_mini_cart_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== View cart Button Background Hover Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#f3f4f6',
				'settings' => 'grogin_mini_cart_view_cart_button_bg_hvrcolor',
				'label' => esc_attr__( 'View cart Button Background Hover Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for background.', 'grogin-core' ),
				'section' => 'grogin_mini_cart_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== View cart Button Border Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#9ca3af',
				'settings' => 'grogin_mini_cart_view_cart_border_color',
				'label' => esc_attr__( 'View cart Button Border Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for background.', 'grogin-core' ),
				'section' => 'grogin_mini_cart_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== View cart Button Hover Border Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#9ca3af',
				'settings' => 'grogin_mini_cart_view_cart_border_hvrcolor',
				'label' => esc_attr__( 'View cart Button Hover Border Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for background.', 'grogin-core' ),
				'section' => 'grogin_mini_cart_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== View cart Button Text Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#634c9f',
				'settings' => 'grogin_mini_cart_view_cart_button_text_color',
				'label' => esc_attr__( 'View cart Button Text Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_mini_cart_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== View cart Button Text Hover Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#634c9f',
				'settings' => 'grogin_mini_cart_view_cart_button_text_hvrcolor',
				'label' => esc_attr__( 'View cart Button Text Hover Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_mini_cart_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);	
		
		/*====== Checkout Button Background Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#634c9f',
				'settings' => 'grogin_mini_cart_checkout_button_bg_color',
				'label' => esc_attr__( 'Checkout Button Background Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for background.', 'grogin-core' ),
				'section' => 'grogin_mini_cart_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Checkout Button Background Hover Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#634c9f',
				'settings' => 'grogin_mini_cart_checkout_button_bg_hvrcolor',
				'label' => esc_attr__( 'Checkout Button Background Hover Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for background.', 'grogin-core' ),
				'section' => 'grogin_mini_cart_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Checkout Button Text Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#ffffff',
				'settings' => 'grogin_mini_cart_checkout_button_text_color',
				'label' => esc_attr__( 'Checkout Button Text Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_mini_cart_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Checkout Button Text Hover Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#fff',
				'settings' => 'grogin_mini_cart_checkout_button_text_hvrcolor',
				'label' => esc_attr__( 'Checkout Button Text Hover Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_mini_cart_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);			
		
	/*====== SHOP ====================================================================================*/
		/*====== Shop Panels ======*/
		Kirki::add_panel (
			'grogin_shop_panel',
			array(
				'title' => esc_html__( 'Shop Settings', 'grogin-core' ),
				'description' => esc_html__( 'You can customize the shop from this panel.', 'grogin-core' ),
			)
		);

		$sections = array (
			'shop_general' => array(
				esc_attr__( 'General', 'grogin-core' ),
				esc_attr__( 'You can customize shop settings.', 'grogin-core' )
			),
			
			'shop_product_box' => array(
				esc_attr__( 'Product Box', 'grogin-core' ),
				esc_attr__( 'You can customize the product box settings.', 'grogin-core' )
			),
			
			'shop_single' => array(
				esc_attr__( 'Product Detail', 'grogin-core' ),
				esc_attr__( 'You can customize the product single settings.', 'grogin-core' )
			),
			
			'shop_banner' => array(
				esc_attr__( 'Banner', 'grogin-core' ),
				esc_attr__( 'You can customize the banner.', 'grogin-core' )
			),
			
			'my_account' => array(
				esc_attr__( 'My Account', 'grogin-core' ),
				esc_attr__( 'You can customize the my account page.', 'grogin-core' )
			),

			'free_shipping_bar' => array(
				esc_attr__( 'Free Shipping Bar ', 'grogin-core' ),
				esc_attr__( 'You can customize the free shipping bar settings.', 'grogin-core' )
			),
			
			'wishlist' => array(
				esc_attr__( 'Wishlist', 'grogin-core' ),
				esc_attr__( 'You can customize the wishlist settings.', 'grogin-core' )
			),
			
			'compare' => array(
				esc_attr__( 'Compare', 'grogin-core' ),
				esc_attr__( 'You can customize the compare settings.', 'grogin-core' )
			),
			
			'shop_single_style' => array(
				esc_attr__( 'Product Detail Style', 'grogin-core' ),
				esc_attr__( 'You can customize the product single style settings.', 'grogin-core' )
			),
			
		);

		foreach ( $sections as $section_id => $section ) {
			$section_args = array(
				'title' => $section[0],
				'description' => $section[1],
				'panel' => 'grogin_shop_panel',
			);

			if ( isset( $section[2] ) ) {
				$section_args['type'] = $section[2];
			}

			Kirki::add_section( 'grogin_' . str_replace( '-', '_', $section_id ) . '_section', $section_args );
		}
		
		/*====== Shop Layouts ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'radio-buttonset',
				'settings' => 'grogin_shop_layout',
				'label' => esc_attr__( 'Layout', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose a layout for the shop.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => 'left-sidebar',
				'choices' => array(
					'left-sidebar' => esc_attr__( 'Left Sidebar', 'grogin-core' ),
					'full-width' => esc_attr__( 'Full Width', 'grogin-core' ),
					'right-sidebar' => esc_attr__( 'Right Sidebar', 'grogin-core' ),
				),
			)
		);

		/*====== Shop Width ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'radio-buttonset',
				'settings' => 'grogin_shop_width',
				'label' => esc_attr__( 'Shop Page Width', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose a layout for the shop page.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => 'boxed',
				'choices' => array(
					'boxed' => esc_attr__( 'Boxed', 'grogin-core' ),
					'wide' => esc_attr__( 'Wide', 'grogin-core' ),
				),
			)
		);

		grogin_customizer_add_field(
			array (
			'type'        => 'radio-buttonset',
			'settings'    => 'grogin_paginate_type',
			'label'       => esc_html__( 'Pagination Type', 'grogin-core' ),
			'section'     => 'grogin_shop_general_section',
			'default'     => 'default',
			'priority'    => 10,
			'choices'     => array(
				'default' => esc_attr__( 'Default', 'grogin-core' ),
				'loadmore' => esc_attr__( 'Load More', 'grogin-core' ),
				'infinite' => esc_attr__( 'Infinite', 'grogin-core' ),
			),
			) 
		);

		/*====== Ajax on Shop Page ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_ajax_on_shop',
				'label' => esc_attr__( 'Ajax on Shop Page', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable Ajax for the shop page.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);
		
		/*====== Grid-List Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_grid_list_view',
				'label' => esc_attr__( 'Grid List View', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable grid list view on shop page.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);
		
		/*====== Atrribute Swatches ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_attribute_swatches',
				'label' => esc_attr__( 'Attribute Swatches', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable the attribute types (Color - Button - Images).', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);
		
		/*====== Perpage Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_perpage_view',
				'label' => esc_attr__( 'Perpage View', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable perpage view on shop page.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);

		/*====== Atrribute Swatches ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_attribute_swatches',
				'label' => esc_attr__( 'Attribute Swatches', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable the attribute types (Color - Button - Images).', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);

		/*====== Ajax Notice Shop ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_shop_notice_ajax_addtocart',
				'label' => esc_attr__( 'Added to Cart Ajax Notice', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of the ajax notice feature.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);

		/*====== Product Badge Tab ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_product_badge_tab',
				'label' => esc_attr__( 'Product Badge Tab', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of the product badge tab.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);
		
		/*====== Remove All Button ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_remove_all_button',
				'label' => esc_attr__( 'Remove All Button in cart page', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of the remove all button.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);

		/*====== Mobile Bottom Menu======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_mobile_bottom_menu',
				'label' => esc_attr__( 'Mobile Bottom Menu', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable the bottom menu on mobile.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);

		/*====== Mobile Bottom Menu Edit Toggle======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_mobile_bottom_menu_edit_toggle',
				'label' => esc_attr__( 'Mobile Bottom Menu Edit', 'grogin-core' ),
				'description' => esc_attr__( 'Edit the mobile bottom menu.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_mobile_bottom_menu',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
				
			)
			
		);
		
		/*====== Mobile Menu Repeater ======*/
		new \Kirki\Field\Repeater(
			array(
				'settings' => 'grogin_mobile_bottom_menu_edit',
				'label' => esc_attr__( 'Mobile Bottom Menu Edit', 'grogin-core' ),
				'description' => esc_attr__( 'Edit the mobile bottom menu.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'required' => array(
					array(
					  'setting'  => 'grogin_mobile_bottom_menu_edit_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
				'fields' => array(
					'mobile_menu_type' => array(
						'type' => 'select',
						'label' => esc_attr__( 'Select Type', 'grogin-core' ),
						'description' => esc_attr__( 'You can select a type', 'grogin-core' ),
						'default' => 'default',
						'choices' => array(
							'default' => esc_attr__( 'Default', 'grogin-core' ),
							'search' => esc_attr__( 'Search', 'grogin-core' ),
							'filter' => esc_attr__( 'Filter', 'grogin-core' ),
							'category' => esc_attr__( 'category', 'grogin-core' ),
							'cart' => esc_attr__( 'Cart', 'grogin-core' ),
							'wishlist' => esc_attr__( 'Wishlist', 'grogin-core' ),
						),
					),
				
					'mobile_menu_icon' => array(
						'type' => 'text',
						'label' => esc_attr__( 'Icon', 'grogin-core' ),
						'description' => esc_attr__( 'You can set an icon. for example; "store"', 'grogin-core' ),
					),
					'mobile_menu_text' => array(
						'type' => 'text',
						'label' => esc_attr__( ' Text', 'grogin-core' ),
						'description' => esc_attr__( 'You can enter a text.', 'grogin-core' ),
					),
					'mobile_menu_url' => array(
						'type' => 'text',
						'label' => esc_attr__( 'URL', 'grogin-core' ),
						'description' => esc_attr__( 'You can set url for the item.', 'grogin-core' ),
					),
				),
				
			)
		);

		/*====== Product Stock Quantity ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_stock_quantity',
				'label' => esc_attr__( 'Show Stock Quantity', 'grogin-core' ),
				'description' => esc_attr__( 'Show stock quantity on the label.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);

		/*====== Product Min/Max Quantity ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_min_max_quantity',
				'label' => esc_attr__( 'Min/Max Quantity', 'grogin-core' ),
				'description' => esc_attr__( 'Enable the additional quantity setting fields in product detail page.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);

		/*====== Category Description ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_category_description_after_content',
				'label' => esc_attr__( 'Category Desc After Content', 'grogin-core' ),
				'description' => esc_attr__( 'Add the category description after the products.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);

		/*====== Catalog Mode - Disable Add to Cart ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_catalog_mode',
				'label' => esc_attr__( 'Catalog Mode', 'grogin-core' ),
				'description' => esc_attr__( 'Disable Add to Cart button on the shop page.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);	

		/*====== Recently Viewed Products ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_recently_viewed_products',
				'label' => esc_attr__( 'Recently Viewed Products', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable Recently Viewed Products.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);

		/*====== Recently Viewed Products Coulmn ======*/
		grogin_customizer_add_field(
			array (
				'type'        => 'radio-buttonset',
				'settings'    => 'grogin_recently_viewed_products_column',
				'label'       => esc_html__( 'Recently Viewed Products Column', 'grogin-core' ),
				'section'     => 'grogin_shop_general_section',
				'default'     => '4',
				'priority'    => 10,
				'choices'     => array(
					'6' => esc_attr__( '6', 'grogin-core' ),
					'5' => esc_attr__( '5', 'grogin-core' ),
					'4' => esc_attr__( '4', 'grogin-core' ),
					'3' => esc_attr__( '3', 'grogin-core' ),
					'2' => esc_attr__( '2', 'grogin-core' ),
				),
				'required' => array(
					array(
					  'setting'  => 'grogin_recently_viewed_products',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			) 
		);

		/*====== Min Order Amount ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_min_order_amount_toggle',
				'label' => esc_attr__( 'Min Order Amount', 'grogin-core' ),
				'description' => esc_attr__( 'Enable Min Order Amount.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '0',
			)
		);
		
		/*====== Min Order Amount Value ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_min_order_amount_value',
				'label' => esc_attr__( 'Min Order Value', 'grogin-core' ),
				'description' => esc_attr__( 'Set amount to specify a minimum order value.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => '',
				'required' => array(
					array(
					  'setting'  => 'grogin_min_order_amount_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);

		/*====== Product Image Size ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'dimensions',
				'settings' => 'grogin_product_image_size',
				'label' => esc_attr__( 'Product Image Size', 'grogin-core' ),
				'description' => esc_attr__( 'You can set size of the product image for the shop page.', 'grogin-core' ),
				'section' => 'grogin_shop_general_section',
				'default' => array(
					'width' => '',
					'height' => '',
				),
			)
		);
		
		/*====== Product Box Type ======*/
		grogin_customizer_add_field(
			array (
				'type'        => 'select',
				'settings'    => 'grogin_product_box_type',
				'label'       => esc_html__( 'Shop Product Box Type', 'grogin-core' ),
				'section'     => 'grogin_shop_product_box_section',
				'default'     => 'type1',
				'priority'    => 10,
				'choices'     => array(
					'type1' => esc_attr__( 'Type 1', 'grogin-core' ),
					'type2' => esc_attr__( 'Type 2', 'grogin-core' ),
					'type3' => esc_attr__( 'Type 3', 'grogin-core' ),
					'type1_custom' => esc_attr__( 'Type 1 (Custom)', 'grogin-core' ),
					'type2_custom' => esc_attr__( 'Type 2 (Custom)', 'grogin-core' ),
					'type3_custom' => esc_attr__( 'Type 3 (Custom)', 'grogin-core' ),
					'type4_custom' => esc_attr__( 'Type 4 (Custom)', 'grogin-core' ),
				),
			) 
		);
		
		/*====== Product Box Gallery Type ======*/
		grogin_customizer_add_field(
			array (
				'type'        => 'radio-buttonset',
				'settings'    => 'grogin_product_box_gallery',
				'label'       => esc_html__( 'Product Gallery Type', 'grogin-core' ),
				'section'     => 'grogin_shop_product_box_section',
				'default'     => 'type1',
				'priority'    => 10,
				'choices'     => array(
					'default' => esc_attr__( 'Default', 'grogin-core' ),
					'flip' 	  => esc_attr__( 'Flip', 'grogin-core' ),
					'slider'  => esc_attr__( 'Slider', 'grogin-core' ),
					'zoom'    => esc_attr__( 'Zoom', 'grogin-core' ),
				),
			) 
		);
		
		/*====== Quantity Box Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_quantity_box',
				'label' => esc_attr__( 'Quantity Box', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable quantity box for the product box.', 'grogin-core' ),
				'section' => 'grogin_shop_product_box_section',
				'default' => '0',
			)
		);
		
		/*====== Quick View Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_quick_view_button',
				'label' => esc_attr__( 'Quick View Button', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of the quick view button.', 'grogin-core' ),
				'section' => 'grogin_shop_product_box_section',
				'default' => '0',
			)
		);
		
		/*====== Shipping Class  ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_product_box_shipping_class',
				'label' => esc_attr__( 'Shipping Classes', 'grogin-core' ),
				'description' => esc_attr__( 'Enable or Disable the shipping class on the product box', 'grogin-core' ),
				'section' => 'grogin_shop_product_box_section',
				'default' => '0',
			)
		);
		
		/*====== Product Box Type ======*/
		grogin_customizer_add_field(
			array (
				'type'        => 'radio-buttonset',
				'settings'    => 'grogin_product_box_shipping_class_type',
				'label'       => esc_html__( 'Shipping Class Type', 'grogin-core' ),
				'section'     => 'grogin_shop_product_box_section',
				'default'     => 'default',
				'priority'    => 10,
				'choices'     => array(
					'default' => esc_attr__( 'Default', 'grogin-core' ),
					'bordered' => esc_attr__( 'Bordered', 'grogin-core' ),
				),
				'required' => array(
					array(
					  'setting'  => 'grogin_product_box_shipping_class',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			) 
		);
		
		/*====== Stock Status  ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_product_box_stock_status',
				'label' => esc_attr__( 'Stock Status', 'grogin-core' ),
				'description' => esc_attr__( 'Enable or Disable the stock statu on the product box', 'grogin-core' ),
				'section' => 'grogin_shop_product_box_section',
				'default' => '0',
			)
		);
		
		/*====== Poor Stock Status  ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_product_box_poor_stock',
				'label' => esc_attr__( 'Poor Stock', 'grogin-core' ),
				'description' => esc_attr__( 'Show quantity remaining in stock when low e.g. "Only 9 left in stock"', 'grogin-core' ),
				'section' => 'grogin_shop_product_box_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_product_box_stock_status',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Stock Progress Bar  ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_product_box_stock_progress_bar',
				'label' => esc_attr__( 'Stock Progress Bar', 'grogin-core' ),
				'description' => esc_attr__( 'Enable or Disable the stock progress bar on the product box', 'grogin-core' ),
				'section' => 'grogin_shop_product_box_section',
				'default' => '0',
			)
		);
		
		/*====== Countdown  ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_product_box_countdown',
				'label' => esc_attr__( 'Countdown', 'grogin-core' ),
				'description' => esc_attr__( 'Enable or Disable the countdown on the product box', 'grogin-core' ),
				'section' => 'grogin_shop_product_box_section',
				'default' => '0',
			)
		);
		
		/*====== Product Variable  ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_product_box_variable',
				'label' => esc_attr__( 'Product Variable', 'grogin-core' ),
				'description' => esc_attr__( 'Enable or Disable the variable on the product box', 'grogin-core' ),
				'section' => 'grogin_shop_product_box_section',
				'default' => '0',
			)
		);
		
		/*====== Shop Single Gallery Type ======*/
		grogin_customizer_add_field(
			array (
				'type'        => 'radio-buttonset',
				'settings'    => 'grogin_single_gallery_type',
				'label'       => esc_html__( 'Gallery Type (Product Detail)', 'grogin-core' ),
				'section'     => 'grogin_shop_single_section',
				'default'     => 'horizontal',
				'priority'    => 10,
				'choices'     => array(
					'horizontal' => esc_attr__( 'Horizontal', 'grogin-core' ),
					'vertical' => esc_attr__( 'Vertical', 'grogin-core' ),
					'1column'  => esc_attr__( '1column', 'grogin-core' ),
					'2columns' => esc_attr__( '2columns', 'grogin-core' ),
					'carousel2columns' => esc_attr__( 'Carousel 2columns', 'grogin-core' ),
				),
			) 
		);
		
		/*====== Shop Single Product Tab Type ======*/
		grogin_customizer_add_field(
			array (
				'type'        => 'radio-buttonset',
				'settings'    => 'grogin_single_product_tab_type',
				'label'       => esc_html__( 'Product Tab Type', 'grogin-core' ),
				'section'     => 'grogin_shop_single_section',
				'default'     => 'horizontal_tab',
				'priority'    => 10,
				'choices'     => array(
					'horizontal_tab' 		  => esc_attr__( 'Horizontal Tab', 'grogin-core' ),
					'vertical_tab' 		      => esc_attr__( 'Vertical Tab', 'grogin-core' ),
					'accordion_tab' 		  => esc_attr__( 'Accordion Tab', 'grogin-core' ),
					'accordion_tab_content'   => esc_attr__( 'Accordion Tab Content', 'grogin-core' ),
				),
			) 
		);
		
		/*====== Shop Single Full width ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_single_full_width',
				'label' => esc_attr__( 'Full Width', 'grogin-core' ),
				'description' => esc_attr__( 'Stretch the single product page content.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);

		/*====== Shop Single Image Zoom  ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_single_image_zoom',
				'label' => esc_attr__( 'Image Zoom', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of the zoom feature.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);
		
		/*====== Comment by Rating ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_comment_rating',
				'label' => esc_attr__( 'Comment Rating', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable the review slot.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);

		/*====== Product360 View ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_shop_single_product360',
				'label' => esc_attr__( 'Product360 View', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable Product 360 View.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);

		/*====== Shop Single Ajax Add To Cart ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_shop_single_ajax_addtocart',
				'label' => esc_attr__( 'Ajax Add to Cart', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable ajax add to cart button.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);
		
		/*======  Sticky Single Cart ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_single_sticky_cart',
				'label' => esc_attr__( 'Sticky Add to Cart', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable sticky cart button.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);
		
		/*====== Single Sticky Titles ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_single_sticky_titles',
				'label' => esc_attr__( 'Sticky Titles', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable the sticky titles for desktop.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);

		/*====== Mobile Sticky Single Cart ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_mobile_single_sticky_cart',
				'label' => esc_attr__( 'Mobile Sticky Add to Cart', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable sticky cart button on mobile.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);

		/*====== Buy Now Single ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_shop_single_buy_now',
				'label' => esc_attr__( 'Buy Now Button', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable Buy Now button.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);

		/*====== Related By Tags ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_related_by_tags',
				'label' => esc_attr__( 'Related Products with Tags', 'grogin-core' ),
				'description' => esc_attr__( 'Display the related products by tags.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);

		/*====== Order on WhatsApp ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_shop_single_orderonwhatsapp',
				'label' => esc_attr__( 'Order on WhatsApp', 'grogin-core' ),
				'description' => esc_attr__( 'Enable the button on the product detail page.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);
		
		/*====== Order on WhatsApp Number======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_shop_single_whatsapp_number',
				'label' => esc_attr__( 'WhatsApp Number', 'grogin-core' ),
				'description' => esc_attr__( 'You can add a phone number for order on WhatsApp.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '',
				'required' => array(
					array(
					  'setting'  => 'grogin_shop_single_orderonwhatsapp',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Move Review Tab ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_shop_single_review_tab_move',
				'label' => esc_attr__( 'Move Review Tab', 'grogin-core' ),
				'description' => esc_attr__( 'Move the review tab out of tabs', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);

		/*====== Product Related Post Column ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'select',
				'settings' => 'grogin_shop_related_post_column',
				'label' => esc_attr__( 'Related Post Column', 'grogin-core' ),
				'description' => esc_attr__( 'You can control related post column with this option.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '4',
				'choices' => array(
					'6' => esc_attr__( '6 Columns', 'grogin-core' ),
					'5' => esc_attr__( '5 Columns', 'grogin-core' ),
					'4' => esc_attr__( '4 Columns', 'grogin-core' ),
					'3' => esc_attr__( '3 Columns', 'grogin-core' ),
					'2' => esc_attr__( '2 Columns', 'grogin-core' ),
				),
			)
		);
		
		/*====== Product Cross Sells Column ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'select',
				'settings' => 'grogin_cross_sells_column',
				'label' => esc_attr__( 'Cross Sells Column', 'grogin-core' ),
				'description' => esc_attr__( 'You can control cross sells post column with this option.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '4',
				'choices' => array(
					'6' => esc_attr__( '6 Columns', 'grogin-core' ),
					'5' => esc_attr__( '5 Columns', 'grogin-core' ),
					'4' => esc_attr__( '4 Columns', 'grogin-core' ),
					'3' => esc_attr__( '3 Columns', 'grogin-core' ),
					'2' => esc_attr__( '2 Columns', 'grogin-core' ),
				),
			)
		);
		
		/*====== Product Upsell Column ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'select',
				'settings' => 'grogin_upsell_column',
				'label' => esc_attr__( 'Upsell Column', 'grogin-core' ),
				'description' => esc_attr__( 'You can control upsell post column with this option.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '4',
				'choices' => array(
					'6' => esc_attr__( '6 Columns', 'grogin-core' ),
					'5' => esc_attr__( '5 Columns', 'grogin-core' ),
					'4' => esc_attr__( '4 Columns', 'grogin-core' ),
					'3' => esc_attr__( '3 Columns', 'grogin-core' ),
					'2' => esc_attr__( '2 Columns', 'grogin-core' ),
				),
			)
		);
		
		/*====== Re-Order Product Detail ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'sortable',
				'settings' => 'grogin_shop_single_reorder',
				'label' => esc_attr__( 'Re-order Product Summary', 'grogin-core' ),
				'description' => esc_attr__( 'Please save the changes and refresh the page once. Live preview is not available for the option.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default'     => [
					'woocommerce_template_single_title',
					'woocommerce_template_single_rating',
					'woocommerce_template_single_excerpt',
					'woocommerce_template_single_price',
					'grogin_output_lowest_price_block',
					'woocommerce_template_single_add_to_cart',
					'grogin_single_product_checklist',
					'woocommerce_template_single_meta',
					'grogin_people_added_in_cart',
					'grogin_single_shipping_class',
				],
				'choices'     => [
					'woocommerce_template_single_title' 		=> esc_html__( 'Title',  		'grogin-core' ),
					'woocommerce_template_single_rating' 		=> esc_html__( 'Rating', 		'grogin-core' ),
					'woocommerce_template_single_excerpt' 		=> esc_html__( 'Excerpt', 		'grogin-core' ),
					'woocommerce_template_single_price' 		=> esc_html__( 'Price', 		'grogin-core' ),
					'grogin_output_lowest_price_block' 			=> esc_html__( 'Lowest Price', 	'grogin-core' ),
					'woocommerce_template_single_add_to_cart' 	=> esc_html__( 'Add to Cart', 	'grogin-core' ),
					'grogin_single_product_checklist' 			=> esc_html__( 'Checklist', 	'grogin-core' ),
					'woocommerce_template_single_meta'			=> esc_html__( 'Meta', 'grogin-core' ),
					'grogin_product_stock_progress_bar' 		=> esc_html__( 'Progress Bar', 	'grogin-core' ),
					'grogin_product_time_countdown'			    => esc_html__( 'Time Countdown', 'grogin-core' ),
					'grogin_people_added_in_cart' 				=> esc_html__( 'People Have this in their carts', 	'grogin-core' ),
					'grogin_single_shipping_class' 				=> esc_html__( 'Shipping Class Name', 	'grogin-core' ),
					
				],
			)
		);
		
		/*====== Shop Single Checklist ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_single_checklist',
				'label' => esc_attr__( 'Checklist', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable the featured list.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);
		
		/*====== Shop Single Checklist ======*/
		new \Kirki\Field\Repeater(
			array(
				'settings' => 'grogin_single_products_checklist',
				'label' => esc_attr__( 'Product Checklist', 'grogin-core' ),
				'description' => esc_attr__( 'You can create the checklist list.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'row_label' => array (
					'type' => 'field',
					'field' => 'link_text',
				),
				'required' => array(
					array(
					  'setting'  => 'grogin_single_checklist',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
				'fields' => array(
					'checklist_icon' => array(
						'type' => 'text',
						'label' => esc_attr__( 'Icon', 'grogin-core' ),
						'description' => esc_attr__( 'You can set an icon. for example; "klb-icon-shield-check"', 'grogin-core' ),
					),
					
					'checklist_title' => array(
						'type' => 'textarea',
						'label' => esc_attr__( 'Title', 'grogin-core' ),
						'description' => esc_attr__( 'You can enter a title.', 'grogin-core' ),
					),
				),
			)
		);
		
		/*====== Shop Single Social Share ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_shop_social_share',
				'priority'    => 15,
				'label' => esc_attr__( 'Social Share (Product Detail)', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable social share buttons.', 'grogin-core' ),
				'section' => 'grogin_shop_single_section',
				'default' => '0',
			)
		);

		/*====== Shop Single Social Share ======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'multicheck',
				'settings'    => 'grogin_shop_single_share',
				'section'     => 'grogin_shop_single_section',
				'priority'    => 16,
				'default'     => array('facebook','twitter', 'pinterest', 'linkedin'),
				'choices'     => [
					'facebook'  => esc_html__( 'Facebook', 	'grogin-core' ),
					'twitter' 	=> esc_html__( 'Twitter', 	'grogin-core' ),
					'pinterest' => esc_html__( 'Pinterest', 'grogin-core' ),
					'linkedin'  => esc_html__( 'Linkedin', 	'grogin-core' ),
				],
				'required' => array(
					array(
					  'setting'  => 'grogin_shop_social_share',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Shop Banner Image======*/
		grogin_customizer_add_field (
			array(
				'type' => 'image',
				'settings' => 'grogin_shop_banner_image',
				'label' => esc_attr__( 'Image', 'grogin-core' ),
				'description' => esc_attr__( 'You can upload an image.', 'grogin-core' ),
				'section' => 'grogin_shop_banner_section',
				'choices' => array(
					'save_as' => 'id',
				),
			)
		);
		
		/*====== Shop Banner Title ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'textarea',
				'settings' => 'grogin_shop_banner_title',
				'label' => esc_attr__( 'Set Title', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a title.', 'grogin-core' ),
				'section' => 'grogin_shop_banner_section',
				'default' => '',
			)
		);
		
		/*====== Shop Banner Subtitle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_shop_banner_subtitle',
				'label' => esc_attr__( 'Set Subtitle', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a subtitle.', 'grogin-core' ),
				'section' => 'grogin_shop_banner_section',
				'default' => '',
			)
		);
		
		/*====== Shop Banner Description ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'textarea',
				'settings' => 'grogin_shop_banner_desc',
				'label' => esc_attr__( 'Set Description', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a description.', 'grogin-core' ),
				'section' => 'grogin_shop_banner_section',
				'default' => '',
			)
		);
		
		/*====== Shop Banner Button Text ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_shop_banner_button_text',
				'label' => esc_attr__( 'Set Button Text', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a text.', 'grogin-core' ),
				'section' => 'grogin_shop_banner_section',
				'default' => '',
			)
		);
		
		/*====== Shop Banner URL ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_shop_banner_url',
				'label' => esc_attr__( 'Set URL', 'grogin-core' ),
				'description' => esc_attr__( 'Set an url for the button', 'grogin-core' ),
				'section' => 'grogin_shop_banner_section',
				'default' => '#',
			)
		);
		
		/*====== Banner Repeater For each category ======*/
		add_action( 'init', function() {
			new \Kirki\Field\Repeater(
				array(
					'settings' => 'grogin_shop_banner_each_category',
					'label' => esc_attr__( 'Banner For Categories', 'grogin-core' ),
					'description' => esc_attr__( 'You can set banner for each category.', 'grogin-core' ),
					'section' => 'grogin_shop_banner_section',
					'fields' => array(
						
						'category_id' => array(
							'type'        => 'select',
							'label'       => esc_html__( 'Select Category', 'grogin-core' ),
							'description' => esc_html__( 'Set a category', 'grogin-core' ),
							'priority'    => 10,
							'choices'     => Kirki_Helper::get_terms( array('taxonomy' => 'product_cat') )
						),
						
						'category_image' =>  array(
							'type' => 'image',
							'label' => esc_attr__( 'Image', 'grogin-core' ),
							'description' => esc_attr__( 'You can upload an image.', 'grogin-core' ),
						),
						
						'category_title' => array(
							'type' => 'text',
							'label' => esc_attr__( 'Set Title', 'grogin-core' ),
							'description' => esc_attr__( 'You can set a title.', 'grogin-core' ),
						),
						
						'category_subtitle' => array(
							'type' => 'text',
							'label' => esc_attr__( 'Set Subtitle', 'grogin-core' ),
							'description' => esc_attr__( 'You can set a subtitle.', 'grogin-core' ),
						),
						
						'category_desc' => array(
							'type' => 'text',
							'label' => esc_attr__( 'Set Description', 'grogin-core' ),
							'description' => esc_attr__( 'You can set a description.', 'grogin-core' ),
						),
						
						'category_button_title' => array(
							'type' => 'text',
							'label' => esc_attr__( 'Set button title', 'grogin-core' ),
							'description' => esc_attr__( 'You can set a description.', 'grogin-core' ),
						),
						
						
						'category_button_url' => array(
							'type' => 'text',
							'label' => esc_attr__( 'Set URL', 'grogin-core' ),
							'description' => esc_attr__( 'Set an url for the button', 'grogin-core' ),
						),
					),
				)
			);
		} );
		
		/*====== My Account Layouts ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'radio-buttonset',
				'settings' => 'grogin_my_account_layout',
				'label' => esc_attr__( 'Layout', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose a layout for the login form.', 'grogin-core' ),
				'section' => 'grogin_my_account_section',
				'default' => 'default',
				'choices' => array(
					'default' => esc_attr__( 'Default', 'grogin-core' ),
					'logintab' => esc_attr__( 'Login Tab', 'grogin-core' ),
				),
			)
		);

		/*====== Registration Form First Name ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'select',
				'settings' => 'grogin_registration_first_name',
				'label' => esc_attr__( 'Register - First Name', 'grogin-core' ),
				'section' => 'grogin_my_account_section',
				'default' => 'hidden',
				'choices' => array(
					'hidden' => esc_attr__( 'Hidden', 'grogin-core' ),
					'visible' => esc_attr__( 'Visible', 'grogin-core' ),
				),
			)
		);
		
		/*====== Registration Form Last Name ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'select',
				'settings' => 'grogin_registration_last_name',
				'label' => esc_attr__( 'Register - Last Name', 'grogin-core' ),
				'section' => 'grogin_my_account_section',
				'default' => 'hidden',
				'choices' => array(
					'hidden' => esc_attr__( 'Hidden', 'grogin-core' ),
					'visible' => esc_attr__( 'Visible', 'grogin-core' ),
				),
			)
		);
		
		/*====== Registration Form Billing Company ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'select',
				'settings' => 'grogin_registration_billing_company',
				'label' => esc_attr__( 'Register - Billing Company', 'grogin-core' ),
				'section' => 'grogin_my_account_section',
				'default' => 'hidden',
				'choices' => array(
					'hidden' => esc_attr__( 'Hidden', 'grogin-core' ),
					'visible' => esc_attr__( 'Visible', 'grogin-core' ),
				),
			)
		);
		
		/*====== Registration Form Billing Phone ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'select',
				'settings' => 'grogin_registration_billing_phone',
				'label' => esc_attr__( 'Register - Billing Phone', 'grogin-core' ),
				'section' => 'grogin_my_account_section',
				'default' => 'hidden',
				'choices' => array(
					'hidden' => esc_attr__( 'Hidden', 'grogin-core' ),
					'visible' => esc_attr__( 'Visible', 'grogin-core' ),
				),
			)
		);
		
		/*====== Ajax Login-Register ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_ajax_login_form',
				'label' => esc_attr__( 'Activate Ajax for Login Form', 'grogin-core' ),
				'section' => 'grogin_my_account_section',
				'default' => '0',
			)
		);

		/*====== Redirect URL After Login ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'url',
				'settings' => 'grogin_redirect_url_after_login',
				'label' => esc_attr__( 'Redirect URL After Login', 'grogin-core' ),
				'section' => 'grogin_my_account_section',
				'default' => '',
			)
		);
		
	/*====== Free Shipping Settings =======================================================*/
	
		/*====== Free Shipping ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_free_shipping',
				'label' => esc_attr__( 'Free shipping bar', 'grogin-core' ),
				'section' => 'grogin_free_shipping_bar_section',
				'default' => '0',
			)
		);
		
		/*====== Free Shipping Goal Amount ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'shipping_progress_bar_amount',
				'label' => esc_attr__( 'Goal Amount', 'grogin-core' ),
				'description' => esc_attr__( 'Amount to reach 100% defined in your currency absolute value. For example: 300', 'grogin-core' ),
				'section' => 'grogin_free_shipping_bar_section',
				'default' => '100',
				'required' => array(
					array(
					  'setting'  => 'grogin_free_shipping',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Free Shipping Location Cart Page ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'shipping_progress_bar_location_card_page',
				'label' => esc_attr__( 'Cart page', 'grogin-core' ),
				'section' => 'grogin_free_shipping_bar_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_free_shipping',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Free Shipping Location Mini cart ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'shipping_progress_bar_location_mini_cart',
				'label' => esc_attr__( 'Mini cart', 'grogin-core' ),
				'section' => 'grogin_free_shipping_bar_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_free_shipping',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Free Shipping Location Checkout page ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'shipping_progress_bar_location_checkout',
				'label' => esc_attr__( 'Checkout page', 'grogin-core' ),
				'section' => 'grogin_free_shipping_bar_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_free_shipping',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Free Shipping Message Initial ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'textarea',
				'settings' => 'shipping_progress_bar_message_initial',
				'label' => esc_attr__( 'Initial Message', 'grogin-core' ),
				'description' => esc_attr__( 'Message to show before reaching the goal. Use shortcode [remainder] to display the amount left to reach the minimum.', 'grogin-core' ),
				'section' => 'grogin_free_shipping_bar_section',
				'default' => 'Add [remainder] to cart and get free shipping!',
				'required' => array(
					array(
					  'setting'  => 'grogin_free_shipping',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Free Shipping Message Success ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'textarea',
				'settings' => 'shipping_progress_bar_message_success',
				'label' => esc_attr__( 'Success message', 'grogin-core' ),
				'description' => esc_attr__( 'Message to show after reaching 100%.', 'grogin-core' ),
				'section' => 'grogin_free_shipping_bar_section',
				'default' => 'Your order qualifies for free shipping!',
				'required' => array(
					array(
					  'setting'  => 'grogin_free_shipping',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
	/*====== Wishlist Settings =======================================================*/
		
		/*====== Wishlist Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_wishlist_button',
				'label' => esc_attr__( 'Custom Wishlist Button', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of the wishlist button.', 'grogin-core' ),
				'section' => 'grogin_wishlist_section',
				'default' => '0',
			)
		);
		
		/*====== Wishlist Page ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'select',
				'settings' => 'grogin_wishlist_page',
				'label' => esc_attr__( 'Select a Wishlist Page', 'grogin-core' ),
				'description' => esc_attr__( 'You can select a wishlist page. [klbwl_list]', 'grogin-core' ),
				'section' => 'grogin_wishlist_section',
				'default' => '',
				'choices'     => Kirki\Util\Helper::get_posts(
					array(
						'posts_per_page' => 30,
						'post_type'      => 'page'
					) ,
				),
				'required' => array(
					array(
					  'setting'  => 'grogin_wishlist_button',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Wishlist  ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_wishlist',
				'label' => esc_attr__( 'Wishlist', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable wishlist on the header.', 'grogin-core' ),
				'section' => 'grogin_wishlist_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_wishlist_button',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
	/*====== Compare Settings =======================================================*/
	
		/*====== Shop Compare Toggle  ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_compare_button',
				'label' => esc_attr__( 'Compare on Shop', 'grogin-core' ),
				'description' => esc_attr__( 'Activate the compare button on the shop page.', 'grogin-core' ),
				'section' => 'grogin_compare_section',
				'default' => '0',
			)
		);
		
		/*====== Compare Page ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'select',
				'settings' => 'grogin_compare_page',
				'label' => esc_attr__( 'Select a Compare Page', 'grogin-core' ),
				'description' => esc_attr__( 'You can select a compare page. [klbcp_list]', 'grogin-core' ),
				'section' => 'grogin_compare_section',
				'default' => '',
				'choices'     => Kirki\Util\Helper::get_posts(
					array(
						'posts_per_page' => 30,
						'post_type'      => 'page'
					) ,
				),
				'required' => array(
					array(
					  'setting'  => 'grogin_compare_button',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Header Compare  ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_header_compare',
				'label' => esc_attr__( 'Compare on Header', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable compare on the header.', 'grogin-core' ),
				'section' => 'grogin_compare_section',
				'default' => '0',
				'required' => array(
					array(
					  'setting'  => 'grogin_compare_button',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
	/*====== Shop Single Style Settings =======================================================*/
		
		/*====== Shop Single Background Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#ffffff',
				'settings' => 'grogin_shop_single_bg_color',
				'label' => esc_attr__( 'Background Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for background.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Image Border Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#000000',
				'settings' => 'grogin_shop_single_image_border_color',
				'label' => esc_attr__( 'Image Border Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);	
		
		/*====== Shop Single Title Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#030712',
				'settings' => 'grogin_shop_single_title_color',
				'label' => esc_attr__( 'Title Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Regular Price Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#111827',
				'settings' => 'grogin_shop_single_regular_price_color',
				'label' => esc_attr__( 'Regular Price Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Sale Price Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#dc2626',
				'settings' => 'grogin_shop_single_sale_price_color',
				'label' => esc_attr__( 'Sale Price Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single orderon-whatsapp Button Background Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#16a34a',
				'settings' => 'grogin_shop_single_whatsapp_button_bg_color',
				'label' => esc_attr__( 'Whatsapp Button Background Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for background.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single orderon-whatsapp Button Background Hover Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#15803d',
				'settings' => 'grogin_shop_single_whatsapp_button_bg_hvrcolor',
				'label' => esc_attr__( 'Whatsapp Button Background Hover Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for background.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single orderon-whatsapp Button Text Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#fff',
				'settings' => 'grogin_shop_single_whatsapp_button_text_color',
				'label' => esc_attr__( 'Whatsapp Button Text Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single orderon-whatsapp Button Text Hover Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#ffffff',
				'settings' => 'grogin_shop_single_whatsapp_button_text_hvrcolor',
				'label' => esc_attr__( 'Whatsapp Button Text Hover Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Description Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#4b5563',
				'settings' => 'grogin_shop_single_desc_color',
				'label' => esc_attr__( 'Description Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Button Background Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#16a34a',
				'settings' => 'grogin_shop_single_button_bg_color',
				'label' => esc_attr__( 'Button Background Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for background.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Button Background Hover Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#15803d',
				'settings' => 'grogin_shop_single_button_bg_hvrcolor',
				'label' => esc_attr__( 'Button Background Hover Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for background.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Button Text Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#ffffff',
				'settings' => 'grogin_shop_single_button_text_color',
				'label' => esc_attr__( 'Button Text Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Button Text Hover Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#ffffff',
				'settings' => 'grogin_shop_single_button_text_hvrcolor',
				'label' => esc_attr__( 'Button Text Hover Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Buy Now Button Background Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#212529',
				'settings' => 'grogin_shop_single_buynow_button_bg_color',
				'label' => esc_attr__( 'Buy Now Button Background Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for background.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Buy Now Button Background Hover Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#424649',
				'settings' => 'grogin_shop_single_buynow_button_bg_hvrcolor',
				'label' => esc_attr__( 'Buy Now Button Background Hover Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for background.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Buy Now Button Text Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#fff',
				'settings' => 'grogin_shop_single_buynow_button_text_color',
				'label' => esc_attr__( 'Buy Now Button Text Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Buy Now Button Text Hover Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#fff',
				'settings' => 'grogin_shop_single_buynow_button_text_hvrcolor',
				'label' => esc_attr__( 'Buy Now Button Text Hover Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Wishlist Title Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#030712',
				'settings' => 'grogin_shop_single_wishlist_title_color',
				'label' => esc_attr__( 'Wishlist Title Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Wishlist Icon Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#030712',
				'settings' => 'grogin_shop_single_wishlist_title_icon_color',
				'label' => esc_attr__( 'Wishlist Icon Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Share Title Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#030712',
				'settings' => 'grogin_shop_single_share_title_color',
				'label' => esc_attr__( 'Share Title Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Share Icon Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#030712',
				'settings' => 'grogin_shop_single_share_icon_color',
				'label' => esc_attr__( 'Share Icon Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		
		/*====== Shop Single Compare Title Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#030712',
				'settings' => 'grogin_shop_single_compare_title_color',
				'label' => esc_attr__( 'Compare Title Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Shop Single Compare Icon Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#030712',
				'settings' => 'grogin_shop_single_compare_icon_color',
				'label' => esc_attr__( 'Compare Icon Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a color for color.', 'grogin-core' ),
				'section' => 'grogin_shop_single_style_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);	


	/*====== Blog Settings =======================================================*/
		/*====== Layouts ======*/
		
		grogin_customizer_add_field (
			array(
				'type' => 'radio-buttonset',
				'settings' => 'grogin_blog_layout',
				'label' => esc_attr__( 'Layout', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose a layout.', 'grogin-core' ),
				'section' => 'grogin_blog_settings_section',
				'default' => 'right-sidebar',
				'choices' => array(
					'left-sidebar' => esc_attr__( 'Left Sidebar', 'grogin-core' ),
					'full-width' => esc_attr__( 'Full Width', 'grogin-core' ),
					'right-sidebar' => esc_attr__( 'Right Sidebar', 'grogin-core' ),
				),
			)
		);
		
		/*====== Main color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#634C9F',
				'settings' => 'grogin_main_color',
				'label' => esc_attr__( 'Main Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can customize the main color.', 'grogin-core' ),
				'section' => 'grogin_main_color_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*====== Main Active color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#39245F',
				'settings' => 'grogin_main_active_color',
				'label' => esc_attr__( 'Main Active Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can customize the main active color.', 'grogin-core' ),
				'section' => 'grogin_main_color_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
		/*======  Secondary Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#FFD200',
				'settings' => 'grogin_secondary_color',
				'label' => esc_attr__( 'Secondary Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can customize the secondary color.', 'grogin-core' ),
				'section' => 'grogin_main_color_section',
			)
		);
		
		/*====== Secondary Active color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#F3C901',
				'settings' => 'grogin_secondary_active_color',
				'label' => esc_attr__( 'Secondary Active Color', 'grogin-core' ),
				'description' => esc_attr__( 'You can customize the active rgb color.', 'grogin-core' ),
				'section' => 'grogin_main_color_section',
				'choices'     => [
					'alpha' => true,
				],
			)
		);
		
	/*====== Elementor Templates =======================================================*/
		/*====== Before Shop Elementor Templates ======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'select',
				'settings'    => 'grogin_before_main_shop_elementor_template',
				'label'       => esc_html__( 'Before Shop Elementor Template', 'grogin-core' ),
				'section'     => 'grogin_elementor_templates_section',
				'default'     => '',
				'placeholder' => esc_html__( 'Select a template from elementor templates ', 'grogin-core' ),
				'choices'     => grogin_get_elementorTemplates('section'),
				
			)
		);
		
		/*====== After Shop Elementor Templates ======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'select',
				'settings'    => 'grogin_after_main_shop_elementor_template',
				'label'       => esc_html__( 'After Shop Elementor Template', 'grogin-core' ),
				'section'     => 'grogin_elementor_templates_section',
				'default'     => '',
				'placeholder' => esc_html__( 'Select a template from elementor templates ', 'grogin-core' ),
				'choices'     => grogin_get_elementorTemplates('section'),
				
			)
		);
		
		/*====== Before Header Elementor Templates ======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'select',
				'settings'    => 'grogin_before_main_header_elementor_template',
				'label'       => esc_html__( 'Before Header Elementor Template', 'grogin-core' ),
				'section'     => 'grogin_elementor_templates_section',
				'default'     => '',
				'placeholder' => esc_html__( 'Select a template from elementor templates, If you want to show any content before products ', 'grogin-core' ),
				'choices'     => grogin_get_elementorTemplates('section'),
				
			)
		);
	
		/*====== After Header Elementor Templates ======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'select',
				'settings'    => 'grogin_after_main_header_elementor_template',
				'label'       => esc_html__( 'After Header Elementor Template', 'grogin-core' ),
				'section'     => 'grogin_elementor_templates_section',
				'default'     => '',
				'placeholder' => esc_html__( 'Select a template from elementor templates ', 'grogin-core' ),
				'choices'     => grogin_get_elementorTemplates('section'),
				
			)
		);
		
		/*====== Before Footer Elementor Template ======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'select',
				'settings'    => 'grogin_before_main_footer_elementor_template',
				'label'       => esc_html__( 'Before Footer Elementor Template', 'grogin-core' ),
				'section'     => 'grogin_elementor_templates_section',
				'default'     => '',
				'placeholder' => esc_html__( 'Select a template from elementor templates, If you want to show any content before products ', 'grogin-core' ),
				'choices'     => grogin_get_elementorTemplates('section'),
				
			)
		);
		
		/*====== After Footer Elementor  Template ======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'select',
				'settings'    => 'grogin_after_main_footer_elementor_template',
				'label'       => esc_html__( 'After Footer Elementor Templates', 'grogin-core' ),
				'section'     => 'grogin_elementor_templates_section',
				'default'     => '',
				'placeholder' => esc_html__( 'Select a template from elementor templates, If you want to show any content before products ', 'grogin-core' ),
				'choices'     => grogin_get_elementorTemplates('section'),
				
			)
		);

		/*====== Templates Repeater For each category ======*/
		add_action( 'init', function() {
			new \Kirki\Field\Repeater(
				array(
					'settings' => 'grogin_elementor_template_each_shop_category',
					'label' => esc_attr__( 'Template For Categories', 'grogin-core' ),
					'description' => esc_attr__( 'You can set template for each category.', 'grogin-core' ),
					'section' => 'grogin_elementor_templates_section',
					'fields' => array(
						
						'category_id' => array(
							'type'        => 'select',
							'label'       => esc_html__( 'Select Category', 'grogin-core' ),
							'description' => esc_html__( 'Set a category', 'grogin-core' ),
							'priority'    => 10,
							'default'     => '',
							'choices'     => Kirki_Helper::get_terms( array('taxonomy' => 'product_cat') )
						),
						
						'grogin_before_main_shop_elementor_template_category' => array(
							'type'        => 'select',
							'label'       => esc_html__( 'Before Shop Elementor Template', 'grogin-core' ),
							'choices'     => grogin_get_elementorTemplates('section'),
							'default'     => '',
							'placeholder' => esc_html__( 'Select a template from elementor templates, If you want to show any content before products ', 'grogin-core' ),
						),
						
						'grogin_after_main_shop_elementor_template_category' => array(
							'type'        => 'select',
							'label'       => esc_html__( 'After Shop Elementor Template', 'grogin-core' ),
							'choices'     => grogin_get_elementorTemplates('section'),
						),
						
						'grogin_before_main_header_elementor_template_category' => array(
							'type'        => 'select',
							'label'       => esc_html__( 'Before Header Elementor Template', 'grogin-core' ),
							'choices'     => grogin_get_elementorTemplates('section'),
						),
						
						'grogin_after_main_header_elementor_template_category' => array(
							'type'        => 'select',
							'label'       => esc_html__( 'After Header Elementor Template', 'grogin-core' ),
							'choices'     => grogin_get_elementorTemplates('section'),
						),
						
						'grogin_before_main_footer_elementor_template_category' => array(
							'type'        => 'select',
							'label'       => esc_html__( 'Before Footer Elementor Template', 'grogin-core' ),
							'choices'     => grogin_get_elementorTemplates('section'),
						),
						
						'grogin_after_main_footer_elementor_template_category' => array(
							'type'        => 'select',
							'label'       => esc_html__( 'After Footer Elementor Template', 'grogin-core' ),
							'choices'     => grogin_get_elementorTemplates('section'),
						),
						

					),
				)
			);
		} );


		/*====== Map Settings ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_mapapi',
				'label' => esc_attr__( 'Google Map Api key', 'grogin-core' ),
				'description' => esc_attr__( 'Add your google map api key', 'grogin-core' ),
				'section' => 'grogin_map_settings_section',
				'default' => '',
			)
		);
		
	/*====== Grogin Widgets ======*/
		/*====== Widgets Panels ======*/
		Kirki::add_panel (
			'grogin_widgets_panel',
			array(
				'title' => esc_html__( 'Grogin Widgets', 'grogin-core' ),
				'description' => esc_html__( 'You can customize the grogin widgets.', 'grogin-core' ),
			)
		);

		$sections = array (
			
			'social_media' => array(
				esc_attr__( 'Social Media', 'grogin-core' ),
				esc_attr__( 'You can customize the social media widget.', 'grogin-core' )
			),
			
		);

		foreach ( $sections as $section_id => $section ) {
			$section_args = array(
				'title' => $section[0],
				'description' => $section[1],
				'panel' => 'grogin_widgets_panel',
			);

			if ( isset( $section[2] ) ) {
				$section_args['type'] = $section[2];
			}

			Kirki::add_section( 'grogin_' . str_replace( '-', '_', $section_id ) . '_section', $section_args );
		}

		/*====== Social Media Widget ======*/
		new \Kirki\Field\Repeater(
			array(
				'settings' => 'grogin_social_media_widget',
				'label' => esc_attr__( 'Social Media Widget', 'grogin-core' ),
				'description' => esc_attr__( 'You can set social icons.', 'grogin-core' ),
				'section' => 'grogin_social_media_section',
				'fields' => array(
					'social_icon' => array(
						'type' => 'text',
						'label' => esc_attr__( 'Icon', 'grogin-core' ),
						'description' => esc_attr__( 'You can set an icon. for example; "facebook"', 'grogin-core' ),
					),

					'social_url' => array(
						'type' => 'text',
						'label' => esc_attr__( 'URL', 'grogin-core' ),
						'description' => esc_attr__( 'You can set url for the item.', 'grogin-core' ),
					),

				),
			)
		);
		
	
		
	/*====== Footer ======*/
		/*====== Footer Panels ======*/
		Kirki::add_panel (
			'grogin_footer_panel',
			array(
				'title' => esc_html__( 'Footer Settings', 'grogin-core' ),
				'description' => esc_html__( 'You can customize the footer from this panel.', 'grogin-core' ),
			)
		);

		$sections = array (
			'footer_subscribe' => array(
				esc_attr__( 'Subscribe', 'grogin-core' ),
				esc_attr__( 'You can customize the subscribe area.', 'grogin-core' )
			),
			
			'footer_extra' => array(
				esc_attr__( 'Footer Extra', 'grogin-core' ),
				esc_attr__( 'You can customize the footer extra section.', 'grogin-core' )
			),
			
			'footer_general' => array(
				esc_attr__( 'Footer General', 'grogin-core' ),
				esc_attr__( 'You can customize the footer settings.', 'grogin-core' )
			),
			
			'footer1_style' => array(
				esc_attr__( 'Footer 1 Style', 'grogin-core' ),
				esc_attr__( 'You can customize the footer settings.', 'grogin-core' )
			),
			
			'footer2_style' => array(
				esc_attr__( 'Footer 2 Style', 'grogin-core' ),
				esc_attr__( 'You can customize the footer settings.', 'grogin-core' )
			),
			
		);

		foreach ( $sections as $section_id => $section ) {
			$section_args = array(
				'title' => $section[0],
				'description' => $section[1],
				'panel' => 'grogin_footer_panel',
			);

			if ( isset( $section[2] ) ) {
				$section_args['type'] = $section[2];
			}

			Kirki::add_section( 'grogin_' . str_replace( '-', '_', $section_id ) . '_section', $section_args );
		}

		
		/*====== Subcribe Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_footer_subscribe_area',
				'label' => esc_attr__( 'Subcribe', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable subscribe section.', 'grogin-core' ),
				'section' => 'grogin_footer_subscribe_section',
				'default' => '0',
			)
		);
		
		/*====== Subcribe FORM ID======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_footer_subscribe_formid',
				'label' => esc_attr__( 'Subscribe Form Id.', 'grogin-core' ),
				'description' => esc_attr__( 'You can find the form id in Dashboard > Mailchimp For Wp > Form.', 'grogin-core' ),
				'section' => 'grogin_footer_subscribe_section',
				'default' => '',
				'active_callback' => [
					[
					  'setting'  => 'grogin_footer_subscribe_area',
					  'operator' => '==',
					  'value'    => '1',
					]
				],
			)
		);
		
		/*====== Subscribe Title ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'textarea',
				'settings' => 'grogin_footer_subscribe_title',
				'label' => esc_attr__( 'Title', 'grogin-core' ),
				'description' => esc_attr__( 'You can set text for subscribe section.', 'grogin-core' ),
				'section' => 'grogin_footer_subscribe_section',
				'default' => '',
				'active_callback' => [
					[
					  'setting'  => 'grogin_footer_subscribe_area',
					  'operator' => '==',
					  'value'    => '1',
					]
				],
			)
		);
		
		/*====== Subscribe Subtitle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'textarea',
				'settings' => 'grogin_footer_subscribe_subtitle',
				'label' => esc_attr__( 'Subtitle', 'grogin-core' ),
				'description' => esc_attr__( 'You can set text for subscribe section.', 'grogin-core' ),
				'section' => 'grogin_footer_subscribe_section',
				'default' => '',
				'active_callback' => [
					[
					  'setting'  => 'grogin_footer_subscribe_area',
					  'operator' => '==',
					  'value'    => '1',
					]
				],
			)
		);
		
		/*====== Footer Type ======*/
		grogin_customizer_add_field(
			array (
				'type'        => 'select',
				'settings'    => 'grogin_footer_type',
				'label'       => esc_html__( 'Footer Type', 'grogin-core' ),
				'section'     => 'grogin_footer_general_section',
				'default'     => 'type1',
				'choices'     => array(
					'type1' => esc_attr__( 'Type 1', 'grogin-core' ),
					'type2' => esc_attr__( 'Type 2', 'grogin-core' ),
				),
			) 
		);
		
		/*====== Footer Column ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'select',
				'settings' => 'grogin_footer_column',
				'label' => esc_attr__( 'Footer Column', 'grogin-core' ),
				'description' => esc_attr__( 'You can set footer column.', 'grogin-core' ),
				'section' => 'grogin_footer_general_section',
				'default' => '4columns',
				'choices' => array(
					'5columns' => esc_attr__( '5 Columns', 'grogin-core' ),
					'4columns' => esc_attr__( '4 Columns', 'grogin-core' ),
					'3columns' => esc_attr__( '3 Columns', 'grogin-core' ),
				),
			)
		);
		
		/*====== Copyright ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_copyright',
				'label' => esc_attr__( 'Copyright', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a copyright text for the footer.', 'grogin-core' ),
				'section' => 'grogin_footer_general_section',
				'default' => '',
			)
		);
		
		/*====== Footer Menu Menu Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_footer_menu',
				'label' => esc_attr__( 'Footer Menu', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable the top footer menu.', 'grogin-core' ),
				'section' => 'grogin_footer_general_section',
				'default' => '0',
			)
		);
		
		/*====== Payment Image ======*/
		new \Kirki\Field\Repeater(
			array(
				'type' => 'repeater',
				'settings' => 'grogin_footer_payment_repeater',
				'label' => esc_attr__( 'Payment Images', 'grogin-core' ),
				'description' => esc_attr__( 'You can set the payment images.', 'grogin-core' ),
				'section' => 'grogin_footer_general_section',
				'fields' => array(
					'payment_image' => array(
						'type' => 'image',
						'label' => esc_attr__( 'Image', 'grogin-core' ),
						'description' => esc_attr__( 'You can upload an image.', 'grogin-core' ),
					),
				),
				'required' => array(
					array(
					  'setting'  => 'grogin_footer_payment_image',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Social List Title======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_footer_social_list_title',
				'label' => esc_attr__( 'Social List Title', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a title.', 'grogin-core' ),
				'section' => 'grogin_footer_general_section',
				'default' => '',
				'priority' => 11,
			)
		);
		
		/*====== Footer Social List ======*/
		new \Kirki\Field\Repeater(
			array(
				'settings' => 'grogin_footer_social_list',
				'label' => esc_attr__( 'Social List', 'grogin-core' ),
				'description' => esc_attr__( 'You can set social icons.', 'grogin-core' ),
				'section' => 'grogin_footer_general_section',
				'priority'    => 12,
				'fields' => array(
					'social_icon' => array(
						'type' => 'text',
						'label' => esc_attr__( 'Icon', 'grogin-core' ),
						'description' => esc_attr__( 'You can set an icon. for example; "facebook"', 'grogin-core' ),
					),

					'social_url' => array(
						'type' => 'text',
						'label' => esc_attr__( 'URL', 'grogin-core' ),
						'description' => esc_attr__( 'You can set url for the item.', 'grogin-core' ),
					),

				),
			)
		);
		
		/*====== Back to top  ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_scroll_to_top',
				'label' => esc_attr__( 'Back To Top Button', 'grogin-core' ),
				'section' => 'grogin_footer_general_section',
				'default' => '0',
			)
		);
		
		/*====== APP Title======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_footer_app_title',
				'label' => esc_attr__( 'APP Title', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a title.', 'grogin-core' ),
				'section' => 'grogin_footer_general_section',
				'default' => '',
			)
		);
		
		/*====== APP Image ======*/
		new \Kirki\Field\Repeater(
			array(
				'settings' => 'grogin_footer_app_image',
				'label' => esc_attr__( 'APP IMAGE', 'grogin-core' ),
				'description' => esc_attr__( 'You can set the app images.', 'grogin-core' ),
				'section' => 'grogin_footer_general_section',
				'fields' => array(
					'app_image' => array(
						'type' => 'image',
						'label' => esc_attr__( 'Image', 'grogin-core' ),
						'description' => esc_attr__( 'You can upload an image.', 'grogin-core' ),
					),
					
					'app_url' => array(
						'type' => 'text',
						'label' => esc_attr__( 'URL', 'grogin-core' ),
						'description' => esc_attr__( 'set an url for the image.', 'grogin-core' ),
					),
					
					'app_image_title' => array(
						'type' => 'text',
						'label' => esc_attr__( 'Text', 'grogin-core' ),
						'description' => esc_attr__( 'set an url for the text.', 'grogin-core' ),
					),
				),
			)
		);

		/*====== GDPR Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_gdpr_toggle',
				'label' => esc_attr__( 'Enable GDPR', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of GDPR.', 'grogin-core' ),
				'section' => 'grogin_gdpr_settings_section',
				'default' => '0',
			)
		);
		
		/*====== GDPR Type ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'radio-buttonset',
				'settings' => 'grogin_gdpr_type',
				'label' => esc_attr__( 'GDPR Type', 'grogin-core' ),
				'section' => 'grogin_gdpr_settings_section',
				'default' => 'type1',
				'choices' => array(
					'type1' => esc_attr__( 'Type 1', 'grogin-core' ),
					'type2' => esc_attr__( 'Type 2', 'grogin-core' ),
				),
				'required' => array(
					array(
					  'setting'  => 'grogin_gdpr_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== GDPR Image======*/
		grogin_customizer_add_field (
			array(
				'type' => 'image',
				'settings' => 'grogin_gdpr_image',
				'label' => esc_attr__( 'Image', 'grogin-core' ),
				'description' => esc_attr__( 'You can upload an image.', 'grogin-core' ),
				'section' => 'grogin_gdpr_settings_section',
				'choices' => array(
					'save_as' => 'id',
				),
				'active_callback' => [
					[
					  'setting'  => 'grogin_gdpr_toggle',
					  'operator' => '==',
					  'value'    => '1',
					],
					[
					  'setting'  => 'grogin_gdpr_type',
					  'operator' => '!=',
					  'value'    => 'type2',
					]
				],
			)
		);
		
		/*====== GDPR Text ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'textarea',
				'settings' => 'grogin_gdpr_text',
				'label' => esc_attr__( 'GDPR Text', 'grogin-core' ),
				'section' => 'grogin_gdpr_settings_section',
				'default' => 'In order to provide you a personalized shopping experience, our site uses cookies. <br><a href="#">cookie policy</a>.',
				'required' => array(
					array(
					  'setting'  => 'grogin_gdpr_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== GDPR Expire Date ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_gdpr_expire_date',
				'label' => esc_attr__( 'GDPR Expire Date', 'grogin-core' ),
				'section' => 'grogin_gdpr_settings_section',
				'default' => '15',
				'required' => array(
					array(
					  'setting'  => 'grogin_gdpr_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== GDPR Button Text ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_gdpr_button_text',
				'label' => esc_attr__( 'GDPR Button Text', 'grogin-core' ),
				'section' => 'grogin_gdpr_settings_section',
				'default' => 'Accept Cookies',
				'required' => array(
					array(
					  'setting'  => 'grogin_gdpr_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);

		/*====== Newsletter Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_newsletter_popup_toggle',
				'label' => esc_attr__( 'Enable Newsletter', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of Newsletter Popup.', 'grogin-core' ),
				'section' => 'grogin_newsletter_settings_section',
				'default' => '0',
			)
		);
		
		/*====== Newsletter Type ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'radio-buttonset',
				'settings' => 'grogin_newsletter_type',
				'label' => esc_attr__( 'Newsletter Type', 'grogin-core' ),
				'section' => 'grogin_newsletter_settings_section',
				'default' => 'type1',
				'choices' => array(
					'type1' => esc_attr__( 'Type 1', 'grogin-core' ),
					'type2' => esc_attr__( 'Type 2', 'grogin-core' ),
					'type3' => esc_attr__( 'Type 3', 'grogin-core' ),
				),
				'required' => array(
					array(
					  'setting'  => 'grogin_newsletter_popup_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Newsletter Image ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'image',
				'settings' => 'grogin_newsletter_image',
				'label' => esc_attr__( 'Image', 'grogin-core' ),
				'description' => esc_attr__( 'You can upload an image.', 'grogin-core' ),
				'section' => 'grogin_newsletter_settings_section',
				'choices' => array(
					'save_as' => 'id',
				),
				'input_attrs' => array( 'class' => 'my_custom_class' ),

				'active_callback' => [
					[
					  'setting'  => 'grogin_newsletter_popup_toggle',
					  'operator' => '==',
					  'value'    => '1',
					],
					[
					  'setting'  => 'grogin_newsletter_type',
					  'operator' => '!=',
					  'value'    => 'type1',
					]
				],

			)
		);
		
		
		/*====== Newsletter Title ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_newsletter_popup_title',
				'label' => esc_attr__( 'Newsletter Title', 'grogin-core' ),
				'section' => 'grogin_newsletter_settings_section',
				'default' => 'Subscribe To Newsletter',
				'required' => array(
					array(
					  'setting'  => 'grogin_newsletter_popup_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Newsletter Subtitle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'textarea',
				'settings' => 'grogin_newsletter_popup_subtitle',
				'label' => esc_attr__( 'Newsletter Subtitle', 'grogin-core' ),
				'section' => 'grogin_newsletter_settings_section',
				'default' => 'Subscribe to the Grogin mailing list to receive updates on new arrivals, special offers and our promotions.',
				'required' => array(
					array(
					  'setting'  => 'grogin_newsletter_popup_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Subcribe Popup FORM ID======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_newsletter_popup_formid',
				'label' => esc_attr__( 'Newsletter Form Id.', 'grogin-core' ),
				'description' => esc_attr__( 'You can find the form id in Dashboard > Mailchimp For Wp > Form.', 'grogin-core' ),
				'section' => 'grogin_newsletter_settings_section',
				'default' => '',
				'required' => array(
					array(
					  'setting'  => 'grogin_newsletter_popup_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Subcribe Popup Expire Date ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_newsletter_popup_expire_date',
				'label' => esc_attr__( 'Newsletter Expire Date', 'grogin-core' ),
				'section' => 'grogin_newsletter_settings_section',
				'default' => '15',
				'required' => array(
					array(
					  'setting'  => 'grogin_newsletter_popup_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Maintenance Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_maintenance_toggle',
				'label' => esc_attr__( 'Enable Maintenance Mode', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of Maintenance.', 'grogin-core' ),
				'section' => 'grogin_maintenance_settings_section',
				'default' => '0',
			)
		);
		
		/*====== Maintenance Title ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_maintenance_title',
				'label' => esc_attr__( 'Title', 'grogin-core' ),
				'section' => 'grogin_maintenance_settings_section',
				'default' => 'Coming',
				'active_callback' => [
					[
					  'setting'  => 'grogin_maintenance_toggle',
					  'operator' => '==',
					  'value'    => '1',
					]
				],
			)
		);

		/*====== Maintenance Second Title ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_maintenance_second_title',
				'label' => esc_attr__( 'Second Title', 'grogin-core' ),
				'section' => 'grogin_maintenance_settings_section',
				'default' => 'Soon',
				'active_callback' => [
					[
					  'setting'  => 'grogin_maintenance_toggle',
					  'operator' => '==',
					  'value'    => '1',
					]
				],
			)
		);
		
		/*====== Maintenance Subtitle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'textarea',
				'settings' => 'grogin_maintenance_subtitle',
				'label' => esc_attr__( 'Subtitle', 'grogin-core' ),
				'section' => 'grogin_maintenance_settings_section',
				'default' => 'Get ready! Something really cool is coming!',
				'active_callback' => [
					[
					  'setting'  => 'grogin_maintenance_toggle',
					  'operator' => '==',
					  'value'    => '1',
					]
				],
			)
		);
		
		/*====== Maintenance Mailchimp FORM ID======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_maintenance_mailchimp_formid',
				'label' => esc_attr__( 'Mailchimp Form Id.', 'grogin-core' ),
				'description' => esc_attr__( 'You can find the form id in Dashboard > Mailchimp For Wp > Form.', 'grogin-core' ),
				'section' => 'grogin_maintenance_settings_section',
				'default' => '',
				'active_callback' => [
					[
					  'setting'  => 'grogin_maintenance_toggle',
					  'operator' => '==',
					  'value'    => '1',
					]
				],
			)
		);
		
		/*====== Maintenance Image ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'image',
				'settings' => 'grogin_maintenance_image',
				'label' => esc_attr__( 'Background Image', 'grogin-core' ),
				'description' => esc_attr__( 'You can upload an image.', 'grogin-core' ),
				'section' => 'grogin_maintenance_settings_section',
				'choices' => array(
					'save_as' => 'id',
				),
				'input_attrs' => array( 'class' => 'my_custom_class' ),
				'active_callback' => [
					[
					  'setting'  => 'grogin_maintenance_toggle',
					  'operator' => '==',
					  'value'    => '1',
					]
				],
			)
		);
		
		/*====== Body Typography ======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'typography',
				'settings' => 'grogin_body_typography',
				'label'       => esc_attr__( 'Body Typography', 'grogin-core' ),
				'section'     => 'grogin_typography_settings_section',
				'default'     => [
					'font-family'    => '"Inter", sans-serif',
					'variant'        => 'regular',
					'font-size'      => '16px',
					'letter-spacing' => '-0.02em',
					'line-height'	 => '1.5',
					'color'          => '#030712',
				],
				'priority'    => 10,
				'transport'   => 'auto',
				'choices' => [
					'fonts' => [
						'google'   => [],
						'families' => [
							'custom' => [
								'text'     => 'Grogin Fonts',
								'children' => [
									[ 'id' => '"Inter", sans-serif', 'text' => 'Inter' ],
									[ 'id' => '"Barlow", sans-serif', 'text' => 'Barlow' ],
								],
							],
						],
						'variants' => [
							'"Inter", sans-serif'       => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
							'"Barlow", sans-serif'   	=> array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
						],
					],
				],
				
			)
		);
		
		/*====== Body background Color ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'color',
				'default' => '#FFFFFF',
				'settings' => 'grogin_body_background_typography',
				'label' => esc_attr__( 'Body Background Color', 'grogin-core' ),
				'section' => 'grogin_typography_settings_section',
			)
		);

		grogin_customizer_add_field ( array(
			'type'        => 'custom',
			'settings'    => 'klb_separator1',
			'section'     => 'grogin_typography_settings_section',
			'default'     => '<hr>',
		) );

		/*====== Heading Typography h1,h2,h3,h4,h5,h6======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'typography',
				'settings' => 'grogin_heading_typography',
				'label'       => esc_attr__( 'Heading Typography', 'grogin-core' ),
				'section'     => 'grogin_typography_settings_section',
				'default'     => [
					'font-family'    => '"Inter", sans-serif',
					'variant'        => '700',
					'letter-spacing' => '-0.02em',
				],
				'priority'    => 10,
				'transport'   => 'auto',
				'choices' => [
					'fonts' => [
						'google'   => [],
						'families' => [
							'custom' => [
								'text'     => 'Grogin Fonts',
								'children' => [
									[ 'id' => '"Inter", sans-serif', 'text' => 'Inter' ],
									[ 'id' => '"Barlow", sans-serif', 'text' => 'Barlow' ],
								],
							],
						],
						'variants' => [
							'"Inter", sans-serif'       => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
							'"Barlow", sans-serif'   	=> array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
						],
					],
				],
				
			)
		);

		grogin_customizer_add_field ( array(
			'type'        => 'custom',
			'settings'    => 'klb_separator2',
			'section'     => 'grogin_typography_settings_section',
			'default'     => '<hr>',
		) );

		/*====== Main Menu Typography======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'typography',
				'settings' => 'grogin_menu_typography',
				'label'       => esc_attr__( 'Menu Typography', 'grogin-core' ),
				'section'     => 'grogin_typography_settings_section',
				'default'     => [
					'font-family'    => '"Inter", sans-serif',
					'variant'        => '600',
					'font-size'      => '15px',
					'letter-spacing' => '-0.02em',
				],
				'priority'    => 10,
				'transport'   => 'auto',
				'choices' => [
					'fonts' => [
						'google'   => [],
						'families' => [
							'custom' => [
								'text'     => 'Grogin Fonts',
								'children' => [
									[ 'id' => '"Inter", sans-serif', 'text' => 'Inter' ],
									[ 'id' => '"Barlow", sans-serif', 'text' => 'Barlow' ],
								],
							],
						],
						'variants' => [
							'"Inter", sans-serif'       => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
							'"Barlow", sans-serif'   	=> array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
						],
					],
				],
				
			)
		);
		
		// Separator
		grogin_customizer_add_field ( array(
			'type'        => 'custom',
			'settings'    => 'klb_separator3',
			'section'     => 'grogin_typography_settings_section',
			'default'     => '<hr>',
		) );
		
		/*====== Form Typography======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'typography',
				'settings' => 'grogin_form_typography',
				'label'       => esc_attr__( 'Form Typography', 'grogin-core' ),
				'section'     => 'grogin_typography_settings_section',
				'default'     => [
					'font-family'    => '"Inter", sans-serif',
					'variant'        => '500',
					'font-size'      => '14px',
					'letter-spacing' => '-0.02em',
				],
				'priority'    => 10,
				'transport'   => 'auto',
				'choices' => [
					'fonts' => [
						'google'   => [],
						'families' => [
							'custom' => [
								'text'     => 'Grogin Fonts',
								'children' => [
									[ 'id' => '"Inter", sans-serif', 'text' => 'Inter' ],
									[ 'id' => '"Barlow", sans-serif', 'text' => 'Barlow' ],
								],
							],
						],
						'variants' => [
							'"Inter", sans-serif'       => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
							'"Barlow", sans-serif'   	=> array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
						],
					],
				],
				
			)
		);
		
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_form_input_height',
				'label' => esc_attr__( 'Input Height', 'grogin-core' ),
				'section' => 'grogin_typography_settings_section',
				'default' => '42px',
			)
		);
		
		// Separator
		grogin_customizer_add_field ( array(
			'type'        => 'custom',
			'settings'    => 'klb_separator4',
			'section'     => 'grogin_typography_settings_section',
			'default'     => '<hr>',
		) );
		
		/*====== Button Typography======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'typography',
				'settings' => 'grogin_button_typography',
				'label'       => esc_attr__( 'Button Typography', 'grogin-core' ),
				'section'     => 'grogin_typography_settings_section',
				'default'     => [
					'font-family'    => '"Inter", sans-serif',
					'variant'        => '700',
					'font-size'      => '14px',
					'letter-spacing' => '-0.02em',
				],
				'priority'    => 10,
				'transport'   => 'auto',
				'choices' => [
					'fonts' => [
						'google'   => [],
						'families' => [
							'custom' => [
								'text'     => 'Grogin Fonts',
								'children' => [
									[ 'id' => '"Inter", sans-serif', 'text' => 'Inter' ],
									[ 'id' => '"Barlow", sans-serif', 'text' => 'Barlow' ],
								],
							],
						],
						'variants' => [
							'"Inter", sans-serif'       => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
							'"Barlow", sans-serif'   	=> array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
						],
					],
				],
				
			)
		);
		
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_button_height',
				'label' => esc_attr__( 'Button Height', 'grogin-core' ),
				'section' => 'grogin_typography_settings_section',
				'default' => '42px',
			)
		);
		
		// Separator
		grogin_customizer_add_field ( array(
			'type'        => 'custom',
			'settings'    => 'klb_separator5',
			'section'     => 'grogin_typography_settings_section',
			'default'     => '<hr>',
		) );
		
		/*====== Price Typography======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'typography',
				'settings' => 'grogin_price_typography',
				'label'       => esc_attr__( 'Price Typography', 'grogin-core' ),
				'section'     => 'grogin_typography_settings_section',
				'default'     => [
					'font-family'       => '"Barlow", sans-serif',
					'variant'           => '700',
					'font-size'      	=> '22px',
					'letter-spacing' 	=> '-0.02em',
				],
				'priority'    => 10,
				'transport'   => 'auto',
				'choices' => [
					'fonts' => [
						'google'   => [],
						'families' => [
							'custom' => [
								'text'     => 'Grogin Fonts',
								'children' => [
									[ 'id' => '"Inter", sans-serif', 'text' => 'Inter' ],
									[ 'id' => '"Barlow", sans-serif', 'text' => 'Barlow' ],
								],
							],
						],
						'variants' => [
							'"Inter", sans-serif'       => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
							'"Barlow", sans-serif'   	=> array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
						],
					],
				],
				
			)
		);
		
		// Separator
		grogin_customizer_add_field ( array(
			'type'        => 'custom',
			'settings'    => 'klb_separator6',
			'section'     => 'grogin_typography_settings_section',
			'default'     => '<hr>',
		) );
		
		/*====== Product Name Typography======*/
		grogin_customizer_add_field (
			array(
				'type'        => 'typography',
				'settings' => 'grogin_product_name_typography',
				'label'       => esc_attr__( 'Product Name Typography', 'grogin-core' ),
				'section'     => 'grogin_typography_settings_section',
				'default'     => [
					'font-family'       => '"Inter", sans-serif',
					'variant'           => '500',
					'font-size'      	=> '14px',
					'letter-spacing' 	=> '-0.02em',	
				],
				'priority'    => 10,
				'transport'   => 'auto',
				'choices' => [
					'fonts' => [
						'google'   => [],
						'families' => [
							'custom' => [
								'text'     => 'Grogin Fonts',
								'children' => [
									[ 'id' => '"Inter", sans-serif', 'text' => 'Inter' ],
									[ 'id' => '"Barlow", sans-serif', 'text' => 'Barlow' ],
								],
							],
						],
						'variants' => [
							'"Inter", sans-serif'       => array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
							'"Barlow", sans-serif'   	=> array( '100', '200', '300', 'regular', '500', '600', '700', '800', '900', '100italic', '200italic', '300italic', 'italic', '500italic', '600italic', '700italic', '800italic', '900italic' ),
						],
					],
				],
			)
		);
		
		// Separator
		grogin_customizer_add_field ( array(
			'type'        => 'custom',
			'settings'    => 'klb_separator7',
			'section'     => 'grogin_typography_settings_section',
			'default'     => '<hr>',
		) );
		
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_excerpt_font_size',
				'label' => esc_attr__( 'Excerpt Font Size', 'grogin-core' ),
				'section' => 'grogin_typography_settings_section',
				'default' => '14px',
			)
		);
		
		// Separator
		grogin_customizer_add_field ( array(
			'type'        => 'custom',
			'settings'    => 'klb_separator8',
			'section'     => 'grogin_typography_settings_section',
			'default'     => '<hr>',
		) );
		
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_description_font_size',
				'label' => esc_attr__( 'Description Font Size', 'grogin-core' ),
				'section' => 'grogin_typography_settings_section',
				'default' => '16px',
			)
		);
		
		// Separator
		grogin_customizer_add_field ( array(
			'type'        => 'custom',
			'settings'    => 'klb_separator9',
			'section'     => 'grogin_typography_settings_section',
			'default'     => '<hr>',
		) );
		
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_teaser_font_size',
				'label' => esc_attr__( 'Teaser Font Size', 'grogin-core' ),
				'section' => 'grogin_typography_settings_section',
				'default' => '18px',
			)
		);
		
		// Separator
		grogin_customizer_add_field ( array(
			'type'        => 'custom',
			'settings'    => 'klb_separator10',
			'section'     => 'grogin_typography_settings_section',
			'default'     => '<hr>',
		) );
		
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_site_gutter',
				'label' => esc_attr__( 'Site Gutter', 'grogin-core' ),
				'section' => 'grogin_typography_settings_section',
				'default' => '30px',
			)
		);
		
		// Separator
		grogin_customizer_add_field ( array(
			'type'        => 'custom',
			'settings'    => 'klb_separator11',
			'section'     => 'grogin_typography_settings_section',
			'default'     => '<hr>',
		) );
		
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_border_radius',
				'label' => esc_attr__( 'Border Radius', 'grogin-core' ),
				'section' => 'grogin_typography_settings_section',
				'default' => '6px',
			)
		);
		
		// Separator
		grogin_customizer_add_field ( array(
			'type'        => 'custom',
			'settings'    => 'klb_separator12',
			'section'     => 'grogin_typography_settings_section',
			'default'     => '<hr>',
		) );
		
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_site_width',
				'label' => esc_attr__( 'Site Width', 'grogin-core' ),
				'section' => 'grogin_typography_settings_section',
				'default' => '1440px',
			)
		);

	/*====== KLB AI Settings =============================*/
		/*====== Header Panels ======*/
		Kirki::add_panel (
			'grogin_klbai_panel',
			array(
				'title' => esc_html__( 'KLB AI', 'grogin-core' ),
				'description' => esc_html__( 'You can customize KLB AI.', 'grogin-core' ),
			)
		);

		$sections = array (
			'openai_secret' => array(
				esc_attr__( 'OpenAI Secret', 'grogin-core' ),
				esc_attr__( 'OpenAI secret key', 'grogin-core' )
			),
			'product_description' => array(
				esc_attr__( 'Product Description', 'grogin-core' ),
				esc_attr__( 'You can customize the logo which is on header..', 'grogin-core' )
			),
			'product_short_description' => array(
				esc_attr__( 'Product Short Description', 'grogin-core' ),
				esc_attr__( 'You can customize the logo which is on header..', 'grogin-core' )
			),
			
		);

		foreach ( $sections as $section_id => $section ) {
			$section_args = array(
				'title' => $section[0],
				'description' => $section[1],
				'panel' => 'grogin_klbai_panel',
			);

			if ( isset( $section[2] ) ) {
				$section_args['type'] = $section[2];
			}

			Kirki::add_section( 'grogin_' . str_replace( '-', '_', $section_id ) . '_section', $section_args );
		}
	

		/*====== OpenAI enable/disable ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_openai_toggle',
				'label' => esc_attr__( 'Enable OpenAI', 'grogin-core' ),
				'description' => esc_attr__( 'Disable or Enable OpenAI.', 'grogin-core' ),
				'section' => 'grogin_openai_secret_section',
				'default' => '0',
			)
		);

		/*====== OpenAI Secret Key ======*/
		new \Kirki\Field\Generic(
			[
				'settings'    => 'grogin_openai_secret_key',
				'label'       => esc_html__( 'OpenAI Secret Key', 'grogin-core' ),
				'description' => esc_html__( 'Enter your OpenAI secret key. It will be stored securely (encrypted).', 'grogin-core' ),
				'section'     => 'grogin_openai_secret_section',
				'default'     => '',
				'option_type'       => 'option',
				'sanitize_callback' => 'grogin_kirki_sanitize_encrypt_secret',
				'choices'     => [
					'element'  => 'input',
					'type'     => 'password',
					'style'    => 'background-color:black;color:red;',
					'data-foo' => 'bar',
				],
				'required' => [
					[
					  'setting'  => 'grogin_openai_toggle',
					  'operator' => '==',
					  'value'    => '1',
					]
				],
			]
		);
		
		/*====== Product Description Language ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_product_description_language',
				'label' => esc_attr__( 'Language', 'grogin-core' ),
				'description' => esc_attr__( 'Set language of the description', 'grogin-core' ),
				'section' => 'grogin_product_description_section',
				'default' => 'English',
			)
		);
		
		/*====== Length of the text ======*/
		new \Kirki\Field\Dimensions(
			[
				'settings'    => 'grogin_product_description_length',
				'label'       => esc_html__( 'Legnth of the text', 'grogin-core' ),
				'section'     => 'grogin_product_description_section',
				'default'     => [
					'min'  => '150',
					'max' => '200',
				],
				'choices'     => [
					'labels' => [
						'min'  => esc_html__( 'Min', 'grogin-core' ),
						'max'  => esc_html__( 'Max', 'grogin-core' ),
					],
				],
			]
		);
		
		/*====== Product Short Description Language ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_product_short_description_language',
				'label' => esc_attr__( 'Language', 'grogin-core' ),
				'description' => esc_attr__( 'Set language of the short description', 'grogin-core' ),
				'section' => 'grogin_product_short_description_section',
				'default' => 'English',
			)
		);
		
		/*====== Length of the text ======*/
		new \Kirki\Field\Dimensions(
			[
				'settings'    => 'grogin_product_short_description_length',
				'label'       => esc_html__( 'Legnth of the text', 'grogin-core' ),
				'section'     => 'grogin_product_short_description_section',
				'default'     => [
					'min'  => '60',
					'max' => '90',
				],
				'choices'     => [
					'labels' => [
						'min'  => esc_html__( 'Min', 'grogin-core' ),
						'max'  => esc_html__( 'Max', 'grogin-core' ),
					],
				],
			]
		);


	/*====== Other Settings =============================*/	
	
		/*====== 404 Page ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'Dropdown_Pages',
				'settings' => 'grogin_404_page',
				'label' => esc_attr__( 'Select a 404 Page', 'grogin-core' ),
				'description' => esc_attr__( 'Select a page that will be shown as your default 404 error page.', 'grogin-core' ),
				'section' => 'grogin_other_settings_section',
				'default' => '',
				'placeholder' => __( 'Select a page', 'grogin-core' ),
				'choices' => array(
					'default' => esc_attr__( 'Select a Page', 'grogin-core' ),
				),
			)
		);

		/*====== Product Search Limit on Elementor ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_elementor_product_search_limit',
				'label' => esc_attr__( 'Elementor Product Search Limit', 'grogin-core' ),
				'description' => esc_attr__( 'You can set a product search limit for Elementor.', 'grogin-core' ),
				'section' => 'grogin_other_settings_section',
				'default' => '100',
			)
		);
		
	/*====== Coupon Banner Popup Toggle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'toggle',
				'settings' => 'grogin_coupon_banner_popup_toggle',
				'label' => esc_attr__( 'Enable Coupon Banner', 'grogin-core' ),
				'description' => esc_attr__( 'You can choose status of Coupon Banner Popup.', 'grogin-core' ),
				'section' => 'grogin_coupon_banner_popup_section',
				'default' => '0',
			)
		);
		
		/*====== Coupon Banner Popup Image ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'image',
				'settings' => 'grogin_coupon_banner_image',
				'label' => esc_attr__( 'Image', 'grogin-core' ),
				'description' => esc_attr__( 'You can upload an image.', 'grogin-core' ),
				'section' => 'grogin_coupon_banner_popup_section',
				'choices' => array(
					'save_as' => 'id',
				),
				'input_attrs' => array( 'class' => 'my_custom_class' ),

				'active_callback' => [
					[
					  'setting'  => 'grogin_coupon_banner_popup_toggle',
					  'operator' => '==',
					  'value'    => '1',
					],
				],

			)
		);
		
		
		/*====== Coupon Banner Popup Title ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_coupon_banner_popup_title',
				'label' => esc_attr__( 'Coupon Banner Title', 'grogin-core' ),
				'section' => 'grogin_coupon_banner_popup_section',
				'default' => 'SUPER SALE',
				'required' => array(
					array(
					  'setting'  => 'grogin_coupon_banner_popup_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Coupon Banner Popup Subtitle ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'textarea',
				'settings' => 'grogin_coupon_banner_popup_subtitle',
				'label' => esc_attr__( 'Coupon Banner Subtitle', 'grogin-core' ),
				'section' => 'grogin_coupon_banner_popup_section',
				'default' => 'Not applicable to ICANN fees, taxes, transfers,or gift cards. Cannot be used in conjunction with any other offer, sale, discount or promotion.',
				'required' => array(
					array(
					  'setting'  => 'grogin_coupon_banner_popup_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Coupon Banner Popup Coupon Code ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_coupon_banner_popup_code',
				'label' => esc_attr__( 'Coupon Code', 'grogin-core' ),
				'section' => 'grogin_coupon_banner_popup_section',
				'default' => 'SUPER200',
				'required' => array(
					array(
					  'setting'  => 'grogin_coupon_banner_popup_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);
		
		/*====== Coupon Banner Popup Expire Date ======*/
		grogin_customizer_add_field (
			array(
				'type' => 'text',
				'settings' => 'grogin_coupon_banner_popup_expire_date',
				'label' => esc_attr__( 'Coupon Banner Expire Date', 'grogin-core' ),
				'section' => 'grogin_coupon_banner_popup_section',
				'default' => '15',
				'required' => array(
					array(
					  'setting'  => 'grogin_coupon_banner_popup_toggle',
					  'operator' => '==',
					  'value'    => '1',
					),
				),
			)
		);			