<?php

/*************************************************
## Scripts
*************************************************/
function grogin_gdpr_scripts() {
	wp_register_style( 'klb-gdpr',   plugins_url( 'css/gdpr.css', __FILE__ ), false, '1.0');
	wp_register_script( 'klb-gdpr',  plugins_url( 'js/gdpr.js', __FILE__ ), true );

}
add_action( 'wp_enqueue_scripts', 'grogin_gdpr_scripts' );

/*************************************************
## GDPR COOKIE
*************************************************/ 
function grogin_gdpr_cookie(){	
	$gdpr  = isset( $_COOKIE['cookie-popup-visible'] ) ? $_COOKIE['cookie-popup-visible'] : 'enable';
	if($gdpr){
		return $gdpr;
	}
}

/*************************************************
## GDPR WP_Footer
*************************************************/ 

add_action('wp_footer', 'grogin_gdpr_filter'); 
function grogin_gdpr_filter() { 

	if ( ! apply_filters( 'grogin_gdpr_filter', true ) ) {
		return;
	}

	if(get_theme_mod('grogin_gdpr_toggle',0) == 1 && grogin_gdpr_cookie() == 'enable'){
		wp_enqueue_script('jquery-cookie');
		wp_enqueue_script('klb-gdpr');
		wp_enqueue_style('klb-gdpr');
		?>
		
		<div class="site-gdpr" data-expires="<?php echo esc_attr(get_theme_mod('grogin_gdpr_expire_date')); ?>">
		  <div class="site-gdpr-inner">
			<p><?php echo grogin_sanitize_data(get_theme_mod('grogin_gdpr_text')); ?></p>
			<div class="gdpr-button">
				<a class="btn btn-primary" href="#"><?php echo esc_html(get_theme_mod('grogin_gdpr_button_text')); ?></a>
			</div><!-- gdpr-button -->
		  </div><!-- site-gdpr-inner -->
		</div>
		
		<?php
	}
}