<?php
/*************************************************
## Ajax Search Scripts
*************************************************/ 
function grogin_ajax_search_scripts() {
	wp_enqueue_style( 'grogin-ajax-search',    plugins_url( 'css/ajax-search.css', __FILE__ ), false, '1.0');
	wp_enqueue_script( 'grogin-ajax-search',    plugins_url( 'js/ajax-search.js', __FILE__ ), false, '1.0');
	wp_localize_script( 'grogin-ajax-search', 'groginsearch', array(
		'ajaxurl' => esc_url(admin_url( 'admin-ajax.php' )),
	));
}
add_action( 'wp_enqueue_scripts', 'grogin_ajax_search_scripts' );


/*************************************************
## Ajax Login CallBack
*************************************************/ 
add_action( 'wp_ajax_nopriv_ajax_search', 'grogin_ajax_search_callback' );
add_action( 'wp_ajax_ajax_search', 'grogin_ajax_search_callback' );
function grogin_ajax_search_callback() {
	global $wpdb;
	
	$keyword        = esc_html( $_POST['keyword'] );
	
	$clean_term      = '%' . $wpdb->esc_like( $keyword ) . '%';
	$sku_to_id = $wpdb->get_col(
		$wpdb->prepare(
			"SELECT DISTINCT IF(p.post_parent = 0, p.ID, p.post_parent) AS product_id
			 FROM {$wpdb->posts} p
			 INNER JOIN {$wpdb->wc_product_meta_lookup} ml
			         ON ml.product_id = p.ID
			  WHERE ml.sku LIKE %s
			  AND (p.post_type = 'product' OR p.post_type = 'product_variation')
			  AND p.post_status = 'publish'",
			$clean_term
		)
	);

	$args = array(
		'post_type'      => 'product',
		'post_status'    => 'publish',
		'posts_per_page' => 7,
		'fields'         => 'ids',
	);
	
	if(!empty($sku_to_id)){
		$args['post__in'] = array_map( 'absint', $sku_to_id );
	} else {
		$args['s'] = $keyword;
	}
	
	if($_POST['selected_cat'] != null){
		$args['tax_query'][] = array(
			'taxonomy' 	=> 'product_cat',
			'field' 	=> 'slug',
			'terms' 	=> $_POST['selected_cat'],
		);
	}
	
	if ( 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) {
		$args['tax_query'] = array(
			array(
				'taxonomy' => 'product_visibility',
				'field'    => 'name',
				'terms'    => 'outofstock',
				'operator' => 'NOT IN',
			),
		);
	}

	// Tags filter
	$tag_product_ids = array();
	if ( $keyword !== '' ) {
		$tag_term_ids = get_terms( array(
			'taxonomy'   => 'product_tag',
			'hide_empty' => true,
			'search'     => $keyword,
			'fields'     => 'ids',
			'number'     => 50, // st snr
		) );

		if ( ! is_wp_error( $tag_term_ids ) && ! empty( $tag_term_ids ) ) {
			$tag_term_ids = array_map( 'absint', $tag_term_ids );
			$in_list      = implode( ',', $tag_term_ids );

			$tag_product_ids = $wpdb->get_col(
				"SELECT DISTINCT IF(p.post_parent = 0, p.ID, p.post_parent) AS product_id
				 FROM {$wpdb->posts} p
				 JOIN {$wpdb->term_relationships} tr
				   ON tr.object_id = p.ID
				 JOIN {$wpdb->term_taxonomy} tt
				   ON tt.term_taxonomy_id = tr.term_taxonomy_id
				WHERE tt.taxonomy = 'product_tag'
				  AND tt.term_id IN ($in_list)
				  AND p.post_type IN ('product','product_variation')
				  AND p.post_status = 'publish'"
			);
		}
	}

	// title,description filter
	$title_ids = array();
	if ( $keyword !== '' ) {
		$title_args = $args; // ayn filtreleri (kategori, stok) kullan
		$title_args['s']      = $keyword;
		$title_args['posts_per_page']  = -1;
		$title_args['no_found_rows']   = true; 
		$title_q = new WP_Query( $title_args );
		if ( $title_q->have_posts() ) {
			$title_ids = $title_q->posts; // zaten ids
		}
		wp_reset_postdata();
	}

	// combine (SKU ? TAG ? title)
	$candidate_ids = array_unique( array_map( 'absint', array_merge( $sku_to_id, $tag_product_ids, $title_ids ) ) );
	$total_count = count( $candidate_ids );

	if ( ! empty( $candidate_ids ) ) {
		$args['post__in'] = $candidate_ids;
		unset( $args['s'] ); 
		$args['orderby'] = 'post__in';
	} else {
		if ( ! empty( $sku_to_id ) ) {
			$args['post__in'] = array_map( 'absint', $sku_to_id );
		} else {
			$args['s'] = $keyword;
		}
	}


	$args = new WP_Query( $args );

	if ( $args->have_posts() ) {
		echo '<ul>';

		while ( $args->have_posts() ) : $args->the_post();
			$product = wc_get_product( get_the_ID() );
			
			$title = $product->get_name();
			$price = $product->get_price_html();

			if ( ! $product || ( 'trash' === $product->get_status() ) ) {
				continue;
			}
			
			echo '<li>';
			echo '<div class="search-img">';
			echo $product->get_image('thumbnail');
			echo '</div>';
			echo '<div class="search-content">';
			echo '<h1 class="product-title"><a href="'.get_permalink().'" title="'.the_title_attribute( 'echo=0' ).'">'.get_the_title().'</a></h1>';
			echo '<span class="price">'.$price.'</span>';
			echo '</div>';
			echo '</li>';
		endwhile;
		
		if($args->found_posts > 7){
			$searchall = add_query_arg(
				array(
					's' => $keyword, 
					'post_type' => 'product'
				),
				site_url() 
			);
					
			echo '<li class="search-more">';
			echo '<a href="'.esc_url($searchall).'"><span>'.esc_html__('See all products...','grogin-core').'</span> <span>('.esc_html($total_count).')</span></a>';
			echo '</li>';
		}
		
		echo '</ul>';
		wp_reset_postdata();
	} else {
		echo '<ul><li><span>'.sprintf(esc_html__( 'No results found for "%s"', 'grogin-core' ), esc_html( $keyword )).'</span></li></ul>';
	}

	wp_die();

}

/*************************************************
## Search Query For SKU
*************************************************/ 
if ( ! function_exists( 'grogin_sku_search_query' ) ) {
	function grogin_sku_search_query( $where, $s ) {
		global $wpdb;

		$search_ids = array();

		$raw = is_array( $s ) ? implode( ' ', $s ) : (string) $s;
		$terms = array_filter( array_map( 'trim', preg_split( '/[,\s]+/', $raw ) ) );

		if ( empty( $terms ) ) {
			return $where;
		}

		foreach ( $terms as $term ) {
			if ( is_admin() && is_numeric( $term ) ) {
				$search_ids[] = (int) $term;
			}

			$sku_to_parent_id = $wpdb->get_col(
				$wpdb->prepare(
					"SELECT p.post_parent as post_id
					 FROM {$wpdb->posts} p
					 JOIN {$wpdb->wc_product_meta_lookup} ml
					   ON p.ID = ml.product_id
					  AND ml.sku LIKE '%%%s%%'
					WHERE p.post_parent <> 0
					GROUP BY p.post_parent",
					wc_clean( $term )
				)
			);

			$clean_term = wc_clean( $term );
			$sku_to_id  = $wpdb->get_results( $wpdb->prepare(
				"SELECT product_id
				   FROM {$wpdb->wc_product_meta_lookup}
				  WHERE sku LIKE %s",
				'%'.$wpdb->esc_like( $clean_term ).'%'
			), ARRAY_N );

			$sku_to_id_results = array();
			if ( is_array( $sku_to_id ) ) {
				foreach ( $sku_to_id as $id ) {
					$sku_to_id_results[] = (int) $id[0];
				}
			}

			$tag_term_ids = get_terms( array(
				'taxonomy'   => 'product_tag',
				'hide_empty' => true,
				'search'     => $term,
				'fields'     => 'ids',
				'number'     => 25,
			) );

			$tag_product_ids = array();
			if ( ! is_wp_error( $tag_term_ids ) && ! empty( $tag_term_ids ) ) {
				
				$tag_term_ids = array_map( 'absint', $tag_term_ids );
				$in_list      = implode( ',', $tag_term_ids );

				$tag_product_ids = $wpdb->get_col(
					"SELECT DISTINCT IF(p.post_parent = 0, p.ID, p.post_parent) AS product_id
					   FROM {$wpdb->posts} p
					   JOIN {$wpdb->term_relationships} tr
					     ON tr.object_id = p.ID
					   JOIN {$wpdb->term_taxonomy} tt
					     ON tt.term_taxonomy_id = tr.term_taxonomy_id
					  WHERE tt.taxonomy = 'product_tag'
					    AND tt.term_id IN ($in_list)
					    AND p.post_type IN ('product','product_variation')
					    AND p.post_status = 'publish'"
				);
			}

			$search_ids = array_merge( $search_ids, $sku_to_id_results, $sku_to_parent_id, $tag_product_ids );
		}

		$search_ids = array_unique( array_filter( array_map( 'absint', $search_ids ) ) );

		if ( ! empty( $search_ids ) ) {
			$where = str_replace(
				')))',
				")) OR ( {$wpdb->posts}.ID IN (" . implode( ',', $search_ids ) . ")))",
				$where
			);
		}

		return $where;
	}
}

 
add_filter( 'posts_search', 'grogin_product_search_sku', 9 );
if ( ! function_exists( 'grogin_product_search_sku' ) ) {
	function grogin_product_search_sku( $where, $class = false ) {
		global $pagenow, $wpdb, $wp;
		
		if ( ( is_admin() ) //if ((is_admin() && 'edit.php' != $pagenow) 
				|| !is_search()  
				|| !isset( $wp->query_vars['s'] ) 
				//post_types can also be arrays..
				|| (isset( $wp->query_vars['post_type'] ) && 'product' != $wp->query_vars['post_type'] )
				|| (isset( $wp->query_vars['post_type'] ) && is_array( $wp->query_vars['post_type'] ) && !in_array( 'product', $wp->query_vars['post_type'] ) ) 
				) {
			return $where;
		}

		$s = $wp->query_vars['s'];


		return grogin_sku_search_query( $where, $s );
		
	}
}