<?php 
/*************************************************
* Catalog Ordering
*************************************************/
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 ); 
add_action( 'klb_catalog_ordering', 'woocommerce_catalog_ordering', 30 ); 

add_action( 'woocommerce_before_shop_loop', 'grogin_catalog_ordering_start', 30 );
function grogin_catalog_ordering_start(){
?>
	
	<div class="before-shop-loop">
		<div class="column d-inline-flex align-items-center">
			<?php if( get_theme_mod( 'grogin_shop_layout' ) == 'full-width' || grogin_get_option() == 'full-width') { ?>
				  <div class="filter-wide-button dropdown d-none d-lg-inline-flex align-items-center">
					<a href="#" class="dropdown-toggle" role="button" data-bs-toggle="dropdown" data-bs-display="static" aria-expanded="false">
					  
					 <?php esc_html_e('Filter Products','grogin-core'); ?>
					</a>
					<div class="dropdown-menu">
					  <div class="dropdown-menu-inner">
						<?php if ( is_active_sidebar( 'shop-sidebar' ) ) { ?>
							<?php dynamic_sidebar( 'shop-sidebar' ); ?>
						<?php } ?>
					  </div><!-- filter-holder-wrapper -->
					</div><!-- filter-holder -->
				  </div><!-- filter-wide-button -->
			<?php } ?>
			
				<a href="#" class="filter-button"><i class="klb-icon-filter"></i> <?php esc_html_e('Filter', 'grogin-core'); ?></a>

				<?php wp_enqueue_script( 'grogin-mobilesorting'); ?>

				<div class="sorting-button">
					<i class="klb-icon-arrow-down-up"></i>
					<span><?php esc_html_e('Sort', 'grogin-core'); ?></span>
				</div><!-- sorting-button -->
				<?php add_action( 'grogin_result_count', 'woocommerce_result_count', 20 ); ?>
			<?php do_action('grogin_result_count'); ?>
		</div><!-- column -->
	
		<div class="column d-inline-flex align-items-center">
			<div class="shop-sorting-wrapper">
				<!-- For get orderby from loop -->
				<?php do_action('klb_catalog_ordering'); ?>
			
				<!-- For perpage option-->
				<?php if(get_theme_mod('grogin_perpage_view','0') == '1'){ ?>
					<?php $perpage = isset($_GET['perpage']) ? $_GET['perpage'] : ''; ?>
					<?php $defaultperpage = wc_get_default_products_per_row() * wc_get_default_product_rows_per_page(); ?>
					<?php $options = array($defaultperpage,$defaultperpage*2,$defaultperpage*3,$defaultperpage*4); ?>
					<div class="sorting-per-page">
					  <span><?php esc_html_e('Show:','grogin-core'); ?></span>
					  <form class="woocommerce-ordering product-filter products-per-page" method="get">
						<?php if (grogin_get_body_class('grogin-ajax-shop-on')) { ?>
							<select name="perpage" class="perpage orderby filterSelect " data-class="select-filter-perpage">
						<?php } else { ?>
							<select name="perpage" class="perpage orderby filterSelect " data-class="select-filter-perpage" onchange="this.form.submit()">
						<?php } ?>
							<?php for( $i=0; $i<count($options); $i++ ) { ?>
							<option value="<?php echo esc_attr($options[$i]); ?>" <?php echo esc_attr($perpage == $options[$i] ? 'selected="selected"' : ''); ?>><?php echo esc_html($options[$i]); ?> <?php esc_html_e('Items','grogin-core'); ?></option>
							<?php } ?>
						</select>
						<?php wc_query_string_form_fields( null, array( 'perpage', 'submit', 'paged', 'product-page' ) ); ?>		
					  </form>
					</div>
				<?php } ?>
			</div><!-- shop-sorting-wrapper -->
		 
			<?php if(get_theme_mod('grogin_grid_list_view','0') == '1'){ ?>
				<div class="product-views-buttons hide-below-992">
					<?php if(grogin_shop_view() == 'list_view') { ?>
						<a href="<?php echo esc_url(add_query_arg('shop_view','grid_view')); ?>" class="grid-view" data-bs-toggle="tooltip" data-bs-placement="top" title="Grid Products">
							<i class="klb-icon-layout-grid"></i>                     
						</a>
					
						<a href="<?php echo esc_url(add_query_arg('shop_view','list_view')); ?>" class="list-view active" data-bs-toggle="tooltip" data-bs-placement="top" title="List Products">
							<i class="klb-icon-layout-list"></i>                   
						</a>
					<?php } else { ?>
						<a href="<?php echo esc_url(add_query_arg('shop_view','grid_view')); ?>" class="grid-view active" data-bs-toggle="tooltip" data-bs-placement="top" title="Grid Products">
							<i class="klb-icon-layout-grid"></i>                        
						</a>
					
						<a href="<?php echo esc_url(add_query_arg('shop_view','list_view')); ?>" class="list-view" data-bs-toggle="tooltip" data-bs-placement="top" title="List Products">
							<i class="klb-icon-layout-list"></i>                     
						</a>
					<?php } ?>
				</div>
			<?php } ?>
		</div><!-- column -->
	</div>
	
<?php

}