jQuery(function ($) {

    $(document).on('found_variation show_variation', 'form.variations_form', function (event, variation) {

        if (!variation || !variation.variation_id) {
            return;
        }

        var $form   = $(this);

        var $target = $form.closest('article.single-product, .product').find('.klb-lowest-price-30');

        if (!$target.length) {
            return;
        }

        var variationId = variation.variation_id;

        $.ajax({
            url: klbPriceHistory.ajaxurl,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'klb_get_variation_lowest_price_30',
                variation_id: variationId
            },
            success: function (response) {
                if (response && response.success && response.data && response.data.html) {
                    $target.html(response.data.html).show();
                } else {
                    $target.hide().empty();
                }
            },
            error: function (xhr, status, error) {
                console.log('Lowest price AJAX error:', status, error);
                console.log('Response:', xhr.responseText);
                $target.hide().empty();
            }
        });
    });

    $(document).on('reset_data hide_variation', 'form.variations_form', function () {
        var $form   = $(this);
        var $target = $form.closest('article.single-product, .product').find('.klb-lowest-price-30');

        if ($target.length) {
            $target.hide().empty();
        }
    });

});
