<?php

/*************************************************
## Ajax Search Scripts
*************************************************/ 
function grogin_lowest_price_scripts() {
    if ( ! is_product() ) {
        return;
    }
	wp_enqueue_style( 'grogin-lowest-price',    plugins_url( 'css/lowest-price.css', __FILE__ ), false, '1.0');
	wp_enqueue_script( 'grogin-lowest-price',    plugins_url( 'js/lowest-price.js', __FILE__ ), false, '1.0');
	wp_localize_script( 'grogin-lowest-price', 'klbPriceHistory', array(
		'ajaxurl' => esc_url(admin_url( 'admin-ajax.php' )),
	));
}
add_action( 'wp_enqueue_scripts', 'grogin_lowest_price_scripts' );

// Comman helper - Save price history
if ( ! function_exists( 'klb_store_price_history' ) ) {
    function klb_store_price_history( $product_id, $current_price ) {

        $current_price = (float) $current_price;

        if ( $current_price <= 0 ) {
            return;
        }

        $history = get_post_meta( $product_id, '_klb_price_history', true );
        if ( ! is_array( $history ) ) {
            $history = array();
        }

        $now       = time();
        $keep_from = $now - DAY_IN_SECONDS * 60; // delete price from 60 days older.
        $cleaned   = array();

        foreach ( $history as $row ) {
            if ( isset( $row['time'], $row['price'] ) && $row['time'] >= $keep_from ) {
                $cleaned[] = $row;
            }
        }

        $last = end( $cleaned );
        if ( ! $last || (float) $last['price'] !== $current_price ) {
            $cleaned[] = array(
                'time'  => $now,
                'price' => $current_price,
            );
        }

        update_post_meta( $product_id, '_klb_price_history', $cleaned );
    }
}


// log price product and variation saving
add_action( 'save_post_product', 'klb_track_price_history_on_save', 20, 3 );
add_action( 'save_post_product_variation', 'klb_track_price_history_on_save', 20, 3 );

function klb_track_price_history_on_save( $post_id, $post, $update ) {

    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    if ( ! in_array( $post->post_type, array( 'product', 'product_variation' ), true ) ) {
        return;
    }

    if ( $post->post_status !== 'publish' ) {
        return;
    }

    $product = wc_get_product( $post_id );
    if ( ! $product ) {
        return;
    }

    $current_price = $product->get_price();

    klb_store_price_history( $post_id, $current_price );
}


// calculate lowest price in the last 30 days.
if ( ! function_exists( 'klb_get_lowest_price_last_30_days' ) ) {
    function klb_get_lowest_price_last_30_days( $product_id ) {
        $history = get_post_meta( $product_id, '_klb_price_history', true );

        if ( ! is_array( $history ) || empty( $history ) ) {
            return false;
        }

        $now       = time();
        $from_time = $now - DAY_IN_SECONDS * 30;
        $prices    = array();

        foreach ( $history as $row ) {
            if ( isset( $row['time'], $row['price'] ) && $row['time'] >= $from_time ) {
                $prices[] = (float) $row['price'];
            }
        }

        if ( empty( $prices ) ) {
            return false;
        }

        return min( $prices );
    }
}


// 2) Log price, On SIMPLE product page
add_action( 'woocommerce_before_single_product', 'klb_track_simple_product_on_view' );
function klb_track_simple_product_on_view() {
    if ( ! is_product() ) {
        return;
    }

    global $product;

    if ( ! $product instanceof WC_Product ) {
        return;
    }

    if ( $product->is_type( 'simple' ) ) {
        $current_price = $product->get_price();
        klb_store_price_history( $product->get_id(), $current_price );
    }
}


// 3) Show lowest price on single product.
add_action( 'woocommerce_single_product_summary', 'grogin_output_lowest_price_block', 31 );
function grogin_output_lowest_price_block() {
    global $product;

    if ( ! $product instanceof WC_Product ) {
        return;
    }

	if ( $product->is_type( 'simple' ) ) {

		if ( ! $product->is_on_sale() ) {
			return;
		}

		$lowest = klb_get_lowest_price_last_30_days( $product->get_id() );

		if ( $lowest === false ) {
			return;
		}

		printf(
			'<p class="klb-lowest-price-30">%s <strong>%s</strong></p>',
			esc_html__( 'Lowest price in the last 30 days:', 'grogin-core' ),
			wc_price( $lowest )
		);

    } elseif ( $product->is_type( 'variable' ) ) {
        echo '<p class="klb-lowest-price-30" style="display:none;"></p>';
    }
}


// 4) AJAX: Variation lowest price in the last 30 days.
add_action( 'wp_ajax_klb_get_variation_lowest_price_30', 'klb_get_variation_lowest_price_30' );
add_action( 'wp_ajax_nopriv_klb_get_variation_lowest_price_30', 'klb_get_variation_lowest_price_30' );

function klb_get_variation_lowest_price_30() {

    if ( ! isset( $_POST['variation_id'] ) ) {
        wp_send_json_error( array( 'message' => 'No variation_id' ) );
    }

    $variation_id = absint( $_POST['variation_id'] );

    if ( ! $variation_id ) {
        wp_send_json_error( array( 'message' => 'Invalid variation_id' ) );
    }

    $variation = wc_get_product( $variation_id );

    if ( ! $variation instanceof WC_Product_Variation ) {
        wp_send_json_error( array( 'message' => 'Not a variation product' ) );
    }

    $current_price = $variation->get_price();
    klb_store_price_history( $variation_id, $current_price );

	if ( ! $variation->is_on_sale() ) {
		wp_send_json_success( array( 'html' => '' ) );
	}

    $lowest = klb_get_lowest_price_last_30_days( $variation_id );

    if ( $lowest === false ) {
        wp_send_json_success( array(
            'html' => '',
        ) );
    }

    $html = sprintf(
        '%s <strong>%s</strong>',
        esc_html__( 'Lowest price in the last 30 days:', 'grogin-core' ),
        wc_price( $lowest )
    );

    wp_send_json_success( array(
        'html' => $html,
    ) );
}
