<?php
/*************************************************
## Scripts
*************************************************/
function grogin_product_box3_scripts() {
	wp_register_style( 'klb-product-custom-box-type3',   plugins_url( 'css/product-custom-box-type3.css', __FILE__ ), false, '1.0');
}
add_action( 'wp_enqueue_scripts', 'grogin_product_box3_scripts' );

function grogin_product_box3_elementor_editor_styles() {
	wp_register_style( 'klb-product-custom-box-type3',   plugins_url( 'css/product-custom-box-type3.css', __FILE__ ), false, '1.0');
	wp_enqueue_style( 'klb-product-custom-box-type3' );
}
add_action( 'elementor/frontend/after_enqueue_styles', 'grogin_product_box3_elementor_editor_styles' );

/*----------------------------
  Product Box Type 3
 ----------------------------*/
if(!function_exists('grogin_product_custom_box_type3')){  
	function grogin_product_custom_box_type3($stockprogressbar = '', $stockstatus = '', $shippingclass = '', $countdown = '', $producttype = '', $product_sku = '', $productattributes = ''){
		global $product;
		global $post;
		global $woocommerce;


		if($producttype != 'type3_custom') {
			return;
		}
		
		$output = '';
		
		wp_enqueue_style( 'klb-product-custom-box-type3');
		
		$id = get_the_ID();
		$allproduct = wc_get_product( get_the_ID() );

		$cart_url = wc_get_cart_url();
		$price = $allproduct->get_price_html();
		$weight = $product->get_weight();
		$stock_status = $product->get_stock_status();
		$stock_text = $product->get_availability();
		$short_desc = $product->get_short_description();
		$rating = wc_get_rating_html($product->get_average_rating());
		$ratingcount = $product->get_review_count();
		$ratingaverage  = $product->get_average_rating();


		$wishlist = get_theme_mod( 'grogin_wishlist_button', '0' );
		$compare = get_theme_mod( 'grogin_compare_button', '0' );
		$quickview = get_theme_mod( 'grogin_quick_view_button', '0' );

		$managestock = $product->managing_stock();
		$stock_quantity = $product->get_stock_quantity();
		$stock_format = esc_html__('Only %s unit left','grogin');
		$stock_poor = '';
		if($managestock && $stock_quantity < 10) {
			$stock_poor .= '<div class="product-inventory color-red">'.sprintf($stock_format, $stock_quantity).'</div>';
		}
		
		$total_sales = $product->get_total_sales();
		$total_stock = $total_sales + $stock_quantity;
		
		if($managestock && $stock_quantity > 0) {
		$progress_percentage = floor($total_sales / (($total_sales + $stock_quantity) / 100)); // yuvarlama
		}
		
		$gallery = get_theme_mod('grogin_product_hover_gallery') == 1 ? 'product-thumbnail' : '';
			
		$output .= '<div class="product-wrapper p-10 sm-p-15 product-custom-type3">';
		$output .= '<div class="product-inner">';
		$output .= '<div class="thumbnail-wrapper">';

		$output .= grogin_sale_percentage();

		$output .= '<div class="thumbnail-buttons">';
			ob_start();
			do_action('grogin_wishlist_action');
			$output .= ob_get_clean();
		
			$output .= grogin_quickview();
			
			ob_start();
			do_action('grogin_compare_action');
			$output .= ob_get_clean();
			
		$output .= '<div class="product-button">';
			ob_start();
			woocommerce_template_loop_add_to_cart();
			$output .= ob_get_clean();;
		
		$output .= '</div>';
		$output .= '</div><!-- thumbnail-buttons -->';
		$output .= '<div class="product-thumbnail entry-media">';
			ob_start();
			$output .= grogin_product_second_image();
			$output .= ob_get_clean();
		$output .= '</div><!-- product-thumbnail -->';
		$output .= '</div><!-- product-thumbnail-wrapper -->';
		
		ob_start();
		do_action('grogin_after_shop_loop_item_image');
		$output .= ob_get_clean();
		
		$output .= '<div class="content-wrapper">';
		$output .= '<div class="product-heading">';
		if($ratingcount){
			$output .= '<div class="product-rating">';
			$output .= $rating;
			$output .= '<div class="rating-count">';
			$output .= '<span class="count-text">'.esc_html($ratingcount).'</span>';
			$output .= '</div><!-- rating-count -->';
			$output .= '</div><!-- product-rating -->';  
		}
		
		$output .= '<h2 class="product-title"><a href="'.get_permalink().'">'.get_the_title().'</a></h2>';	
		$output .= '</div><!-- product-heading -->';
		
		$output .= '<div class="product-price-wrapper d-flex flex-column align-items-start gap-1">';
		$output .= '<span class="price">';
		$output .= $price;	
		$output .= '</span> ';         
		$output .= '</div><!-- product-price-wrapper -->';    
		
		ob_start();
		do_action('grogin_product_box_footer', $stockprogressbar, $stockstatus, $shippingclass, $countdown, $product_sku, $productattributes);
		$output .= ob_get_clean();
		
		$output .= '</div><!-- product-content-wrapper -->';        
		$output .= '</div><!-- product-inner -->';
		$output .= '</div><!-- product-wrapper -->';
		
		ob_start();
		do_action('grogin_after_product_box');
		$output .= ob_get_clean();
		
		echo $output;
	}
}
add_action('klb_product_box','grogin_product_custom_box_type3', 10, 7); 