<?php

/*************************************************
## Admin Scripts
*************************************************/
function grogin_product_extra_tab_admin_styles() {
	wp_enqueue_style( 'klb-product-extra-tab',   plugins_url( 'css/admin/product-extra-tab.css', __FILE__ ), false, '1.0');
}
add_action('admin_enqueue_scripts', 'grogin_product_extra_tab_admin_styles');


add_filter('woocommerce_product_data_tabs', function($tabs) {
	$tabs['klb_extra_tab_data'] = [
		'label' => esc_html__('Extra Tab', 'grogin-core'),
		'target' => 'klb_product_extra_tab',
		'priority' => 65
	];
	return $tabs;
});

add_action('woocommerce_product_data_panels', function() {
	?><div id="klb_product_extra_tab" class="panel woocommerce_options_panel hidden"><?php
 
    global $product_object, $post;

	echo '<div class="options_group">';
	woocommerce_wp_textarea_input([
		'id' => '_klb_product_extra_tab1_title',
		'label' => esc_html__('Tab Title 1', 'grogin-core'),
		'desc_tip'    => true,
		'description' => esc_html__( 'Set a text for the tab title.', 'grogin-core' ),
	]);

    echo '<div class="form-field _klb_product_extra_tab_description_field ">';
    echo '<label for="_klb_product_extra_tab1_description">'.esc_html__('Tab Description 1', 'grogin-core').'</label>';

    $content = get_post_meta( $post->ID, '_klb_product_extra_tab1_description', true );
    $editor_id = '_klb_product_extra_tab1_description';
	
	$settings = array(
		'textarea_name' => $editor_id,
		'textarea_rows' => 5,
		'media_buttons' => true,
		'tinymce' => array(
			'toolbar1' => 'formatselect,bold,italic,underline,bullist,numlist,blockquote,alignleft,aligncenter,alignright,link,unlink,wp_fullscreen,wp_adv',
			'toolbar2' => 'forecolor,backcolor,pastetext,removeformat,charmap,outdent,indent,undo,redo,wp_help',
		),
		'quicktags' => true,
	);

    wp_editor( $content, $editor_id, $settings );
	
    echo '</div>';
    echo '</div>';
	
	echo '<div class="options_group">';
	woocommerce_wp_textarea_input([
		'id' => '_klb_product_extra_tab2_title',
		'label' => esc_html__('Tab Title 2', 'grogin-core'),
		'desc_tip'    => true,
		'description' => esc_html__( 'Set a text for the tab title.', 'grogin-core' ),
	]);

    echo '<div class="form-field _klb_product_extra_tab_description_field ">';
    echo '<label for="_klb_product_extra_tab2_description">'.esc_html__('Tab Description 2', 'grogin-core').'</label>';

    $content2 = get_post_meta( $post->ID, '_klb_product_extra_tab2_description', true );
    $editor_id2 = '_klb_product_extra_tab2_description';
	
	$settings2 = array(
		'textarea_name' => $editor_id2,
		'textarea_rows' => 5,
		'media_buttons' => true,
		'tinymce' => array(
			'toolbar1' => 'formatselect,bold,italic,underline,bullist,numlist,blockquote,alignleft,aligncenter,alignright,link,unlink,wp_fullscreen,wp_adv',
			'toolbar2' => 'forecolor,backcolor,pastetext,removeformat,charmap,outdent,indent,undo,redo,wp_help',
		),
		'quicktags' => true,
	);

    wp_editor( $content2, $editor_id2, $settings2 );
	
    echo '</div>';
    echo '</div>';
	
	?></div><?php
});

add_action('woocommerce_process_product_meta', function($post_id) {
	$product = wc_get_product($post_id);
	
	// Extra Tab1
	$product->update_meta_data('_klb_product_extra_tab1_title', sanitize_text_field($_POST['_klb_product_extra_tab1_title']));
	$product->update_meta_data('_klb_product_extra_tab1_description', wpautop( wp_kses_post($_POST['_klb_product_extra_tab1_description']) ));

	// Extra Tab2
	$product->update_meta_data('_klb_product_extra_tab2_title', sanitize_text_field($_POST['_klb_product_extra_tab2_title']));
	$product->update_meta_data('_klb_product_extra_tab2_description', wpautop( wp_kses_post($_POST['_klb_product_extra_tab2_description']) ));

	$product->save();
});


if (!function_exists('grogin_product_extra_tab1')) {
	add_filter( 'woocommerce_product_tabs', 'grogin_product_extra_tab1' );
	function grogin_product_extra_tab1( $tabs ) {
		$extratab_desc1 = get_post_meta( get_the_ID(), '_klb_product_extra_tab1_description', true );
		$extratab_desc2 = get_post_meta( get_the_ID(), '_klb_product_extra_tab2_description', true );

		// Adds the new tab
		if($extratab_desc1){
			$tabs['extratab1'] = array(
				'title' 	=> get_post_meta( get_the_ID(), '_klb_product_extra_tab1_title', true ),
				'priority' 	=> 17,
				'callback' 	=> 'grogin_product_extra_tab1_content'
			);
		}
		
		// Adds the new tab
		if($extratab_desc2){
			$tabs['extratab2'] = array(
				'title' 	=> get_post_meta( get_the_ID(), '_klb_product_extra_tab2_title', true ),
				'priority' 	=> 18,
				'callback' 	=> 'grogin_product_extra_tab2_content'
			);
		}
		
		return $tabs;
	}
}

if (!function_exists('grogin_product_extra_tab1_content')) {
	function grogin_product_extra_tab1_content() {
		$extratab_desc = get_post_meta( get_the_ID(), '_klb_product_extra_tab1_description', true );
		echo '<div class="extra-tab-content">'.grogin_sanitize_data($extratab_desc).'</div>';
	}
}

if (!function_exists('grogin_product_extra_tab2_content')) {
	function grogin_product_extra_tab2_content() {
		$extratab_desc = get_post_meta( get_the_ID(), '_klb_product_extra_tab2_description', true );
		echo '<div class="extra-tab-content">'.grogin_sanitize_data($extratab_desc).'</div>';
	}
}